/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: tf_ops.td                                                            *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace TF {
/// Outputs a tensor containing the reduction across all input tensors.
/// Outputs a tensor containing the reduction across all input tensors passed to ops
/// within the same `shared_name.
/// 
/// The graph should be constructed so if one op runs with shared_name value `c`,
/// then `num_devices` ops will run with shared_name value `c`.  Failure to do so
/// will cause the graph execution to fail to complete.
/// 
/// input: the input to the reduction
/// data: the value of the reduction across all `num_devices` devices.
/// reduction: the reduction operation to perform.
/// num_devices: The number of devices participating in this reduction.
/// shared_name: Identifier that shared between ops of the same reduction.
class NcclAllReduceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class NdtriOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes numerical negative value element-wise.
/// I.e., \\(y = -x\\).
class NegOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the next representable value of `x1` in the direction of `x2`, element-wise.
/// This operation returns the same result as the C++ std::nextafter function.
/// 
/// It can also return a subnormal number.
/// 
/// @compatibility(cpp)
/// Equivalent to C++ std::nextafter function.
/// @end_compatibility
class NextAfterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Does nothing. Only useful as a placeholder for control edges.
class NoOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Greedily selects a subset of bounding boxes in descending order of score,
/// pruning away boxes that have high intersection-over-union (IOU) overlap
/// with previously selected boxes.  Bounding boxes with score less than
/// `score_threshold` are removed.  Bounding boxes are supplied as
/// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
/// diagonal pair of box corners and the coordinates can be provided as normalized
/// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
/// is agnostic to where the origin is in the coordinate system and more
/// generally is invariant to orthogonal transformations and translations
/// of the coordinate system; thus translating or reflections of the coordinate
/// system result in the same boxes being selected by the algorithm.
/// The output of this operation is a set of integers indexing into the input
/// collection of bounding boxes representing the selected boxes.  The bounding
/// box coordinates corresponding to the selected indices can then be obtained
/// using the `tf.gather operation`.  For example:
///   selected_indices = tf.image.non_max_suppression_v2(
///       boxes, scores, max_output_size, iou_threshold, score_threshold)
///   selected_boxes = tf.gather(boxes, selected_indices)
class NonMaxSuppressionV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Greedily selects a subset of bounding boxes in descending order of score,
/// pruning away boxes that have high intersection-over-union (IOU) overlap
/// with previously selected boxes.  Bounding boxes with score less than
/// `score_threshold` are removed.  Bounding boxes are supplied as
/// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
/// diagonal pair of box corners and the coordinates can be provided as normalized
/// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
/// is agnostic to where the origin is in the coordinate system and more
/// generally is invariant to orthogonal transformations and translations
/// of the coordinate system; thus translating or reflections of the coordinate
/// system result in the same boxes being selected by the algorithm.
/// The output of this operation is a set of integers indexing into the input
/// collection of bounding boxes representing the selected boxes.  The bounding
/// box coordinates corresponding to the selected indices can then be obtained
/// using the `tf.gather operation`.  For example:
///   selected_indices = tf.image.non_max_suppression_v2(
///       boxes, scores, max_output_size, iou_threshold, score_threshold)
///   selected_boxes = tf.gather(boxes, selected_indices)
class NonMaxSuppressionV4Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Greedily selects a subset of bounding boxes in descending order of score,
/// pruning away boxes that have high intersection-over-union (IOU) overlap
/// with previously selected boxes.  Bounding boxes with score less than
/// `score_threshold` are removed.  Bounding boxes are supplied as
/// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
/// diagonal pair of box corners and the coordinates can be provided as normalized
/// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
/// is agnostic to where the origin is in the coordinate system and more
/// generally is invariant to orthogonal transformations and translations
/// of the coordinate system; thus translating or reflections of the coordinate
/// system result in the same boxes being selected by the algorithm.
/// The output of this operation is a set of integers indexing into the input
/// collection of bounding boxes representing the selected boxes.  The bounding
/// box coordinates corresponding to the selected indices can then be obtained
/// using the `tf.gather operation`.  For example:
///   selected_indices = tf.image.non_max_suppression_v2(
///       boxes, scores, max_output_size, iou_threshold, score_threshold)
///   selected_boxes = tf.gather(boxes, selected_indices)
/// This op also supports a Soft-NMS (with Gaussian weighting) mode (c.f.
/// Bodla et al, https://arxiv.org/abs/1704.04503) where boxes reduce the score
/// of other overlapping boxes instead of directly causing them to be pruned.
/// To enable this Soft-NMS mode, set the `soft_nms_sigma` parameter to be
/// larger than 0.
class NonMaxSuppressionV5Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of (x != y) element-wise.
/// *NOTE*: `NotEqual` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class NotEqualOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a one-hot tensor.
/// The locations represented by indices in `indices` take value `on_value`,
/// while all other locations take value `off_value`.
/// 
/// If the input `indices` is rank `N`, the output will have rank `N+1`,
/// The new axis is created at dimension `axis` (default: the new axis is
/// appended at the end).
/// 
/// If `indices` is a scalar the output shape will be a vector of length `depth`.
/// 
/// If `indices` is a vector of length `features`, the output shape will be:
/// ```
///   features x depth if axis == -1
///   depth x features if axis == 0
/// ```
/// 
/// If `indices` is a matrix (batch) with shape `[batch, features]`,
/// the output shape will be:
/// ```
///   batch x features x depth if axis == -1
///   batch x depth x features if axis == 1
///   depth x batch x features if axis == 0
/// ```
/// 
/// 
/// Examples
/// =========
/// 
/// Suppose that
/// ```
///   indices = [0, 2, -1, 1]
///   depth = 3
///   on_value = 5.0
///   off_value = 0.0
///   axis = -1
/// ```
/// 
/// Then output is `[4 x 3]`:
/// ```
/// output =
///   [5.0 0.0 0.0]  // one_hot(0)
///   [0.0 0.0 5.0]  // one_hot(2)
///   [0.0 0.0 0.0]  // one_hot(-1)
///   [0.0 5.0 0.0]  // one_hot(1)
/// ```
/// 
/// Suppose that
/// ```
///   indices = [0, 2, -1, 1]
///   depth = 3
///   on_value = 0.0
///   off_value = 3.0
///   axis = 0
/// ```
/// 
/// Then output is `[3 x 4]`:
/// ```
/// output =
///   [0.0 3.0 3.0 3.0]
///   [3.0 3.0 3.0 0.0]
///   [3.0 3.0 3.0 3.0]
///   [3.0 0.0 3.0 3.0]
/// //  ^                one_hot(0)
/// //      ^            one_hot(2)
/// //          ^        one_hot(-1)
/// //              ^    one_hot(1)
/// ```
/// 
/// Suppose that
/// ```
///   indices = [[0, 2], [1, -1]]
///   depth = 3
///   on_value = 1.0
///   off_value = 0.0
///   axis = -1
/// ```
/// 
/// Then output is `[2 x 2 x 3]`:
/// ```
/// output =
///   [
///     [1.0, 0.0, 0.0]  // one_hot(0)
///     [0.0, 0.0, 1.0]  // one_hot(2)
///   ][
///     [0.0, 1.0, 0.0]  // one_hot(1)
///     [0.0, 0.0, 0.0]  // one_hot(-1)
///   ]
/// ```
class OneHotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Makes a "one-shot" iterator that can be iterated only once.
/// A one-shot iterator bundles the logic for defining the dataset and
/// the state of the iterator in a single op, which allows simple input
/// pipelines to be defined without an additional initialization
/// ("MakeIterator") step.
/// 
/// One-shot iterators have the following limitations:
/// 
/// * They do not support parameterization: all logic for creating the underlying
///   dataset must be bundled in the `dataset_factory` function.
/// * They are not resettable. Once a one-shot iterator reaches the end of its
///   underlying dataset, subsequent "IteratorGetNext" operations on that
///   iterator will always produce an `OutOfRange` error.
/// 
/// For greater flexibility, use "Iterator" and "MakeIterator" to define
/// an iterator using an arbitrary subgraph, which may capture tensors
/// (including fed values) as parameters, and which may be reset multiple
/// times by rerunning "MakeIterator".
class OneShotIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a tensor of ones with the same shape and type as x.
class OnesLikeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset by applying related optimizations to `input_dataset`.
/// Creates a dataset by applying related optimizations to `input_dataset`.
class OptimizeDatasetV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Constructs an Optional variant from a tuple of tensors.
class OptionalFromValueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the value stored in an Optional variant or raises an error if none exists.
class OptionalGetValueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns true if and only if the given Optional variant has a value.
class OptionalHasValueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates an Optional variant with no value.
class OptionalNoneOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Enqueue a Tensor on the computation outfeed.
class OutfeedEnqueueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Enqueue multiple Tensor values on the computation outfeed.
class OutfeedEnqueueTupleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Packs a list of `N` rank-`R` tensors into one rank-`(R+1)` tensor.
/// Packs the `N` tensors in `values` into a tensor with rank one higher than each
/// tensor in `values`, by packing them along the `axis` dimension.
/// Given a list of tensors of shape `(A, B, C)`;
/// 
/// if `axis == 0` then the `output` tensor will have the shape `(N, A, B, C)`.
/// if `axis == 1` then the `output` tensor will have the shape `(A, N, B, C)`.
/// Etc.
/// 
/// For example:
/// 
/// ```
/// # 'x' is [1, 4]
/// # 'y' is [2, 5]
/// # 'z' is [3, 6]
/// pack([x, y, z]) => [[1, 4], [2, 5], [3, 6]]  # Pack along first dim.
/// pack([x, y, z], axis=1) => [[1, 2, 3], [4, 5, 6]]
/// ```
/// 
/// This is the opposite of `unpack`.
class PackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Pads a tensor with zeros.
/// This operation pads a `input` with zeros according to the `paddings` you
/// specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is the
/// rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
/// how many zeros to add before the contents of `input` in that dimension, and
/// `paddings[D, 1]` indicates how many zeros to add after the contents of `input`
/// in that dimension.
/// 
/// The padded size of each dimension D of the output is:
/// 
/// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
/// 
/// For example:
/// 
/// ```
/// # 't' is [[1, 1], [2, 2]]
/// # 'paddings' is [[1, 1], [2, 2]]
/// # rank of 't' is 2
/// pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
///                       [0, 0, 1, 1, 0, 0]
///                       [0, 0, 2, 2, 0, 0]
///                       [0, 0, 0, 0, 0, 0]]
/// ```
class PadOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Pads a tensor.
/// This operation pads `input` according to the `paddings` and `constant_values`
/// you specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is
/// the rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
/// how many padding values to add before the contents of `input` in that dimension,
/// and `paddings[D, 1]` indicates how many padding values to add after the contents
/// of `input` in that dimension. `constant_values` is a scalar tensor of the same
/// type as `input` that indicates the value to use for padding `input`.
/// 
/// The padded size of each dimension D of the output is:
/// 
/// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
/// 
/// For example:
/// 
/// ```
/// # 't' is [[1, 1], [2, 2]]
/// # 'paddings' is [[1, 1], [2, 2]]
/// # 'constant_values' is 0
/// # rank of 't' is 2
/// pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
///                       [0, 0, 1, 1, 0, 0]
///                       [0, 0, 2, 2, 0, 0]
///                       [0, 0, 0, 0, 0, 0]]
/// ```
class PadV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Interleave the values from the `data` tensors into a single tensor.
/// Builds a merged tensor such that
/// 
/// ```python
///     merged[indices[m][i, ..., j], ...] = data[m][i, ..., j, ...]
/// ```
/// 
/// For example, if each `indices[m]` is scalar or vector, we have
/// 
/// ```python
///     # Scalar indices:
///     merged[indices[m], ...] = data[m][...]
/// 
///     # Vector indices:
///     merged[indices[m][i], ...] = data[m][i, ...]
/// ```
/// 
/// Each `data[i].shape` must start with the corresponding `indices[i].shape`,
/// and the rest of `data[i].shape` must be constant w.r.t. `i`.  That is, we
/// must have `data[i].shape = indices[i].shape + constant`.  In terms of this
/// `constant`, the output shape is
/// 
///     merged.shape = [max(indices)] + constant
/// 
/// Values may be merged in parallel, so if an index appears in both `indices[m][i]`
/// and `indices[n][j]`, the result may be invalid. This differs from the normal
/// DynamicStitch operator that defines the behavior in that case.
/// 
/// For example:
/// 
/// ```python
///     indices[0] = 6
///     indices[1] = [4, 1]
///     indices[2] = [[5, 2], [0, 3]]
///     data[0] = [61, 62]
///     data[1] = [[41, 42], [11, 12]]
///     data[2] = [[[51, 52], [21, 22]], [[1, 2], [31, 32]]]
///     merged = [[1, 2], [11, 12], [21, 22], [31, 32], [41, 42],
///               [51, 52], [61, 62]]
/// ```
/// 
/// This method can be used to merge partitions created by `dynamic_partition`
/// as illustrated on the following example:
/// 
/// ```python
///     # Apply function (increments x_i) on elements for which a certain condition
///     # apply (x_i != -1 in this example).
///     x=tf.constant([0.1, -1., 5.2, 4.3, -1., 7.4])
///     condition_mask=tf.not_equal(x,tf.constant(-1.))
///     partitioned_data = tf.dynamic_partition(
///         x, tf.cast(condition_mask, tf.int32) , 2)
///     partitioned_data[1] = partitioned_data[1] + 1.0
///     condition_indices = tf.dynamic_partition(
///         tf.range(tf.shape(x)[0]), tf.cast(condition_mask, tf.int32) , 2)
///     x = tf.dynamic_stitch(condition_indices, partitioned_data)
///     # Here x=[1.1, -1., 6.2, 5.3, -1, 8.4], the -1. values remain
///     # unchanged.
/// ```
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicStitch.png" alt>
/// </div>
class ParallelDynamicStitchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that applies `f` to the outputs of `input_dataset`.
/// Unlike a "MapDataset", which applies `f` sequentially, this dataset invokes up
/// to `num_parallel_calls` copies of `f` in parallel.
class ParallelMapDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that applies `f` to the outputs of `input_dataset`.
/// Unlike a "MapDataset", which applies `f` sequentially, this dataset invokes up
/// to `num_parallel_calls` copies of `f` in parallel.
class ParallelMapDatasetV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a normal distribution. The parameters may each be a
/// scalar which applies to the entire output, or a vector of length shape[0] which
/// stores the parameters for each batch.
class ParameterizedTruncatedNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Transforms a vector of tf.Example protos (as strings) into typed tensors.
class ParseExampleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Transforms a vector of tf.Example protos (as strings) into typed tensors.
class ParseExampleV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// returns `f(inputs)`, where `f`'s body is placed and partitioned.
/// Asynchronously executes a function, potentially across multiple devices but
/// within a single process. The kernel places and partitions a given function's
/// underlying graph, and executes each of the partitioned subgraphs as a function.
class PartitionedCallOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Placeholder op
/// Inserts a placeholder for a tensor that will be always fed.
class PlaceholderOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Placeholder op
/// A placeholder op that passes through input when its output is not fed.
class PlaceholderWithDefaultOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the polygamma function \\(\psi^{(n)}(x)\\).
/// The polygamma function is defined as:
/// 
/// 
/// \\(\psi^{(a)}(x) = \frac{d^a}{dx^a} \psi(x)\\)
/// 
/// where \\(\psi(x)\\) is the digamma function.
/// The polygamma function is defined only for non-negative integer orders \\a\\.
class PolygammaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes element-wise population count (a.k.a. popcount, bitsum, bitcount).
/// For each entry in `x`, calculates the number of `1` (on) bits in the binary
/// representation of that entry.
/// 
/// **NOTE**: It is more efficient to first `tf.bitcast` your tensors into
/// `int32` or `int64` and perform the bitcount on the result, than to feed in
/// 8- or 16-bit inputs and then aggregate the resulting counts.
class PopulationCountOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the power of one value to another.
/// Given a tensor `x` and a tensor `y`, this operation computes \\(x^y\\) for
/// corresponding elements in `x` and `y`. For example:
/// 
/// ```
/// # tensor 'x' is [[2, 2]], [3, 3]]
/// # tensor 'y' is [[8, 16], [2, 3]]
/// tf.pow(x, y) ==> [[256, 65536], [9, 27]]
/// ```
class PowOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that asynchronously prefetches elements from `input_dataset`.
class PrefetchDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An identity op that triggers an error if a gradient is requested.
/// When executed in a graph, this op outputs its input tensor as-is.
/// 
/// When building ops to compute gradients, the TensorFlow gradient system
/// will return an error when trying to lookup the gradient of this op,
/// because no gradient must ever be registered for this function.  This
/// op exists to prevent subtle bugs from silently returning unimplemented
/// gradients in some corner cases.
class PreventGradientOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Prints a list of tensors.
/// Passes `input` through to `output` and prints `data` when evaluating.
class PrintOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Prints a string scalar.
/// Prints a string scalar to the desired output_stream.
class PrintV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the product of elements across dimensions of a tensor.
/// Reduces `input` along the dimensions given in `axis`. Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `axis`. If `keep_dims` is true, the reduced dimensions are
/// retained with length 1.
class ProdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the QR decompositions of one or more matrices.
/// Computes the QR decomposition of each inner matrix in `tensor` such that
/// `tensor[..., :, :] = q[..., :, :] * r[..., :,:])`
/// 
/// Currently, the gradient for the QR decomposition is well-defined only when
/// the first `P` columns of the inner matrix are linearly independent, where
/// `P` is the minimum of `M` and `N`, the 2 inner-most dimmensions of `tensor`.
/// 
/// ```python
/// # a is a tensor.
/// # q is a tensor of orthonormal matrices.
/// # r is a tensor of upper triangular matrices.
/// q, r = qr(a)
/// q_full, r_full = qr(a, full_matrices=True)
/// ```
class QrOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Use QuantizeAndDequantizeV2 instead.
class QuantizeAndDequantizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Quantizes then dequantizes a tensor.
/// This op simulates the precision loss from the quantized forward pass by:
/// 
/// 1. Quantizing the tensor to fixed point numbers, which should match the target
///    quantization method when it is used in inference.
/// 2. Dequantizing it back to floating point numbers for the following ops, most
///    likely matmul.
/// 
/// There are different ways to quantize. This version uses only scaling, so 0.0
/// maps to 0.
/// 
/// From the specified 'num_bits' in the quantized output type, it determines
/// minimum and maximum representable quantized values.
/// 
/// e.g.
/// 
/// *   [-128, 127] for signed, num_bits = 8, or
/// *   [0, 255] for unsigned, num_bits = 8.
/// 
/// If range_given == False, the initial input_min, input_max will be determined
/// automatically as the minimum and maximum values in the input tensor, otherwise
/// the specified values of input_min, input_max are used.
/// 
/// Note: If the input_min, input_max are specified, they do not need to equal the
/// actual minimum and maximum values in the tensor. e.g. in some cases it may be
/// beneficial to specify these values such that the low probability extremes of the
/// input distribution are clipped.
/// 
/// This op determines the maximum scale_factor that would map the initial
/// [input_min, input_max] range to a range that lies within the representable
/// quantized range.
/// 
/// It determines the scale from one of input_min and input_max, then updates the
/// other one to maximize the representable range.
/// 
/// e.g.
/// 
/// *   if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
///     5.0]: it would use a scale_factor of -128 / -10.0 = 12.8 In this case, it
///     would update input_max to be 127 / 12.8 = 9.921875
/// *   if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
///     10.0]: it would use a scale_factor of 127 / 10.0 = 12.7 In this case, it
///     would update input_min to be 128.0 / 12.7 = -10.07874
/// *   if the output is unsigned, input_min is forced to be 0, and only the
///     specified input_max is used.
/// 
/// After determining the scale_factor and updating the input range, it applies the
/// following to each value in the 'input' tensor.
/// 
/// output = round(clamp(value, input_min, input_max) * scale_factor) / scale_factor.
/// 
/// The above round function rounds the value based on the given round_mode.
class QuantizeAndDequantizeV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Quantizes then dequantizes a tensor.
/// This is almost identical to QuantizeAndDequantizeV2, except that num_bits is a
/// tensor, so its value can change during training.
class QuantizeAndDequantizeV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Quantizes then dequantizes a tensor.
/// This is almost identical to QuantizeAndDequantizeV2, except that it returns a
/// gradient of 1 for inputs that are within the quantization range, or 0 otherwise.
class QuantizeAndDequantizeV4Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Quantize the 'input' tensor of type float to 'output' tensor of type 'T'.
/// [min_range, max_range] are scalar floats that specify the range for
/// the 'input' data. The 'mode' attribute controls exactly which calculations are
/// used to convert the float values to their quantized equivalents.  The
/// 'round_mode' attribute controls which rounding tie-breaking algorithm is used
/// when rounding float values to their quantized equivalents.
/// 
/// In 'MIN_COMBINED' mode, each value of the tensor will undergo the following:
/// 
/// ```
/// out[i] = (in[i] - min_range) * range(T) / (max_range - min_range)
/// if T == qint8: out[i] -= (range(T) + 1) / 2.0
/// ```
/// 
/// here `range(T) = numeric_limits<T>::max() - numeric_limits<T>::min()`
/// 
/// *MIN_COMBINED Mode Example*
/// 
/// Assume the input is type float and has a possible range of [0.0, 6.0] and the
/// output type is quint8 ([0, 255]). The min_range and max_range values should be
/// specified as 0.0 and 6.0. Quantizing from float to quint8 will multiply each
/// value of the input by 255/6 and cast to quint8.
/// 
/// If the output type was qint8 ([-128, 127]), the operation will additionally
/// subtract each value by 128 prior to casting, so that the range of values aligns
/// with the range of qint8.
/// 
/// If the mode is 'MIN_FIRST', then this approach is used:
/// 
/// ```
/// num_discrete_values = 1 << (# of bits in T)
/// range_adjust = num_discrete_values / (num_discrete_values - 1)
/// range = (range_max - range_min) * range_adjust
/// range_scale = num_discrete_values / range
/// quantized = round(input * range_scale) - round(range_min * range_scale) +
///   numeric_limits<T>::min()
/// quantized = max(quantized, numeric_limits<T>::min())
/// quantized = min(quantized, numeric_limits<T>::max())
/// ```
/// 
/// The biggest difference between this and MIN_COMBINED is that the minimum range
/// is rounded first, before it's subtracted from the rounded value. With
/// MIN_COMBINED, a small bias is introduced where repeated iterations of quantizing
/// and dequantizing will introduce a larger and larger error.
/// 
/// *SCALED mode Example*
/// 
/// `SCALED` mode matches the quantization approach used in
/// `QuantizeAndDequantize{V2|V3}`.
/// 
/// If the mode is `SCALED`, the quantization is performed by multiplying each
/// input value by a scaling_factor.
/// The scaling_factor is determined from `min_range` and `max_range` to be as large
/// as possible such that the range from `min_range` to `max_range` is representable
/// within values of type T.
/// 
/// ```c++
/// 
///   const int min_T = std::numeric_limits<T>::min();
///   const int max_T = std::numeric_limits<T>::max();
///   const float max_float = std::numeric_limits<float>::max();
/// 
///   const float scale_factor_from_min_side =
///       (min_T * min_range > 0) ? min_T / min_range : max_float;
///   const float scale_factor_from_max_side =
///       (max_T * max_range > 0) ? max_T / max_range : max_float;
/// 
///   const float scale_factor = std::min(scale_factor_from_min_side,
///                                       scale_factor_from_max_side);
/// ```
/// 
/// We next use the scale_factor to adjust min_range and max_range as follows:
/// 
/// ```c++
///       min_range = min_T / scale_factor;
///       max_range = max_T / scale_factor;
/// ```
/// 
/// 
/// e.g. if T = qint8, and initially min_range = -10, and max_range = 9, we would
/// compare -128/-10.0 = 12.8 to 127/9.0 = 14.11, and set scaling_factor = 12.8
/// In this case, min_range would remain -10, but max_range would be adjusted to
/// 127 / 12.8 = 9.921875
/// 
/// So we will quantize input values in the range (-10, 9.921875) to (-128, 127).
/// 
/// The input tensor can now be quantized by clipping values to the range
/// `min_range` to `max_range`, then multiplying by scale_factor as follows:
/// 
/// ```c++
/// result = round(min(max_range, max(min_range, input)) * scale_factor)
/// ```
/// 
/// The adjusted `min_range` and `max_range` are returned as outputs 2 and 3 of
/// this operation. These outputs should be used as the range for any further
/// calculations.
/// 
/// 
/// *narrow_range (bool) attribute*
/// 
/// If true, we do not use the minimum quantized value.
/// i.e. for int8 the quantized output, it would be restricted to the range
/// -127..127 instead of the full -128..127 range.
/// This is provided for compatibility with certain inference backends.
/// (Only applies to SCALED mode)
/// 
/// 
/// *axis (int) attribute*
/// 
/// An optional `axis` attribute can specify a dimension index of the input tensor,
/// such that quantization ranges will be calculated and applied separately for each
/// slice of the tensor along that dimension. This is useful for per-channel
/// quantization.
/// 
/// If axis is specified, min_range and max_range
/// 
/// if `axis`=None, per-tensor quantization is performed as normal.
/// 
/// 
/// *ensure_minimum_range (float) attribute*
/// 
/// Ensures the minimum quantization range is at least this value.
/// The legacy default value for this is 0.01, but it is strongly suggested to
/// set it to 0 for new uses.
class QuantizeV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Dequeues a tuple of one or more tensors from the given queue.
/// This operation has k outputs, where k is the number of components
/// in the tuples stored in the given queue, and output i is the ith
/// component of the dequeued tuple.
/// 
/// N.B. If the queue is empty, this operation will block until an element
/// has been dequeued (or 'timeout_ms' elapses, if specified).
class QueueDequeueV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// 2D real-valued fast Fourier transform.
/// Computes the 2-dimensional discrete Fourier transform of a real-valued signal
/// over the inner-most 2 dimensions of `input`.
/// 
/// Since the DFT of a real signal is Hermitian-symmetric, `RFFT2D` only returns the
/// `fft_length / 2 + 1` unique components of the FFT for the inner-most dimension
/// of `output`: the zero-frequency term, followed by the `fft_length / 2`
/// positive-frequency terms.
/// 
/// Along each axis `RFFT2D` is computed on, if `fft_length` is smaller than the
/// corresponding dimension of `input`, the dimension is cropped. If it is larger,
/// the dimension is padded with zeros.
class RFFT2DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// 3D real-valued fast Fourier transform.
/// Computes the 3-dimensional discrete Fourier transform of a real-valued signal
/// over the inner-most 3 dimensions of `input`.
/// 
/// Since the DFT of a real signal is Hermitian-symmetric, `RFFT3D` only returns the
/// `fft_length / 2 + 1` unique components of the FFT for the inner-most dimension
/// of `output`: the zero-frequency term, followed by the `fft_length / 2`
/// positive-frequency terms.
/// 
/// Along each axis `RFFT3D` is computed on, if `fft_length` is smaller than the
/// corresponding dimension of `input`, the dimension is cropped. If it is larger,
/// the dimension is padded with zeros.
class RFFT3DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Real-valued fast Fourier transform.
/// Computes the 1-dimensional discrete Fourier transform of a real-valued signal
/// over the inner-most dimension of `input`.
/// 
/// Since the DFT of a real signal is Hermitian-symmetric, `RFFT` only returns the
/// `fft_length / 2 + 1` unique components of the FFT: the zero-frequency term,
/// followed by the `fft_length / 2` positive-frequency terms.
/// 
/// Along the axis `RFFT` is computed on, if `fft_length` is smaller than the
/// corresponding dimension of `input`, the dimension is cropped. If it is larger,
/// the dimension is padded with zeros.
class RFFTOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts one or more images from RGB to HSV.
/// Outputs a tensor of the same shape as the `images` tensor, containing the HSV
/// value of the pixels. The output is only well defined if the value in `images`
/// are in `[0,1]`.
/// 
/// `output[..., 0]` contains hue, `output[..., 1]` contains saturation, and
/// `output[..., 2]` contains value. All HSV values are in `[0,1]`. A hue of 0
/// corresponds to pure red, hue 1/3 is pure green, and 2/3 is pure blue.
/// 
/// Usage Example:
/// 
/// >>> blue_image = tf.stack([
/// ...    tf.zeros([5,5]),
/// ...    tf.zeros([5,5]),
/// ...    tf.ones([5,5])],
/// ...    axis=-1)
/// >>> blue_hsv_image = tf.image.rgb_to_hsv(blue_image)
/// >>> blue_hsv_image[0,0].numpy()
/// array([0.6666667, 1. , 1. ], dtype=float32)
class RGBToHSVOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gather ragged slices from `params` axis `0` according to `indices`.
/// Outputs a `RaggedTensor` output composed from `output_dense_values` and
/// `output_nested_splits`, such that:
/// 
/// ```python
/// output.shape = indices.shape + params.shape[1:]
/// output.ragged_rank = indices.shape.ndims + params.ragged_rank
/// output[i...j, d0...dn] = params[indices[i...j], d0...dn]
/// ```
/// 
/// where
/// 
/// * `params =
///    ragged.from_nested_row_splits(params_dense_values, params_nested_splits)`
///    provides the values that should be gathered.
/// * `indices` ia a dense tensor with dtype `int32` or `int64`, indicating which
///    values should be gathered.
/// * `output =
///    ragged.from_nested_row_splits(output_dense_values, output_nested_splits)`
///    is the output tensor.
/// 
/// (Note: This c++ op is used to implement the higher-level python
/// `tf.ragged.gather` op, which also supports ragged indices.)
class RaggedGatherOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a `RaggedTensor` containing the specified sequences of numbers.
/// Returns a `RaggedTensor` `result` composed from `rt_dense_values` and
/// `rt_nested_splits`, such that
/// `result[i] = range(starts[i], limits[i], deltas[i])`.
/// 
/// ```python
/// (rt_nested_splits, rt_dense_values) = ragged_range(
///       starts=[2, 5, 8], limits=[3, 5, 12], deltas=1)
/// result = tf.ragged.from_row_splits(rt_dense_values, rt_nested_splits)
/// print(result)
/// <tf.RaggedTensor [[2], [], [8, 9, 10, 11]] >
/// ```
/// 
/// The input tensors `starts`, `limits`, and `deltas` may be scalars or vectors.
/// The vector inputs must all have the same size.  Scalar inputs are broadcast
/// to match the size of the vector inputs.
class RaggedRangeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the derivative of a Gamma random sample w.r.t. `alpha`.
class RandomGammaGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from the Gamma distribution(s) described by alpha.
/// This op uses the algorithm by Marsaglia et al. to acquire samples via
/// transformation-rejection from pairs of uniform and normal random variables.
/// See http://dl.acm.org/citation.cfm?id=358414
class RandomGammaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Use RandomPoissonV2 instead.
class RandomPoissonOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from the Poisson distribution(s) described by rate.
/// This op uses two algorithms, depending on rate. If rate >= 10, then
/// the algorithm by Hormann is used to acquire samples via
/// transformation-rejection.
/// See http://www.sciencedirect.com/science/article/pii/0167668793909974.
/// 
/// Otherwise, Knuth's algorithm is used to acquire samples via multiplying uniform
/// random variables.
/// See Donald E. Knuth (1969). Seminumerical Algorithms. The Art of Computer
/// Programming, Volume 2. Addison Wesley
class RandomPoissonV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Randomly shuffles a tensor along its first dimension.
/// The tensor is shuffled along dimension 0, such that each `value[j]` is mapped
///   to one and only one `output[i]`. For example, a mapping that might occur for a
///   3x2 tensor is:
/// 
/// ```
/// [[1, 2],       [[5, 6],
///  [3, 4],  ==>   [1, 2],
///  [5, 6]]        [3, 4]]
/// ```
class RandomShuffleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a normal distribution.
/// The generated values will have mean 0 and standard deviation 1.
class RandomStandardNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random integers from a uniform distribution.
/// The generated values are uniform integers in the range `[minval, maxval)`.
/// The lower bound `minval` is included in the range, while the upper bound
/// `maxval` is excluded.
/// 
/// The random integers are slightly biased unless `maxval - minval` is an exact
/// power of two.  The bias is small for values of `maxval - minval` significantly
/// smaller than the range of the output (either `2^32` or `2^64`).
class RandomUniformIntOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[0, 1)`. The
/// lower bound 0 is included in the range, while the upper bound 1 is excluded.
class RandomUniformOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset with a range of values. Corresponds to python's xrange.
class RangeDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a sequence of numbers.
/// This operation creates a sequence of numbers that begins at `start` and
/// extends by increments of `delta` up to but not including `limit`.
/// 
/// For example:
/// 
/// ```
/// # 'start' is 3
/// # 'limit' is 18
/// # 'delta' is 3
/// tf.range(start, limit, delta) ==> [3, 6, 9, 12, 15]
/// ```
class RangeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the rank of a tensor.
/// This operation returns an integer representing the rank of `input`.
/// 
/// For example:
/// 
/// ```
/// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
/// # shape of tensor 't' is [2, 2, 3]
/// rank(t) ==> 3
/// ```
/// 
/// **Note**: The rank of a tensor is not the same as the rank of a matrix. The rank
/// of a tensor is the number of indices required to uniquely select each element
/// of the tensor. Rank is also known as "order", "degree", or "ndims."
class RankOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reads and outputs the entire contents of the input filename.
class ReadFileOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reads the value of a variable.
/// The tensor returned by this operation is immutable.
/// 
/// The value returned by this operation is guaranteed to be influenced by all the
/// writes on which this operation depends directly or indirectly, and to not be
/// influenced by any of the writes which depend directly or indirectly on this
/// operation.
class ReadVariableOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x / y element-wise for real types.
/// If `x` and `y` are reals, this will return the floating-point division.
/// 
/// *NOTE*: `Div` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class RealDivOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the real part of a complex number.
/// Given a tensor `input` of complex numbers, this operation returns a tensor of
/// type `float` that is the real part of each element in `input`. All elements in
/// `input` must be complex numbers of the form \\(a + bj\\), where *a* is the real
///  part returned by this operation and *b* is the imaginary part.
/// 
/// For example:
/// 
/// ```
/// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
/// tf.real(input) ==> [-2.25, 3.25]
/// ```
class RealOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient for the inverse of `x` wrt its input.
/// Specifically, `grad = -dy * y*y`, where `y = 1/x`, and `dy`
/// is the corresponding input gradient.
class ReciprocalGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the reciprocal of x element-wise.
/// I.e., \\(y = 1 / x\\).
class ReciprocalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Receives the named tensor from send_device on recv_device.
class RecvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that receives embedding activations on the TPU.
/// The TPU system performs the embedding lookups and aggregations specified by
/// the arguments to TPUEmbeddingEnqueue(Integer/Sparse/SparseTensor)Batch. The
/// results of these aggregations are visible to the Tensorflow Graph as the
/// outputs of a RecvTPUEmbeddingActivations op. This op returns a list containing
/// one Tensor of activations per table specified in the model. There can be at
/// most one RecvTPUEmbeddingActivations op in the TPU graph.
class RecvTPUEmbeddingActivationsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reduces the input dataset to a singleton using a reduce function.
class ReduceDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Joins a string Tensor across the given dimensions.
/// Computes the string join across dimensions in the given string Tensor of shape
/// `[\\(d_0, d_1, ..., d_{n-1}\\)]`.  Returns a new Tensor created by joining the input
/// strings with the given separator (default: empty string).  Negative indices are
/// counted backwards from the end, with `-1` being equivalent to `n - 1`.  If
/// indices are not specified, joins across all dimensions beginning from `n - 1`
/// through `0`.
/// 
/// For example:
/// 
/// ```python
/// # tensor `a` is [["a", "b"], ["c", "d"]]
/// tf.reduce_join(a, 0) ==> ["ac", "bd"]
/// tf.reduce_join(a, 1) ==> ["ab", "cd"]
/// tf.reduce_join(a, -2) = tf.reduce_join(a, 0) ==> ["ac", "bd"]
/// tf.reduce_join(a, -1) = tf.reduce_join(a, 1) ==> ["ab", "cd"]
/// tf.reduce_join(a, 0, keep_dims=True) ==> [["ac", "bd"]]
/// tf.reduce_join(a, 1, keep_dims=True) ==> [["ab"], ["cd"]]
/// tf.reduce_join(a, 0, separator=".") ==> ["a.c", "b.d"]
/// tf.reduce_join(a, [0, 1]) ==> "acbd"
/// tf.reduce_join(a, [1, 0]) ==> "abcd"
/// tf.reduce_join(a, []) ==> [["a", "b"], ["c", "d"]]
/// tf.reduce_join(a) = tf.reduce_join(a, [1, 0]) ==> "abcd"
/// ```
class ReduceJoinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes rectified linear 6 gradients for a Relu6 operation.
class Relu6GradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes rectified linear 6: `min(max(features, 0), 6)`.
class Relu6Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes rectified linear gradients for a Relu operation.
class ReluGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes rectified linear: `max(features, 0)`.
/// See: https://en.wikipedia.org/wiki/Rectifier_(neural_networks)
/// Example usage:
/// >>> tf.nn.relu([-2., 0., 3.]).numpy()
/// array([0., 0., 3.], dtype=float32)
class ReluOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Runs function `f` on a remote device indicated by `target`.
class RemoteCallOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that emits the outputs of `input_dataset` `count` times.
class RepeatDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reshapes a tensor.
/// Given `tensor`, this operation returns a tensor that has the same values
/// as `tensor` with shape `shape`.
/// 
/// If one component of 1-D tensor `shape` is the special value -1, the size of that
/// dimension is computed so that the total size remains constant.  In particular, a
/// `shape` of `[-1]` flattens into 1-D.  At most one component of `shape` may be
/// unknown.
/// 
/// The `shape` must be 1-D and the operation returns a tensor with shape
/// `shape` filled with the values of `tensor`. In this case, the number of elements
/// implied by `shape` must be the same as the number of elements in `tensor`.
/// 
/// It is an error if `shape` is not 1-D.
/// 
/// For example:
/// 
/// ```
/// # tensor 't' is [1, 2, 3, 4, 5, 6, 7, 8, 9]
/// # tensor 't' has shape [9]
/// reshape(t, [3, 3]) ==> [[1, 2, 3],
///                         [4, 5, 6],
///                         [7, 8, 9]]
/// 
/// # tensor 't' is [[[1, 1], [2, 2]],
/// #                [[3, 3], [4, 4]]]
/// # tensor 't' has shape [2, 2, 2]
/// reshape(t, [2, 4]) ==> [[1, 1, 2, 2],
///                         [3, 3, 4, 4]]
/// 
/// # tensor 't' is [[[1, 1, 1],
/// #                 [2, 2, 2]],
/// #                [[3, 3, 3],
/// #                 [4, 4, 4]],
/// #                [[5, 5, 5],
/// #                 [6, 6, 6]]]
/// # tensor 't' has shape [3, 2, 3]
/// # pass '[-1]' to flatten 't'
/// reshape(t, [-1]) ==> [1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6]
/// 
/// # -1 can also be used to infer the shape
/// 
/// # -1 is inferred to be 9:
/// reshape(t, [2, -1]) ==> [[1, 1, 1, 2, 2, 2, 3, 3, 3],
///                          [4, 4, 4, 5, 5, 5, 6, 6, 6]]
/// # -1 is inferred to be 2:
/// reshape(t, [-1, 9]) ==> [[1, 1, 1, 2, 2, 2, 3, 3, 3],
///                          [4, 4, 4, 5, 5, 5, 6, 6, 6]]
/// # -1 is inferred to be 3:
/// reshape(t, [ 2, -1, 3]) ==> [[[1, 1, 1],
///                               [2, 2, 2],
///                               [3, 3, 3]],
///                              [[4, 4, 4],
///                               [5, 5, 5],
///                               [6, 6, 6]]]
/// 
/// # tensor 't' is [7]
/// # shape `[]` reshapes to a scalar
/// reshape(t, []) ==> 7
/// ```
class ReshapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient of bilinear interpolation.
class ResizeBilinearGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Resize `images` to `size` using bilinear interpolation.
/// Input images can be of different types but output images are always float.
class ResizeBilinearOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient of nearest neighbor interpolation.
class ResizeNearestNeighborGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Resize `images` to `size` using nearest neighbor interpolation.
class ResizeNearestNeighborOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the AdaMax algorithm.
/// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
/// v_t <- max(beta2 * v_{t-1}, abs(g))
/// variable <- variable - learning_rate / (1 - beta1^t) * m_t / (v_t + epsilon)
class ResourceApplyAdaMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the adadelta scheme.
/// accum = rho() * accum + (1 - rho()) * grad.square();
/// update = (update_accum + epsilon).sqrt() * (accum + epsilon()).rsqrt() * grad;
/// update_accum = rho() * update_accum + (1 - rho()) * update.square();
/// var -= update;
class ResourceApplyAdadeltaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the proximal adagrad scheme.
class ResourceApplyAdagradDAOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the adagrad scheme.
/// accum += grad * grad
/// var -= lr * grad * (1 / sqrt(accum))
class ResourceApplyAdagradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the adagrad scheme.
/// accum += grad * grad
/// var -= lr * grad * (1 / (sqrt(accum) + epsilon))
class ResourceApplyAdagradV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the Adam algorithm.
/// $$\text{lr}_t := \mathrm{lr} \cdot \frac{\sqrt{1 - \beta_2^t}}{1 - \beta_1^t}$$
/// $$m_t := \beta_1 \cdot m_{t-1} + (1 - \beta_1) \cdot g$$
/// $$v_t := \beta_2 \cdot v_{t-1} + (1 - \beta_2) \cdot g^2$$
/// $$\text{var} := \begin{cases} \text{var} - (m_t \beta_1 + g \cdot (1 - \beta_1))\cdot\text{lr}_t/(\sqrt{v_t} + \epsilon), &\text{if use_nesterov}\\\\  \text{var} - m_t \cdot \text{lr}_t /(\sqrt{v_t} + \epsilon), &\text{otherwise} \end{cases}$$
class ResourceApplyAdamOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the AddSign update.
/// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
/// update <- (alpha + sign_decay * sign(g) *sign(m)) * g
/// variable <- variable - lr_t * update
class ResourceApplyAddSignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the centered RMSProp algorithm.
/// The centered RMSProp algorithm uses an estimate of the centered second moment
/// (i.e., the variance) for normalization, as opposed to regular RMSProp, which
/// uses the (uncentered) second moment. This often helps with training, but is
/// slightly more expensive in terms of computation and memory.
/// 
/// Note that in dense implementation of this algorithm, mg, ms, and mom will
/// update even if the grad is zero, but in this sparse implementation, mg, ms,
/// and mom will not update in iterations during which the grad is zero.
/// 
/// mean_square = decay * mean_square + (1-decay) * gradient ** 2
/// mean_grad = decay * mean_grad + (1-decay) * gradient
/// 
/// Delta = learning_rate * gradient / sqrt(mean_square + epsilon - mean_grad ** 2)
/// 
/// mg <- rho * mg_{t-1} + (1-rho) * grad
/// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
/// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms - mg * mg + epsilon)
/// var <- var - mom
class ResourceApplyCenteredRMSPropOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the Ftrl-proximal scheme.
/// accum_new = accum + grad * grad
/// linear += grad - (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
/// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
/// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
/// accum = accum_new
class ResourceApplyFtrlOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the Ftrl-proximal scheme.
/// accum_new = accum + grad * grad
/// grad_with_shrinkage = grad + 2 * l2_shrinkage * var
/// linear += grad_with_shrinkage +
///     (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
/// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
/// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
/// accum = accum_new
class ResourceApplyFtrlV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' by subtracting 'alpha' * 'delta' from it.
class ResourceApplyGradientDescentOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the momentum scheme.
/// Set use_nesterov = True if you want to use Nesterov momentum.
/// 
/// accum = accum * momentum - lr * grad
/// var += accum
class ResourceApplyKerasMomentumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the momentum scheme.
/// Set use_nesterov = True if you want to use Nesterov momentum.
/// 
/// accum = accum * momentum + grad
/// var -= lr * accum
class ResourceApplyMomentumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the AddSign update.
/// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
/// update <- exp(logbase * sign_decay * sign(g) * sign(m_t)) * g
/// variable <- variable - lr_t * update
class ResourceApplyPowerSignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' and '*accum' according to FOBOS with Adagrad learning rate.
/// accum += grad * grad
/// prox_v = var - lr * grad * (1 / sqrt(accum))
/// var = sign(prox_v)/(1+lr*l2) * max{|prox_v|-lr*l1,0}
class ResourceApplyProximalAdagradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' as FOBOS algorithm with fixed learning rate.
/// prox_v = var - alpha * delta
/// var = sign(prox_v)/(1+alpha*l2) * max{|prox_v|-alpha*l1,0}
class ResourceApplyProximalGradientDescentOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the RMSProp algorithm.
/// Note that in dense implementation of this algorithm, ms and mom will
/// update even if the grad is zero, but in this sparse implementation, ms
/// and mom will not update in iterations during which the grad is zero.
/// 
/// mean_square = decay * mean_square + (1-decay) * gradient ** 2
/// Delta = learning_rate * gradient / sqrt(mean_square + epsilon)
/// 
/// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
/// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms + epsilon)
/// var <- var - mom
class ResourceApplyRMSPropOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// GatherNd on a resource.
/// This op reads the variable referenced by the first argument, and
/// then performs a GatherNd operation on it.
class ResourceGatherNdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gather slices from the variable pointed to by `resource` according to `indices`.
/// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
/// Produces an output tensor with shape `indices.shape + params.shape[1:]` where:
/// 
/// ```python
///     # Scalar indices
///     output[:, ..., :] = params[indices, :, ... :]
/// 
///     # Vector indices
///     output[i, :, ..., :] = params[indices[i], :, ... :]
/// 
///     # Higher rank indices
///     output[i, ..., j, :, ... :] = params[indices[i, ..., j], :, ..., :]
/// ```
class ResourceGatherOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adds sparse updates to the variable referenced by `resource`.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] += updates[...]
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] += updates[i, ...]
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] += updates[i, ..., j, ...]
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions add.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Divides sparse updates into the variable referenced by `resource`.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] /= updates[...]
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] /= updates[i, ...]
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] /= updates[i, ..., j, ...]
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions multiply.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterDivOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reduces sparse updates into the variable referenced by `resource` using the `max` operation.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] = max(ref[indices, ...], updates[...])
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] = max(ref[indices[i], ...], updates[i, ...])
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] = max(ref[indices[i, ..., j], ...], updates[i, ..., j, ...])
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions are combined.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reduces sparse updates into the variable referenced by `resource` using the `min` operation.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] = min(ref[indices, ...], updates[...])
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] = min(ref[indices[i], ...], updates[i, ...])
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] = min(ref[indices[i, ..., j], ...], updates[i, ..., j, ...])
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions are combined.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterMinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Multiplies sparse updates into the variable referenced by `resource`.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] *= updates[...]
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] *= updates[i, ...]
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] *= updates[i, ..., j, ...]
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions multiply.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Applies sparse addition to individual values or slices in a Variable.
/// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
/// 
/// `indices` must be integer tensor, containing indices into `ref`.
/// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
/// 
/// The innermost dimension of `indices` (with length `K`) corresponds to
/// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
/// dimension of `ref`.
/// 
/// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
/// 
/// ```
/// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]]
/// ```
/// 
/// For example, say we want to add 4 scattered elements to a rank-1 tensor to
/// 8 elements. In Python, that addition would look like this:
/// 
/// ```python
/// ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8], use_resource=True)
/// indices = tf.constant([[4], [3], [1], [7]])
/// updates = tf.constant([9, 10, 11, 12])
/// add = tf.scatter_nd_add(ref, indices, updates)
/// with tf.Session() as sess:
///   print sess.run(add)
/// ```
/// 
/// The resulting update to ref would look like this:
/// 
///     [1, 13, 3, 14, 14, 6, 7, 20]
/// 
/// See `tf.scatter_nd` for more details about how to make updates to
/// slices.
class ResourceScatterNdAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Applies sparse subtraction to individual values or slices in a Variable.
/// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
/// 
/// `indices` must be integer tensor, containing indices into `ref`.
/// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
/// 
/// The innermost dimension of `indices` (with length `K`) corresponds to
/// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
/// dimension of `ref`.
/// 
/// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
/// 
/// ```
/// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]]
/// ```
/// 
/// For example, say we want to subtract 4 scattered elements from a rank-1 tensor
/// with 8 elements. In Python, that subtraction would look like this:
/// 
/// ```python
/// ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8], use_resource=True)
/// indices = tf.constant([[4], [3], [1], [7]])
/// updates = tf.constant([9, 10, 11, 12])
/// sub = tf.scatter_nd_sub(ref, indices, updates)
/// with tf.Session() as sess:
///   print sess.run(sub)
/// ```
/// 
/// The resulting update to ref would look like this:
/// 
///     [1, -9, 3, -6, -4, 6, 7, -4]
/// 
/// See `tf.scatter_nd` for more details about how to make updates to
/// slices.
class ResourceScatterNdSubOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Applies sparse `updates` to individual values or slices within a given
/// variable according to `indices`.
/// 
/// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
/// 
/// `indices` must be integer tensor, containing indices into `ref`.
/// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
/// 
/// The innermost dimension of `indices` (with length `K`) corresponds to
/// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
/// dimension of `ref`.
/// 
/// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
/// 
/// ```
/// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]].
/// ```
/// 
/// For example, say we want to update 4 scattered elements to a rank-1 tensor to
/// 8 elements. In Python, that update would look like this:
/// 
/// ```python
///     ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8])
///     indices = tf.constant([[4], [3], [1] ,[7]])
///     updates = tf.constant([9, 10, 11, 12])
///     update = tf.scatter_nd_update(ref, indices, updates)
///     with tf.Session() as sess:
///       print sess.run(update)
/// ```
/// 
/// The resulting update to ref would look like this:
/// 
///     [1, 11, 3, 10, 9, 6, 7, 12]
/// 
/// See `tf.scatter_nd` for more details about how to make updates to
/// slices.
class ResourceScatterNdUpdateOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Subtracts sparse updates from the variable referenced by `resource`.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] -= updates[...]
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] -= updates[i, ...]
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] -= updates[i, ..., j, ...]
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions add.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterSubOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Assigns sparse updates to the variable referenced by `resource`.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] = updates[...]
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] = updates[i, ...]
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] = updates[i, ..., j, ...]
class ResourceScatterUpdateOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update relevant entries in '*var' and '*accum' according to the adagrad scheme.
/// That is for rows we have grad for, we update var and accum as follows:
/// accum += grad * grad
/// var -= lr * grad * (1 / sqrt(accum))
class ResourceSparseApplyAdagradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update relevant entries in '*var' and '*accum' according to the adagrad scheme.
/// That is for rows we have grad for, we update var and accum as follows:
/// accum += grad * grad
/// var -= lr * grad * (1 / sqrt(accum))
class ResourceSparseApplyAdagradV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update relevant entries in '*var' according to the Ftrl-proximal scheme.
/// That is for rows we have grad for, we update var, accum and linear as follows:
/// accum_new = accum + grad * grad
/// linear += grad - (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
/// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
/// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
/// accum = accum_new
class ResourceSparseApplyFtrlOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Assign `value` to the sliced l-value reference of `ref`.
/// The values of `value` are assigned to the positions in the variable
/// `ref` that are selected by the slice parameters. The slice parameters
/// `begin, `end`, `strides`, etc. work exactly as in `StridedSlice`.
/// 
/// NOTE this op currently does not support broadcasting and so `value`'s
/// shape must be exactly the shape produced by the slice of `ref`.
class ResourceStridedSliceAssignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Restores a tensor from checkpoint files.
/// Reads a tensor stored in one or several files. If there are several files (for
/// instance because a tensor was saved as slices), `file_pattern` may contain
/// wildcard symbols (`*` and `?`) in the filename portion only, not in the
/// directory portion.
/// 
/// If a `file_pattern` matches several files, `preferred_shard` can be used to hint
/// in which file the requested tensor is likely to be found. This op will first
/// open the file at index `preferred_shard` in the list of matching files and try
/// to restore tensors from that file.  Only if some tensors or tensor slices are
/// not found in that first file, then the Op opens all the files. Setting
/// `preferred_shard` to match the value passed as the `shard` input
/// of a matching `Save` Op may speed up Restore.  This attribute only affects
/// performance, not correctness.  The default value -1 means files are processed in
/// order.
/// 
/// See also `RestoreSlice`.
class RestoreOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Restores tensors from a V2 checkpoint.
/// For backward compatibility with the V1 format, this Op currently allows
/// restoring from a V1 checkpoint as well:
///   - This Op first attempts to find the V2 index file pointed to by "prefix", and
///     if found proceed to read it as a V2 checkpoint;
///   - Otherwise the V1 read path is invoked.
/// Relying on this behavior is not recommended, as the ability to fall back to read
/// V1 might be deprecated and eventually removed.
/// 
/// By default, restores the named tensors in full.  If the caller wishes to restore
/// specific slices of stored tensors, "shape_and_slices" should be non-empty
/// strings and correspondingly well-formed.
/// 
/// Callers must ensure all the named tensors are indeed stored in the checkpoint.
class RestoreV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingADAMParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve ADAM embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingADAMParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingAdadeltaParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve Adadelta embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingAdadeltaParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingAdagradParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve Adagrad embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingAdagradParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve centered RMSProp embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingCenteredRMSPropParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingFTRLParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve FTRL embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingFTRLParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve MDL Adagrad Light embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingMDLAdagradLightParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingMomentumParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve Momentum embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingMomentumParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve proximal Adagrad embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingProximalAdagradParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingProximalYogiParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingProximalYogiParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve RMSProp embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingRMSPropParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve SGD embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingStochasticGradientDescentParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reverses specific dimensions of a tensor.
/// Given a `tensor`, and a `bool` tensor `dims` representing the dimensions
/// of `tensor`, this operation reverses each dimension i of `tensor` where
/// `dims[i]` is `True`.
/// 
/// `tensor` can have up to 8 dimensions. The number of dimensions
/// of `tensor` must equal the number of elements in `dims`. In other words:
/// 
/// `rank(tensor) = size(dims)`
/// 
/// For example:
/// 
/// ```
/// # tensor 't' is [[[[ 0,  1,  2,  3],
/// #                  [ 4,  5,  6,  7],
/// #                  [ 8,  9, 10, 11]],
/// #                 [[12, 13, 14, 15],
/// #                  [16, 17, 18, 19],
/// #                  [20, 21, 22, 23]]]]
/// # tensor 't' shape is [1, 2, 3, 4]
/// 
/// # 'dims' is [False, False, False, True]
/// reverse(t, dims) ==> [[[[ 3,  2,  1,  0],
///                         [ 7,  6,  5,  4],
///                         [ 11, 10, 9, 8]],
///                        [[15, 14, 13, 12],
///                         [19, 18, 17, 16],
///                         [23, 22, 21, 20]]]]
/// 
/// # 'dims' is [False, True, False, False]
/// reverse(t, dims) ==> [[[[12, 13, 14, 15],
///                         [16, 17, 18, 19],
///                         [20, 21, 22, 23]
///                        [[ 0,  1,  2,  3],
///                         [ 4,  5,  6,  7],
///                         [ 8,  9, 10, 11]]]]
/// 
/// # 'dims' is [False, False, True, False]
/// reverse(t, dims) ==> [[[[8, 9, 10, 11],
///                         [4, 5, 6, 7],
///                         [0, 1, 2, 3]]
///                        [[20, 21, 22, 23],
///                         [16, 17, 18, 19],
///                         [12, 13, 14, 15]]]]
/// ```
class ReverseOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reverses variable length slices.
/// This op first slices `input` along the dimension `batch_dim`, and for each
/// slice `i`, reverses the first `seq_lengths[i]` elements along
/// the dimension `seq_dim`.
/// 
/// The elements of `seq_lengths` must obey `seq_lengths[i] <= input.dims[seq_dim]`,
/// and `seq_lengths` must be a vector of length `input.dims[batch_dim]`.
/// 
/// The output slice `i` along dimension `batch_dim` is then given by input
/// slice `i`, with the first `seq_lengths[i]` slices along dimension
/// `seq_dim` reversed.
/// 
/// For example:
/// 
/// ```
/// # Given this:
/// batch_dim = 0
/// seq_dim = 1
/// input.dims = (4, 8, ...)
/// seq_lengths = [7, 2, 3, 5]
/// 
/// # then slices of input are reversed on seq_dim, but only up to seq_lengths:
/// output[0, 0:7, :, ...] = input[0, 7:0:-1, :, ...]
/// output[1, 0:2, :, ...] = input[1, 2:0:-1, :, ...]
/// output[2, 0:3, :, ...] = input[2, 3:0:-1, :, ...]
/// output[3, 0:5, :, ...] = input[3, 5:0:-1, :, ...]
/// 
/// # while entries past seq_lens are copied through:
/// output[0, 7:, :, ...] = input[0, 7:, :, ...]
/// output[1, 2:, :, ...] = input[1, 2:, :, ...]
/// output[2, 3:, :, ...] = input[2, 3:, :, ...]
/// output[3, 2:, :, ...] = input[3, 2:, :, ...]
/// ```
/// 
/// In contrast, if:
/// 
/// ```
/// # Given this:
/// batch_dim = 2
/// seq_dim = 0
/// input.dims = (8, ?, 4, ...)
/// seq_lengths = [7, 2, 3, 5]
/// 
/// # then slices of input are reversed on seq_dim, but only up to seq_lengths:
/// output[0:7, :, 0, :, ...] = input[7:0:-1, :, 0, :, ...]
/// output[0:2, :, 1, :, ...] = input[2:0:-1, :, 1, :, ...]
/// output[0:3, :, 2, :, ...] = input[3:0:-1, :, 2, :, ...]
/// output[0:5, :, 3, :, ...] = input[5:0:-1, :, 3, :, ...]
/// 
/// # while entries past seq_lens are copied through:
/// output[7:, :, 0, :, ...] = input[7:, :, 0, :, ...]
/// output[2:, :, 1, :, ...] = input[2:, :, 1, :, ...]
/// output[3:, :, 2, :, ...] = input[3:, :, 2, :, ...]
/// output[2:, :, 3, :, ...] = input[2:, :, 3, :, ...]
/// ```
class ReverseSequenceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reverses specific dimensions of a tensor.
/// Given a `tensor`, and a `int32` tensor `axis` representing the set of
/// dimensions of `tensor` to reverse. This operation reverses each dimension
/// `i` for which there exists `j` s.t. `axis[j] == i`.
/// 
/// `tensor` can have up to 8 dimensions. The number of dimensions specified
/// in `axis` may be 0 or more entries. If an index is specified more than
/// once, a InvalidArgument error is raised.
/// 
/// For example:
/// 
/// ```
/// # tensor 't' is [[[[ 0,  1,  2,  3],
/// #                  [ 4,  5,  6,  7],
/// #                  [ 8,  9, 10, 11]],
/// #                 [[12, 13, 14, 15],
/// #                  [16, 17, 18, 19],
/// #                  [20, 21, 22, 23]]]]
/// # tensor 't' shape is [1, 2, 3, 4]
/// 
/// # 'dims' is [3] or 'dims' is [-1]
/// reverse(t, dims) ==> [[[[ 3,  2,  1,  0],
///                         [ 7,  6,  5,  4],
///                         [ 11, 10, 9, 8]],
///                        [[15, 14, 13, 12],
///                         [19, 18, 17, 16],
///                         [23, 22, 21, 20]]]]
/// 
/// # 'dims' is '[1]' (or 'dims' is '[-3]')
/// reverse(t, dims) ==> [[[[12, 13, 14, 15],
///                         [16, 17, 18, 19],
///                         [20, 21, 22, 23]
///                        [[ 0,  1,  2,  3],
///                         [ 4,  5,  6,  7],
///                         [ 8,  9, 10, 11]]]]
/// 
/// # 'dims' is '[2]' (or 'dims' is '[-2]')
/// reverse(t, dims) ==> [[[[8, 9, 10, 11],
///                         [4, 5, 6, 7],
///                         [0, 1, 2, 3]]
///                        [[20, 21, 22, 23],
///                         [16, 17, 18, 19],
///                         [12, 13, 14, 15]]]]
/// ```
class ReverseV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Elementwise computes the bitwise right-shift of `x` and `y`.
/// Performs a logical shift for unsigned integer types, and an arithmetic shift
/// for signed integer types.
/// 
/// If `y` is negative, or greater than or equal to than the width of `x` in bits
/// the result is implementation defined.
/// 
/// Example:
/// 
/// ```python
/// import tensorflow as tf
/// from tensorflow.python.ops import bitwise_ops
/// import numpy as np
/// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64]
/// 
/// for dtype in dtype_list:
///   lhs = tf.constant([-1, -5, -3, -14], dtype=dtype)
///   rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
/// 
///   right_shift_result = bitwise_ops.right_shift(lhs, rhs)
/// 
///   print(right_shift_result)
/// 
/// # This will print:
/// # tf.Tensor([-1 -5 -1 -1], shape=(4,), dtype=int8)
/// # tf.Tensor([-1 -5 -1 -1], shape=(4,), dtype=int16)
/// # tf.Tensor([-1 -5 -1 -1], shape=(4,), dtype=int32)
/// # tf.Tensor([-1 -5 -1 -1], shape=(4,), dtype=int64)
/// 
/// lhs = np.array([-2, 64, 101, 32], dtype=np.int8)
/// rhs = np.array([-1, -5, -3, -14], dtype=np.int8)
/// bitwise_ops.right_shift(lhs, rhs)
/// # <tf.Tensor: shape=(4,), dtype=int8, numpy=array([ -2,  64, 101,  32], dtype=int8)>
/// ```
class RightShiftOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns element-wise integer closest to x.
/// If the result is midway between two representable values,
/// the even representable is chosen.
/// For example:
/// 
/// ```
/// rint(-1.5) ==> -2.0
/// rint(0.5000001) ==> 1.0
/// rint([-1.7, -1.5, -0.2, 0.2, 1.5, 1.7, 2.0]) ==> [-2., -2., -0., 0., 2., 2., 2.]
/// ```
class RintOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x + y element-wise.
/// *NOTE*: `RiscAdd` does not supports broadcasting.
/// 
/// Given two input tensors, the `tf.risc_add` operation computes the sum for every element in the tensor.
/// 
/// Both input and output have a range `(-inf, inf)`.
class RiscAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RiscDotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Advance the counter of a counter-based RNG.
/// The state of the RNG after
/// `rng_read_and_skip(n)` will be the same as that after `uniform([n])`
/// (or any other distribution). The actual increment added to the
/// counter is an unspecified implementation choice.
/// 
/// In the case that the input algorithm is RNG_ALG_AUTO_SELECT, the counter in the state needs to be of size int64[2], the current maximal counter size among algorithms. In this case, this op will manage the counter as if it is an 128-bit integer with layout [lower_64bits, higher_64bits]. If an algorithm needs less than 128 bits for the counter, it should use the left portion of the int64[2]. In this way, the int64[2] is compatible with all current RNG algorithms (Philox, ThreeFry and xla::RandomAlgorithm::RNG_DEFAULT). Downstream RNG ops can thus use this counter with any RNG algorithm.
class RngReadAndSkipOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Rolls the elements of a tensor along an axis.
/// The elements are shifted positively (towards larger indices) by the offset of
/// `shift` along the dimension of `axis`. Negative `shift` values will shift
/// elements in the opposite direction. Elements that roll passed the last position
/// will wrap around to the first and vice versa. Multiple shifts along multiple
/// axes may be specified.
/// 
/// For example:
/// 
/// ```
/// # 't' is [0, 1, 2, 3, 4]
/// roll(t, shift=2, axis=0) ==> [3, 4, 0, 1, 2]
/// 
/// # shifting along multiple dimensions
/// # 't' is [[0, 1, 2, 3, 4], [5, 6, 7, 8, 9]]
/// roll(t, shift=[1, -2], axis=[0, 1]) ==> [[7, 8, 9, 5, 6], [2, 3, 4, 0, 1]]
/// 
/// # shifting along the same axis multiple times
/// # 't' is [[0, 1, 2, 3, 4], [5, 6, 7, 8, 9]]
/// roll(t, shift=[2, -3], axis=[1, 1]) ==> [[1, 2, 3, 4, 0], [6, 7, 8, 9, 5]]
/// ```
class RollOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Rounds the values of a tensor to the nearest integer, element-wise.
/// Rounds half to even.  Also known as bankers rounding. If you want to round
/// according to the current system rounding mode use std::cint.
class RoundOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient for the rsqrt of `x` wrt its input.
/// Specifically, `grad = dy * -0.5 * y^3`, where `y = rsqrt(x)`, and `dy`
/// is the corresponding input gradient.
class RsqrtGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes reciprocal of square root of x element-wise.
/// I.e., \\(y = 1 / \sqrt{x}\\).
class RsqrtOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Saves the input tensors to disk.
/// The size of `tensor_names` must match the number of tensors in `data`. `data[i]`
/// is written to `filename` with name `tensor_names[i]`.
/// 
/// See also `SaveSlices`.
class SaveOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Saves input tensors slices to disk.
/// This is like `Save` except that tensors can be listed in the saved file as being
/// a slice of a larger tensor.  `shapes_and_slices` specifies the shape of the
/// larger tensor and the slice that this tensor covers. `shapes_and_slices` must
/// have as many elements as `tensor_names`.
/// 
/// Elements of the `shapes_and_slices` input must either be:
/// 
/// *  The empty string, in which case the corresponding tensor is
///    saved normally.
/// *  A string of the form `dim0 dim1 ... dimN-1 slice-spec` where the
///    `dimI` are the dimensions of the larger tensor and `slice-spec`
///    specifies what part is covered by the tensor to save.
/// 
/// `slice-spec` itself is a `:`-separated list: `slice0:slice1:...:sliceN-1`
/// where each `sliceI` is either:
/// 
/// *  The string `-` meaning that the slice covers all indices of this dimension
/// *  `start,length` where `start` and `length` are integers.  In that
///    case the slice covers `length` indices starting at `start`.
/// 
/// See also `Save`.
class SaveSlicesOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Saves tensors in V2 checkpoint format.
/// By default, saves the named tensors in full.  If the caller wishes to save
/// specific slices of full tensors, "shape_and_slices" should be non-empty strings
/// and correspondingly well-formed.
class SaveV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Scatters `updates` into a tensor of shape `shape` according to `indices`.
/// Scatter sparse `updates` according to individual values at the specified
/// `indices`. This op returns an output tensor with the `shape` you specify. This
/// op is the inverse of the `tf.gather_nd` operator which extracts values or slices
/// from a given tensor.
/// 
/// This operation is similar to `tf.tensor_scatter_nd_add`, except that the tensor
/// is zero-initialized. Calling `tf.scatter_nd(indices, updates, shape)`
/// is identical to calling
/// `tf.tensor_scatter_nd_add(tf.zeros(shape, updates.dtype), indices, updates)`
/// 
/// If `indices` contains duplicates, the associated `updates` are accumulated
/// (summed) into the output tensor.
/// 
/// **WARNING**: For floating-point data types, the output may be nondeterministic.
/// This is because the order in which the updates are applied is nondeterministic
/// and when floating-point numbers are added in different orders the resulting
/// numerical approximation error can be slightly different. However, the output
/// will be deterministic if op determinism is enabled via
/// `tf.config.experimental.enable_op_determinism`.
/// 
/// `indices` is an integer tensor containing indices into the output tensor. The
/// last dimension of `indices` can be at most the rank of `shape`:
/// 
///     indices.shape[-1] <= shape.rank
/// 
/// The last dimension of `indices` corresponds to indices of elements
/// (if `indices.shape[-1] = shape.rank`) or slices
/// (if `indices.shape[-1] < shape.rank`) along dimension `indices.shape[-1]` of
/// `shape`.
/// 
/// `updates` is a tensor with shape:
/// 
///     indices.shape[:-1] + shape[indices.shape[-1]:]
/// 
/// The simplest form of the scatter op is to insert individual elements in
/// a tensor by index. Consider an example where you want to insert 4 scattered
/// elements in a rank-1 tensor with 8 elements.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/ScatterNd1.png" alt>
/// </div>
/// 
/// In Python, this scatter operation would look like this:
/// 
/// ```python
///     indices = tf.constant([[4], [3], [1], [7]])
///     updates = tf.constant([9, 10, 11, 12])
///     shape = tf.constant([8])
///     scatter = tf.scatter_nd(indices, updates, shape)
///     print(scatter)
/// ```
/// 
/// The resulting tensor would look like this:
/// 
///     [0, 11, 0, 10, 9, 0, 0, 12]
/// 
/// You can also insert entire slices of a higher rank tensor all at once. For
/// example, you can insert two slices in the first dimension of a rank-3 tensor
/// with two matrices of new values.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/ScatterNd2.png" alt>
/// </div>
/// 
/// In Python, this scatter operation would look like this:
/// 
/// ```python
///     indices = tf.constant([[1], [3]])
///     updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
///                             [7, 7, 7, 7], [8, 8, 8, 8]],
///                            [[5, 5, 5, 5], [6, 6, 6, 6],
///                             [7, 7, 7, 7], [8, 8, 8, 8]]])
///     shape = tf.constant([4, 4, 4])
///     scatter = tf.scatter_nd(indices, updates, shape)
///     print(scatter)
/// ```
/// 
/// The resulting tensor would look like this:
/// 
///     [[[0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0]],
///      [[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
///      [[0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0]],
///      [[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]]]
/// 
/// If `indices` contains any out-of-bound indices, depending on
/// `bad_indices_policy`, the op will either return an error or ignore the
/// out-of-bound indices. `bad_indices_policy` can be one of the following values:
/// 1. "" or "DEFAULT": raises on CPU and ignore on GPU. This is because
///    historically on CPU and GPU we handle errors in different ways, and for
///    backward compatibility we keep the default behavior.
/// 2. "ERROR": raises error; GPU does not support this value.
/// 3. "IGNORE": ignore the bad indices; supported on both CPU and GPU.
class ScatterNdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the maximum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \max_j(data_j)\\) where `max` is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the max is empty for a given segment ID `i`, `output[i] = 0`.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMax.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> tf.math.segment_max(c, tf.constant([0, 0, 1])).numpy()
/// array([[4, 3, 3, 4],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the maximum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \max_j(data_j)\\) where `max` is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the maximum is empty for a given segment ID `i`, it outputs the smallest
/// possible value for the specific numeric type,
/// `output[i] = numeric_limits<T>::lowest()`.
/// 
/// Note: That this op is currently only supported with jit_compile=True.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// The only difference with SegmentMax is the additional input  `num_segments`.
/// This helps in evaluating the output shape in compile time.
/// `num_segments` should be consistent with segment_ids.
/// e.g. Max(segment_ids) should be equal to `num_segments` - 1 for a 1-d segment_ids
/// With inconsistent num_segments, the op still runs. only difference is,
/// the output takes the size of num_segments irrespective of size of segment_ids and data.
/// for num_segments less than expected output size, the last elements are ignored
/// for num_segments more than the expected output size, last elements are assigned
/// smallest possible value for the specific numeric type.
/// 
/// For example:
/// 
/// >>> @tf.function(jit_compile=True)
/// ... def test(c):
/// ...   return tf.raw_ops.SegmentMaxV2(data=c, segment_ids=tf.constant([0, 0, 1]), num_segments=2)
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> test(c).numpy()
/// array([[4, 3, 3, 4],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentMaxV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the mean along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \frac{\sum_j data_j}{N}\\) where `mean` is
/// over `j` such that `segment_ids[j] == i` and `N` is the total number of
/// values summed.
/// 
/// If the mean is empty for a given segment ID `i`, `output[i] = 0`.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as a smaller following index when computing the numerator
/// of the mean.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMean.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1.0,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> tf.math.segment_mean(c, tf.constant([0, 0, 1])).numpy()
/// array([[2.5, 2.5, 2.5, 2.5],
///        [5., 6., 7., 8.]], dtype=float32)
class SegmentMeanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the minimum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \min_j(data_j)\\) where `min` is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the min is empty for a given segment ID `i`, `output[i] = 0`.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMin.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> tf.math.segment_min(c, tf.constant([0, 0, 1])).numpy()
/// array([[1, 2, 2, 1],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentMinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the minimum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \min_j(data_j)\\) where `min` is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the minimum is empty for a given segment ID `i`, it outputs the largest
/// possible value for the specific numeric type,
/// `output[i] = numeric_limits<T>::max()`.
/// 
/// Note: That this op is currently only supported with jit_compile=True.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// The only difference with SegmentMin is the additional input  `num_segments`.
/// This helps in evaluating the output shape in compile time.
/// `num_segments` should be consistent with segment_ids.
/// e.g. Max(segment_ids) should be equal to `num_segments` - 1 for a 1-d segment_ids
/// With inconsistent num_segments, the op still runs. only difference is,
/// the output takes the size of num_segments irrespective of size of segment_ids and data.
/// for num_segments less than expected output size, the last elements are ignored
/// for num_segments more than the expected output size, last elements are assigned
/// the largest possible value for the specific numeric type.
/// 
/// For example:
/// 
/// >>> @tf.function(jit_compile=True)
/// ... def test(c):
/// ...   return tf.raw_ops.SegmentMinV2(data=c, segment_ids=tf.constant([0, 0, 1]), num_segments=2)
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> test(c).numpy()
/// array([[1, 2, 2, 1],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentMinV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the product along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \prod_j data_j\\) where the product is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the product is empty for a given segment ID `i`, `output[i] = 1`.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentProd.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> tf.math.segment_prod(c, tf.constant([0, 0, 1])).numpy()
/// array([[4, 6, 6, 4],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentProdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the product along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \prod_j data_j\\) where the product is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the product is empty for a given segment ID `i`, `output[i] = 1`.
/// 
/// Note: That this op is currently only supported with jit_compile=True.
/// 
/// The only difference with SegmentProd is the additional input  `num_segments`.
/// This helps in evaluating the output shape in compile time.
/// `num_segments` should be consistent with segment_ids.
/// e.g. Max(segment_ids) - 1 should be equal to `num_segments` for a 1-d segment_ids
/// With inconsistent num_segments, the op still runs. only difference is,
/// the output takes the size of num_segments irrespective of size of segment_ids and data.
/// for num_segments less than expected output size, the last elements are ignored
/// for num_segments more than the expected output size, last elements are assigned 1.
/// 
/// For example:
/// 
/// >>> @tf.function(jit_compile=True)
/// ... def test(c):
/// ...   return tf.raw_ops.SegmentProdV2(data=c, segment_ids=tf.constant([0, 0, 1]), num_segments=2)
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> test(c).numpy()
/// array([[4, 6, 6, 4],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentProdV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \sum_j data_j\\) where sum is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the sum is empty for a given segment ID `i`, `output[i] = 0`.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentSum.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> tf.math.segment_sum(c, tf.constant([0, 0, 1])).numpy()
/// array([[5, 5, 5, 5],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentSumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \sum_j data_j\\) where sum is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the sum is empty for a given segment ID `i`, `output[i] = 0`.
/// 
/// Note that this op is currently only supported with jit_compile=True.
/// </div>
class SegmentSumV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Selects elements from `x` or `y`, depending on `condition`.
/// The `x`, and `y` tensors must all have the same shape, and the
/// output will also have that shape.
/// 
/// The `condition` tensor must be a scalar if `x` and `y` are scalars.
/// If `x` and `y` are vectors or higher rank, then `condition` must be either a
/// scalar, a vector with size matching the first dimension of `x`, or must have
/// the same shape as `x`.
/// 
/// The `condition` tensor acts as a mask that chooses, based on the value at each
/// element, whether the corresponding element / row in the output should be
/// taken from `x` (if true) or `y` (if false).
/// 
/// If `condition` is a vector and `x` and `y` are higher rank matrices, then
/// it chooses which row (outer dimension) to copy from `x` and `y`.
/// If `condition` has the same shape as `x` and `y`, then it chooses which
/// element to copy from `x` and `y`.
/// 
/// For example:
/// 
/// ```python
/// # 'condition' tensor is [[True,  False]
/// #                        [False, True]]
/// # 't' is [[1, 2],
/// #         [3, 4]]
/// # 'e' is [[5, 6],
/// #         [7, 8]]
/// select(condition, t, e)  # => [[1, 6], [7, 4]]
/// 
/// 
/// # 'condition' tensor is [True, False]
/// # 't' is [[1, 2],
/// #         [3, 4]]
/// # 'e' is [[5, 6],
/// #         [7, 8]]
/// select(condition, t, e) ==> [[1, 2],
///                              [7, 8]]
/// 
/// ```
class SelectOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class SelectV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the eigen decomposition of one or more square self-adjoint matrices.
/// Computes the eigenvalues and (optionally) eigenvectors of each inner matrix in
/// `input` such that `input[..., :, :] = v[..., :, :] * diag(e[..., :])`. The eigenvalues
/// are sorted in non-decreasing order.
/// 
/// ```python
/// # a is a tensor.
/// # e is a tensor of eigenvalues.
/// # v is a tensor of eigenvectors.
/// e, v = self_adjoint_eig(a)
/// e = self_adjoint_eig(a, compute_v=False)
/// ```
class SelfAdjointEigV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients for the scaled exponential linear (Selu) operation.
class SeluGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes scaled exponential linear: `scale * alpha * (exp(features) - 1)`
/// if < 0, `scale * features` otherwise.
/// 
/// To be used together with
/// `initializer = tf.variance_scaling_initializer(factor=1.0, mode='FAN_IN')`.
/// For correct dropout, use `tf.contrib.nn.alpha_dropout`.
/// 
/// See [Self-Normalizing Neural Networks](https://arxiv.org/abs/1706.02515)
class SeluOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Sends the named tensor from send_device to recv_device.
class SendOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Performs gradient updates of embedding tables.
class SendTPUEmbeddingGradientsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts the given `resource_handle` representing an iterator to a variant tensor.
class SerializeIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Serialize a `SparseTensor` into a `[3]` `Tensor` object.
class SerializeSparseOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op used to indicate to the compiler and runtime the static bounds of a tensor.
/// The information passed through this op can possibly be used by the compiler and
/// runtime to perform certain optimizations such as more efficient DMAs. The
/// bounds passed via this op should be considered advisory only, and depending on
/// the implementation, might do nothing and simply be an identity
/// 
/// `input`: The tensor that has dynamic dimensions.
/// `static_shape`: The static shape of the tensor, corresponds to the maximum bounds of each dimension.
/// `output` is the input tensor with no changes done to it.
/// 
/// Example usage:
/// 
/// def tpu_call(args):
///   def model_fn(args):
///     # do something with dynamic tensor
/// 
///   @function.Defun(capture_resource_var_by_value=False)
///   def tpu_subgraph():
///       return tf.tpu.rewrite(model_fn, args)
/// 
///   return tf.raw_ops.TPUPartitionedCall(
///       args=tpu_subgraph.captured_inputs,
///       Tout=[o.type for o in tpu_subgraph.definition.signature.output_arg],
///       f=tpu_subgraph,
///       device_ordinal=[0])
/// 
/// static_shape = tf.placeholder(tf.int32, shape=([3]), name='static_size')
/// 
/// w = tf.Variable(tf.constant([[1.0], [2.0], [3.0]]), name='w')
/// 
/// w_dyn = tf.SetDynamicDimensionBounds(w, static_size])
/// tpu_call([w_dyn])
class SetStaticDimensionBoundsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns shape of tensors.
/// This operation returns N 1-D integer tensors representing shape of `input[i]s`.
class ShapeNOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the shape of a tensor.
/// This operation returns a 1-D integer tensor representing the shape of `input`.
/// 
/// For example:
/// 
/// ```
/// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
/// shape(t) ==> [2, 2, 3]
/// ```
class ShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Generate a sharded filename. The filename is printf formatted as
/// %s-%05d-of-%05d, basename, shard, num_shards.
class ShardedFilenameOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class ShuffleAndRepeatDatasetV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class ShuffleDatasetV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class ShuffleDatasetV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Shuts down a running distributed TPU system.
/// The op returns an error if no system is running.
class ShutdownDistributedTPUOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that shuts down the TPU system.
class ShutdownTPUSystemOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient of the sigmoid of `x` wrt its input.
/// Specifically, `grad = dy * y * (1 - y)`, where `y = sigmoid(x)`, and
/// `dy` is the corresponding input gradient.
class SigmoidGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes sigmoid of `x` element-wise.
/// Specifically, `y = 1 / (1 + exp(-x))`.
class SigmoidOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns an element-wise indication of the sign of a number.
/// `y = sign(x) = -1` if `x < 0`; 0 if `x == 0`; 1 if `x > 0`.
/// 
/// For complex numbers, `y = sign(x) = x / |x|` if `x != 0`, otherwise `y = 0`.
/// 
/// Example usage:
/// >>> tf.math.sign([0., 2., -3.])
/// <tf.Tensor: shape=(3,), dtype=float32, numpy=array([ 0.,  1., -1.], dtype=float32)>
class SignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes sine of x element-wise.
/// Given an input tensor, this function computes sine of every
///   element in the tensor. Input range is `(-inf, inf)` and
///   output range is `[-1,1]`.
/// 
///   ```python
///   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 200, 10, float("inf")])
///   tf.math.sin(x) ==> [nan -0.4121185 -0.47942555 0.84147096 0.9320391 -0.87329733 -0.54402107 nan]
///   ```
class SinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes hyperbolic sine of x element-wise.
/// Given an input tensor, this function computes hyperbolic sine of every
///   element in the tensor. Input range is `[-inf,inf]` and output range
///   is `[-inf,inf]`.
/// 
///   ```python
///   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 2, 10, float("inf")])
///   tf.math.sinh(x) ==> [-inf -4.0515420e+03 -5.2109528e-01 1.1752012e+00 1.5094614e+00 3.6268604e+00 1.1013232e+04 inf]
///   ```
class SinhOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the size of a tensor.
/// This operation returns an integer representing the number of elements in
/// `input`.
/// 
/// For example:
/// 
/// ```
/// # 't' is [[[1, 1,, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]]
/// size(t) ==> 12
/// ```
class SizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Return a slice from 'input'.
/// The output tensor is a tensor with dimensions described by 'size'
/// whose values are extracted from 'input' starting at the offsets in
/// 'begin'.
/// 
/// *Requirements*:
///   0 <= begin[i] <= begin[i] + size[i] <= Di  for i in [0, n)
class SliceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a copy of the input tensor.
class SnapshotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softmax cross entropy cost and gradients to backpropagate.
/// Inputs are the logits, not probabilities.
class SoftmaxCrossEntropyWithLogitsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softmax activations.
/// For each batch `i` and class `j` we have
/// 
///     $$softmax[i, j] = exp(logits[i, j]) / sum_j(exp(logits[i, j]))$$
class SoftmaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softplus gradients for a softplus operation.
class SoftplusGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class SoftplusOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softsign gradients for a softsign operation.
class SoftsignGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softsign: `features / (abs(features) + 1)`.
class SoftsignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op which sorts each COO tensors in the list by which SparseCore the id will go to. This op should be used along with the ConvertToSparseCoreCsrWrappedCooTensorOp.
class SortListOfSparseCoreCooTensorsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// SpaceToBatch for N-D tensors of type T.
/// This operation divides "spatial" dimensions `[1, ..., M]` of the input into a
/// grid of blocks of shape `block_shape`, and interleaves these blocks with the
/// "batch" dimension (0) such that in the output, the spatial dimensions
/// `[1, ..., M]` correspond to the position within the grid, and the batch
/// dimension combines both the position within a spatial block and the original
/// batch position.  Prior to division into blocks, the spatial dimensions of the
/// input are optionally zero padded according to `paddings`. See below for a
/// precise description.
/// 
/// This operation is equivalent to the following steps:
/// 
/// 1. Zero-pad the start and end of dimensions `[1, ..., M]` of the
///    input according to `paddings` to produce `padded` of shape `padded_shape`.
/// 
/// 2. Reshape `padded` to `reshaped_padded` of shape:
/// 
///      [batch] +
///      [padded_shape[1] / block_shape[0],
///        block_shape[0],
///       ...,
///       padded_shape[M] / block_shape[M-1],
///       block_shape[M-1]] +
///      remaining_shape
/// 
/// 3. Permute dimensions of `reshaped_padded` to produce
///    `permuted_reshaped_padded` of shape:
/// 
///      block_shape +
///      [batch] +
///      [padded_shape[1] / block_shape[0],
///       ...,
///       padded_shape[M] / block_shape[M-1]] +
///      remaining_shape
/// 
/// 4. Reshape `permuted_reshaped_padded` to flatten `block_shape` into the batch
///    dimension, producing an output tensor of shape:
/// 
///      [batch * prod(block_shape)] +
///      [padded_shape[1] / block_shape[0],
///       ...,
///       padded_shape[M] / block_shape[M-1]] +
///      remaining_shape
/// 
/// Some examples:
/// 
/// (1) For the following input of shape `[1, 2, 2, 1]`, `block_shape = [2, 2]`, and
///     `paddings = [[0, 0], [0, 0]]`:
/// 
/// ```
/// x = [[[[1], [2]], [[3], [4]]]]
/// ```
/// 
/// The output tensor has shape `[4, 1, 1, 1]` and value:
/// 
/// ```
/// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
/// ```
/// 
/// (2) For the following input of shape `[1, 2, 2, 3]`, `block_shape = [2, 2]`, and
///     `paddings = [[0, 0], [0, 0]]`:
/// 
/// ```
/// x = [[[[1, 2, 3], [4, 5, 6]],
///       [[7, 8, 9], [10, 11, 12]]]]
/// ```
/// 
/// The output tensor has shape `[4, 1, 1, 3]` and value:
/// 
/// ```
/// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
/// ```
/// 
/// (3) For the following input of shape `[1, 4, 4, 1]`, `block_shape = [2, 2]`, and
///     `paddings = [[0, 0], [0, 0]]`:
/// 
/// ```
/// x = [[[[1],   [2],  [3],  [4]],
///       [[5],   [6],  [7],  [8]],
///       [[9],  [10], [11],  [12]],
///       [[13], [14], [15],  [16]]]]
/// ```
/// 
/// The output tensor has shape `[4, 2, 2, 1]` and value:
/// 
/// ```
/// x = [[[[1], [3]], [[9], [11]]],
///      [[[2], [4]], [[10], [12]]],
///      [[[5], [7]], [[13], [15]]],
///      [[[6], [8]], [[14], [16]]]]
/// ```
/// 
/// (4) For the following input of shape `[2, 2, 4, 1]`, block_shape = `[2, 2]`, and
///     paddings = `[[0, 0], [2, 0]]`:
/// 
/// ```
/// x = [[[[1],   [2],  [3],  [4]],
///       [[5],   [6],  [7],  [8]]],
///      [[[9],  [10], [11],  [12]],
///       [[13], [14], [15],  [16]]]]
/// ```
/// 
/// The output tensor has shape `[8, 1, 3, 1]` and value:
/// 
/// ```
/// x = [[[[0], [1], [3]]], [[[0], [9], [11]]],
///      [[[0], [2], [4]]], [[[0], [10], [12]]],
///      [[[0], [5], [7]]], [[[0], [13], [15]]],
///      [[[0], [6], [8]]], [[[0], [14], [16]]]]
/// ```
/// 
/// Among others, this operation is useful for reducing atrous convolution into
/// regular convolution.
class SpaceToBatchNDOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// SpaceToBatch for 4-D tensors of type T.
/// This is a legacy version of the more general SpaceToBatchND.
/// 
/// Zero-pads and then rearranges (permutes) blocks of spatial data into batch.
/// More specifically, this op outputs a copy of the input tensor where values from
/// the `height` and `width` dimensions are moved to the `batch` dimension. After
/// the zero-padding, both `height` and `width` of the input must be divisible by the
/// block size.
/// 
/// The attr `block_size` must be greater than one. It indicates the block size.
/// 
///   * Non-overlapping blocks of size `block_size x block size` in the height and
///     width dimensions are rearranged into the batch dimension at each location.
///   * The batch of the output tensor is `batch * block_size * block_size`.
///   * Both height_pad and width_pad must be divisible by block_size.
/// 
/// The shape of the output will be:
/// 
///     [batch*block_size*block_size, height_pad/block_size, width_pad/block_size,
///      depth]
/// 
/// Some examples:
/// 
/// (1) For the following input of shape `[1, 2, 2, 1]` and block_size of 2:
/// 
/// ```
/// x = [[[[1], [2]], [[3], [4]]]]
/// ```
/// 
/// The output tensor has shape `[4, 1, 1, 1]` and value:
/// 
/// ```
/// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
/// ```
/// 
/// (2) For the following input of shape `[1, 2, 2, 3]` and block_size of 2:
/// 
/// ```
/// x = [[[[1, 2, 3], [4, 5, 6]],
///       [[7, 8, 9], [10, 11, 12]]]]
/// ```
/// 
/// The output tensor has shape `[4, 1, 1, 3]` and value:
/// 
/// ```
/// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
/// ```
/// 
/// (3) For the following input of shape `[1, 4, 4, 1]` and block_size of 2:
/// 
/// ```
/// x = [[[[1],   [2],  [3],  [4]],
///       [[5],   [6],  [7],  [8]],
///       [[9],  [10], [11],  [12]],
///       [[13], [14], [15],  [16]]]]
/// ```
/// 
/// The output tensor has shape `[4, 2, 2, 1]` and value:
/// 
/// ```
/// x = [[[[1], [3]], [[9], [11]]],
///      [[[2], [4]], [[10], [12]]],
///      [[[5], [7]], [[13], [15]]],
///      [[[6], [8]], [[14], [16]]]]
/// ```
/// 
/// (4) For the following input of shape `[2, 2, 4, 1]` and block_size of 2:
/// 
/// ```
/// x = [[[[1],   [2],  [3],  [4]],
///       [[5],   [6],  [7],  [8]]],
///      [[[9],  [10], [11],  [12]],
///       [[13], [14], [15],  [16]]]]
/// ```
/// 
/// The output tensor has shape `[8, 1, 2, 1]` and value:
/// 
/// ```
/// x = [[[[1], [3]]], [[[9], [11]]], [[[2], [4]]], [[[10], [12]]],
///      [[[5], [7]]], [[[13], [15]]], [[[6], [8]]], [[[14], [16]]]]
/// ```
/// 
/// Among others, this operation is useful for reducing atrous convolution into
/// regular convolution.
class SpaceToBatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// SpaceToDepth for tensors of type T.
/// Rearranges blocks of spatial data, into depth. More specifically,
/// this op outputs a copy of the input tensor where values from the `height`
/// and `width` dimensions are moved to the `depth` dimension.
/// The attr `block_size` indicates the input block size.
/// 
///   * Non-overlapping blocks of size `block_size x block size` are rearranged
///     into depth at each location.
///   * The depth of the output tensor is `block_size * block_size * input_depth`.
///   * The Y, X coordinates within each block of the input become the high order
///     component of the output channel index.
///   * The input tensor's height and width must be divisible by block_size.
/// 
/// The `data_format` attr specifies the layout of the input and output tensors
/// with the following options:
///   "NHWC": `[ batch, height, width, channels ]`
///   "NCHW": `[ batch, channels, height, width ]`
///   "NCHW_VECT_C":
///       `qint8 [ batch, channels / 4, height, width, 4 ]`
/// 
/// It is useful to consider the operation as transforming a 6-D Tensor.
/// e.g. for data_format = NHWC,
///      Each element in the input tensor can be specified via 6 coordinates,
///      ordered by decreasing memory layout significance as:
///      n,oY,bY,oX,bX,iC  (where n=batch index, oX, oY means X or Y coordinates
///                         within the output image, bX, bY means coordinates
///                         within the input block, iC means input channels).
///      The output would be a transpose to the following layout:
///      n,oY,oX,bY,bX,iC
/// 
/// This operation is useful for resizing the activations between convolutions
/// (but keeping all data), e.g. instead of pooling. It is also useful for training
/// purely convolutional models.
/// 
/// For example, given an input of shape `[1, 2, 2, 1]`, data_format = "NHWC" and
/// block_size = 2:
/// 
/// ```
/// x = [[[[1], [2]],
///       [[3], [4]]]]
/// ```
/// 
/// This operation will output a tensor of shape `[1, 1, 1, 4]`:
/// 
/// ```
/// [[[[1, 2, 3, 4]]]]
/// ```
/// 
/// Here, the input has a batch of 1 and each batch element has shape `[2, 2, 1]`,
/// the corresponding output will have a single element (i.e. width and height are
/// both 1) and will have a depth of 4 channels (1 * block_size * block_size).
/// The output element shape is `[1, 1, 4]`.
/// 
/// For an input tensor with larger depth, here of shape `[1, 2, 2, 3]`, e.g.
/// 
/// ```
/// x = [[[[1, 2, 3], [4, 5, 6]],
///       [[7, 8, 9], [10, 11, 12]]]]
/// ```
/// 
/// This operation, for block_size of 2, will return the following tensor of shape
/// `[1, 1, 1, 12]`
/// 
/// ```
/// [[[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]]]]
/// ```
/// 
/// Similarly, for the following input of shape `[1 4 4 1]`, and a block size of 2:
/// 
/// ```
/// x = [[[[1],   [2],  [5],  [6]],
///       [[3],   [4],  [7],  [8]],
///       [[9],  [10], [13],  [14]],
///       [[11], [12], [15],  [16]]]]
/// ```
/// 
/// the operator will return the following tensor of shape `[1 2 2 4]`:
/// 
/// ```
/// x = [[[[1, 2, 3, 4],
///        [5, 6, 7, 8]],
///       [[9, 10, 11, 12],
///        [13, 14, 15, 16]]]]
/// ```
class SpaceToDepthOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adds two `SparseTensor` objects to produce another `SparseTensor`.
/// The input `SparseTensor` objects' indices are assumed ordered in standard
/// lexicographic order.  If this is not the case, before this step run
/// `SparseReorder` to restore index ordering.
/// 
/// By default, if two values sum to zero at some index, the output `SparseTensor`
/// would still include that particular location in its index, storing a zero in the
/// corresponding value slot.  To override this, callers can specify `thresh`,
/// indicating that if the sum has a magnitude strictly smaller than `thresh`, its
/// corresponding value and index would then not be included.  In particular,
/// `thresh == 0` (default) means everything is kept and actual thresholding happens
/// only for a positive value.
/// 
/// In the following shapes, `nnz` is the count after taking `thresh` into account.
class SparseAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Fills empty rows in the input 2-D `SparseTensor` with a default value.
/// The input `SparseTensor` is represented via the tuple of inputs
/// (`indices`, `values`, `dense_shape`).  The output `SparseTensor` has the
/// same `dense_shape` but with indices `output_indices` and values
/// `output_values`.
/// 
/// This op inserts a single entry for every row that doesn't have any values.
/// The index is created as `[row, 0, ..., 0]` and the inserted value
/// is `default_value`.
/// 
/// For example, suppose `sp_input` has shape `[5, 6]` and non-empty values:
/// 
///     [0, 1]: a
///     [0, 3]: b
///     [2, 0]: c
///     [3, 1]: d
/// 
/// Rows 1 and 4 are empty, so the output will be of shape `[5, 6]` with values:
/// 
///     [0, 1]: a
///     [0, 3]: b
///     [1, 0]: default_value
///     [2, 0]: c
///     [3, 1]: d
///     [4, 0]: default_value
/// 
/// The output `SparseTensor` will be in row-major order and will have the
/// same shape as the input.
/// 
/// This op also returns an indicator vector shaped `[dense_shape[0]]` such that
/// 
///     empty_row_indicator[i] = True iff row i was an empty row.
/// 
/// And a reverse index map vector shaped `[indices.shape[0]]` that is used during
/// backpropagation,
/// 
///     reverse_index_map[j] = out_j s.t. indices[j, :] == output_indices[out_j, :]
class SparseFillEmptyRowsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Multiply matrix "a" by matrix "b".
/// The inputs must be two-dimensional matrices and the inner dimension of "a" must
/// match the outer dimension of "b". Both "a" and "b" must be `Tensor`s not
/// `SparseTensor`s.  This op is optimized for the case where at least one of "a" or
/// "b" is sparse, in the sense that they have a large proportion of zero values.
/// The breakeven for using this versus a dense matrix multiply on one platform was
/// 30% zero values in the sparse matrix.
/// 
/// The gradient computation of this operation will only take advantage of sparsity
/// in the input gradient when that gradient comes from a Relu.
class SparseMatMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum of elements across dimensions of a SparseTensor.
/// This Op takes a SparseTensor and is the sparse counterpart to
/// `tf.reduce_sum()`.  In particular, this Op also returns a dense `Tensor`
/// instead of a sparse one.
/// 
/// Reduces `sp_input` along the dimensions given in `reduction_axes`.  Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `reduction_axes`. If `keep_dims` is true, the reduced dimensions are retained
/// with length 1.
/// 
/// If `reduction_axes` has no entries, all dimensions are reduced, and a tensor
/// with a single element is returned.  Additionally, the axes can be negative,
/// which are interpreted according to the indexing rules in Python.
class SparseReduceSumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reshapes a SparseTensor to represent values in a new dense shape.
/// This operation has the same semantics as reshape on the represented dense
/// tensor.  The `input_indices` are recomputed based on the requested `new_shape`.
/// 
/// If one component of `new_shape` is the special value -1, the size of that
/// dimension is computed so that the total dense size remains constant.  At
/// most one component of `new_shape` can be -1.  The number of dense elements
/// implied by `new_shape` must be the same as the number of dense elements
/// originally implied by `input_shape`.
/// 
/// Reshaping does not affect the order of values in the SparseTensor.
/// 
/// If the input tensor has rank `R_in` and `N` non-empty values, and `new_shape`
/// has length `R_out`, then `input_indices` has shape `[N, R_in]`,
/// `input_shape` has length `R_in`, `output_indices` has shape `[N, R_out]`, and
/// `output_shape` has length `R_out`.
class SparseReshapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients for SparseSegmentMean.
/// Returns tensor "output" with same shape as grad, except for dimension 0 whose
/// value is output_dim0.
class SparseSegmentMeanGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the mean along sparse segments of a tensor.
/// See `tf.sparse.segment_sum` for usage examples.
/// 
/// Like `SegmentMean`, but `segment_ids` can have rank less than `data`'s first
/// dimension, selecting a subset of dimension 0, specified by `indices`.
class SparseSegmentMeanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the mean along sparse segments of a tensor.
/// Like `SparseSegmentMean`, but allows missing ids in `segment_ids`. If an id is
/// missing, the `output` tensor at that position will be zeroed.
/// 
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
class SparseSegmentMeanWithNumSegmentsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients for SparseSegmentSqrtN.
/// Returns tensor "output" with same shape as grad, except for dimension 0 whose
/// value is output_dim0.
class SparseSegmentSqrtNGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along sparse segments of a tensor divided by the sqrt of N.
/// N is the size of the segment being reduced.
/// 
/// See `tf.sparse.segment_sum` for usage examples.
class SparseSegmentSqrtNOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along sparse segments of a tensor divided by the sqrt of N.
/// N is the size of the segment being reduced.
/// 
/// Like `SparseSegmentSqrtN`, but allows missing ids in `segment_ids`. If an id is
/// missing, the `output` tensor at that position will be zeroed.
/// 
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
class SparseSegmentSqrtNWithNumSegmentsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along sparse segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Like `SegmentSum`, but `segment_ids` can have rank less than `data`'s first
/// dimension, selecting a subset of dimension 0, specified by `indices`.
/// 
/// For example:
/// 
/// ```python
/// c = tf.constant([[1,2,3,4], [-1,-2,-3,-4], [5,6,7,8]])
/// 
/// # Select two rows, one segment.
/// tf.sparse_segment_sum(c, tf.constant([0, 1]), tf.constant([0, 0]))
/// # => [[0 0 0 0]]
/// 
/// # Select two rows, two segment.
/// tf.sparse_segment_sum(c, tf.constant([0, 1]), tf.constant([0, 1]))
/// # => [[ 1  2  3  4]
/// #     [-1 -2 -3 -4]]
/// 
/// # Select all rows, two segments.
/// tf.sparse_segment_sum(c, tf.constant([0, 1, 2]), tf.constant([0, 0, 1]))
/// # => [[0 0 0 0]
/// #     [5 6 7 8]]
/// 
/// # Which is equivalent to:
/// tf.segment_sum(c, tf.constant([0, 0, 1]))
/// ```
class SparseSegmentSumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softmax cross entropy cost and gradients to backpropagate.
/// Unlike `SoftmaxCrossEntropyWithLogits`, this operation does not accept
/// a matrix of label probabilities, but rather a single label per row
/// of features.  This label is considered to have probability 1.0 for the
/// given row.
/// 
/// Inputs are the logits, not probabilities.
class SparseSoftmaxCrossEntropyWithLogitsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Multiply SparseTensor (of rank 2) "A" by dense matrix "B".
/// No validity checking is performed on the indices of A.  However, the following
/// input format is recommended for optimal behavior:
/// 
/// if adjoint_a == false:
///   A should be sorted in lexicographically increasing order.  Use SparseReorder
///   if you're not sure.
/// if adjoint_a == true:
///   A should be sorted in order of increasing dimension 1 (i.e., "column major"
///   order instead of "row major" order).
class SparseTensorDenseMatMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts a sparse representation into a dense tensor.
/// Builds an array `dense` with shape `output_shape` such that
/// 
/// ```
/// # If sparse_indices is scalar
/// dense[i] = (i == sparse_indices ? sparse_values : default_value)
/// 
/// # If sparse_indices is a vector, then for each i
/// dense[sparse_indices[i]] = sparse_values[i]
/// 
/// # If sparse_indices is an n by d matrix, then for each i in [0, n)
/// dense[sparse_indices[i][0], ..., sparse_indices[i][d-1]] = sparse_values[i]
/// ```
/// 
/// All other values in `dense` are set to `default_value`.  If `sparse_values` is a
/// scalar, all sparse indices are set to this single value.
/// 
/// Indices should be sorted in lexicographic order, and indices must not
/// contain any repeats. If `validate_indices` is true, these properties
/// are checked during execution.
class SparseToDenseOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Splits a tensor into `num_split` tensors along one dimension.
class SplitOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Splits a tensor into `num_split` tensors along one dimension.
class SplitVOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient for the sqrt of `x` wrt its input.
/// Specifically, `grad = dy * 0.5 / y`, where `y = sqrt(x)`, and `dy`
/// is the corresponding input gradient.
class SqrtGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes square root of x element-wise.
/// I.e., \\(y = \sqrt{x} = x^{1/2}\\).
class SqrtOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes square of x element-wise.
/// I.e., \\(y = x * x = x^2\\).
class SquareOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns conj(x - y)(x - y) element-wise.
/// *NOTE*: `SquaredDifference` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class SquaredDifferenceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Removes dimensions of size 1 from the shape of a tensor.
/// Given a tensor `input`, this operation returns a tensor of the same type with
/// all dimensions of size 1 removed. If you don't want to remove all size 1
/// dimensions, you can remove specific size 1 dimensions by specifying
/// `axis`.
/// 
/// For example:
/// 
/// ```
/// # 't' is a tensor of shape [1, 2, 1, 3, 1, 1]
/// shape(squeeze(t)) ==> [2, 3]
/// ```
/// 
/// Or, to remove specific size 1 dimensions:
/// 
/// ```
/// # 't' is a tensor of shape [1, 2, 1, 3, 1, 1]
/// shape(squeeze(t, [2, 4])) ==> [1, 2, 3, 1]
/// ```
class SqueezeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Delete the stack from its resource container.
class StackCloseV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Pop the element at the top of the stack.
class StackPopV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Push an element onto the stack.
class StackPushV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A stack that produces elements in first-in last-out order.
class StackV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// returns `f(inputs)`, where `f`'s body is placed and partitioned.
/// Asynchronously executes a function, potentially across multiple devices but
/// within a single process. The kernel places and partitions a given function's
/// underlying graph, and executes each of the partitioned subgraphs as a function.
class StatefulPartitionedCallOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a normal distribution.
/// The generated values will have mean 0 and standard deviation 1.
class StatefulStandardNormalV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a truncated normal distribution.
/// The generated values follow a normal distribution with mean 0 and standard
/// deviation 1, except that values whose magnitude is more than 2 standard
/// deviations from the mean are dropped and re-picked.
class StatefulTruncatedNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random integers from a uniform distribution.
/// The generated values are uniform integers covering the whole range of `dtype`.
class StatefulUniformFullIntOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random integers from a uniform distribution.
/// The generated values are uniform integers in the range `[minval, maxval)`.
/// The lower bound `minval` is included in the range, while the upper bound
/// `maxval` is excluded.
/// 
/// The random integers are slightly biased unless `maxval - minval` is an exact
/// power of two.  The bias is small for values of `maxval - minval` significantly
/// smaller than the range of the output (either `2^32` or `2^64`).
class StatefulUniformIntOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[0, 1)`. The
/// lower bound 0 is included in the range, while the upper bound 1 is excluded.
class StatefulUniformOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Draws samples from a multinomial distribution.
class StatelessMultinomialOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class StatelessParameterizedTruncatedNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random numbers from a binomial distribution.
/// Outputs random values from a binomial distribution.
/// 
/// The outputs are a deterministic function of `shape`, `seed`, `counts`, and `probs`.
class StatelessRandomBinomialOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random numbers from a gamma distribution.
/// Outputs random values from a gamma distribution.
/// 
/// The outputs are a deterministic function of `shape`, `seed`, and `alpha`.
class StatelessRandomGammaV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Picks the best counter-based RNG algorithm based on device.
/// This op picks the best counter-based RNG algorithm based on device.
class StatelessRandomGetAlgOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Picks the best algorithm based on device, and scrambles seed into key and counter.
/// This op picks the best counter-based RNG algorithm based on device, and scrambles a shape-[2] seed into a key and a counter, both needed by the counter-based algorithm. The scrambling is opaque but approximately satisfies the property that different seed results in different key/counter pair (which will in turn result in different random numbers).
class StatelessRandomGetKeyCounterAlgOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Scrambles seed into key and counter, using the best algorithm based on device.
/// This op scrambles a shape-[2] seed into a key and a counter, both needed by counter-based RNG algorithms. The scrambing uses the best algorithm based on device. The scrambling is opaque but approximately satisfies the property that different seed results in different key/counter pair (which will in turn result in different random numbers).
class StatelessRandomGetKeyCounterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom values from a normal distribution.
/// The generated values will have mean 0 and standard deviation 1.
/// 
/// The outputs are a deterministic function of `shape` and `seed`.
class StatelessRandomNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom values from a normal distribution.
/// The generated values will have mean 0 and standard deviation 1.
/// 
/// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
class StatelessRandomNormalV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random numbers from a Poisson distribution.
/// Outputs random values from a Poisson distribution.
/// 
/// The outputs are a deterministic function of `shape`, `seed`, and `lam`.
class StatelessRandomPoissonOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random integers from a uniform distribution.
/// The generated values are uniform integers covering the whole range of `dtype`.
/// 
/// The outputs are a deterministic function of `shape` and `seed`.
class StatelessRandomUniformFullIntOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random integers from a uniform distribution.
/// The generated values are uniform integers covering the whole range of `dtype`.
/// 
/// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
class StatelessRandomUniformFullIntV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random integers from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[minval, maxval)`.
/// 
/// The outputs are a deterministic function of `shape`, `seed`, `minval`, and `maxval`.
class StatelessRandomUniformIntOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random integers from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[minval, maxval)`.
/// 
/// The outputs are a deterministic function of `shape`, `key`, `counter`, `alg`, `minval` and `maxval`.
class StatelessRandomUniformIntV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random values from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[0, 1)`. The
/// lower bound 0 is included in the range, while the upper bound 1 is excluded.
/// 
/// The outputs are a deterministic function of `shape` and `seed`.
class StatelessRandomUniformOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random values from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[0, 1)`. The
/// lower bound 0 is included in the range, while the upper bound 1 is excluded.
/// 
/// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
class StatelessRandomUniformV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom values from a truncated normal distribution.
/// The generated values follow a normal distribution with mean 0 and standard
/// deviation 1, except that values whose magnitude is more than 2 standard
/// deviations from the mean are dropped and re-picked.
/// 
/// The outputs are a deterministic function of `shape` and `seed`.
class StatelessTruncatedNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom values from a truncated normal distribution.
/// The generated values follow a normal distribution with mean 0 and standard
/// deviation 1, except that values whose magnitude is more than 2 standard
/// deviations from the mean are dropped and re-picked.
/// 
/// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
class StatelessTruncatedNormalV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Check if the input matches the regex pattern.
/// The input is a string tensor of any shape. The pattern is the
/// regular expression to be matched with every element of the input tensor.
/// The boolean values (True or False) of the output tensor indicate
/// if the input matches the regex pattern provided.
/// 
/// The pattern follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
class StaticRegexFullMatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Stops gradient computation.
/// When executed in a graph, this op outputs its input tensor as-is.
/// 
/// When building ops to compute gradients, this op prevents the contribution of
/// its inputs to be taken into account.  Normally, the gradient generator adds ops
/// to a graph to compute the derivatives of a specified 'loss' by recursively
/// finding out inputs that contributed to its computation.  If you insert this op
/// in the graph it inputs are masked from the gradient generator.  They are not
/// taken into account for computing gradients.
/// 
/// This is useful any time you want to compute a value with TensorFlow but need
/// to pretend that the value was a constant. For example, the softmax function
/// for a vector x can be written as
/// 
/// ```python
/// 
///   def softmax(x):
///     numerator = tf.exp(x)
///     denominator = tf.reduce_sum(numerator)
///     return numerator / denominator
/// ```
/// 
/// This however is susceptible to overflow if the values in x are large. An
/// alternative more stable way is to subtract the maximum of x from each of the
/// values.
/// 
/// ```python
/// 
///   def stable_softmax(x):
///     z = x - tf.reduce_max(x)
///     numerator = tf.exp(z)
///     denominator = tf.reduce_sum(numerator)
///     return numerator / denominator
/// ```
/// 
/// However, when we backprop through the softmax to x, we dont want to backprop
/// through the `tf.reduce_max(x)` (if the max values are not unique then the
/// gradient could flow to the wrong input) calculation and treat that as a
/// constant. Therefore, we should write this out as
/// 
/// ```python
/// 
///   def stable_softmax(x):
///     z = x - tf.stop_gradient(tf.reduce_max(x))
///     numerator = tf.exp(z)
///     denominator = tf.reduce_sum(numerator)
///     return numerator / denominator
/// ```
/// 
/// Some other examples include:
/// 
/// *  The *EM* algorithm where the *M-step* should not involve backpropagation
///    through the output of the *E-step*.
/// *  Contrastive divergence training of Boltzmann machines where, when
///    differentiating the energy function, the training must not backpropagate
///    through the graph that generated the samples from the model.
/// *  Adversarial training, where no backprop should happen through the adversarial
///    example generation process.
class StopGradientOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Store the number of IDs and unique IDs in an FDO table.
class StoreMinibatchStatisticsInFdoOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the gradient of `StridedSlice`.
/// Since `StridedSlice` cuts out pieces of its `input` which is size
/// `shape`, its gradient will have the same shape (which is passed here
/// as `shape`). The gradient will be zero in any element that the slice
/// does not select.
/// 
/// Arguments are the same as StridedSliceGrad with the exception that
/// `dy` is the input gradient to be propagated and `shape` is the
/// shape of `StridedSlice`'s `input`.
class StridedSliceGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Return a strided slice from `input`.
/// Note, most python users will want to use the Python `Tensor.__getitem__`
/// or `Variable.__getitem__` rather than this op directly.
/// 
/// The goal of this op is to produce a new tensor with a subset of
/// the elements from the `n` dimensional `input` tensor. The subset is chosen using
/// a sequence of `m` sparse range specifications encoded into the arguments
/// of this function. Note, in some cases
/// `m` could be equal to `n`, but this need not be the case. Each
/// range specification entry can be one of the following:
/// 
/// - An ellipsis (...). Ellipses are used to imply zero or more
///   dimensions of full-dimension selection and are produced using
///   `ellipsis_mask`. For example, `foo[...]` is the identity slice.
/// 
/// - A new axis. This is used to insert a new shape=1 dimension and is
///   produced using `new_axis_mask`. For example, `foo[:, ...]` where
///   `foo` is shape `(3, 4)` produces a `(1, 3, 4)` tensor.
/// 
/// 
/// - A range `begin:end:stride`. This is used to specify how much to choose from
///   a given dimension. `stride` can be any integer but 0.  `begin` is an integer
///   which represents the index of the first value to select while `end` represents
///   the index of the last value to select. The number of values selected in each
///   dimension is `end - begin` if `stride > 0` and `begin - end` if `stride < 0`.
///   `begin` and `end` can be negative where `-1` is the last element, `-2` is
///   the second to last. `begin_mask` controls whether to replace the explicitly
///   given `begin` with an implicit effective value of `0` if `stride > 0` and
///   `-1` if `stride < 0`. `end_mask` is analogous but produces the number
///   required to create the largest open interval. For example, given a shape
///   `(3,)` tensor `foo[:]`, the effective `begin` and `end` are `0` and `3`. Do
///   not assume this is equivalent to `foo[0:-1]` which has an effective `begin`
///   and `end` of `0` and `2`. Another example is `foo[-2::-1]` which reverses the
///   first dimension of a tensor while dropping the last two (in the original
///   order elements). For example `foo = [1,2,3,4]; foo[-2::-1]` is `[4,3]`.
/// 
/// - A single index. This is used to keep only elements that have a given
///   index. For example (`foo[2, :]` on a shape `(5,6)` tensor produces a
///   shape `(6,)` tensor. This is encoded in `begin` and `end` and
///   `shrink_axis_mask`.
/// 
/// Each conceptual range specification is encoded in the op's argument. This
/// encoding is best understand by considering a non-trivial example. In
/// particular,
/// `foo[1, 2:4, None, ..., :-3:-1, :]` will be encoded as
/// 
/// ```
/// begin = [1, 2, x, x, 0, x] # x denotes don't care (usually 0)
/// end = [2, 4, x, x, -3, x]
/// strides = [1, 1, x, x, -1, 1]
/// begin_mask = 1<<4 | 1<<5 = 48
/// end_mask = 1<<5 = 32
/// ellipsis_mask = 1<<3 = 8
/// new_axis_mask = 1<<2 = 4
/// shrink_axis_mask = 1<<0 = 1
/// ```
/// 
/// In this case if `foo.shape` is (5, 5, 5, 5, 5, 5) the final shape of
/// the slice becomes (2, 1, 5, 5, 2, 5).
/// Let us walk step by step through each argument specification.
/// 
/// 1.  The first argument in the example slice is turned into `begin = 1` and
/// `end = begin + 1 = 2`. To disambiguate from the original spec `2:4` we
/// also set the appropriate bit in `shrink_axis_mask`.
/// 
/// 2. `2:4` is contributes 2, 4, 1 to begin, end, and stride. All masks have
/// zero bits contributed.
/// 
/// 3. None is a synonym for `tf.newaxis`. This means insert a dimension of size 1
/// dimension in the final shape. Dummy values are contributed to begin,
/// end and stride, while the new_axis_mask bit is set.
/// 
/// 4. `...` grab the full ranges from as many dimensions as needed to
/// fully specify a slice for every dimension of the input shape.
/// 
/// 5. `:-3:-1` shows the use of negative indices. A negative index `i` associated
/// with a dimension that has shape `s` is converted to a positive index
/// `s + i`. So `-1` becomes `s-1` (i.e. the last element). This conversion
/// is done internally so begin, end and strides receive x, -3, and -1.
/// The appropriate begin_mask bit is set to indicate the start range is the
/// full range (ignoring the x).
/// 
/// 6. `:` indicates that the entire contents of the corresponding dimension
/// is selected. This is equivalent to `::` or `0::1`. begin, end, and strides
/// receive 0, 0, and 1, respectively. The appropriate bits in `begin_mask` and
/// `end_mask` are also set.
/// 
/// *Requirements*:
///   `0 != strides[i] for i in [0, m)`
///   `ellipsis_mask must be a power of two (only one ellipsis)`
class StridedSliceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Formats a string template using a list of tensors.
/// Formats a string template using a list of tensors, pretty-printing tensor summaries.
class StringFormatOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Joins the strings in the given list of string tensors into one tensor;
/// with the given separator (default is an empty separator).
/// 
/// Examples:
/// 
/// >>> s = ["hello", "world", "tensorflow"]
/// >>> tf.strings.join(s, " ")
/// <tf.Tensor: shape=(), dtype=string, numpy=b'hello world tensorflow'>
class StringJoinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Strip leading and trailing whitespaces from the Tensor.
/// Examples:
/// 
/// >>> tf.strings.strip(["\nTensorFlow", "     The python library    "]).numpy()
/// array([b'TensorFlow', b'The python library'], dtype=object)
class StringStripOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts each string in the input Tensor to its hash mod by a number of buckets.
/// The hash function is deterministic on the content of the string within the
/// process and will never change. However, it is not suitable for cryptography.
/// This function may be used when CPU time is scarce and inputs are trusted or
/// unimportant. There is a risk of adversaries constructing inputs that all hash
/// to the same bucket. To prevent this problem, use a strong hash function with
/// `tf.string_to_hash_bucket_strong`.
/// 
/// Examples:
/// 
/// >>> tf.strings.to_hash_bucket_fast(["Hello", "TensorFlow", "2.x"], 3).numpy()
/// array([0, 2, 2])
class StringToHashBucketFastOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x - y element-wise.
/// *NOTE*: `Subtract` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class SubOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum of elements across dimensions of a tensor.
/// Reduces `input` along the dimensions given in `axis`. Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `axis`. If `keep_dims` is true, the reduced dimensions are
/// retained with length 1.
class SumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a handle to be used to access a summary writer.
/// The summary writer is an in-graph resource which can be used by ops to write
/// summaries to event files.
/// 
/// writer: the summary writer resource. Scalar handle.
class SummaryWriterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the singular value decompositions of one or more matrices.
/// Computes the SVD of each inner matrix in `input` such that
/// `input[..., :, :] = u[..., :, :] * diag(s[..., :, :]) * transpose(v[..., :, :])`
/// 
/// ```python
/// # a is a tensor containing a batch of matrices.
/// # s is a tensor of singular values for each matrix.
/// # u is the tensor containing the left singular vectors for each matrix.
/// # v is the tensor containing the right singular vectors for each matrix.
/// s, u, v = svd(a)
/// s, _, _ = svd(a, compute_uv=False)
/// ```
class SvdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient function for function f via backpropagation.
class SymbolicGradientOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Placeholder op which takes the output of TPUCopyWithDynamicShapeOp and pass
/// them to the following tpu ops.
/// This op serves as an annotation for the dynamic shaped tensor and will be
/// removed during the bridge rewrite.
class TPUAnnotateTensorsWithDynamicShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the result of a TPU compilation.
/// This operation returns the result of a TPU compilation as a serialized
/// CompilationResultProto, which holds a status and an error message if an error
/// occurred during compilation.
class TPUCompilationResultOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that compiles a computation in MLIR into a TPU program, and loads and executes it on a TPU device.
/// For the internal use of the TPU compiler.
/// 
/// 'static_shapes' are tensors specifying the maximum dimension sizes for the tensors specified in `dynamic_operands`.
/// 'args' are inputs to the TPU computation.
/// 'operands_with_static_shape' are the indices of the operands that have a maximal static shape specified.
/// 'mlir_module' is a serialized MLIR module with a `main` function that contains
/// target computation.
/// 'metadata' is a serialized TPUCompileMetadataProto describing the shapes and
/// types of the inputs to the computation, as well as a mapping onto the TPU pod
/// topology.
/// 'producer_name' is a string describing the name of the framework that add support for running this portion of the model on TPUs.
class TPUCompileMlirAndExecuteOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Asserts that compilation succeeded.
/// This op produces no output and closes the device during failure to ensure all
/// pending device interactions fail.
/// 
/// 'compilation_status' is a serialized CompilationResultProto.
class TPUCompileSucceededAssertOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that copies host tensors to device with bounded dynamic shape support.
/// This op copies the padded tensor on cpu to TPU without the padded data. `tensors`
/// is a list of cpu tensors with padded data. `unpadded_sizes` is a list of shape
/// tensors which describes unpadded size of each dimension for each cpu tensor.
/// The size of the `unpadded_sizes` should be the same as `tensors`. They are both
/// on host. `tpu_tensors` are list of tpu device tensors without the padded data.
/// `tpu_tensors` also has the same size of the `tensors` and the shapes of
/// `tpu_tensors` are determined by the `unpadded_sizes`.
class TPUCopyWithDynamicShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that copies host tensor to device with specified layout.
/// For internal use only.
class TPUCopyWithLayoutOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Generates a zero-valued tensor for use as a dummy input to a TPU.
/// For the internal use of the TF2XLA bridge in the XLA Broadcast pass. This op
class TPUDummyInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op enabling differentiation of TPU Embeddings.
/// This op simply returns its first input, which is assumed to have been sliced
/// from the Tensors returned by TPUEmbeddingDequeueActivations. The presence of
/// this op, and its first argument being a trainable Variable, enables automatic
/// differentiation of graphs containing embeddings via the TPU Embedding Python
/// libraries.
class TPUEmbeddingActivationsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that executes a program with optional in-place variable updates.
/// It (optionally) reads device variables, loads and executes a TPU program on a
/// TPU device, and then (optionally) in-place updates variables using the program
/// outputs, as specified in attributes device_var_reads_indices (program input
/// indices from directly reading variables) and device_var_updates_indices (program
/// output indices used to update variables, -1 means no-update/read-only). Such
/// program outputs are consumed by these variables will not appear in the op
/// output. For the internal use of the distributed TPU compiler.
class TPUExecuteAndUpdateVariablesOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that loads and executes a TPU program on a TPU device.
/// For the internal use of the distributed TPU compiler.
class TPUExecuteOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that retrieves the layout of an input or output determined by TPUCompile.
/// For internal use only.
class TPUGetLayoutOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A TPU core selector Op.
/// This Op produces a set of TPU cores (for warm-up) or a single TPU core
/// (for regular inference) to execute the TPU program on. The output is
/// consumed by TPUPartitionedCall.
class TPUOrdinalSelectorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Calls a function placed on a specified TPU device.
class TPUPartitionedCallOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that groups a list of partitioned inputs together. This op
class TPUPartitionedInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that groups a list of partitioned inputs together. Supports ND sharding.
class TPUPartitionedInputV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that demultiplexes a tensor to be sharded by XLA to a list of partitioned
/// outputs outside the XLA computation.
class TPUPartitionedOutputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that demultiplexes a tensor to be sharded by XLA to a list of partitioned
/// outputs outside the XLA computation. Supports ND sharding.
class TPUPartitionedOutputV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Metadata indicating how the TPU computation should be replicated.
/// This operation holds the metadata common to operations of a `tpu.replicate()` computation subgraph.
class TPUReplicateMetadataOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Connects N inputs to an N-way replicated TPU computation.
/// This operation holds a replicated input to a `tpu.replicate()` computation subgraph.
/// Each replicated input has the same shape and type alongside the output.
/// 
/// For example:
/// ```
/// %a = "tf.opA"()
/// %b = "tf.opB"()
/// %replicated_input = "tf.TPUReplicatedInput"(%a, %b)
/// %computation = "tf.Computation"(%replicated_input)
/// ```
/// The above computation has a replicated input of two replicas.
class TPUReplicatedInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Connects N outputs from an N-way replicated TPU computation.
/// This operation holds a replicated output from a `tpu.replicate()` computation subgraph.
/// Each replicated output has the same shape and type alongside the input.
/// 
/// For example:
/// ```
/// %computation = "tf.Computation"()
/// %replicated_output:2 = "tf.TPUReplicatedOutput"(%computation)
/// ```
/// The above computation has a replicated output of two replicas.
class TPUReplicatedOutputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that reshards on-device TPU variables to specified state.
/// Op that reshards on-device TPU variables to specified state. Internal use only.
/// 
/// The sharding state is represented as the key of the compilation that generated
/// the sharding/unsharding programs along with the main program. new_format_key
/// specifies the desired state, and format_state_var is the current state of the
/// variables.
class TPUReshardVariablesOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Round-robin load balancing on TPU cores.
/// A load balancing op that round-robins among TPU cores.
/// 
/// This op round-robins between the integers in [0, NumTPUCoresVisiblePerHost]. It
/// is useful for interfacing with TensorFlow ops that take as input a TPU core on
/// which to execute computations, such as `TPUPartitionedCall`.
/// 
/// device_ordinal: An integer in [0, NumTPUCoresVisiblePerHost].
class TPURoundRobinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that contains `count` elements from the `input_dataset`.
class TakeDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that stops iteration when predicate` is false.
/// The `predicate` function must return a scalar boolean and accept the
/// following arguments:
/// 
/// * One tensor for each component of an element of `input_dataset`.
/// * One tensor for each value in `other_arguments`.
class TakeWhileDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes tan of x element-wise.
/// Given an input tensor, this function computes tangent of every
///   element in the tensor. Input range is `(-inf, inf)` and
///   output range is `(-inf, inf)`. If input lies outside the boundary, `nan`
///   is returned.
/// 
///   ```python
///   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 200, 10000, float("inf")])
///   tf.math.tan(x) ==> [nan 0.45231566 -0.5463025 1.5574077 2.572152 -1.7925274 0.32097113 nan]
///   ```
class TanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient for the tanh of `x` wrt its input.
/// Specifically, `grad = dy * (1 - y*y)`, where `y = tanh(x)`, and `dy`
/// is the corresponding input gradient.
class TanhGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes hyperbolic tangent of `x` element-wise.
/// Given an input tensor, this function computes hyperbolic tangent of every
///   element in the tensor. Input range is `[-inf, inf]` and
///   output range is `[-1,1]`.
/// 
///   >>> x = tf.constant([-float("inf"), -5, -0.5, 1, 1.2, 2, 3, float("inf")])
///   >>> tf.math.tanh(x)
///   <tf.Tensor: shape=(8,), dtype=float32, numpy=
///   array([-1.0, -0.99990916, -0.46211717,  0.7615942 ,  0.8336547 ,
///           0.9640276 ,  0.9950547 ,  1.0], dtype=float32)>
class TanhOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Delete the TensorArray from its resource container.
/// This enables the user to close and release the resource in the middle
/// of a step/run.
class TensorArrayCloseV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Concat the elements from the TensorArray into value `value`.
/// Takes `T` elements of shapes
/// 
///   ```
///   (n0 x d0 x d1 x ...), (n1 x d0 x d1 x ...), ..., (n(T-1) x d0 x d1 x ...)
///   ```
/// 
/// and concatenates them into a Tensor of shape:
/// 
///   ```
///   (n0 + n1 + ... + n(T-1) x d0 x d1 x ...)
///   ```
/// 
/// All elements must have the same shape (excepting the first dimension).
class TensorArrayConcatV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gather specific elements from the TensorArray into output `value`.
/// All elements selected by `indices` must have the same shape.
class TensorArrayGatherV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a TensorArray for storing the gradients of values in the given handle.
/// If the given TensorArray gradient already exists, returns a reference to it.
/// 
/// Locks the size of the original TensorArray by disabling its dynamic size flag.
/// 
/// **A note about the input flow_in:**
/// 
/// The handle flow_in forces the execution of the gradient lookup to occur
/// only after certain other operations have occurred.  For example, when
/// the forward TensorArray is dynamically sized, writes to this TensorArray
/// may resize the object.  The gradient TensorArray is statically sized based
/// on the size of the forward TensorArray when this operation executes.
/// Furthermore, the size of the forward TensorArray is frozen by this call.
/// As a result, the flow is used to ensure that the call to generate the gradient
/// TensorArray only happens after all writes are executed.
/// 
/// In the case of dynamically sized TensorArrays, gradient computation should
/// only be performed on read operations that have themselves been chained via
/// flow to occur only after all writes have executed. That way the final size
/// of the forward TensorArray is known when this operation is called.
/// 
/// **A note about the source attribute:**
/// 
/// TensorArray gradient calls use an accumulator TensorArray object.  If
/// multiple gradients are calculated and run in the same session, the multiple
/// gradient nodes may accidentally flow through the same accumulator TensorArray.
/// This double counts and generally breaks the TensorArray gradient flow.
/// 
/// The solution is to identify which gradient call this particular
/// TensorArray gradient is being called in.  This is performed by identifying
/// a unique string (e.g. "gradients", "gradients_1", ...) from the input
/// gradient Tensor's name.  This string is used as a suffix when creating
/// the TensorArray gradient object here (the attribute `source`).
/// 
/// The attribute `source` is added as a suffix to the forward TensorArray's
/// name when performing the creation / lookup, so that each separate gradient
/// calculation gets its own TensorArray accumulator.
class TensorArrayGradV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Read an element from the TensorArray into output `value`.
class TensorArrayReadV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Scatter the data from the input value into specific TensorArray elements.
/// `indices` must be a vector, its length must match the first dim of `value`.
class TensorArrayScatterV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Get the current size of the TensorArray.
class TensorArraySizeV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Split the data from the input value into TensorArray elements.
/// Assuming that `lengths` takes on values
/// 
///   ```
///   (n0, n1, ..., n(T-1))
///   ```
/// 
/// and that `value` has shape
/// 
///   ```
///   (n0 + n1 + ... + n(T-1) x d0 x d1 x ...),
///   ```
/// 
/// this splits values into a TensorArray with T tensors.
/// 
/// TensorArray index t will be the subtensor of values with starting position
/// 
///   ```
///   (n0 + n1 + ... + n(t-1), 0, 0, ...)
///   ```
/// 
/// and having size
/// 
///   ```
///   nt x d0 x d1 x ...
///   ```
class TensorArraySplitV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An array of Tensors of given size.
/// Write data via Write and read via Read or Pack.
class TensorArrayV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Push an element onto the tensor_array.
class TensorArrayWriteV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Concats all tensors in the list along the 0th dimension.
/// Requires that all tensors have the same shape except the first dimension.
/// 
/// input_handle: The input list.
/// element_shape: The shape of the uninitialized elements in the list. If the first
///   dimension is not -1, it is assumed that all list elements have the same
///   leading dim.
/// leading_dims: The list of leading dims of uninitialized list elements. Used if
///   the leading dim of input_handle.element_shape or the element_shape input arg
///   is not already set.
/// tensor: The concated result.
/// lengths: Output tensor containing sizes of the 0th dimension of tensors in the list, used for computing the gradient.
class TensorListConcatV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// The shape of the elements of the given list, as a tensor.
/// input_handle: the list
///   element_shape: the shape of elements of the list
class TensorListElementShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a TensorList which, when stacked, has the value of `tensor`.
/// Each tensor in the result list corresponds to one row of the input tensor.
/// 
/// tensor: The input tensor.
/// output_handle: The list.
class TensorListFromTensorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a Tensor by indexing into the TensorList.
/// Each row in the produced Tensor corresponds to the element in the TensorList
/// specified by the given index (see `tf.gather`).
/// 
/// input_handle: The input tensor list.
/// indices: The indices used to index into the list.
/// values: The tensor.
class TensorListGatherOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class TensorListGetItemOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the number of tensors in the input tensor list.
/// input_handle: the input list
/// length: the number of tensors in the list
class TensorListLengthOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the last element of the input list as well as a list with all but that element.
/// Fails if the list is empty.
/// 
/// input_handle: the input list
/// tensor: the withdrawn last element of the list
/// element_dtype: the type of elements in the list
/// element_shape: the shape of the output tensor
class TensorListPopBackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a list which has the passed-in `Tensor` as last element and the other elements of the given list in `input_handle`.
/// tensor: The tensor to put on the list.
/// input_handle: The old list.
/// output_handle: A list with the elements of the old list followed by tensor.
/// element_dtype: the type of elements in the list.
/// element_shape: a shape compatible with that of elements in the list.
class TensorListPushBackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// List of the given size with empty elements.
/// element_shape: the shape of the future elements of the list
/// num_elements: the number of elements to reserve
/// handle: the output list
/// element_dtype: the desired type of elements in the list.
class TensorListReserveOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Resizes the list.
/// input_handle: the input list
/// size: size of the output list
class TensorListResizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Scatters tensor at indices in an input list.
/// Each member of the TensorList corresponds to one row of the input tensor,
/// specified by the given index (see `tf.gather`).
/// 
/// input_handle: The list to scatter into.
/// tensor: The input tensor.
/// indices: The indices used to index into the list.
/// output_handle: The TensorList.
class TensorListScatterIntoExistingListOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class TensorListSetItemOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Stacks all tensors in the list.
/// Requires that all tensors have the same shape.
/// 
/// input_handle: the input list
/// tensor: the gathered result
/// num_elements: optional. If not -1, the number of elements in the list.
class TensorListStackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adds sparse `updates` to an existing tensor according to `indices`.
/// This operation creates a new tensor by adding sparse `updates` to the passed
/// in `tensor`.
/// This operation is very similar to `tf.compat.v1.scatter_nd_add`, except that the
/// updates are added onto an existing tensor (as opposed to a variable). If the
/// memory for the existing tensor cannot be re-used, a copy is made and updated.
/// 
/// `indices` is an integer tensor containing indices into a new tensor of shape
/// `tensor.shape`.  The last dimension of `indices` can be at most the rank of
/// `tensor.shape`:
/// 
/// ```
/// indices.shape[-1] <= tensor.shape.rank
/// ```
/// 
/// The last dimension of `indices` corresponds to indices into elements
/// (if `indices.shape[-1] = tensor.shape.rank`) or slices
/// (if `indices.shape[-1] < tensor.shape.rank`) along dimension
/// `indices.shape[-1]` of `tensor.shape`.  `updates` is a tensor with shape
/// 
/// ```
/// indices.shape[:-1] + tensor.shape[indices.shape[-1]:]
/// ```
/// 
/// The simplest form of `tensor_scatter_nd_add` is to add individual elements to a
/// tensor by index. For example, say we want to add 4 elements in a rank-1
/// tensor with 8 elements.
/// 
/// In Python, this scatter add operation would look like this:
/// 
/// >>> indices = tf.constant([[4], [3], [1], [7]])
/// >>> updates = tf.constant([9, 10, 11, 12])
/// >>> tensor = tf.ones([8], dtype=tf.int32)
/// >>> updated = tf.tensor_scatter_nd_add(tensor, indices, updates)
/// >>> updated
/// <tf.Tensor: shape=(8,), dtype=int32,
/// numpy=array([ 1, 12,  1, 11, 10,  1,  1, 13], dtype=int32)>
/// 
/// We can also, insert entire slices of a higher rank tensor all at once. For
/// example, if we wanted to insert two slices in the first dimension of a
/// rank-3 tensor with two matrices of new values.
/// 
/// In Python, this scatter add operation would look like this:
/// 
/// >>> indices = tf.constant([[0], [2]])
/// >>> updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
/// ...                         [7, 7, 7, 7], [8, 8, 8, 8]],
/// ...                        [[5, 5, 5, 5], [6, 6, 6, 6],
/// ...                         [7, 7, 7, 7], [8, 8, 8, 8]]])
/// >>> tensor = tf.ones([4, 4, 4],dtype=tf.int32)
/// >>> updated = tf.tensor_scatter_nd_add(tensor, indices, updates)
/// >>> updated
/// <tf.Tensor: shape=(4, 4, 4), dtype=int32,
/// numpy=array([[[6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8], [9, 9, 9, 9]],
///              [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]],
///              [[6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8], [9, 9, 9, 9]],
///              [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]]], dtype=int32)>
/// 
/// 
/// If `indices` contains any out-of-bound indices, depending on
/// `bad_indices_policy`, the op will either return an error or ignore the
/// out-of-bound indices. `bad_indices_policy` can be one of the following values:
/// 1. "" or "DEFAULT": raises on CPU and ignore on GPU. This is because
///    historically on CPU and GPU we handle errors in different ways, and for
///    backward compatibility we keep the default behavior.
/// 2. "ERROR": raises error; GPU does not support this value.
/// 3. "IGNORE": ignore the bad indices; supported on both CPU and GPU.
class TensorScatterAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Apply a sparse update to a tensor taking the element-wise maximum.
/// Returns a new tensor copied from `tensor` whose values are element-wise maximum between
/// tensor and updates according to the indices.
/// 
/// >>> tensor = [0, 0, 0, 0, 0, 0, 0, 0]
/// >>> indices = [[1], [4], [5]]
/// >>> updates = [1, -1, 1]
/// >>> tf.tensor_scatter_nd_max(tensor, indices, updates).numpy()
/// array([0, 1, 0, 0, 0, 1, 0, 0], dtype=int32)
/// 
/// Refer to `tf.tensor_scatter_nd_update` for more details.
class TensorScatterMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class TensorScatterMinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Subtracts sparse `updates` from an existing tensor according to `indices`.
/// This operation creates a new tensor by subtracting sparse `updates` from the
/// passed in `tensor`.
/// This operation is very similar to `tf.scatter_nd_sub`, except that the updates
/// are subtracted from an existing tensor (as opposed to a variable). If the memory
/// for the existing tensor cannot be re-used, a copy is made and updated.
/// 
/// `indices` is an integer tensor containing indices into a new tensor of shape
/// `shape`.  The last dimension of `indices` can be at most the rank of `shape`:
/// 
///     indices.shape[-1] <= shape.rank
/// 
/// The last dimension of `indices` corresponds to indices into elements
/// (if `indices.shape[-1] = shape.rank`) or slices
/// (if `indices.shape[-1] < shape.rank`) along dimension `indices.shape[-1]` of
/// `shape`.  `updates` is a tensor with shape
/// 
///     indices.shape[:-1] + shape[indices.shape[-1]:]
/// 
/// The simplest form of tensor_scatter_sub is to subtract individual elements
/// from a tensor by index. For example, say we want to insert 4 scattered elements
/// in a rank-1 tensor with 8 elements.
/// 
/// In Python, this scatter subtract operation would look like this:
/// 
/// ```python
///     indices = tf.constant([[4], [3], [1], [7]])
///     updates = tf.constant([9, 10, 11, 12])
///     tensor = tf.ones([8], dtype=tf.int32)
///     updated = tf.tensor_scatter_nd_sub(tensor, indices, updates)
///     print(updated)
/// ```
/// 
/// The resulting tensor would look like this:
/// 
///     [1, -10, 1, -9, -8, 1, 1, -11]
/// 
/// We can also, insert entire slices of a higher rank tensor all at once. For
/// example, if we wanted to insert two slices in the first dimension of a
/// rank-3 tensor with two matrices of new values.
/// 
/// In Python, this scatter add operation would look like this:
/// 
/// ```python
///     indices = tf.constant([[0], [2]])
///     updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
///                             [7, 7, 7, 7], [8, 8, 8, 8]],
///                            [[5, 5, 5, 5], [6, 6, 6, 6],
///                             [7, 7, 7, 7], [8, 8, 8, 8]]])
///     tensor = tf.ones([4, 4, 4],dtype=tf.int32)
///     updated = tf.tensor_scatter_nd_sub(tensor, indices, updates)
///     print(updated)
/// ```
/// 
/// The resulting tensor would look like this:
/// 
///     [[[-4, -4, -4, -4], [-5, -5, -5, -5], [-6, -6, -6, -6], [-7, -7, -7, -7]],
///      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]],
///      [[-4, -4, -4, -4], [-5, -5, -5, -5], [-6, -6, -6, -6], [-7, -7, -7, -7]],
///      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]]]
/// 
/// Note that on CPU, if an out of bound index is found, an error is returned.
/// On GPU, if an out of bound index is found, the index is ignored.
class TensorScatterSubOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Scatter `updates` into an existing tensor according to `indices`.
/// This operation creates a new tensor by applying sparse `updates` to the passed
/// in `tensor`.
/// This operation is very similar to `tf.scatter_nd`, except that the updates are
/// scattered onto an existing tensor (as opposed to a zero-tensor). If the memory
/// for the existing tensor cannot be re-used, a copy is made and updated.
/// 
/// If `indices` contains duplicates, then we pick the last update for the index.
/// 
/// **WARNING**: There are some GPU specific semantics for this operation.
/// - If an out of bound index is found, the index is ignored.
/// - The order in which updates are applied is nondeterministic, so the output
/// will be nondeterministic if `indices` contains duplicates.
/// 
/// `indices` is an integer tensor containing indices into a new tensor of shape
/// `shape`.
/// 
/// * `indices` must have at least 2 axes: `(num_updates, index_depth)`.
/// * The last axis of `indices` is how deep to index into `tensor` so  this index
///   depth must be less than the rank of `tensor`: `indices.shape[-1] <= tensor.ndim`
/// 
/// if `indices.shape[-1] = tensor.rank` this Op indexes and updates scalar elements.
/// if `indices.shape[-1] < tensor.rank` it indexes and updates slices of the input
/// `tensor`.
/// 
/// Each `update` has a rank of `tensor.rank - indices.shape[-1]`.
/// The overall shape of `updates` is:
/// 
/// ```
/// indices.shape[:-1] + tensor.shape[indices.shape[-1]:]
/// ```
/// 
/// If `indices` contains any out-of-bound indices, depending on
/// `bad_indices_policy`, the op will either return an error or ignore the
/// out-of-bound indices. `bad_indices_policy` can be one of the following values:
/// 1. "" or "DEFAULT": raises on CPU and ignore on GPU. This is because
///    historically on CPU and GPU we handle errors in different ways, and for
///    backward compatibility we keep the default behavior.
/// 2. "ERROR": raises error; GPU does not support this value.
/// 3. "IGNORE": ignore the bad indices; supported on both CPU and GPU.
/// 
/// For usage examples see the python [tf.tensor_scatter_nd_update](
/// https://www.tensorflow.org/api_docs/python/tf/tensor_scatter_nd_update) function
class TensorScatterUpdateOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that emits each dim-0 slice of `components` once.
class TensorSliceDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Assign `value` to the sliced l-value reference of `input`.
/// The values of `value` are assigned to the positions in the tensor `input` that
/// are selected by the slice parameters. The slice parameters `begin` `end`
/// `strides` etc. work exactly as in `StridedSlice`.
/// 
/// NOTE this op currently does not support broadcasting and so `value`'s shape
/// must be exactly the shape produced by the slice of `input`.
class TensorStridedSliceUpdateOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Constructs a tensor by tiling a given tensor.
/// This operation creates a new tensor by replicating `input` `multiples` times.
/// The output tensor's i'th dimension has `input.dims(i) * multiples[i]` elements,
/// and the values of `input` are replicated `multiples[i]` times along the 'i'th
/// dimension. For example, tiling `[a b c d]` by `[2]` produces
/// `[a b c d a b c d]`.
/// 
/// >>> a = tf.constant([[1,2,3],[4,5,6]], tf.int32)
/// >>> b = tf.constant([1,2], tf.int32)
/// >>> tf.tile(a, b)
/// <tf.Tensor: shape=(2, 6), dtype=int32, numpy=
/// array([[1, 2, 3, 1, 2, 3],
///        [4, 5, 6, 4, 5, 6]], dtype=int32)>
/// >>> c = tf.constant([2,1], tf.int32)
/// >>> tf.tile(a, c)
/// <tf.Tensor: shape=(4, 3), dtype=int32, numpy=
/// array([[1, 2, 3],
///        [4, 5, 6],
///        [1, 2, 3],
///        [4, 5, 6]], dtype=int32)>
/// >>> d = tf.constant([2,2], tf.int32)
/// >>> tf.tile(a, d)
/// <tf.Tensor: shape=(4, 6), dtype=int32, numpy=
/// array([[1, 2, 3, 1, 2, 3],
///        [4, 5, 6, 4, 5, 6],
///        [1, 2, 3, 1, 2, 3],
///        [4, 5, 6, 4, 5, 6]], dtype=int32)>
class TileOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Provides the time since epoch in seconds.
/// Returns the timestamp as a `float64` for seconds since the Unix epoch.
/// 
/// Common usages include:
/// * Logging
/// * Providing a random number seed
/// * Debugging graph execution
/// * Generating timing information, mainly through comparison of timestamps
/// 
/// Note: In graph mode, the timestamp is computed when the op is executed,
/// not when it is added to the graph.  In eager mode, the timestamp is computed
/// when the op is eagerly executed.
class TimestampOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts a tensor to a scalar predicate.
/// Converts a tensor to a scalar predicate with the following rules:
/// 
/// - For 0D tensors, truthiness is determined by comparing against a "zero"
///   value. For numerical types it is the obvious zero. For strings it is the
///   empty string.
/// 
/// - For >0D tensors, truthiness is determined by looking at the number of
///   elements. If has zero elements, then the result is false. Otherwise the
///   result is true.
/// 
/// This matches the behavior of If and While for determining if a tensor counts
/// as true/false for a branch condition.
class ToBoolOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the TopK unique values in the array in sorted order.
/// The running time is proportional to the product of K and the input
/// size. Sorting the whole array is more efficient for sufficiently large
/// values of K. The median-of-medians algorithm is probably faster, but
/// difficult to implement efficiently in XLA. If there are fewer than K
/// unique numbers (not NANs), the results are padded with negative
/// infinity. NaNs are never returned. Subnormal numbers are flushed to
/// zero. If an element appears at multiple indices, the highest index is
/// returned. If a TopK element never appears in the input due to padding
/// values, the indices are padded with negative one. If a padding value
/// appears in the input and padding is needed, the highest index of the
/// padding value will be returned. The semantics are not the same as
/// kth_order_statistic.
class TopKUniqueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Finds values and indices of the `k` largest elements for the last dimension.
/// If the input is a vector (rank-1), finds the `k` largest entries in the vector
/// and outputs their values and indices as vectors.  Thus `values[j]` is the
/// `j`-th largest entry in `input`, and its index is `indices[j]`.
/// 
/// For matrices (resp. higher rank input), computes the top `k` entries in each
/// row (resp. vector along the last dimension).  Thus,
/// 
///     values.shape = indices.shape = input.shape[:-1] + [k]
/// 
/// If two elements are equal, the lower-index element appears first.
class TopKV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the TopK values in the array in sorted order.
/// This is a combination of MakeUnique and TopKUnique. The returned top-K will
/// have its lower bits replaced by iota, thus it will be close to the original
/// value but not exactly the same. The running time is proportional to the product
/// of K and the input size. NaNs are never returned. Subnormal numbers are flushed
/// to zero.
class TopKWithUniqueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Shuffle dimensions of x according to a permutation.
/// The output `y` has the same rank as `x`. The shapes of `x` and `y` satisfy:
///   `y.shape[i] == x.shape[perm[i]] for i in [0, 1, ..., rank(x) - 1]`
class TransposeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Calculate product with tridiagonal matrix.
/// Calculates product of two matrices, where left matrix is a tridiagonal matrix.
class TridiagonalMatMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Solves tridiagonal systems of equations.
/// Solves tridiagonal systems of equations.
///   Supports batch dimensions and multiple right-hand sides per each left-hand
///   side.
///   On CPU, solution is computed via Gaussian elimination with or without partial
///   pivoting, depending on `partial_pivoting` attribute. On GPU, Nvidia's cuSPARSE
///   library is used: https://docs.nvidia.com/cuda/cusparse/index.html#gtsv
///   Partial pivoting is not yet supported by XLA backends.
class TridiagonalSolveOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x / y element-wise, rounded towards zero.
/// Truncation designates that negative numbers will round fractional quantities
/// toward zero. I.e. -7 / 5 = -1. This matches C semantics but it is different
/// than Python semantics. See `FloorDiv` for a division function that matches
/// Python Semantics.
/// 
/// *NOTE*: `TruncateDiv` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class TruncateDivOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns element-wise remainder of division. This emulates C semantics in that
/// the result here is consistent with a truncating divide. E.g. `truncate(x / y) *
/// y + truncate_mod(x, y) = x`.
/// 
/// *NOTE*: `TruncateMod` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class TruncateModOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a truncated normal distribution.
/// The generated values follow a normal distribution with mean 0 and standard
/// deviation 1, except that values whose magnitude is more than 2 standard
/// deviations from the mean are dropped and re-picked.
class TruncatedNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Uncompresses a compressed dataset element.
class UncompressElementOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform dequantization on the quantized Tensor `input`.
/// Given quantized `input` which was quantized using `scales` and `zero_points`, performs dequantization using the formula:
/// dequantized_data = (quantized_data - zero_point) * scale.
class UniformDequantizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform quantization on Tensor `input`.
/// Given `input`, `scales` and `zero_points`, performs quantization using the formula:
/// quantized_data = floor(input_data * (1.0f / scale) + 0.5f) + zero_point
class UniformQuantizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform quantized add of quantized Tensor `lhs` and quantized Tensor `rhs` to make quantized `output`.
/// Given quantized `lhs` and quantized `rhs`, performs quantized add on `lhs` and `rhs` to make quantized `output`.
/// 
/// `UniformQuantizedAdd` follows Numpy broadcasting rules.
/// The two input array shapes are compared element-wise.
/// Starting with the trailing dimensions, the two dimensions either have to be equal or one of them needs to be 1.
/// 
/// `lhs` and `rhs` must be quantized Tensor, where data value is quantized using the formula:
/// ```
/// quantized_data = clip(original_data / scale + zero_point, quantization_min_val, quantization_max_val)
/// ```
/// `output` is also quantized, using the same formula.
/// 
/// If `lhs` and `output` is both per-axis quantized, the quantization axis must match.
/// Also, if `rhs` and `output` is both per-axis quantized, the quantization axis must match.
/// *Match* means the axis must match when adding, regarding the broadcasting.
/// i.e. For both operands `lhs` and `rhs`,
/// if `operand.quantization_axis` >= 0 and `output.quantization_axis` >= 0,
/// `operand.dims` - `operand.quantization_axis` must be equal to `output.dims` - `output.quantization_axis`.
class UniformQuantizedAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform clip by value on the quantized Tensor `operand`.
/// Given quantized `operand` which was quantized using `scales` and `zero_points`, performs clip by value using `min` and `max` values.
/// If quantization_axis is -1 (per-tensor quantized), the entire operand is clipped using scalar min, max.
/// Otherwise (per-channel quantized), the clipping is also done per-channel.
class UniformQuantizedClipByValueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform hybrid quantized convolution of float Tensor `lhs` and quantized Tensor `rhs`.
/// Given float `lhs` and quantized `rhs`, internally performs quantization on `lhs`,
/// and then performs quantized convolution on quantized `lhs` and `rhs`.
/// 
/// The internal quantization on `lhs` is a quantization to `Trhs`, dynamic range,
/// per-batch (per-axis along axis `dimension_numbers.input_batch_dimension`), asymmetric,
/// and not narrow range (the range is [Trhs_MIN, Trhs_MAX]).
/// 
/// `lhs` and `rhs` must be Tensors of same rank, and meet following shape conditions.
/// - lhs_feature % feature_group_count == 0
/// - lhs_feature % rhs_input_feature == 0
/// - lhs_feature / feature_group_count == rhs_input_feature
/// - rhs_output_feature % feature_group_count == 0
/// - lhs_batch % batch_group_count == 0
/// - rhs_output_feature % batch_group_count == 0
/// 
/// `rhs` must be quantized Tensor, where its data value is quantized using the formula:
/// quantized_data = clip(original_data / scale + zero_point, quantization_min_val, quantization_max_val).
class UniformQuantizedConvolutionHybridOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform quantized convolution of quantized Tensor `lhs` and quantized Tensor `rhs`. to make quantized `output`.
/// Given quantized `lhs` and quantized `rhs`, performs quantized dot on `lhs` and `rhs` to make quantized `output`.
/// 
/// `lhs` and `rhs` must be Tensors of same rank, and meet following shape conditions.
/// - `lhs_feature` % `feature_group_count` == 0
/// - `lhs_feature` % `rhs_input_feature` == 0
/// - `lhs_feature` / `feature_group_count` == `rhs_input_feature`
/// - `rhs_output_feature` % `feature_group_count` == 0
/// - `lhs_batch` % `batch_group_count` == 0
/// - `rhs_output_feature` % `batch_group_count` == 0
/// 
/// `lhs` and `rhs` must be quantized Tensor, where data value is quantized using the formula:
/// ```
/// quantized_data = clip(original_data / scale + zero_point, quantization_min_val, quantization_max_val)
/// ```
/// `output` is also quantized, using the same formula.
/// If `rhs` is per-tensor quantized, `output` must be also per-tensor quantized.
class UniformQuantizedConvolutionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform hybrid quantized dot of float Tensor `lhs` and quantized Tensor `rhs`.
/// Given float `lhs` and quantized `rhs`, internally performs quantization on `lhs`, and then performs quantized dot on quantized lhs and `rhs`.
/// The internal quantization on `lhs` is a quantization to qint8, dynamic range, per-batch (per-axis along axis 0), asymmetric, and not narrow range (the range is [-128, 127]).
/// `lhs` and `rhs` must be 2D Tensors and the lhs.dim_size(1) must match rhs.dim_size(0).
/// `rhs` must be quantized Tensor, where its data value is quantized using the formula:
/// quantized_data = clip(original_data / scale + zero_point, quantization_min_val, quantization_max_val).
class UniformQuantizedDotHybridOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform quantized dot of quantized Tensor `lhs` and quantized Tensor `rhs` to make quantized `output`.
/// Given quantized `lhs` and quantized `rhs`, performs quantized dot on `lhs` and `rhs` to make quantized `output`.
/// `lhs` and `rhs` must be 2D Tensors and the lhs.dim_size(1) must match rhs.dim_size(0).
/// `lhs` and `rhs` must be quantized Tensor, where data value is quantized using the formula:
/// quantized_data = clip(original_data / scale + zero_point, quantization_min_val, quantization_max_val).
/// `output` is also quantized, using the same formula.
/// If `rhs` is per-tensor quantized, `output` must be also per-tensor quantized.
class UniformQuantizedDotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Given quantized tensor `input`, requantize it with new quantization parameters.
/// Given quantized tensor `input`, which was quantized using {input_scales, input_zero_points, input_quantization_axis, input_quantization_min_val, input_quantization_max_val},
/// requantize it to a tensor, which is quantized using {output_scales, output_zero_points, output_quantization_axis, output_quantization_min_val, output_quantization_max_val}.
/// The requantization is done by using the formula:
/// output_quantized_data = clip(
///   (input_quantized_data - input_zero_point) * (input_scale / output_scale) + output_zero_point,
///   output_quantization_min_val,
///   output_quantization_max_val)
/// 
/// Per-tensor and per-axis quantization supported cases are followings:
/// * per-tensor -> per-tensor
/// * per-tensor -> per-axis
/// * per-axis -> per-axis where input_quantization_axis equals output_quantization_axis.
/// i.e. At least one among input_quantization_axis and output_quantization_axis must be -1, or two must be equal.
class UniformRequantizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Finds unique elements in a 1-D tensor.
/// This operation returns a tensor `y` containing all of the unique elements of `x`
/// sorted in the same order that they occur in `x`; `x` does not need to be sorted.
/// This operation also returns a tensor `idx` the same size as `x` that contains
/// the index of each value of `x` in the unique output `y`. In other words:
/// 
/// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
/// 
/// Examples:
/// 
/// ```
/// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
/// y, idx = unique(x)
/// y ==> [1, 2, 4, 7, 8]
/// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
/// ```
/// 
/// ```
/// # tensor 'x' is [4, 5, 1, 2, 3, 3, 4, 5]
/// y, idx = unique(x)
/// y ==> [4, 5, 1, 2, 3]
/// idx ==> [0, 1, 2, 3, 4, 4, 0, 1]
/// ```
class UniqueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Finds unique elements along an axis of a tensor.
/// This operation either returns a tensor `y` containing unique elements
/// along the `axis` of a tensor. The returned unique elements is sorted
/// in the same order as they occur along `axis` in `x`.
/// This operation also returns a tensor `idx` that is the same size as
/// the number of the elements in `x` along the `axis` dimension. It
/// contains the index in the unique output `y`.
/// In other words, for an `1-D` tensor `x` with `axis = None:
/// 
/// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
/// 
/// For example:
/// 
/// ```
/// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
/// y, idx = unique(x)
/// y ==> [1, 2, 4, 7, 8]
/// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
/// ```
/// 
/// For an `2-D` tensor `x` with `axis = 0`:
/// 
/// ```
/// # tensor 'x' is [[1, 0, 0],
/// #                [1, 0, 0],
/// #                [2, 0, 0]]
/// y, idx = unique(x, axis=0)
/// y ==> [[1, 0, 0],
///        [2, 0, 0]]
/// idx ==> [0, 0, 1]
/// ```
/// 
/// For an `2-D` tensor `x` with `axis = 1`:
/// 
/// ```
/// # tensor 'x' is [[1, 0, 0],
/// #                [1, 0, 0],
/// #                [2, 0, 0]]
/// y, idx = unique(x, axis=1)
/// y ==> [[1, 0],
///        [1, 0],
///        [2, 0]]
/// idx ==> [0, 1, 1]
/// ```
class UniqueV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Unpacks a given dimension of a rank-`R` tensor into `num` rank-`(R-1)` tensors.
/// Unpacks `num` tensors from `value` by chipping it along the `axis` dimension.
/// For example, given a tensor of shape `(A, B, C, D)`;
/// 
/// If `axis == 0` then the i'th tensor in `output` is the slice `value[i, :, :, :]`
///   and each tensor in `output` will have shape `(B, C, D)`. (Note that the
///   dimension unpacked along is gone, unlike `split`).
/// 
/// If `axis == 1` then the i'th tensor in `output` is the slice `value[:, i, :, :]`
///   and each tensor in `output` will have shape `(A, C, D)`.
/// Etc.
/// 
/// This is the opposite of `pack`.
class UnpackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the maximum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// This operator is similar to `tf.math.unsorted_segment_sum`,
/// Instead of computing the sum over segments, it computes the maximum such that:
/// 
/// \\(output_i = \max_{j...} data[j...]\\) where max is over tuples `j...` such
/// that `segment_ids[j...] == i`.
/// 
/// If the maximum is empty for a given segment ID `i`, it outputs the smallest
/// possible value for the specific numeric type,
/// `output[i] = numeric_limits<T>::lowest()`.
/// 
/// If the given segment ID `i` is negative, then the corresponding value is
/// dropped, and will not be included in the result.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be less than
/// `num_segments`, and an error is thrown for out-of-bound indices. On GPU, this
/// does not throw an error for out-of-bound indices. On Gpu, out-of-bound indices
/// result in safe but unspecified behavior, which may include ignoring
/// out-of-bound indices or outputting a tensor with a 0 stored in the first
/// dimension of its shape if `num_segments` is 0.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/UnsortedSegmentMax.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
/// >>> tf.math.unsorted_segment_max(c, tf.constant([0, 1, 0]), num_segments=2).numpy()
/// array([[4, 3, 3, 4],
///        [5,  6, 7, 8]], dtype=int32)
class UnsortedSegmentMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the minimum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// This operator is similar to `tf.math.unsorted_segment_sum`,
/// Instead of computing the sum over segments, it computes the minimum such that:
/// 
/// \\(output_i = \min_{j...} data_[j...]\\) where min is over tuples `j...` such
/// that `segment_ids[j...] == i`.
/// 
/// If the minimum is empty for a given segment ID `i`, it outputs the largest
/// possible value for the specific numeric type,
/// `output[i] = numeric_limits<T>::max()`.
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
/// >>> tf.math.unsorted_segment_min(c, tf.constant([0, 1, 0]), num_segments=2).numpy()
/// array([[1, 2, 2, 1],
///        [5, 6, 7, 8]], dtype=int32)
/// 
/// If the given segment ID `i` is negative, then the corresponding value is
/// dropped, and will not be included in the result.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be less than
/// `num_segments`, and an error is thrown for out-of-bound indices. On GPU, this
/// does not throw an error for out-of-bound indices. On Gpu, out-of-bound indices
/// result in safe but unspecified behavior, which may include ignoring
/// out-of-bound indices or outputting a tensor with a 0 stored in the first
/// dimension of its shape if `num_segments` is 0.
class UnsortedSegmentMinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the product along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// This operator is similar to `tf.math.unsorted_segment_sum`,
/// Instead of computing the sum over segments, it computes the product of all
/// entries belonging to a segment such that:
/// 
/// \\(output_i = \prod_{j...} data[j...]\\) where the product is over tuples
/// `j...` such that `segment_ids[j...] == i`.
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
/// >>> tf.math.unsorted_segment_prod(c, tf.constant([0, 1, 0]), num_segments=2).numpy()
/// array([[4, 6, 6, 4],
///        [5, 6, 7, 8]], dtype=int32)
/// 
/// If there is no entry for a given segment ID `i`, it outputs 1.
/// 
/// If the given segment ID `i` is negative, then the corresponding value is
/// dropped, and will not be included in the result.
/// Caution: On CPU, values in `segment_ids` are always validated to be less than
/// `num_segments`, and an error is thrown for out-of-bound indices. On GPU, this
/// does not throw an error for out-of-bound indices. On Gpu, out-of-bound indices
/// result in safe but unspecified behavior, which may include ignoring
/// out-of-bound indices or outputting a tensor with a 0 stored in the first
/// dimension of its shape if `num_segments` is 0.
class UnsortedSegmentProdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output[i] = \sum_{j...} data[j...]\\) where the sum is over tuples `j...` such
/// that `segment_ids[j...] == i`.  Unlike `SegmentSum`, `segment_ids`
/// need not be sorted and need not cover all values in the full
/// range of valid values.
/// 
/// If the sum is empty for a given segment ID `i`, `output[i] = 0`.
/// If the given segment ID `i` is negative, the value is dropped and will not be
/// added to the sum of the segment.
/// 
/// `num_segments` should equal the number of distinct segment IDs.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be less than
/// `num_segments`, and an error is thrown for out-of-bound indices. On GPU, this
/// does not throw an error for out-of-bound indices. On Gpu, out-of-bound indices
/// result in safe but unspecified behavior, which may include ignoring
/// out-of-bound indices or outputting a tensor with a 0 stored in the first
/// dimension of its shape if `num_segments` is 0.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/UnsortedSegmentSum.png" alt>
/// </div>
/// 
/// >>> c = [[1,2,3,4], [5,6,7,8], [4,3,2,1]]
/// >>> tf.math.unsorted_segment_sum(c, [0, 1, 0], num_segments=2).numpy()
/// array([[5, 5, 5, 5],
///        [5, 6, 7, 8]], dtype=int32)
class UnsortedSegmentSumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Applies upper_bound(sorted_search_values, values) along each row.
/// Each set of rows with the same index in (sorted_inputs, values) is treated
/// independently.  The resulting row is the equivalent of calling
/// `np.searchsorted(sorted_inputs, values, side='right')`.
/// 
/// The result is not a global index to the entire
/// `Tensor`, but rather just the index in the last dimension.
/// 
/// A 2-D example:
///   sorted_sequence = [[0, 3, 9, 9, 10],
///                      [1, 2, 3, 4, 5]]
///   values = [[2, 4, 9],
///             [0, 2, 6]]
/// 
///   result = UpperBound(sorted_sequence, values)
/// 
///   result == [[1, 2, 4],
///              [0, 2, 5]]
class UpperBoundOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a handle to a Variable resource from its name.
/// container: the container this variable is placed in.
/// shared_name: the name by which this variable is referred to.
/// dtype and shape: attributes representing the data type and shape held in the
///   variable.
/// 
/// Example:
///     resource_variable_ops.var_handle_op(
///           dtype=dtypes.int32, shape=[8, 16], container="foo", shared_name="bar")
///   returns a handle for a variable with name "bar" in container "foo", and the
///   variable holds a tensor of shape [8, 16] and dtype int32.
class VarHandleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Checks whether a resource handle-based variable has been initialized.
class VarIsInitializedOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Use VariableV2 instead.
class VariableOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the shape of the variable pointed to by `resource`.
/// This operation returns a 1-D integer tensor representing the shape of `input`.
/// 
/// For example:
/// 
/// ```
/// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
/// shape(t) ==> [2, 2, 3]
/// ```
class VariableShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Holds state in the form of a tensor that persists across steps.
/// Outputs a ref to the tensor state so it may be read or modified.
/// TODO(zhifengc/mrry): Adds a pointer to a more detail document
/// about sharing states in tensorflow.
class VariableV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns locations of nonzero / true values in a tensor.
/// This operation returns the coordinates of true elements in `condition`. The
/// coordinates are returned in a 2-D tensor where the first dimension (rows)
/// represents the number of true elements, and the second dimension (columns)
/// represents the coordinates of the true elements. Keep in mind, the shape of
/// the output tensor can vary depending on how many true values there are in
/// `condition`. Indices are output in row-major order.
/// 
/// For example:
/// 
/// ```
/// # 'input' tensor is [[True, False]
/// #                    [True, False]]
/// # 'input' has two true values, so output has two coordinates.
/// # 'input' has rank of 2, so coordinates have two indices.
/// where(input) ==> [[0, 0],
///                   [1, 0]]
/// 
/// # `condition` tensor is [[[True, False]
/// #                     [True, False]]
/// #                    [[False, True]
/// #                     [False, True]]
/// #                    [[False, False]
/// #                     [False, True]]]
/// # 'input' has 5 true values, so output has 5 coordinates.
/// # 'input' has rank of 3, so coordinates have three indices.
/// where(input) ==> [[0, 0, 0],
///                   [0, 1, 0],
///                   [1, 0, 1],
///                   [1, 1, 1],
///                   [2, 1, 1]]
/// 
/// # `condition` tensor is [[[1.5,  0.0]
/// #                     [-0.5, 0.0]]
/// #                    [[0.0,  0.25]
/// #                     [0.0,  0.75]]
/// #                    [[0.0,  0.0]
/// #                     [0.0,  0.01]]]
/// # 'input' has 5 nonzero values, so output has 5 coordinates.
/// # 'input' has rank of 3, so coordinates have three indices.
/// where(input) ==> [[0, 0, 0],
///                   [0, 1, 0],
///                   [1, 0, 1],
///                   [1, 1, 1],
///                   [2, 1, 1]]
/// 
/// # `condition` tensor is [[[1.5 + 0.0j, 0.0  + 0.0j]
/// #                     [0.0 + 0.5j, 0.0  + 0.0j]]
/// #                    [[0.0 + 0.0j, 0.25 + 1.5j]
/// #                     [0.0 + 0.0j, 0.75 + 0.0j]]
/// #                    [[0.0 + 0.0j, 0.0  + 0.0j]
/// #                     [0.0 + 0.0j, 0.01 + 0.0j]]]
/// # 'input' has 5 nonzero magnitude values, so output has 5 coordinates.
/// # 'input' has rank of 3, so coordinates have three indices.
/// where(input) ==> [[0, 0, 0],
///                   [0, 1, 0],
///                   [1, 0, 1],
///                   [1, 1, 1],
///                   [2, 1, 1]]
/// ```
class WhereOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// output = input; While (Cond(output)) { output = Body(output) }
/// output = input; While (Cond(output)) { output = Body(output) }
/// 
/// input: A list of input tensors whose types are T.
/// output: A list of output tensors whose types are T.
/// cond: A function that takes 'input' and returns a tensor.  If the tensor is
///     a scalar of non-boolean, the scalar is converted to a boolean
///     according to the following rule: if the scalar is a numerical
///     value, non-zero means True and zero means False; if the scalar is
///     a string, non-empty means True and empty means False. If the
///     tensor is not a scalar, non-emptiness means True and False
///     otherwise.
/// body: A function that takes a list of tensors and returns another
///       list of tensors. Both lists have the same types as specified
///       by T.
class WhileOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// while operation
/// The tf.WhileRegion op represents a while loop using 2 regions and a set of
///   iteration variables. The iteration variables maintained by this Op have the
///   same types as the inputs. The Op executes a while loop described by the
///   following pseudo code:
/// 
///   ```
///      func WhileRegionOp(inputs) {
///        iteration_vars = inputs;
///        while (cond(iteration_vars)) {
///            iteration_vars = body(iteration_vars);
///        }
///        return iteration_vars;
///      }
///   ```
/// 
///   `cond` is the condition region and `body` is the body region. Both these
///   regions accept the current value of the iteration variables as inputs.
/// 
///   The condition region yields a tensor<i1> which, if false, will exit the loop.
///   It can also, optionally and additionally, yield the iteration variables, which
///   must be unchanged.
/// 
///   The body region always has to yield the (possibly updated) iteration variables.
/// 
///   The iteration variables are initialized to the Op input, and the results of the
///   tf.WhileRegion op are the final values of the iteration variables.
/// 
///   This implies that the operand and result types for tf.WhileRegion should be
///   the same. Note that the condition and body regions can implicitly capture
///   loop invariant values directly. In canonical form, iteration variables that
///   pass through the loop body unmodified are converted to implicitly captured
///   references to their values outside the loop.
class WhileRegionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a `Summary` protocol buffer with audio.
/// The summary has up to `max_outputs` summary values containing audio. The
/// audio is built from `tensor` which must be 3-D with shape `[batch_size,
/// frames, channels]` or 2-D with shape `[batch_size, frames]`. The values are
/// assumed to be in the range of `[-1.0, 1.0]` with a sample rate of `sample_rate`.
/// 
/// The `tag` argument is a scalar `Tensor` of type `string`.  It is used to
/// build the `tag` of the summary values:
/// 
/// *  If `max_outputs` is 1, the summary value tag is '*tag*/audio'.
/// *  If `max_outputs` is greater than 1, the summary value tags are
///    generated sequentially as '*tag*/audio/0', '*tag*/audio/1', etc.
/// 
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tag: Scalar. Used to build the `tag` attribute of the summary values.
/// tensor: 2-D of shape `[batch_size, frames]`.
/// sample_rate: The sample rate of the signal in hertz.
/// max_outputs: Max number of batch elements to generate audio for.
class WriteAudioSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a `GraphDef` protocol buffer to a `SummaryWriter`.
/// writer: Handle of `SummaryWriter`.
/// step: The step to write the summary for.
/// tensor: A scalar string of the serialized tf.GraphDef proto.
class WriteGraphSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a histogram summary.
/// The generated
/// [`Summary`](https://www.tensorflow.org/code/tensorflow/core/framework/summary.proto)
/// has one summary value containing a histogram for `values`.
/// 
/// This op reports an `InvalidArgument` error if any value is not finite.
/// 
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tag: Scalar.  Tag to use for the `Summary.Value`.
/// values: Any shape. Values to use to build the histogram.
class WriteHistogramSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a `Summary` protocol buffer with images.
/// The summary has up to `max_images` summary values containing images. The
/// images are built from `tensor` which must be 4-D with shape `[batch_size,
/// height, width, channels]` and where `channels` can be:
/// 
/// *  1: `tensor` is interpreted as Grayscale.
/// *  3: `tensor` is interpreted as RGB.
/// *  4: `tensor` is interpreted as RGBA.
/// 
/// The images have the same number of channels as the input tensor. For float
/// input, the values are normalized one image at a time to fit in the range
/// `[0, 255]`.  `uint8` values are unchanged.  The op uses two different
/// normalization algorithms:
/// 
/// *  If the input values are all positive, they are rescaled so the largest one
///    is 255.
/// 
/// *  If any input value is negative, the values are shifted so input value 0.0
///    is at 127.  They are then rescaled so that either the smallest value is 0,
///    or the largest one is 255.
/// 
/// The `tag` argument is a scalar `Tensor` of type `string`.  It is used to
/// build the `tag` of the summary values:
/// 
/// *  If `max_images` is 1, the summary value tag is '*tag*/image'.
/// *  If `max_images` is greater than 1, the summary value tags are
///    generated sequentially as '*tag*/image/0', '*tag*/image/1', etc.
/// 
/// The `bad_color` argument is the color to use in the generated images for
/// non-finite input values.  It is a `unit8` 1-D tensor of length `channels`.
/// Each element must be in the range `[0, 255]` (It represents the value of a
/// pixel in the output image).  Non-finite values in the input tensor are
/// replaced by this tensor in the output image.  The default value is the color
/// red.
/// 
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tag: Scalar. Used to build the `tag` attribute of the summary values.
/// tensor: 4-D of shape `[batch_size, height, width, channels]` where
///   `channels` is 1, 3, or 4.
/// max_images: Max number of batch elements to generate images for.
/// bad_color: Color to use for pixels with non-finite values.
class WriteImageSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a `Summary` protocol buffer with serialized string `Summary` protocol buffers.
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tensor: A tensor holding one or more serialized `Summary` protobufs to write.
class WriteRawProtoSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a `Summary` protocol buffer with scalar values.
/// The input `tag` and `value` must have the scalars.
/// 
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tag: Tag for the summary.
/// value: Value for the summary.
class WriteScalarSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs a `Summary` protocol buffer with a tensor.
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tensor: A tensor to serialize.
/// tag: The summary's tag.
/// summary_metadata: Serialized SummaryMetadata protocol buffer containing
///  plugin-related metadata for this summary.
class WriteSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes the given predictions into a RecordIO file using a previously
/// initialized global TrainingPredictionWriter. The predictions are transformed
/// into a PredictionData proto before they are written to the file.
class WriteTrainingPredictionsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns 0 if x == 0, and x / y otherwise, elementwise.
class XdivyOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA AllReduce operator
/// documented at https://www.tensorflow.org/xla/operation_semantics#allreduce.
class XlaAllReduceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Helper operator for performing XLA-style broadcasts
/// Broadcasts `lhs` and `rhs` to the same rank, by adding size 1 dimensions to
/// whichever of `lhs` and `rhs` has the lower rank, using XLA's broadcasting rules
/// for binary operators.
class XlaBroadcastHelperOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Invokes a StableHLO module.
/// This op is used with JAX native serialization in a TensorFlow context with
/// stability guarantees.
class XlaCallModuleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Operator that connects the output of an XLA computation to other consumer graph nodes.
class XlaClusterOutputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Concats input tensor across all dimensions.
/// An op which merges slices the input tensor based on the given num_splits
/// attribute, strips paddings optionally, and returns the merged tensor without
/// paddings.
/// 
/// This op may be generated via the TPU bridge.
/// 
/// For example, with `input` tensor:
/// ```
/// [[0, 1],
///  [4, 5]]
/// [[2, 3],
///  [6, 7]]
/// [[8, 9],
///  [12, 13]]
/// [[10, 11],
///  [14, 15]]
/// ```
/// `num_splits`:
/// ```
/// [2, 2]
/// ```
/// and `paddings`:
/// ```
/// [1, 1]
/// ```
/// the expected `outputs` is:
/// ```
/// [[0, 1, 2],
///  [4, 5, 6],
///  [8, 9, 10]]
/// ```
class XlaConcatNDOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA ConvGeneralDilated operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#conv_convolution
/// .
class XlaConvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA ConvGeneralDilated operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#conv_convolution
/// .
class XlaConvV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Emits an HLO `CustomCall` operation with multiple outputs.
/// As opposed to `XlaCustomCall`, this operation supports multiple outputs.
/// 
/// See `CustomCall` specification at
///   https://tensorflow.org/xla/operation_semantics#customcall,
/// and `mhlo.custom_call` specification at
///   https://tensorflow.org/mlir/hlo_ops#mhlocustom_call_mlirmhlocustomcallop.
class XlaCustomCallV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA DotGeneral operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#dotgeneral
/// .
class XlaDotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA DotGeneral operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#dotgeneral
/// .
class XlaDotV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA DynamicSlice operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#dynamicslice
/// .
/// 
/// DynamicSlice extracts a sub-array from the input array at dynamic
/// start_indices. The size of the slice in each dimension is passed in
/// size_indices, which specify the end point of exclusive slice intervals in each
/// dimension -- [start, start + size). The shape of start_indices must have rank 1,
/// with dimension size equal to the rank of operand.
class XlaDynamicSliceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA DynamicUpdateSlice operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#dynamicupdateslice
/// .
/// 
/// XlaDynamicUpdateSlice generates a result which is the value of the `input`
/// operand, with a slice update overwritten at `indices`. The shape of `update`
/// determines the shape of the sub-array of the result which is updated. The shape
/// of indices must be rank == 1, with dimension size equal to the rank of `input`.
/// 
/// Handling of out-of-bounds slice indices is implementation-defined.
class XlaDynamicUpdateSliceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op which supports basic einsum op with 2 inputs and 1 output.
/// This op has better TPU performance since it doesn't have explicitly reshape and
/// transpose operations as tf.einsum does.
class XlaEinsumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Gather operator documented at
/// https://www.tensorflow.org/xla/operation_semantics#gather
class XlaGatherOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A pseudo-op to represent host-side computation in an XLA program.
class XlaHostComputeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Sort operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#sort
/// .
/// 
/// Sorts a tensor. Currently only sorts in ascending order are supported.
class XlaKeyValueSortOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// XLA Launch Op. For use by the XLA JIT only.
class XlaLaunchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// XLA Launch Op. For use by the XLA JIT only.
class XlaLaunchV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA OptimizationBarrier operator.
/// Documented at https://www.tensorflow.org/xla/operation_semantics#optimizationbarrier.
class XlaOptimizationBarrierOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Pad operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#pad
/// .
class XlaPadOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op to receive a tensor from the host.
/// output: the tensor that will be received from the host.
/// Toutput: element type for output.
/// shape: shape for output.
/// key: A unique identifier for this region used to match up host transfers.
class XlaRecvFromHostOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Receives the named tensor from another XLA computation. Wraps the XLA Recv
/// operator documented at
///  https://www.tensorflow.org/performance/xla/operation_semantics#recv .
class XlaRecvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that receives embedding activations on the TPU.
/// The TPU system performs the embedding lookups and aggregations. The results of
/// these aggregations are visible to the Tensorflow Graph as the outputs of a
/// XlaRecvTPUEmbeddingActivations Op. This op returns a list containing one
/// Tensor of activations per table specified in the model.
class XlaRecvTPUEmbeddingActivationsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Receives deduplication data (indices and weights) from the embedding core.
/// The deduplication data is a Tensor with type=DT_VARIANT. The tensor itself is an
/// XLA nested tuple containing N elements (where N is the ratio of the number of
/// embedding to tensor cores per TPU chip). Each element of the nested tuple is a
/// tuple of rank 1 tensors. Each tensor either contains indices (DT_UINT32) for
/// embedding lookup on the TensorCore or weights (DT_FLOAT) to apply to the output
/// of the embedding lookup operation.
class XlaRecvTPUEmbeddingDeduplicationDataOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Reduce operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#reduce .
class XlaReduceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA ReducePrecision operator
/// documented at https://www.tensorflow.org/xla/operation_semantics#reduceprecision.
class XlaReducePrecisionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA ReduceScatter operator
/// documented at https://www.tensorflow.org/xla/operation_semantics#reducescatter.
class XlaReduceScatterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA ReduceWindow operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#reducewindow .
class XlaReduceWindowOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Inverse of XlaSetDynamicDimensionSize.
/// Make an xla bounded dynamic dimension into a static dimension. The bound of the
/// size of dimension `dim_index` becomes the static dimension size.
class XlaRemoveDynamicDimensionSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Replica ID.
class XlaReplicaIdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Stateless PRNG bit generator.
/// Wraps the XLA RngBitGenerator operator, documented at
///  https://www.tensorflow.org/performance/xla/operation_semantics#rngbitgenerator.
class XlaRngBitGeneratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Scatter operator documented at
/// https://www.tensorflow.org/xla/operation_semantics#scatter.
class XlaScatterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA SelectAndScatter operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#selectandscatter
/// .
class XlaSelectAndScatterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the eigen decomposition of a batch of self-adjoint matrices
/// (Note: Only real inputs are supported).
/// 
/// Computes the eigenvalues and eigenvectors of the innermost N-by-N matrices in
/// tensor such that tensor[...,:,:] * v[..., :,i] = e[..., i] * v[...,:,i], for
/// i=0...N-1.
class XlaSelfAdjointEigOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Sends the named tensor to another XLA computation. Wraps the XLA Send operator
/// documented at
///  https://www.tensorflow.org/performance/xla/operation_semantics#send .
class XlaSendOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that performs gradient updates of embedding tables.
/// The gradients argument is a TensorList having the same length and shapes as the
/// return value of XlaRecvTPUEmbeddingActivations, but contains gradients of the
/// model's loss with respect to the embedding activations. The embedding tables are
/// updated from these gradients via the optimizer specified in the
/// TPUEmbeddingConfiguration proto given to tpu.initialize_system.
class XlaSendTPUEmbeddingGradientsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op to send a tensor to the host.
/// input: the tensor that will be sent to the host.
/// Tinput: element type for input.
/// key: A unique identifier for this region used to match up host transfers.
class XlaSendToHostOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Set a bound for the given input value as a hint to Xla compiler,
/// returns the same value.
class XlaSetBoundOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Make a static dimension into a xla bounded dynamic dimension.
/// The current static dimension size will become the bound and the second
///         operand becomes the dynamic size of the dimension.
class XlaSetDynamicDimensionSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op which shards the input based on the given sharding attribute.
/// 
/// Since TF runtime still relies on V1 sharding but the compiler requires V2
/// Sharding to support the new partitioner Shardy, when the op can reach both the
/// compiler and the runtime, we record V1 sharding attribute in _XlaSharding and V2
/// sharding attribute in _XlaShardingV2, and verify that they are equivalent when
/// they both exist and _XlaShardingV2 is used.
class XlaShardingOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Sort operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#sort
/// .
/// 
/// Sorts a tensor. Currently only sorts in ascending order are supported.
class XlaSortOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// XlaSparseActivationsUnstackOp attempts to fuse transpose, relayout,
///     conversion, stacking and optionally interleaving of the embedding
///     activations, while also offloading this work to SparseCore.
/// 
///     The op assumes its operand is in SparseCore layout, while also being F32.
///     The output is a tuple of tensors in TensorCore layout, in any data type.
class XlaSparseActivationsUnstackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseCoreAdagradMomentumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseCoreAdagradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseCoreAdamOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseCoreFtrlOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseCoreSgdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithAdagradAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithAdagradMomentumAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithAdamAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithFtrlAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithSgdAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op looks up the embedding vectors on SparseCores and performs the given combiner computation on TensorCores.
class XlaSparseDenseMatmulCustomCombinerOnTcWithCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the custom optimizer per-row update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class XlaSparseDenseMatmulGradWithSgdAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the SGD optimizer update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithSgdAndStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseDenseMatmulWithCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulWithStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// XlaSparseGradientsStackOp attempts to fuse transpose, relayout, conversion,
///     unstacking and optionally interleaving of the embedding gradients, while
///     also offloading this work to SparseCore.
/// 
///     The op assumes its operands are in TensoreCore layout and in any data type.
///     The output is in SparseCore layout and is expected to be F32.
class XlaSparseGradientsStackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Splits input tensor across all dimensions.
/// An op which slices the input tensor based on the given num_splits attribute,
/// pads slices optionally, and returned the slices. Slices are returned in
/// row-major order.
/// 
/// This op may be generated via the TPU bridge.
/// 
/// For example, with `input` tensor:
/// ```
/// [[0, 1, 2],
///  [3, 4, 5],
///  [6, 7, 8]]
/// ```
/// `num_splits`:
/// ```
/// [2, 2]
/// ```
/// and `paddings`:
/// ```
/// [1, 1]
/// ```
/// the expected `outputs` is:
/// ```
/// [[0, 1],
///  [3, 4]]
/// [[2, 0],
///  [5, 0]]
/// [[6, 7],
///  [0, 0]]
/// [[8, 0],
///  [0, 0]]
/// ```
class XlaSplitNDOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op used by XLA SPMD partitioner to switch from automatic partitioning to
/// manual partitioning. It annotates the input (full-shape, to be automatically
/// partitioned) with the same sharding used by manual partitioning, and outputs a
/// shard-shaped tensor to be consumed by later manually-partitioned ops. If the
/// shape is not evenly partitionable, the padding region will be masked with 0s.
/// The conversion can happen partially in subgroups, by specifying the dim
/// attribute, where only that dim will be converted.
class XlaSpmdFullToShardShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op used by XLA SPMD partitioner to switch from manual partitioning to
/// automatic partitioning. It converts the shard-shaped, manually partitioned input
/// into full-shaped tensor to be partitioned automatically with the same sharding
/// used by manual partitioning. The conversion can happen partially in subgroups,
/// by specifying the dim attribute, where only that dim will be converted.
class XlaSpmdShardToFullShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the eigen decomposition of a batch of self-adjoint matrices
/// (Note: Only real inputs are supported).
/// 
/// Computes the eigenvalues and eigenvectors of the innermost M-by-N matrices in
/// tensor such that tensor[...,:,:] = u[..., :, :] * Diag(s[..., :]) * Transpose(v[...,:,:]).
class XlaSvdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the variadic XLA Reduce operator.
/// Semantics are documented at
///  https://www.tensorflow.org/performance/xla/operation_semantics#variadic_reduce.
/// 
/// This version is limited to operands of the same dtype.
/// XlaVariadicReduceV2 is a version that supports heterogeneous operands.
class XlaVariadicReduceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the variadic XLA Reduce operator.
/// Semantics are documented at
///  https://www.tensorflow.org/performance/xla/operation_semantics#variadic_reduce.
/// 
/// This is an expanded version of XlaVariadicReduce, with support for
/// operands of different dtypes, and improved shape inference.
class XlaVariadicReduceV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Sort operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#sort
/// .
/// 
/// Sorts one or more tensors, with support for custom comparator, dimension, and
/// is_stable attributes.
class XlaVariadicSortOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns 0 if x == 0, and x * log1p(y) otherwise, elementwise.
class Xlog1pyOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns 0 if x == 0, and x * log(y) otherwise, elementwise.
class XlogyOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Yield operation
/// The "yield" operation represents a return operation within the conditional
///     and body of structured control flow (e.g., if and while). The operation
///     takes a variable number of operands and produces no results. The number and
///     types of inputs must match the signature of the operation that contains the
///     region.
class YieldOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a tensor of zeros with the same shape and type as x.
class ZerosLikeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the Hurwitz zeta function \\(\zeta(x, q)\\).
/// The Hurwitz zeta function is defined as:
/// 
/// 
/// \\(\zeta(x, q) = \sum_{n=0}^{\infty} (q + n)^{-x}\\)
class ZetaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class XlaSparseDenseMatmulGradWithAdagradAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the Adagrad optimizer update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithAdagradAndStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the Adagrad momentumoptimizer update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithAdagradMomentumAndStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class XlaSparseDenseMatmulGradWithAdamAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the Adam optimizer update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithAdamAndStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class XlaSparseDenseMatmulGradWithFtrlAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the Ftrl optimizer update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithFtrlAndStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::NcclAllReduceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class NcclAllReduceOpGenericAdaptorBase {
public:
  struct Properties {
    using num_devicesTy = ::mlir::IntegerAttr;
    num_devicesTy num_devices;

    auto getNumDevices() const {
      auto &propStorage = this->num_devices;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setNumDevices(const ::mlir::IntegerAttr &propValue) {
      this->num_devices = propValue;
    }
    using reductionTy = ::mlir::StringAttr;
    reductionTy reduction;

    auto getReduction() const {
      auto &propStorage = this->reduction;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setReduction(const ::mlir::StringAttr &propValue) {
      this->reduction = propValue;
    }
    using shared_nameTy = ::mlir::StringAttr;
    shared_nameTy shared_name;

    auto getSharedName() const {
      auto &propStorage = this->shared_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSharedName(const ::mlir::StringAttr &propValue) {
      this->shared_name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.num_devices == this->num_devices &&
        rhs.reduction == this->reduction &&
        rhs.shared_name == this->shared_name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NcclAllReduceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.NcclAllReduce", odsAttrs.getContext());
  }

  NcclAllReduceOpGenericAdaptorBase(NcclAllReduceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getReductionAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().reduction);
    return attr;
  }

  ::llvm::StringRef getReduction();
  ::mlir::IntegerAttr getNumDevicesAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().num_devices);
    return attr;
  }

  uint64_t getNumDevices();
  ::mlir::StringAttr getSharedNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().shared_name);
    return attr;
  }

  ::llvm::StringRef getSharedName();
};
} // namespace detail
template <typename RangeT>
class NcclAllReduceOpGenericAdaptor : public detail::NcclAllReduceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NcclAllReduceOpGenericAdaptorBase;
public:
  NcclAllReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NcclAllReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NcclAllReduceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NcclAllReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NcclAllReduceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NcclAllReduceOpGenericAdaptor(RangeT values, const NcclAllReduceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NcclAllReduceOp, typename = std::enable_if_t<std::is_same_v<LateInst, NcclAllReduceOp>>>
  NcclAllReduceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NcclAllReduceOpAdaptor : public NcclAllReduceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using NcclAllReduceOpGenericAdaptor::NcclAllReduceOpGenericAdaptor;
  NcclAllReduceOpAdaptor(NcclAllReduceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NcclAllReduceOp : public ::mlir::Op<NcclAllReduceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, GetResourceInstanceInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NcclAllReduceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NcclAllReduceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("num_devices"), ::llvm::StringRef("reduction"), ::llvm::StringRef("shared_name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getNumDevicesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getNumDevicesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getReductionAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getReductionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSharedNameAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSharedNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.NcclAllReduce");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getData() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getReductionAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().reduction);
  }

  ::llvm::StringRef getReduction();
  ::mlir::IntegerAttr getNumDevicesAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().num_devices);
  }

  uint64_t getNumDevices();
  ::mlir::StringAttr getSharedNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().shared_name);
  }

  ::llvm::StringRef getSharedName();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setReductionAttr(::mlir::StringAttr attr) {
    getProperties().reduction = attr;
  }

  void setReduction(::llvm::StringRef attrValue);
  void setNumDevicesAttr(::mlir::IntegerAttr attr) {
    getProperties().num_devices = attr;
  }

  void setNumDevices(uint64_t attrValue);
  void setSharedNameAttr(::mlir::StringAttr attr) {
    getProperties().shared_name = attr;
  }

  void setSharedName(::llvm::StringRef attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type data, ::mlir::Value input, ::mlir::StringAttr reduction, ::mlir::IntegerAttr num_devices, ::mlir::StringAttr shared_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, ::mlir::StringAttr reduction, ::mlir::IntegerAttr num_devices, ::mlir::StringAttr shared_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::StringAttr reduction, ::mlir::IntegerAttr num_devices, ::mlir::StringAttr shared_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type data, ::mlir::Value input, ::llvm::StringRef reduction, uint64_t num_devices, ::llvm::StringRef shared_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, ::llvm::StringRef reduction, uint64_t num_devices, ::llvm::StringRef shared_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::llvm::StringRef reduction, uint64_t num_devices, ::llvm::StringRef shared_name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  std::optional<std::string> GetResourceInstanceStr();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::NcclAllReduceOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::NdtriOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class NdtriOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NdtriOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Ndtri", odsAttrs.getContext());
  }

  NdtriOpGenericAdaptorBase(NdtriOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class NdtriOpGenericAdaptor : public detail::NdtriOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NdtriOpGenericAdaptorBase;
public:
  NdtriOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NdtriOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NdtriOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NdtriOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NdtriOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NdtriOpGenericAdaptor(RangeT values, const NdtriOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NdtriOp, typename = std::enable_if_t<std::is_same_v<LateInst, NdtriOp>>>
  NdtriOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NdtriOpAdaptor : public NdtriOpGenericAdaptor<::mlir::ValueRange> {
public:
  using NdtriOpGenericAdaptor::NdtriOpGenericAdaptor;
  NdtriOpAdaptor(NdtriOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NdtriOp : public ::mlir::Op<NdtriOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NdtriOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NdtriOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Ndtri");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::NdtriOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::NegOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class NegOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NegOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Neg", odsAttrs.getContext());
  }

  NegOpGenericAdaptorBase(NegOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class NegOpGenericAdaptor : public detail::NegOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NegOpGenericAdaptorBase;
public:
  NegOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NegOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NegOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NegOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NegOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NegOpGenericAdaptor(RangeT values, const NegOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NegOp, typename = std::enable_if_t<std::is_same_v<LateInst, NegOp>>>
  NegOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NegOpAdaptor : public NegOpGenericAdaptor<::mlir::ValueRange> {
public:
  using NegOpGenericAdaptor::NegOpGenericAdaptor;
  NegOpAdaptor(NegOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NegOp : public ::mlir::Op<NegOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::TF::CwiseUnary, ::mlir::OpTrait::TF::IsInvolution, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NegOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NegOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Neg");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::NegOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::NextAfterOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class NextAfterOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NextAfterOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.NextAfter", odsAttrs.getContext());
  }

  NextAfterOpGenericAdaptorBase(NextAfterOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class NextAfterOpGenericAdaptor : public detail::NextAfterOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NextAfterOpGenericAdaptorBase;
public:
  NextAfterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NextAfterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NextAfterOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NextAfterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NextAfterOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NextAfterOpGenericAdaptor(RangeT values, const NextAfterOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NextAfterOp, typename = std::enable_if_t<std::is_same_v<LateInst, NextAfterOp>>>
  NextAfterOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX1() {
    return (*getODSOperands(0).begin());
  }

  ValueT getX2() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NextAfterOpAdaptor : public NextAfterOpGenericAdaptor<::mlir::ValueRange> {
public:
  using NextAfterOpGenericAdaptor::NextAfterOpGenericAdaptor;
  NextAfterOpAdaptor(NextAfterOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NextAfterOp : public ::mlir::Op<NextAfterOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ResultsBroadcastableShape, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NextAfterOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NextAfterOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.NextAfter");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getX2() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getX1Mutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getX2Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value x, Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value x1, ::mlir::Value x2);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x1, ::mlir::Value x2);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::NextAfterOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::NoOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class NoOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NoOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.NoOp", odsAttrs.getContext());
  }

  NoOpGenericAdaptorBase(NoOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class NoOpGenericAdaptor : public detail::NoOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NoOpGenericAdaptorBase;
public:
  NoOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NoOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NoOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NoOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NoOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NoOpGenericAdaptor(RangeT values, const NoOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NoOp, typename = std::enable_if_t<std::is_same_v<LateInst, NoOp>>>
  NoOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NoOpAdaptor : public NoOpGenericAdaptor<::mlir::ValueRange> {
public:
  using NoOpGenericAdaptor::NoOpGenericAdaptor;
  NoOpAdaptor(NoOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NoOp : public ::mlir::Op<NoOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NoOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NoOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.NoOp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::NoOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::NonMaxSuppressionV3Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class NonMaxSuppressionV3OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NonMaxSuppressionV3OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.NonMaxSuppressionV3", odsAttrs.getContext());
  }

  NonMaxSuppressionV3OpGenericAdaptorBase(NonMaxSuppressionV3Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class NonMaxSuppressionV3OpGenericAdaptor : public detail::NonMaxSuppressionV3OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NonMaxSuppressionV3OpGenericAdaptorBase;
public:
  NonMaxSuppressionV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NonMaxSuppressionV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NonMaxSuppressionV3OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NonMaxSuppressionV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NonMaxSuppressionV3OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NonMaxSuppressionV3OpGenericAdaptor(RangeT values, const NonMaxSuppressionV3OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NonMaxSuppressionV3Op, typename = std::enable_if_t<std::is_same_v<LateInst, NonMaxSuppressionV3Op>>>
  NonMaxSuppressionV3OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBoxes() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScores() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMaxOutputSize() {
    return (*getODSOperands(2).begin());
  }

  ValueT getIouThreshold() {
    return (*getODSOperands(3).begin());
  }

  ValueT getScoreThreshold() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NonMaxSuppressionV3OpAdaptor : public NonMaxSuppressionV3OpGenericAdaptor<::mlir::ValueRange> {
public:
  using NonMaxSuppressionV3OpGenericAdaptor::NonMaxSuppressionV3OpGenericAdaptor;
  NonMaxSuppressionV3OpAdaptor(NonMaxSuppressionV3Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NonMaxSuppressionV3Op : public ::mlir::Op<NonMaxSuppressionV3Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NonMaxSuppressionV3OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NonMaxSuppressionV3OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("T_threshold")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTThresholdAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTThresholdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.NonMaxSuppressionV3");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getBoxes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getScores() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getMaxOutputSize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getIouThreshold() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getScoreThreshold() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getBoxesMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScoresMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMaxOutputSizeMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getIouThresholdMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScoreThresholdMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getSelectedIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  ::mlir::Type getTThreshold();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type selected_indices, ::mlir::Value boxes, ::mlir::Value scores, ::mlir::Value max_output_size, ::mlir::Value iou_threshold, ::mlir::Value score_threshold);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value boxes, ::mlir::Value scores, ::mlir::Value max_output_size, ::mlir::Value iou_threshold, ::mlir::Value score_threshold);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::NonMaxSuppressionV3Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::NonMaxSuppressionV4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class NonMaxSuppressionV4OpGenericAdaptorBase {
public:
  struct Properties {
    using pad_to_max_output_sizeTy = ::mlir::BoolAttr;
    pad_to_max_output_sizeTy pad_to_max_output_size;

    auto getPadToMaxOutputSize() const {
      auto &propStorage = this->pad_to_max_output_size;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setPadToMaxOutputSize(const ::mlir::BoolAttr &propValue) {
      this->pad_to_max_output_size = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.pad_to_max_output_size == this->pad_to_max_output_size &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NonMaxSuppressionV4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.NonMaxSuppressionV4", odsAttrs.getContext());
  }

  NonMaxSuppressionV4OpGenericAdaptorBase(NonMaxSuppressionV4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getPadToMaxOutputSizeAttr();
  bool getPadToMaxOutputSize();
};
} // namespace detail
template <typename RangeT>
class NonMaxSuppressionV4OpGenericAdaptor : public detail::NonMaxSuppressionV4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NonMaxSuppressionV4OpGenericAdaptorBase;
public:
  NonMaxSuppressionV4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NonMaxSuppressionV4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NonMaxSuppressionV4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NonMaxSuppressionV4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NonMaxSuppressionV4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NonMaxSuppressionV4OpGenericAdaptor(RangeT values, const NonMaxSuppressionV4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NonMaxSuppressionV4Op, typename = std::enable_if_t<std::is_same_v<LateInst, NonMaxSuppressionV4Op>>>
  NonMaxSuppressionV4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBoxes() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScores() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMaxOutputSize() {
    return (*getODSOperands(2).begin());
  }

  ValueT getIouThreshold() {
    return (*getODSOperands(3).begin());
  }

  ValueT getScoreThreshold() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NonMaxSuppressionV4OpAdaptor : public NonMaxSuppressionV4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using NonMaxSuppressionV4OpGenericAdaptor::NonMaxSuppressionV4OpGenericAdaptor;
  NonMaxSuppressionV4OpAdaptor(NonMaxSuppressionV4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NonMaxSuppressionV4Op : public ::mlir::Op<NonMaxSuppressionV4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NonMaxSuppressionV4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NonMaxSuppressionV4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("T_threshold"), ::llvm::StringRef("pad_to_max_output_size")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTThresholdAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTThresholdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getPadToMaxOutputSizeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getPadToMaxOutputSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.NonMaxSuppressionV4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getBoxes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getScores() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getMaxOutputSize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getIouThreshold() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getScoreThreshold() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getBoxesMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScoresMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMaxOutputSizeMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getIouThresholdMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScoreThresholdMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getSelectedIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getValidOutputs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getPadToMaxOutputSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().pad_to_max_output_size);
  }

  bool getPadToMaxOutputSize();
  ::mlir::Type getT();
  ::mlir::Type getTThreshold();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setPadToMaxOutputSizeAttr(::mlir::BoolAttr attr) {
    getProperties().pad_to_max_output_size = attr;
  }

  void setPadToMaxOutputSize(::std::optional<bool> attrValue);
  ::mlir::Attribute removePadToMaxOutputSizeAttr() {
      auto attr = getProperties().pad_to_max_output_size;
      getProperties().pad_to_max_output_size = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type selected_indices, ::mlir::Type valid_outputs, ::mlir::Value boxes, ::mlir::Value scores, ::mlir::Value max_output_size, ::mlir::Value iou_threshold, ::mlir::Value score_threshold, /*optional*/::mlir::BoolAttr pad_to_max_output_size);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value boxes, ::mlir::Value scores, ::mlir::Value max_output_size, ::mlir::Value iou_threshold, ::mlir::Value score_threshold, /*optional*/::mlir::BoolAttr pad_to_max_output_size);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type selected_indices, ::mlir::Type valid_outputs, ::mlir::Value boxes, ::mlir::Value scores, ::mlir::Value max_output_size, ::mlir::Value iou_threshold, ::mlir::Value score_threshold, /*optional*/bool pad_to_max_output_size = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value boxes, ::mlir::Value scores, ::mlir::Value max_output_size, ::mlir::Value iou_threshold, ::mlir::Value score_threshold, /*optional*/bool pad_to_max_output_size = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::NonMaxSuppressionV4Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::NonMaxSuppressionV5Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class NonMaxSuppressionV5OpGenericAdaptorBase {
public:
  struct Properties {
    using pad_to_max_output_sizeTy = ::mlir::BoolAttr;
    pad_to_max_output_sizeTy pad_to_max_output_size;

    auto getPadToMaxOutputSize() const {
      auto &propStorage = this->pad_to_max_output_size;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setPadToMaxOutputSize(const ::mlir::BoolAttr &propValue) {
      this->pad_to_max_output_size = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.pad_to_max_output_size == this->pad_to_max_output_size &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NonMaxSuppressionV5OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.NonMaxSuppressionV5", odsAttrs.getContext());
  }

  NonMaxSuppressionV5OpGenericAdaptorBase(NonMaxSuppressionV5Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getPadToMaxOutputSizeAttr();
  bool getPadToMaxOutputSize();
};
} // namespace detail
template <typename RangeT>
class NonMaxSuppressionV5OpGenericAdaptor : public detail::NonMaxSuppressionV5OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NonMaxSuppressionV5OpGenericAdaptorBase;
public:
  NonMaxSuppressionV5OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NonMaxSuppressionV5OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NonMaxSuppressionV5OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NonMaxSuppressionV5OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NonMaxSuppressionV5OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NonMaxSuppressionV5OpGenericAdaptor(RangeT values, const NonMaxSuppressionV5OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NonMaxSuppressionV5Op, typename = std::enable_if_t<std::is_same_v<LateInst, NonMaxSuppressionV5Op>>>
  NonMaxSuppressionV5OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBoxes() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScores() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMaxOutputSize() {
    return (*getODSOperands(2).begin());
  }

  ValueT getIouThreshold() {
    return (*getODSOperands(3).begin());
  }

  ValueT getScoreThreshold() {
    return (*getODSOperands(4).begin());
  }

  ValueT getSoftNmsSigma() {
    return (*getODSOperands(5).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NonMaxSuppressionV5OpAdaptor : public NonMaxSuppressionV5OpGenericAdaptor<::mlir::ValueRange> {
public:
  using NonMaxSuppressionV5OpGenericAdaptor::NonMaxSuppressionV5OpGenericAdaptor;
  NonMaxSuppressionV5OpAdaptor(NonMaxSuppressionV5Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NonMaxSuppressionV5Op : public ::mlir::Op<NonMaxSuppressionV5Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<3>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<6>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NonMaxSuppressionV5OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NonMaxSuppressionV5OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("pad_to_max_output_size")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getPadToMaxOutputSizeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getPadToMaxOutputSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.NonMaxSuppressionV5");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getBoxes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getScores() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getMaxOutputSize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getIouThreshold() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getScoreThreshold() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(4).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getSoftNmsSigma() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(5).begin());
  }

  ::mlir::OpOperand &getBoxesMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScoresMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMaxOutputSizeMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getIouThresholdMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScoreThresholdMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSoftNmsSigmaMutable() {
    auto range = getODSOperandIndexAndLength(5);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getSelectedIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getSelectedScores() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getValidOutputs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(2).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getPadToMaxOutputSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().pad_to_max_output_size);
  }

  bool getPadToMaxOutputSize();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setPadToMaxOutputSizeAttr(::mlir::BoolAttr attr) {
    getProperties().pad_to_max_output_size = attr;
  }

  void setPadToMaxOutputSize(::std::optional<bool> attrValue);
  ::mlir::Attribute removePadToMaxOutputSizeAttr() {
      auto attr = getProperties().pad_to_max_output_size;
      getProperties().pad_to_max_output_size = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type selected_indices, ::mlir::Type selected_scores, ::mlir::Type valid_outputs, ::mlir::Value boxes, ::mlir::Value scores, ::mlir::Value max_output_size, ::mlir::Value iou_threshold, ::mlir::Value score_threshold, ::mlir::Value soft_nms_sigma, /*optional*/::mlir::BoolAttr pad_to_max_output_size);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value boxes, ::mlir::Value scores, ::mlir::Value max_output_size, ::mlir::Value iou_threshold, ::mlir::Value score_threshold, ::mlir::Value soft_nms_sigma, /*optional*/::mlir::BoolAttr pad_to_max_output_size);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type selected_indices, ::mlir::Type selected_scores, ::mlir::Type valid_outputs, ::mlir::Value boxes, ::mlir::Value scores, ::mlir::Value max_output_size, ::mlir::Value iou_threshold, ::mlir::Value score_threshold, ::mlir::Value soft_nms_sigma, /*optional*/bool pad_to_max_output_size = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value boxes, ::mlir::Value scores, ::mlir::Value max_output_size, ::mlir::Value iou_threshold, ::mlir::Value score_threshold, ::mlir::Value soft_nms_sigma, /*optional*/bool pad_to_max_output_size = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::NonMaxSuppressionV5Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::NotEqualOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class NotEqualOpGenericAdaptorBase {
public:
  struct Properties {
    using incompatible_shape_errorTy = ::mlir::BoolAttr;
    incompatible_shape_errorTy incompatible_shape_error;

    auto getIncompatibleShapeError() const {
      auto &propStorage = this->incompatible_shape_error;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setIncompatibleShapeError(const ::mlir::BoolAttr &propValue) {
      this->incompatible_shape_error = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.incompatible_shape_error == this->incompatible_shape_error &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NotEqualOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.NotEqual", odsAttrs.getContext());
  }

  NotEqualOpGenericAdaptorBase(NotEqualOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getIncompatibleShapeErrorAttr();
  bool getIncompatibleShapeError();
};
} // namespace detail
template <typename RangeT>
class NotEqualOpGenericAdaptor : public detail::NotEqualOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NotEqualOpGenericAdaptorBase;
public:
  NotEqualOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NotEqualOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NotEqualOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NotEqualOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NotEqualOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NotEqualOpGenericAdaptor(RangeT values, const NotEqualOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NotEqualOp, typename = std::enable_if_t<std::is_same_v<LateInst, NotEqualOp>>>
  NotEqualOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NotEqualOpAdaptor : public NotEqualOpGenericAdaptor<::mlir::ValueRange> {
public:
  using NotEqualOpGenericAdaptor::NotEqualOpGenericAdaptor;
  NotEqualOpAdaptor(NotEqualOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NotEqualOp : public ::mlir::Op<NotEqualOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsCommutative, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NotEqualOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NotEqualOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("incompatible_shape_error")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIncompatibleShapeErrorAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIncompatibleShapeErrorAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.NotEqual");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getIncompatibleShapeErrorAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().incompatible_shape_error);
  }

  bool getIncompatibleShapeError();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setIncompatibleShapeErrorAttr(::mlir::BoolAttr attr) {
    getProperties().incompatible_shape_error = attr;
  }

  void setIncompatibleShapeError(::std::optional<bool> attrValue);
  ::mlir::Attribute removeIncompatibleShapeErrorAttr() {
      auto attr = getProperties().incompatible_shape_error;
      getProperties().incompatible_shape_error = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value x, Value y, BoolAttr incompatible_shape_error);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type z, ::mlir::Value x, ::mlir::Value y, /*optional*/::mlir::BoolAttr incompatible_shape_error);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, /*optional*/::mlir::BoolAttr incompatible_shape_error);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type z, ::mlir::Value x, ::mlir::Value y, /*optional*/bool incompatible_shape_error = true);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, /*optional*/bool incompatible_shape_error = true);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::NotEqualOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::OneHotOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class OneHotOpGenericAdaptorBase {
public:
  struct Properties {
    using axisTy = ::mlir::IntegerAttr;
    axisTy axis;

    auto getAxis() const {
      auto &propStorage = this->axis;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAxis(const ::mlir::IntegerAttr &propValue) {
      this->axis = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.axis == this->axis &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OneHotOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.OneHot", odsAttrs.getContext());
  }

  OneHotOpGenericAdaptorBase(OneHotOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getAxisAttr();
  uint64_t getAxis();
};
} // namespace detail
template <typename RangeT>
class OneHotOpGenericAdaptor : public detail::OneHotOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OneHotOpGenericAdaptorBase;
public:
  OneHotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OneHotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OneHotOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OneHotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OneHotOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OneHotOpGenericAdaptor(RangeT values, const OneHotOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OneHotOp, typename = std::enable_if_t<std::is_same_v<LateInst, OneHotOp>>>
  OneHotOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getIndices() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDepth() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOnValue() {
    return (*getODSOperands(2).begin());
  }

  ValueT getOffValue() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OneHotOpAdaptor : public OneHotOpGenericAdaptor<::mlir::ValueRange> {
public:
  using OneHotOpGenericAdaptor::OneHotOpGenericAdaptor;
  OneHotOpAdaptor(OneHotOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OneHotOp : public ::mlir::Op<OneHotOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OneHotOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OneHotOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("TI"), ::llvm::StringRef("axis")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTIAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTIAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getAxisAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getAxisAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.OneHot");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDepth() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getOnValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getOffValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getIndicesMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDepthMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOnValueMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOffValueMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getAxisAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().axis);
  }

  uint64_t getAxis();
  ::mlir::Type getT();
  ::mlir::Type getTI();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setAxisAttr(::mlir::IntegerAttr attr) {
    getProperties().axis = attr;
  }

  void setAxis(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeAxisAttr() {
      auto attr = getProperties().axis;
      getProperties().axis = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value indices, Value depth, Value on_value, Value off_value, IntegerAttr axis);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value indices, ::mlir::Value depth, ::mlir::Value on_value, ::mlir::Value off_value, /*optional*/::mlir::IntegerAttr axis);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value indices, ::mlir::Value depth, ::mlir::Value on_value, ::mlir::Value off_value, /*optional*/::mlir::IntegerAttr axis);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value indices, ::mlir::Value depth, ::mlir::Value on_value, ::mlir::Value off_value, /*optional*/uint64_t axis = -1);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value indices, ::mlir::Value depth, ::mlir::Value on_value, ::mlir::Value off_value, /*optional*/uint64_t axis = -1);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::OneHotOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::OneShotIteratorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class OneShotIteratorOpGenericAdaptorBase {
public:
  struct Properties {
    using containerTy = ::mlir::StringAttr;
    containerTy container;

    auto getContainer() const {
      auto &propStorage = this->container;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setContainer(const ::mlir::StringAttr &propValue) {
      this->container = propValue;
    }
    using dataset_factoryTy = ::mlir::SymbolRefAttr;
    dataset_factoryTy dataset_factory;

    auto getDatasetFactory() const {
      auto &propStorage = this->dataset_factory;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setDatasetFactory(const ::mlir::SymbolRefAttr &propValue) {
      this->dataset_factory = propValue;
    }
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    using shared_nameTy = ::mlir::StringAttr;
    shared_nameTy shared_name;

    auto getSharedName() const {
      auto &propStorage = this->shared_name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setSharedName(const ::mlir::StringAttr &propValue) {
      this->shared_name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.container == this->container &&
        rhs.dataset_factory == this->dataset_factory &&
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        rhs.shared_name == this->shared_name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OneShotIteratorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.OneShotIterator", odsAttrs.getContext());
  }

  OneShotIteratorOpGenericAdaptorBase(OneShotIteratorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getDatasetFactoryAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().dataset_factory);
    return attr;
  }

  ::mlir::SymbolRefAttr getDatasetFactory();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::StringAttr getContainerAttr();
  ::llvm::StringRef getContainer();
  ::mlir::StringAttr getSharedNameAttr();
  ::llvm::StringRef getSharedName();
};
} // namespace detail
template <typename RangeT>
class OneShotIteratorOpGenericAdaptor : public detail::OneShotIteratorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OneShotIteratorOpGenericAdaptorBase;
public:
  OneShotIteratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OneShotIteratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OneShotIteratorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OneShotIteratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OneShotIteratorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OneShotIteratorOpGenericAdaptor(RangeT values, const OneShotIteratorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OneShotIteratorOp, typename = std::enable_if_t<std::is_same_v<LateInst, OneShotIteratorOp>>>
  OneShotIteratorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OneShotIteratorOpAdaptor : public OneShotIteratorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using OneShotIteratorOpGenericAdaptor::OneShotIteratorOpGenericAdaptor;
  OneShotIteratorOpAdaptor(OneShotIteratorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OneShotIteratorOp : public ::mlir::Op<OneShotIteratorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OneShotIteratorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OneShotIteratorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("container"), ::llvm::StringRef("dataset_factory"), ::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types"), ::llvm::StringRef("shared_name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getContainerAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getContainerAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDatasetFactoryAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDatasetFactoryAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getSharedNameAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getSharedNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.OneShotIterator");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getDatasetFactoryAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().dataset_factory);
  }

  ::mlir::SymbolRefAttr getDatasetFactory();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::StringAttr getContainerAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().container);
  }

  ::llvm::StringRef getContainer();
  ::mlir::StringAttr getSharedNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().shared_name);
  }

  ::llvm::StringRef getSharedName();
  void setDatasetFactoryAttr(::mlir::SymbolRefAttr attr) {
    getProperties().dataset_factory = attr;
  }

  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  void setContainerAttr(::mlir::StringAttr attr) {
    getProperties().container = attr;
  }

  void setContainer(::std::optional<::llvm::StringRef> attrValue);
  void setSharedNameAttr(::mlir::StringAttr attr) {
    getProperties().shared_name = attr;
  }

  void setSharedName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeContainerAttr() {
      auto attr = getProperties().container;
      getProperties().container = {};
      return attr;
  }

  ::mlir::Attribute removeSharedNameAttr() {
      auto attr = getProperties().shared_name;
      getProperties().shared_name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::SymbolRefAttr dataset_factory, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::StringAttr container, /*optional*/::mlir::StringAttr shared_name = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr dataset_factory, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::StringAttr container, /*optional*/::mlir::StringAttr shared_name = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::SymbolRefAttr dataset_factory, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::llvm::StringRef container = "", /*optional*/::llvm::StringRef shared_name = "");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr dataset_factory, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::llvm::StringRef container = "", /*optional*/::llvm::StringRef shared_name = "");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::OneShotIteratorOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::OnesLikeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class OnesLikeOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OnesLikeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.OnesLike", odsAttrs.getContext());
  }

  OnesLikeOpGenericAdaptorBase(OnesLikeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class OnesLikeOpGenericAdaptor : public detail::OnesLikeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OnesLikeOpGenericAdaptorBase;
public:
  OnesLikeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OnesLikeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OnesLikeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OnesLikeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OnesLikeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OnesLikeOpGenericAdaptor(RangeT values, const OnesLikeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OnesLikeOp, typename = std::enable_if_t<std::is_same_v<LateInst, OnesLikeOp>>>
  OnesLikeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OnesLikeOpAdaptor : public OnesLikeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using OnesLikeOpGenericAdaptor::OnesLikeOpGenericAdaptor;
  OnesLikeOpAdaptor(OnesLikeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OnesLikeOp : public ::mlir::Op<OnesLikeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::TF::IsIdempotent, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OnesLikeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OnesLikeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.OnesLike");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::OnesLikeOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::OptimizeDatasetV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class OptimizeDatasetV2OpGenericAdaptorBase {
public:
  struct Properties {
    using optimization_configsTy = ::mlir::ArrayAttr;
    optimization_configsTy optimization_configs;

    auto getOptimizationConfigs() const {
      auto &propStorage = this->optimization_configs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setOptimizationConfigs(const ::mlir::ArrayAttr &propValue) {
      this->optimization_configs = propValue;
    }
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.optimization_configs == this->optimization_configs &&
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OptimizeDatasetV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.OptimizeDatasetV2", odsAttrs.getContext());
  }

  OptimizeDatasetV2OpGenericAdaptorBase(OptimizeDatasetV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::ArrayAttr getOptimizationConfigsAttr();
  ::mlir::ArrayAttr getOptimizationConfigs();
};
} // namespace detail
template <typename RangeT>
class OptimizeDatasetV2OpGenericAdaptor : public detail::OptimizeDatasetV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OptimizeDatasetV2OpGenericAdaptorBase;
public:
  OptimizeDatasetV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OptimizeDatasetV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OptimizeDatasetV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OptimizeDatasetV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OptimizeDatasetV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OptimizeDatasetV2OpGenericAdaptor(RangeT values, const OptimizeDatasetV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OptimizeDatasetV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, OptimizeDatasetV2Op>>>
  OptimizeDatasetV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInputDataset() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOptimizationsEnabled() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOptimizationsDisabled() {
    return (*getODSOperands(2).begin());
  }

  ValueT getOptimizationsDefault() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OptimizeDatasetV2OpAdaptor : public OptimizeDatasetV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using OptimizeDatasetV2OpGenericAdaptor::OptimizeDatasetV2OpGenericAdaptor;
  OptimizeDatasetV2OpAdaptor(OptimizeDatasetV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OptimizeDatasetV2Op : public ::mlir::Op<OptimizeDatasetV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OptimizeDatasetV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OptimizeDatasetV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("optimization_configs"), ::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOptimizationConfigsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOptimizationConfigsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.OptimizeDatasetV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputDataset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getOptimizationsEnabled() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getOptimizationsDisabled() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getOptimizationsDefault() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getInputDatasetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOptimizationsEnabledMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOptimizationsDisabledMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOptimizationsDefaultMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::ArrayAttr getOptimizationConfigsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().optimization_configs);
  }

  ::mlir::ArrayAttr getOptimizationConfigs();
  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  void setOptimizationConfigsAttr(::mlir::ArrayAttr attr) {
    getProperties().optimization_configs = attr;
  }

  ::mlir::Attribute removeOptimizationConfigsAttr() {
      auto attr = getProperties().optimization_configs;
      getProperties().optimization_configs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value input_dataset, ::mlir::Value optimizations_enabled, ::mlir::Value optimizations_disabled, ::mlir::Value optimizations_default, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::ArrayAttr optimization_configs = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input_dataset, ::mlir::Value optimizations_enabled, ::mlir::Value optimizations_disabled, ::mlir::Value optimizations_default, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::ArrayAttr optimization_configs = nullptr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::OptimizeDatasetV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::OptionalFromValueOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class OptionalFromValueOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OptionalFromValueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.OptionalFromValue", odsAttrs.getContext());
  }

  OptionalFromValueOpGenericAdaptorBase(OptionalFromValueOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class OptionalFromValueOpGenericAdaptor : public detail::OptionalFromValueOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OptionalFromValueOpGenericAdaptorBase;
public:
  OptionalFromValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OptionalFromValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OptionalFromValueOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OptionalFromValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OptionalFromValueOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OptionalFromValueOpGenericAdaptor(RangeT values, const OptionalFromValueOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OptionalFromValueOp, typename = std::enable_if_t<std::is_same_v<LateInst, OptionalFromValueOp>>>
  OptionalFromValueOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getComponents() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OptionalFromValueOpAdaptor : public OptionalFromValueOpGenericAdaptor<::mlir::ValueRange> {
public:
  using OptionalFromValueOpGenericAdaptor::OptionalFromValueOpGenericAdaptor;
  OptionalFromValueOpAdaptor(OptionalFromValueOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OptionalFromValueOp : public ::mlir::Op<OptionalFromValueOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OptionalFromValueOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OptionalFromValueOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Toutput_types")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getToutputTypesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getToutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.OptionalFromValue");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getComponents() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getComponentsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOptional() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  mlir::OperandElementTypeRange getToutputTypes();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type optional, ::mlir::ValueRange components);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::OptionalFromValueOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::OptionalGetValueOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class OptionalGetValueOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OptionalGetValueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.OptionalGetValue", odsAttrs.getContext());
  }

  OptionalGetValueOpGenericAdaptorBase(OptionalGetValueOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class OptionalGetValueOpGenericAdaptor : public detail::OptionalGetValueOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OptionalGetValueOpGenericAdaptorBase;
public:
  OptionalGetValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OptionalGetValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OptionalGetValueOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OptionalGetValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OptionalGetValueOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OptionalGetValueOpGenericAdaptor(RangeT values, const OptionalGetValueOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OptionalGetValueOp, typename = std::enable_if_t<std::is_same_v<LateInst, OptionalGetValueOp>>>
  OptionalGetValueOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOptional() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OptionalGetValueOpAdaptor : public OptionalGetValueOpGenericAdaptor<::mlir::ValueRange> {
public:
  using OptionalGetValueOpGenericAdaptor::OptionalGetValueOpGenericAdaptor;
  OptionalGetValueOpAdaptor(OptionalGetValueOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OptionalGetValueOp : public ::mlir::Op<OptionalGetValueOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OptionalGetValueOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OptionalGetValueOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.OptionalGetValue");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOptional() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOptionalMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getComponents() {
    return getODSResults(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  mlir::TF::ResultShapeRange getOutputShapes();
  mlir::ResultElementTypeRange getOutputTypes();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange components, ::mlir::Value optional);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::OptionalGetValueOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::OptionalHasValueOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class OptionalHasValueOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OptionalHasValueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.OptionalHasValue", odsAttrs.getContext());
  }

  OptionalHasValueOpGenericAdaptorBase(OptionalHasValueOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class OptionalHasValueOpGenericAdaptor : public detail::OptionalHasValueOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OptionalHasValueOpGenericAdaptorBase;
public:
  OptionalHasValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OptionalHasValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OptionalHasValueOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OptionalHasValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OptionalHasValueOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OptionalHasValueOpGenericAdaptor(RangeT values, const OptionalHasValueOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OptionalHasValueOp, typename = std::enable_if_t<std::is_same_v<LateInst, OptionalHasValueOp>>>
  OptionalHasValueOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOptional() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OptionalHasValueOpAdaptor : public OptionalHasValueOpGenericAdaptor<::mlir::ValueRange> {
public:
  using OptionalHasValueOpGenericAdaptor::OptionalHasValueOpGenericAdaptor;
  OptionalHasValueOpAdaptor(OptionalHasValueOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OptionalHasValueOp : public ::mlir::Op<OptionalHasValueOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OptionalHasValueOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OptionalHasValueOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.OptionalHasValue");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOptional() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOptionalMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHasValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type has_value, ::mlir::Value optional);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value optional);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::OptionalHasValueOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::OptionalNoneOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class OptionalNoneOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OptionalNoneOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.OptionalNone", odsAttrs.getContext());
  }

  OptionalNoneOpGenericAdaptorBase(OptionalNoneOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class OptionalNoneOpGenericAdaptor : public detail::OptionalNoneOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OptionalNoneOpGenericAdaptorBase;
public:
  OptionalNoneOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OptionalNoneOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OptionalNoneOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OptionalNoneOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OptionalNoneOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OptionalNoneOpGenericAdaptor(RangeT values, const OptionalNoneOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OptionalNoneOp, typename = std::enable_if_t<std::is_same_v<LateInst, OptionalNoneOp>>>
  OptionalNoneOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OptionalNoneOpAdaptor : public OptionalNoneOpGenericAdaptor<::mlir::ValueRange> {
public:
  using OptionalNoneOpGenericAdaptor::OptionalNoneOpGenericAdaptor;
  OptionalNoneOpAdaptor(OptionalNoneOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OptionalNoneOp : public ::mlir::Op<OptionalNoneOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OptionalNoneOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OptionalNoneOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.OptionalNone");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOptional() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type optional);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::OptionalNoneOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::OutfeedEnqueueOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class OutfeedEnqueueOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OutfeedEnqueueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.OutfeedEnqueue", odsAttrs.getContext());
  }

  OutfeedEnqueueOpGenericAdaptorBase(OutfeedEnqueueOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class OutfeedEnqueueOpGenericAdaptor : public detail::OutfeedEnqueueOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OutfeedEnqueueOpGenericAdaptorBase;
public:
  OutfeedEnqueueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OutfeedEnqueueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OutfeedEnqueueOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OutfeedEnqueueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OutfeedEnqueueOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OutfeedEnqueueOpGenericAdaptor(RangeT values, const OutfeedEnqueueOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OutfeedEnqueueOp, typename = std::enable_if_t<std::is_same_v<LateInst, OutfeedEnqueueOp>>>
  OutfeedEnqueueOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OutfeedEnqueueOpAdaptor : public OutfeedEnqueueOpGenericAdaptor<::mlir::ValueRange> {
public:
  using OutfeedEnqueueOpGenericAdaptor::OutfeedEnqueueOpGenericAdaptor;
  OutfeedEnqueueOpAdaptor(OutfeedEnqueueOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OutfeedEnqueueOp : public ::mlir::Op<OutfeedEnqueueOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OutfeedEnqueueOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OutfeedEnqueueOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dtype")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.OutfeedEnqueue");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::OutfeedEnqueueOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::OutfeedEnqueueTupleOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class OutfeedEnqueueTupleOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OutfeedEnqueueTupleOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.OutfeedEnqueueTuple", odsAttrs.getContext());
  }

  OutfeedEnqueueTupleOpGenericAdaptorBase(OutfeedEnqueueTupleOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class OutfeedEnqueueTupleOpGenericAdaptor : public detail::OutfeedEnqueueTupleOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OutfeedEnqueueTupleOpGenericAdaptorBase;
public:
  OutfeedEnqueueTupleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OutfeedEnqueueTupleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OutfeedEnqueueTupleOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OutfeedEnqueueTupleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OutfeedEnqueueTupleOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OutfeedEnqueueTupleOpGenericAdaptor(RangeT values, const OutfeedEnqueueTupleOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OutfeedEnqueueTupleOp, typename = std::enable_if_t<std::is_same_v<LateInst, OutfeedEnqueueTupleOp>>>
  OutfeedEnqueueTupleOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getInputs() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OutfeedEnqueueTupleOpAdaptor : public OutfeedEnqueueTupleOpGenericAdaptor<::mlir::ValueRange> {
public:
  using OutfeedEnqueueTupleOpGenericAdaptor::OutfeedEnqueueTupleOpGenericAdaptor;
  OutfeedEnqueueTupleOpAdaptor(OutfeedEnqueueTupleOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OutfeedEnqueueTupleOp : public ::mlir::Op<OutfeedEnqueueTupleOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OutfeedEnqueueTupleOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OutfeedEnqueueTupleOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dtypes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDtypesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDtypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.OutfeedEnqueueTuple");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getInputs() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getInputsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  mlir::OperandElementTypeRange getDtypes();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange inputs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::OutfeedEnqueueTupleOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PackOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PackOpGenericAdaptorBase {
public:
  struct Properties {
    using axisTy = ::mlir::IntegerAttr;
    axisTy axis;

    auto getAxis() const {
      auto &propStorage = this->axis;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAxis(const ::mlir::IntegerAttr &propValue) {
      this->axis = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.axis == this->axis &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PackOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Pack", odsAttrs.getContext());
  }

  PackOpGenericAdaptorBase(PackOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getAxisAttr();
  uint64_t getAxis();
};
} // namespace detail
template <typename RangeT>
class PackOpGenericAdaptor : public detail::PackOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PackOpGenericAdaptorBase;
public:
  PackOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PackOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PackOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PackOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PackOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PackOpGenericAdaptor(RangeT values, const PackOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PackOp, typename = std::enable_if_t<std::is_same_v<LateInst, PackOp>>>
  PackOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getValues() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PackOpAdaptor : public PackOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PackOpGenericAdaptor::PackOpGenericAdaptor;
  PackOpAdaptor(PackOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PackOp : public ::mlir::Op<PackOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PackOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PackOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("N"), ::llvm::StringRef("T"), ::llvm::StringRef("axis")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getAxisAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getAxisAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Pack");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getValues() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getValuesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getAxisAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().axis);
  }

  uint64_t getAxis();
  size_t getN();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setAxisAttr(::mlir::IntegerAttr attr) {
    getProperties().axis = attr;
  }

  void setAxis(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeAxisAttr() {
      auto attr = getProperties().axis;
      getProperties().axis = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::ValueRange values, /*optional*/::mlir::IntegerAttr axis);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange values, /*optional*/::mlir::IntegerAttr axis);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::ValueRange values, /*optional*/uint64_t axis = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange values, /*optional*/uint64_t axis = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PackOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PadOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Pad", odsAttrs.getContext());
  }

  PadOpGenericAdaptorBase(PadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class PadOpGenericAdaptor : public detail::PadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PadOpGenericAdaptorBase;
public:
  PadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PadOpGenericAdaptor(RangeT values, const PadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PadOp, typename = std::enable_if_t<std::is_same_v<LateInst, PadOp>>>
  PadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getPaddings() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PadOpAdaptor : public PadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PadOpGenericAdaptor::PadOpGenericAdaptor;
  PadOpAdaptor(PadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PadOp : public ::mlir::Op<PadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, FoldOperandsTransposeInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tpaddings")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTpaddingsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTpaddingsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Pad");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getPaddings() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getPaddingsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  ::mlir::Type getTpaddings();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value paddings);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value paddings);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // TF_FoldOperandsTransposeInterface:
  SmallVector<unsigned, 4> GetLayoutDependentArgs() { return {0}; }
  SmallVector<unsigned, 4> GetLayoutDependentResults() { return {0}; }
  LogicalResult FoldOperandsPermutation(ArrayRef<int64_t> permutation);
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PadOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PadV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PadV2OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PadV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.PadV2", odsAttrs.getContext());
  }

  PadV2OpGenericAdaptorBase(PadV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class PadV2OpGenericAdaptor : public detail::PadV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PadV2OpGenericAdaptorBase;
public:
  PadV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PadV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PadV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PadV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PadV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PadV2OpGenericAdaptor(RangeT values, const PadV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PadV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, PadV2Op>>>
  PadV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getPaddings() {
    return (*getODSOperands(1).begin());
  }

  ValueT getConstantValues() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PadV2OpAdaptor : public PadV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using PadV2OpGenericAdaptor::PadV2OpGenericAdaptor;
  PadV2OpAdaptor(PadV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PadV2Op : public ::mlir::Op<PadV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PadV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PadV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tpaddings")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTpaddingsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTpaddingsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.PadV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getPaddings() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getConstantValues() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getPaddingsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getConstantValuesMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  ::mlir::Type getTpaddings();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value paddings, ::mlir::Value constant_values);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value paddings, ::mlir::Value constant_values);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PadV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ParallelDynamicStitchOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ParallelDynamicStitchOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ParallelDynamicStitchOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ParallelDynamicStitch", odsAttrs.getContext());
  }

  ParallelDynamicStitchOpGenericAdaptorBase(ParallelDynamicStitchOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ParallelDynamicStitchOpGenericAdaptor : public detail::ParallelDynamicStitchOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ParallelDynamicStitchOpGenericAdaptorBase;
public:
  ParallelDynamicStitchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ParallelDynamicStitchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ParallelDynamicStitchOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ParallelDynamicStitchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ParallelDynamicStitchOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ParallelDynamicStitchOpGenericAdaptor(RangeT values, const ParallelDynamicStitchOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ParallelDynamicStitchOp, typename = std::enable_if_t<std::is_same_v<LateInst, ParallelDynamicStitchOp>>>
  ParallelDynamicStitchOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getIndices() {
    return getODSOperands(0);
  }

  RangeT getData() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ParallelDynamicStitchOpAdaptor : public ParallelDynamicStitchOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ParallelDynamicStitchOpGenericAdaptor::ParallelDynamicStitchOpGenericAdaptor;
  ParallelDynamicStitchOpAdaptor(ParallelDynamicStitchOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ParallelDynamicStitchOp : public ::mlir::Op<ParallelDynamicStitchOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ParallelDynamicStitchOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ParallelDynamicStitchOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("N"), ::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ParallelDynamicStitch");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getData() {
    return getODSOperands(1);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getDataMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getMerged() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  size_t getN();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type merged, ::mlir::ValueRange indices, ::mlir::ValueRange data);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange indices, ::mlir::ValueRange data);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ParallelDynamicStitchOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ParallelMapDatasetOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ParallelMapDatasetOpGenericAdaptorBase {
public:
  struct Properties {
    using fTy = ::mlir::SymbolRefAttr;
    fTy f;

    auto getF() const {
      auto &propStorage = this->f;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setF(const ::mlir::SymbolRefAttr &propValue) {
      this->f = propValue;
    }
    using metadataTy = ::mlir::StringAttr;
    metadataTy metadata;

    auto getMetadata() const {
      auto &propStorage = this->metadata;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setMetadata(const ::mlir::StringAttr &propValue) {
      this->metadata = propValue;
    }
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    using preserve_cardinalityTy = ::mlir::BoolAttr;
    preserve_cardinalityTy preserve_cardinality;

    auto getPreserveCardinality() const {
      auto &propStorage = this->preserve_cardinality;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setPreserveCardinality(const ::mlir::BoolAttr &propValue) {
      this->preserve_cardinality = propValue;
    }
    using sloppyTy = ::mlir::BoolAttr;
    sloppyTy sloppy;

    auto getSloppy() const {
      auto &propStorage = this->sloppy;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setSloppy(const ::mlir::BoolAttr &propValue) {
      this->sloppy = propValue;
    }
    using use_inter_op_parallelismTy = ::mlir::BoolAttr;
    use_inter_op_parallelismTy use_inter_op_parallelism;

    auto getUseInterOpParallelism() const {
      auto &propStorage = this->use_inter_op_parallelism;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setUseInterOpParallelism(const ::mlir::BoolAttr &propValue) {
      this->use_inter_op_parallelism = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.f == this->f &&
        rhs.metadata == this->metadata &&
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        rhs.preserve_cardinality == this->preserve_cardinality &&
        rhs.sloppy == this->sloppy &&
        rhs.use_inter_op_parallelism == this->use_inter_op_parallelism &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ParallelMapDatasetOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ParallelMapDataset", odsAttrs.getContext());
  }

  ParallelMapDatasetOpGenericAdaptorBase(ParallelMapDatasetOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getFAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().f);
    return attr;
  }

  ::mlir::SymbolRefAttr getF();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::BoolAttr getUseInterOpParallelismAttr();
  bool getUseInterOpParallelism();
  ::mlir::BoolAttr getSloppyAttr();
  bool getSloppy();
  ::mlir::BoolAttr getPreserveCardinalityAttr();
  bool getPreserveCardinality();
  ::mlir::StringAttr getMetadataAttr();
  ::llvm::StringRef getMetadata();
};
} // namespace detail
template <typename RangeT>
class ParallelMapDatasetOpGenericAdaptor : public detail::ParallelMapDatasetOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ParallelMapDatasetOpGenericAdaptorBase;
public:
  ParallelMapDatasetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ParallelMapDatasetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ParallelMapDatasetOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ParallelMapDatasetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ParallelMapDatasetOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ParallelMapDatasetOpGenericAdaptor(RangeT values, const ParallelMapDatasetOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ParallelMapDatasetOp, typename = std::enable_if_t<std::is_same_v<LateInst, ParallelMapDatasetOp>>>
  ParallelMapDatasetOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInputDataset() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOtherArguments() {
    return getODSOperands(1);
  }

  ValueT getNumParallelCalls() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ParallelMapDatasetOpAdaptor : public ParallelMapDatasetOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ParallelMapDatasetOpGenericAdaptor::ParallelMapDatasetOpGenericAdaptor;
  ParallelMapDatasetOpAdaptor(ParallelMapDatasetOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ParallelMapDatasetOp : public ::mlir::Op<ParallelMapDatasetOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ParallelMapDatasetOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ParallelMapDatasetOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Targuments"), ::llvm::StringRef("f"), ::llvm::StringRef("metadata"), ::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types"), ::llvm::StringRef("preserve_cardinality"), ::llvm::StringRef("sloppy"), ::llvm::StringRef("use_inter_op_parallelism")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTargumentsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTargumentsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getMetadataAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getMetadataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getPreserveCardinalityAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getPreserveCardinalityAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getSloppyAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getSloppyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getUseInterOpParallelismAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getUseInterOpParallelismAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ParallelMapDataset");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputDataset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getOtherArguments() {
    return getODSOperands(1);
  }

  ::mlir::TypedValue<::mlir::TensorType> getNumParallelCalls() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getInputDatasetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getOtherArgumentsMutable();
  ::mlir::OpOperand &getNumParallelCallsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getFAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().f);
  }

  ::mlir::SymbolRefAttr getF();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::BoolAttr getUseInterOpParallelismAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().use_inter_op_parallelism);
  }

  bool getUseInterOpParallelism();
  ::mlir::BoolAttr getSloppyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().sloppy);
  }

  bool getSloppy();
  ::mlir::BoolAttr getPreserveCardinalityAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().preserve_cardinality);
  }

  bool getPreserveCardinality();
  ::mlir::StringAttr getMetadataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().metadata);
  }

  ::llvm::StringRef getMetadata();
  mlir::OperandElementTypeRange getTarguments();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setFAttr(::mlir::SymbolRefAttr attr) {
    getProperties().f = attr;
  }

  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  void setUseInterOpParallelismAttr(::mlir::BoolAttr attr) {
    getProperties().use_inter_op_parallelism = attr;
  }

  void setUseInterOpParallelism(::std::optional<bool> attrValue);
  void setSloppyAttr(::mlir::BoolAttr attr) {
    getProperties().sloppy = attr;
  }

  void setSloppy(::std::optional<bool> attrValue);
  void setPreserveCardinalityAttr(::mlir::BoolAttr attr) {
    getProperties().preserve_cardinality = attr;
  }

  void setPreserveCardinality(::std::optional<bool> attrValue);
  void setMetadataAttr(::mlir::StringAttr attr) {
    getProperties().metadata = attr;
  }

  void setMetadata(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeUseInterOpParallelismAttr() {
      auto attr = getProperties().use_inter_op_parallelism;
      getProperties().use_inter_op_parallelism = {};
      return attr;
  }

  ::mlir::Attribute removeSloppyAttr() {
      auto attr = getProperties().sloppy;
      getProperties().sloppy = {};
      return attr;
  }

  ::mlir::Attribute removePreserveCardinalityAttr() {
      auto attr = getProperties().preserve_cardinality;
      getProperties().preserve_cardinality = {};
      return attr;
  }

  ::mlir::Attribute removeMetadataAttr() {
      auto attr = getProperties().metadata;
      getProperties().metadata = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value input_dataset, ::mlir::ValueRange other_arguments, ::mlir::Value num_parallel_calls, ::mlir::SymbolRefAttr f, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::BoolAttr use_inter_op_parallelism, /*optional*/::mlir::BoolAttr sloppy = nullptr, /*optional*/::mlir::BoolAttr preserve_cardinality = nullptr, /*optional*/::mlir::StringAttr metadata = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input_dataset, ::mlir::ValueRange other_arguments, ::mlir::Value num_parallel_calls, ::mlir::SymbolRefAttr f, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::BoolAttr use_inter_op_parallelism, /*optional*/::mlir::BoolAttr sloppy = nullptr, /*optional*/::mlir::BoolAttr preserve_cardinality = nullptr, /*optional*/::mlir::StringAttr metadata = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value input_dataset, ::mlir::ValueRange other_arguments, ::mlir::Value num_parallel_calls, ::mlir::SymbolRefAttr f, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/bool use_inter_op_parallelism = true, /*optional*/bool sloppy = false, /*optional*/bool preserve_cardinality = false, /*optional*/::llvm::StringRef metadata = "");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input_dataset, ::mlir::ValueRange other_arguments, ::mlir::Value num_parallel_calls, ::mlir::SymbolRefAttr f, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/bool use_inter_op_parallelism = true, /*optional*/bool sloppy = false, /*optional*/bool preserve_cardinality = false, /*optional*/::llvm::StringRef metadata = "");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ParallelMapDatasetOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ParallelMapDatasetV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ParallelMapDatasetV2OpGenericAdaptorBase {
public:
  struct Properties {
    using deterministicTy = ::mlir::StringAttr;
    deterministicTy deterministic;

    auto getDeterministic() const {
      auto &propStorage = this->deterministic;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setDeterministic(const ::mlir::StringAttr &propValue) {
      this->deterministic = propValue;
    }
    using fTy = ::mlir::SymbolRefAttr;
    fTy f;

    auto getF() const {
      auto &propStorage = this->f;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setF(const ::mlir::SymbolRefAttr &propValue) {
      this->f = propValue;
    }
    using metadataTy = ::mlir::StringAttr;
    metadataTy metadata;

    auto getMetadata() const {
      auto &propStorage = this->metadata;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setMetadata(const ::mlir::StringAttr &propValue) {
      this->metadata = propValue;
    }
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    using preserve_cardinalityTy = ::mlir::BoolAttr;
    preserve_cardinalityTy preserve_cardinality;

    auto getPreserveCardinality() const {
      auto &propStorage = this->preserve_cardinality;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setPreserveCardinality(const ::mlir::BoolAttr &propValue) {
      this->preserve_cardinality = propValue;
    }
    using use_inter_op_parallelismTy = ::mlir::BoolAttr;
    use_inter_op_parallelismTy use_inter_op_parallelism;

    auto getUseInterOpParallelism() const {
      auto &propStorage = this->use_inter_op_parallelism;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setUseInterOpParallelism(const ::mlir::BoolAttr &propValue) {
      this->use_inter_op_parallelism = propValue;
    }
    using use_unbounded_threadpoolTy = ::mlir::BoolAttr;
    use_unbounded_threadpoolTy use_unbounded_threadpool;

    auto getUseUnboundedThreadpool() const {
      auto &propStorage = this->use_unbounded_threadpool;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setUseUnboundedThreadpool(const ::mlir::BoolAttr &propValue) {
      this->use_unbounded_threadpool = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.deterministic == this->deterministic &&
        rhs.f == this->f &&
        rhs.metadata == this->metadata &&
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        rhs.preserve_cardinality == this->preserve_cardinality &&
        rhs.use_inter_op_parallelism == this->use_inter_op_parallelism &&
        rhs.use_unbounded_threadpool == this->use_unbounded_threadpool &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ParallelMapDatasetV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ParallelMapDatasetV2", odsAttrs.getContext());
  }

  ParallelMapDatasetV2OpGenericAdaptorBase(ParallelMapDatasetV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getFAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().f);
    return attr;
  }

  ::mlir::SymbolRefAttr getF();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::BoolAttr getUseInterOpParallelismAttr();
  bool getUseInterOpParallelism();
  ::mlir::StringAttr getDeterministicAttr();
  ::llvm::StringRef getDeterministic();
  ::mlir::BoolAttr getPreserveCardinalityAttr();
  bool getPreserveCardinality();
  ::mlir::BoolAttr getUseUnboundedThreadpoolAttr();
  bool getUseUnboundedThreadpool();
  ::mlir::StringAttr getMetadataAttr();
  ::llvm::StringRef getMetadata();
};
} // namespace detail
template <typename RangeT>
class ParallelMapDatasetV2OpGenericAdaptor : public detail::ParallelMapDatasetV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ParallelMapDatasetV2OpGenericAdaptorBase;
public:
  ParallelMapDatasetV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ParallelMapDatasetV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ParallelMapDatasetV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ParallelMapDatasetV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ParallelMapDatasetV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ParallelMapDatasetV2OpGenericAdaptor(RangeT values, const ParallelMapDatasetV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ParallelMapDatasetV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ParallelMapDatasetV2Op>>>
  ParallelMapDatasetV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInputDataset() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOtherArguments() {
    return getODSOperands(1);
  }

  ValueT getNumParallelCalls() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ParallelMapDatasetV2OpAdaptor : public ParallelMapDatasetV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ParallelMapDatasetV2OpGenericAdaptor::ParallelMapDatasetV2OpGenericAdaptor;
  ParallelMapDatasetV2OpAdaptor(ParallelMapDatasetV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ParallelMapDatasetV2Op : public ::mlir::Op<ParallelMapDatasetV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ParallelMapDatasetV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ParallelMapDatasetV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Targuments"), ::llvm::StringRef("deterministic"), ::llvm::StringRef("f"), ::llvm::StringRef("metadata"), ::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types"), ::llvm::StringRef("preserve_cardinality"), ::llvm::StringRef("use_inter_op_parallelism"), ::llvm::StringRef("use_unbounded_threadpool")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTargumentsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTargumentsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDeterministicAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDeterministicAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getMetadataAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getMetadataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getPreserveCardinalityAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getPreserveCardinalityAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getUseInterOpParallelismAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getUseInterOpParallelismAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getUseUnboundedThreadpoolAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getUseUnboundedThreadpoolAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ParallelMapDatasetV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputDataset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getOtherArguments() {
    return getODSOperands(1);
  }

  ::mlir::TypedValue<::mlir::TensorType> getNumParallelCalls() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getInputDatasetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getOtherArgumentsMutable();
  ::mlir::OpOperand &getNumParallelCallsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getFAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().f);
  }

  ::mlir::SymbolRefAttr getF();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::BoolAttr getUseInterOpParallelismAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().use_inter_op_parallelism);
  }

  bool getUseInterOpParallelism();
  ::mlir::StringAttr getDeterministicAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().deterministic);
  }

  ::llvm::StringRef getDeterministic();
  ::mlir::BoolAttr getPreserveCardinalityAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().preserve_cardinality);
  }

  bool getPreserveCardinality();
  ::mlir::BoolAttr getUseUnboundedThreadpoolAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().use_unbounded_threadpool);
  }

  bool getUseUnboundedThreadpool();
  ::mlir::StringAttr getMetadataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().metadata);
  }

  ::llvm::StringRef getMetadata();
  mlir::OperandElementTypeRange getTarguments();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setFAttr(::mlir::SymbolRefAttr attr) {
    getProperties().f = attr;
  }

  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  void setUseInterOpParallelismAttr(::mlir::BoolAttr attr) {
    getProperties().use_inter_op_parallelism = attr;
  }

  void setUseInterOpParallelism(::std::optional<bool> attrValue);
  void setDeterministicAttr(::mlir::StringAttr attr) {
    getProperties().deterministic = attr;
  }

  void setDeterministic(::std::optional<::llvm::StringRef> attrValue);
  void setPreserveCardinalityAttr(::mlir::BoolAttr attr) {
    getProperties().preserve_cardinality = attr;
  }

  void setPreserveCardinality(::std::optional<bool> attrValue);
  void setUseUnboundedThreadpoolAttr(::mlir::BoolAttr attr) {
    getProperties().use_unbounded_threadpool = attr;
  }

  void setUseUnboundedThreadpool(::std::optional<bool> attrValue);
  void setMetadataAttr(::mlir::StringAttr attr) {
    getProperties().metadata = attr;
  }

  void setMetadata(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeUseInterOpParallelismAttr() {
      auto attr = getProperties().use_inter_op_parallelism;
      getProperties().use_inter_op_parallelism = {};
      return attr;
  }

  ::mlir::Attribute removeDeterministicAttr() {
      auto attr = getProperties().deterministic;
      getProperties().deterministic = {};
      return attr;
  }

  ::mlir::Attribute removePreserveCardinalityAttr() {
      auto attr = getProperties().preserve_cardinality;
      getProperties().preserve_cardinality = {};
      return attr;
  }

  ::mlir::Attribute removeUseUnboundedThreadpoolAttr() {
      auto attr = getProperties().use_unbounded_threadpool;
      getProperties().use_unbounded_threadpool = {};
      return attr;
  }

  ::mlir::Attribute removeMetadataAttr() {
      auto attr = getProperties().metadata;
      getProperties().metadata = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value input_dataset, ::mlir::ValueRange other_arguments, ::mlir::Value num_parallel_calls, ::mlir::SymbolRefAttr f, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::BoolAttr use_inter_op_parallelism, /*optional*/::mlir::StringAttr deterministic = nullptr, /*optional*/::mlir::BoolAttr preserve_cardinality = nullptr, /*optional*/::mlir::BoolAttr use_unbounded_threadpool = nullptr, /*optional*/::mlir::StringAttr metadata = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input_dataset, ::mlir::ValueRange other_arguments, ::mlir::Value num_parallel_calls, ::mlir::SymbolRefAttr f, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::BoolAttr use_inter_op_parallelism, /*optional*/::mlir::StringAttr deterministic = nullptr, /*optional*/::mlir::BoolAttr preserve_cardinality = nullptr, /*optional*/::mlir::BoolAttr use_unbounded_threadpool = nullptr, /*optional*/::mlir::StringAttr metadata = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value input_dataset, ::mlir::ValueRange other_arguments, ::mlir::Value num_parallel_calls, ::mlir::SymbolRefAttr f, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/bool use_inter_op_parallelism = true, /*optional*/::llvm::StringRef deterministic = "default", /*optional*/bool preserve_cardinality = false, /*optional*/bool use_unbounded_threadpool = false, /*optional*/::llvm::StringRef metadata = "");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input_dataset, ::mlir::ValueRange other_arguments, ::mlir::Value num_parallel_calls, ::mlir::SymbolRefAttr f, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/bool use_inter_op_parallelism = true, /*optional*/::llvm::StringRef deterministic = "default", /*optional*/bool preserve_cardinality = false, /*optional*/bool use_unbounded_threadpool = false, /*optional*/::llvm::StringRef metadata = "");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 9 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ParallelMapDatasetV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ParameterizedTruncatedNormalOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ParameterizedTruncatedNormalOpGenericAdaptorBase {
public:
  struct Properties {
    using seedTy = ::mlir::IntegerAttr;
    seedTy seed;

    auto getSeed() const {
      auto &propStorage = this->seed;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed(const ::mlir::IntegerAttr &propValue) {
      this->seed = propValue;
    }
    using seed2Ty = ::mlir::IntegerAttr;
    seed2Ty seed2;

    auto getSeed2() const {
      auto &propStorage = this->seed2;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed2(const ::mlir::IntegerAttr &propValue) {
      this->seed2 = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.seed == this->seed &&
        rhs.seed2 == this->seed2 &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ParameterizedTruncatedNormalOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ParameterizedTruncatedNormal", odsAttrs.getContext());
  }

  ParameterizedTruncatedNormalOpGenericAdaptorBase(ParameterizedTruncatedNormalOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSeedAttr();
  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr();
  uint64_t getSeed2();
};
} // namespace detail
template <typename RangeT>
class ParameterizedTruncatedNormalOpGenericAdaptor : public detail::ParameterizedTruncatedNormalOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ParameterizedTruncatedNormalOpGenericAdaptorBase;
public:
  ParameterizedTruncatedNormalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ParameterizedTruncatedNormalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ParameterizedTruncatedNormalOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ParameterizedTruncatedNormalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ParameterizedTruncatedNormalOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ParameterizedTruncatedNormalOpGenericAdaptor(RangeT values, const ParameterizedTruncatedNormalOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ParameterizedTruncatedNormalOp, typename = std::enable_if_t<std::is_same_v<LateInst, ParameterizedTruncatedNormalOp>>>
  ParameterizedTruncatedNormalOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getShape() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMeans() {
    return (*getODSOperands(1).begin());
  }

  ValueT getStdevs() {
    return (*getODSOperands(2).begin());
  }

  ValueT getMinvals() {
    return (*getODSOperands(3).begin());
  }

  ValueT getMaxvals() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ParameterizedTruncatedNormalOpAdaptor : public ParameterizedTruncatedNormalOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ParameterizedTruncatedNormalOpGenericAdaptor::ParameterizedTruncatedNormalOpGenericAdaptor;
  ParameterizedTruncatedNormalOpAdaptor(ParameterizedTruncatedNormalOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ParameterizedTruncatedNormalOp : public ::mlir::Op<ParameterizedTruncatedNormalOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::TF::CannotDuplicate, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ParameterizedTruncatedNormalOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ParameterizedTruncatedNormalOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("dtype"), ::llvm::StringRef("seed"), ::llvm::StringRef("seed2")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSeedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSeedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSeed2AttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSeed2AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ParameterizedTruncatedNormal");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getMeans() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getStdevs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getMinvals() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getMaxvals() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getShapeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMeansMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getStdevsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMinvalsMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMaxvalsMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSeedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed);
  }

  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed2);
  }

  uint64_t getSeed2();
  ::mlir::Type getT();
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSeedAttr(::mlir::IntegerAttr attr) {
    getProperties().seed = attr;
  }

  void setSeed(::std::optional<uint64_t> attrValue);
  void setSeed2Attr(::mlir::IntegerAttr attr) {
    getProperties().seed2 = attr;
  }

  void setSeed2(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSeedAttr() {
      auto attr = getProperties().seed;
      getProperties().seed = {};
      return attr;
  }

  ::mlir::Attribute removeSeed2Attr() {
      auto attr = getProperties().seed2;
      getProperties().seed2 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, ::mlir::Value means, ::mlir::Value stdevs, ::mlir::Value minvals, ::mlir::Value maxvals, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, ::mlir::Value means, ::mlir::Value stdevs, ::mlir::Value minvals, ::mlir::Value maxvals, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, ::mlir::Value means, ::mlir::Value stdevs, ::mlir::Value minvals, ::mlir::Value maxvals, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, ::mlir::Value means, ::mlir::Value stdevs, ::mlir::Value minvals, ::mlir::Value maxvals, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ParameterizedTruncatedNormalOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ParseExampleOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ParseExampleOpGenericAdaptorBase {
public:
  struct Properties {
    using dense_shapesTy = ::mlir::ArrayAttr;
    dense_shapesTy dense_shapes;

    auto getDenseShapes() const {
      auto &propStorage = this->dense_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setDenseShapes(const ::mlir::ArrayAttr &propValue) {
      this->dense_shapes = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    using resultSegmentSizesTy = std::array<int32_t, 4>;
    resultSegmentSizesTy resultSegmentSizes;
    ::llvm::ArrayRef<int32_t> getResultSegmentSizes() const {
      auto &propStorage = this->resultSegmentSizes;
      return propStorage;
    }
    void setResultSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->resultSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dense_shapes == this->dense_shapes &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        rhs.resultSegmentSizes == this->resultSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ParseExampleOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ParseExample", odsAttrs.getContext());
  }

  ParseExampleOpGenericAdaptorBase(ParseExampleOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getDenseShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().dense_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getDenseShapes();
};
} // namespace detail
template <typename RangeT>
class ParseExampleOpGenericAdaptor : public detail::ParseExampleOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ParseExampleOpGenericAdaptorBase;
public:
  ParseExampleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ParseExampleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ParseExampleOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ParseExampleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ParseExampleOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ParseExampleOpGenericAdaptor(RangeT values, const ParseExampleOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ParseExampleOp, typename = std::enable_if_t<std::is_same_v<LateInst, ParseExampleOp>>>
  ParseExampleOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSerialized() {
    return (*getODSOperands(0).begin());
  }

  ValueT getNames() {
    return (*getODSOperands(1).begin());
  }

  RangeT getSparseKeys() {
    return getODSOperands(2);
  }

  RangeT getDenseKeys() {
    return getODSOperands(3);
  }

  RangeT getDenseDefaults() {
    return getODSOperands(4);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ParseExampleOpAdaptor : public ParseExampleOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ParseExampleOpGenericAdaptor::ParseExampleOpGenericAdaptor;
  ParseExampleOpAdaptor(ParseExampleOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ParseExampleOp : public ::mlir::Op<ParseExampleOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedResultSegments, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ParseExampleOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ParseExampleOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Ndense"), ::llvm::StringRef("Nsparse"), ::llvm::StringRef("Tdense"), ::llvm::StringRef("dense_shapes"), ::llvm::StringRef("sparse_types"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNdenseAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNdenseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getNsparseAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getNsparseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getTdenseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getTdenseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getDenseShapesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getDenseShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getSparseTypesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getSparseTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ParseExample");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getSerialized() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getNames() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getSparseKeys() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getDenseKeys() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getDenseDefaults() {
    return getODSOperands(4);
  }

  ::mlir::OpOperand &getSerializedMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getNamesMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getSparseKeysMutable();
  ::mlir::MutableOperandRange getDenseKeysMutable();
  ::mlir::MutableOperandRange getDenseDefaultsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getSparseIndices() {
    return getODSResults(0);
  }

  ::mlir::Operation::result_range getSparseValues() {
    return getODSResults(1);
  }

  ::mlir::Operation::result_range getSparseShapes() {
    return getODSResults(2);
  }

  ::mlir::Operation::result_range getDenseValues() {
    return getODSResults(3);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getDenseShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().dense_shapes);
  }

  ::mlir::ArrayAttr getDenseShapes();
  size_t getNsparse();
  size_t getNdense();
  mlir::OperandElementTypeRange getTdense();
  mlir::ResultElementTypeRange getSparseTypes();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setDenseShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().dense_shapes = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange sparse_indices, ::mlir::TypeRange sparse_values, ::mlir::TypeRange sparse_shapes, ::mlir::TypeRange dense_values, ::mlir::Value serialized, ::mlir::Value names, ::mlir::ValueRange sparse_keys, ::mlir::ValueRange dense_keys, ::mlir::ValueRange dense_defaults, ::mlir::ArrayAttr dense_shapes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value serialized, ::mlir::Value names, ::mlir::ValueRange sparse_keys, ::mlir::ValueRange dense_keys, ::mlir::ValueRange dense_defaults, ::mlir::ArrayAttr dense_shapes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ParseExampleOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ParseExampleV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ParseExampleV2OpGenericAdaptorBase {
public:
  struct Properties {
    using dense_shapesTy = ::mlir::ArrayAttr;
    dense_shapesTy dense_shapes;

    auto getDenseShapes() const {
      auto &propStorage = this->dense_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setDenseShapes(const ::mlir::ArrayAttr &propValue) {
      this->dense_shapes = propValue;
    }
    using num_sparseTy = ::mlir::IntegerAttr;
    num_sparseTy num_sparse;

    auto getNumSparse() const {
      auto &propStorage = this->num_sparse;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setNumSparse(const ::mlir::IntegerAttr &propValue) {
      this->num_sparse = propValue;
    }
    using resultSegmentSizesTy = std::array<int32_t, 6>;
    resultSegmentSizesTy resultSegmentSizes;
    ::llvm::ArrayRef<int32_t> getResultSegmentSizes() const {
      auto &propStorage = this->resultSegmentSizes;
      return propStorage;
    }
    void setResultSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->resultSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dense_shapes == this->dense_shapes &&
        rhs.num_sparse == this->num_sparse &&
        rhs.resultSegmentSizes == this->resultSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ParseExampleV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ParseExampleV2", odsAttrs.getContext());
  }

  ParseExampleV2OpGenericAdaptorBase(ParseExampleV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getNumSparseAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().num_sparse);
    return attr;
  }

  uint64_t getNumSparse();
  ::mlir::ArrayAttr getDenseShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().dense_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getDenseShapes();
};
} // namespace detail
template <typename RangeT>
class ParseExampleV2OpGenericAdaptor : public detail::ParseExampleV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ParseExampleV2OpGenericAdaptorBase;
public:
  ParseExampleV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ParseExampleV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ParseExampleV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ParseExampleV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ParseExampleV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ParseExampleV2OpGenericAdaptor(RangeT values, const ParseExampleV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ParseExampleV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, ParseExampleV2Op>>>
  ParseExampleV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSerialized() {
    return (*getODSOperands(0).begin());
  }

  ValueT getNames() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSparseKeys() {
    return (*getODSOperands(2).begin());
  }

  ValueT getDenseKeys() {
    return (*getODSOperands(3).begin());
  }

  ValueT getRaggedKeys() {
    return (*getODSOperands(4).begin());
  }

  RangeT getDenseDefaults() {
    return getODSOperands(5);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ParseExampleV2OpAdaptor : public ParseExampleV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using ParseExampleV2OpGenericAdaptor::ParseExampleV2OpGenericAdaptor;
  ParseExampleV2OpAdaptor(ParseExampleV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ParseExampleV2Op : public ::mlir::Op<ParseExampleV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<5>::Impl, ::mlir::OpTrait::AttrSizedResultSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ParseExampleV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ParseExampleV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Tdense"), ::llvm::StringRef("dense_shapes"), ::llvm::StringRef("num_sparse"), ::llvm::StringRef("ragged_split_types"), ::llvm::StringRef("ragged_value_types"), ::llvm::StringRef("sparse_types")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTdenseAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTdenseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDenseShapesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDenseShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getNumSparseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getNumSparseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getRaggedSplitTypesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getRaggedSplitTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getRaggedValueTypesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getRaggedValueTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getSparseTypesAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getSparseTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ParseExampleV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getSerialized() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getNames() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getSparseKeys() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDenseKeys() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getRaggedKeys() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(4).begin());
  }

  ::mlir::Operation::operand_range getDenseDefaults() {
    return getODSOperands(5);
  }

  ::mlir::OpOperand &getSerializedMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getNamesMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSparseKeysMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDenseKeysMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRaggedKeysMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getDenseDefaultsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getSparseIndices() {
    return getODSResults(0);
  }

  ::mlir::Operation::result_range getSparseValues() {
    return getODSResults(1);
  }

  ::mlir::Operation::result_range getSparseShapes() {
    return getODSResults(2);
  }

  ::mlir::Operation::result_range getDenseValues() {
    return getODSResults(3);
  }

  ::mlir::Operation::result_range getRaggedValues() {
    return getODSResults(4);
  }

  ::mlir::Operation::result_range getRaggedRowSplits() {
    return getODSResults(5);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getNumSparseAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().num_sparse);
  }

  uint64_t getNumSparse();
  ::mlir::ArrayAttr getDenseShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().dense_shapes);
  }

  ::mlir::ArrayAttr getDenseShapes();
  mlir::OperandElementTypeRange getTdense();
  mlir::ResultElementTypeRange getSparseTypes();
  mlir::ResultElementTypeRange getRaggedValueTypes();
  mlir::ResultElementTypeRange getRaggedSplitTypes();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setNumSparseAttr(::mlir::IntegerAttr attr) {
    getProperties().num_sparse = attr;
  }

  void setNumSparse(uint64_t attrValue);
  void setDenseShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().dense_shapes = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange sparse_indices, ::mlir::TypeRange sparse_values, ::mlir::TypeRange sparse_shapes, ::mlir::TypeRange dense_values, ::mlir::TypeRange ragged_values, ::mlir::TypeRange ragged_row_splits, ::mlir::Value serialized, ::mlir::Value names, ::mlir::Value sparse_keys, ::mlir::Value dense_keys, ::mlir::Value ragged_keys, ::mlir::ValueRange dense_defaults, ::mlir::IntegerAttr num_sparse, ::mlir::ArrayAttr dense_shapes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value serialized, ::mlir::Value names, ::mlir::Value sparse_keys, ::mlir::Value dense_keys, ::mlir::Value ragged_keys, ::mlir::ValueRange dense_defaults, ::mlir::IntegerAttr num_sparse, ::mlir::ArrayAttr dense_shapes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange sparse_indices, ::mlir::TypeRange sparse_values, ::mlir::TypeRange sparse_shapes, ::mlir::TypeRange dense_values, ::mlir::TypeRange ragged_values, ::mlir::TypeRange ragged_row_splits, ::mlir::Value serialized, ::mlir::Value names, ::mlir::Value sparse_keys, ::mlir::Value dense_keys, ::mlir::Value ragged_keys, ::mlir::ValueRange dense_defaults, uint64_t num_sparse, ::mlir::ArrayAttr dense_shapes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value serialized, ::mlir::Value names, ::mlir::Value sparse_keys, ::mlir::Value dense_keys, ::mlir::Value ragged_keys, ::mlir::ValueRange dense_defaults, uint64_t num_sparse, ::mlir::ArrayAttr dense_shapes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ParseExampleV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PartitionedCallOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PartitionedCallOpGenericAdaptorBase {
public:
  struct Properties {
    using arg_attrsTy = ::mlir::ArrayAttr;
    arg_attrsTy arg_attrs;

    auto getArgAttrs() const {
      auto &propStorage = this->arg_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setArgAttrs(const ::mlir::ArrayAttr &propValue) {
      this->arg_attrs = propValue;
    }
    using configTy = ::mlir::StringAttr;
    configTy config;

    auto getConfig() const {
      auto &propStorage = this->config;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setConfig(const ::mlir::StringAttr &propValue) {
      this->config = propValue;
    }
    using config_protoTy = ::mlir::StringAttr;
    config_protoTy config_proto;

    auto getConfigProto() const {
      auto &propStorage = this->config_proto;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setConfigProto(const ::mlir::StringAttr &propValue) {
      this->config_proto = propValue;
    }
    using executor_typeTy = ::mlir::StringAttr;
    executor_typeTy executor_type;

    auto getExecutorType() const {
      auto &propStorage = this->executor_type;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setExecutorType(const ::mlir::StringAttr &propValue) {
      this->executor_type = propValue;
    }
    using fTy = ::mlir::SymbolRefAttr;
    fTy f;

    auto getF() const {
      auto &propStorage = this->f;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setF(const ::mlir::SymbolRefAttr &propValue) {
      this->f = propValue;
    }
    using res_attrsTy = ::mlir::ArrayAttr;
    res_attrsTy res_attrs;

    auto getResAttrs() const {
      auto &propStorage = this->res_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setResAttrs(const ::mlir::ArrayAttr &propValue) {
      this->res_attrs = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.arg_attrs == this->arg_attrs &&
        rhs.config == this->config &&
        rhs.config_proto == this->config_proto &&
        rhs.executor_type == this->executor_type &&
        rhs.f == this->f &&
        rhs.res_attrs == this->res_attrs &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PartitionedCallOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.PartitionedCall", odsAttrs.getContext());
  }

  PartitionedCallOpGenericAdaptorBase(PartitionedCallOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getArgAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::mlir::SymbolRefAttr getFAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().f);
    return attr;
  }

  ::mlir::SymbolRefAttr getF();
  ::mlir::StringAttr getConfigAttr();
  ::llvm::StringRef getConfig();
  ::mlir::StringAttr getConfigProtoAttr();
  ::llvm::StringRef getConfigProto();
  ::mlir::StringAttr getExecutorTypeAttr();
  ::llvm::StringRef getExecutorType();
};
} // namespace detail
template <typename RangeT>
class PartitionedCallOpGenericAdaptor : public detail::PartitionedCallOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PartitionedCallOpGenericAdaptorBase;
public:
  PartitionedCallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PartitionedCallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PartitionedCallOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PartitionedCallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PartitionedCallOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PartitionedCallOpGenericAdaptor(RangeT values, const PartitionedCallOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PartitionedCallOp, typename = std::enable_if_t<std::is_same_v<LateInst, PartitionedCallOp>>>
  PartitionedCallOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getArgs() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PartitionedCallOpAdaptor : public PartitionedCallOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PartitionedCallOpGenericAdaptor::PartitionedCallOpGenericAdaptor;
  PartitionedCallOpAdaptor(PartitionedCallOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PartitionedCallOp : public ::mlir::Op<PartitionedCallOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::CallOpInterface::Trait, ::mlir::SymbolUserOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PartitionedCallOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PartitionedCallOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Tin"), ::llvm::StringRef("Tout"), ::llvm::StringRef("arg_attrs"), ::llvm::StringRef("config"), ::llvm::StringRef("config_proto"), ::llvm::StringRef("executor_type"), ::llvm::StringRef("f"), ::llvm::StringRef("res_attrs")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTinAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTinAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getToutAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getToutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getArgAttrsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getArgAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getConfigAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getConfigAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getConfigProtoAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getConfigProtoAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getExecutorTypeAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getExecutorTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getFAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getFAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getResAttrsAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getResAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.PartitionedCall");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getArgs() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getArgsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getOutput() {
    return getODSResults(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getArgAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::mlir::SymbolRefAttr getFAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().f);
  }

  ::mlir::SymbolRefAttr getF();
  ::mlir::StringAttr getConfigAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().config);
  }

  ::llvm::StringRef getConfig();
  ::mlir::StringAttr getConfigProtoAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().config_proto);
  }

  ::llvm::StringRef getConfigProto();
  ::mlir::StringAttr getExecutorTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().executor_type);
  }

  ::llvm::StringRef getExecutorType();
  mlir::OperandElementTypeRange getTin();
  mlir::ResultElementTypeRange getTout();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setArgAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().arg_attrs = attr;
  }

  void setResAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().res_attrs = attr;
  }

  void setFAttr(::mlir::SymbolRefAttr attr) {
    getProperties().f = attr;
  }

  void setConfigAttr(::mlir::StringAttr attr) {
    getProperties().config = attr;
  }

  void setConfig(::std::optional<::llvm::StringRef> attrValue);
  void setConfigProtoAttr(::mlir::StringAttr attr) {
    getProperties().config_proto = attr;
  }

  void setConfigProto(::std::optional<::llvm::StringRef> attrValue);
  void setExecutorTypeAttr(::mlir::StringAttr attr) {
    getProperties().executor_type = attr;
  }

  void setExecutorType(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeArgAttrsAttr() {
      auto attr = getProperties().arg_attrs;
      getProperties().arg_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeResAttrsAttr() {
      auto attr = getProperties().res_attrs;
      getProperties().res_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeConfigAttr() {
      auto attr = getProperties().config;
      getProperties().config = {};
      return attr;
  }

  ::mlir::Attribute removeConfigProtoAttr() {
      auto attr = getProperties().config_proto;
      getProperties().config_proto = {};
      return attr;
  }

  ::mlir::Attribute removeExecutorTypeAttr() {
      auto attr = getProperties().executor_type;
      getProperties().executor_type = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange output, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::SymbolRefAttr f, /*optional*/::mlir::StringAttr config, /*optional*/::mlir::StringAttr config_proto = nullptr, /*optional*/::mlir::StringAttr executor_type = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange output, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::SymbolRefAttr f, /*optional*/::llvm::StringRef config = "", /*optional*/::llvm::StringRef config_proto = "", /*optional*/::llvm::StringRef executor_type = "");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verifySymbolUses(::mlir::SymbolTableCollection &symbolTable);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Gets the argument operands to the called function.
  operand_range getArgOperands() { return getArgs(); }
  MutableOperandRange getArgOperandsMutable() {
    return getArgsMutable();
  }

  // Returns the callee of this operation.
  CallInterfaceCallable getCallableForCallee() { return getFAttr(); }
  // Sets the callee from the callable.
  void setCalleeFromCallable(CallInterfaceCallable callee);

  // returns the callee of this operation.
  func::FuncOp func() {
    return SymbolTable::lookupNearestSymbolFrom<func::FuncOp>(*this, getF());
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PartitionedCallOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PlaceholderOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PlaceholderOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PlaceholderOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Placeholder", odsAttrs.getContext());
  }

  PlaceholderOpGenericAdaptorBase(PlaceholderOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class PlaceholderOpGenericAdaptor : public detail::PlaceholderOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PlaceholderOpGenericAdaptorBase;
public:
  PlaceholderOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PlaceholderOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PlaceholderOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PlaceholderOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PlaceholderOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PlaceholderOpGenericAdaptor(RangeT values, const PlaceholderOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PlaceholderOp, typename = std::enable_if_t<std::is_same_v<LateInst, PlaceholderOp>>>
  PlaceholderOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PlaceholderOpAdaptor : public PlaceholderOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PlaceholderOpGenericAdaptor::PlaceholderOpGenericAdaptor;
  PlaceholderOpAdaptor(PlaceholderOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PlaceholderOp : public ::mlir::Op<PlaceholderOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PlaceholderOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PlaceholderOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dtype")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Placeholder");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PlaceholderOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PlaceholderWithDefaultOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PlaceholderWithDefaultOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PlaceholderWithDefaultOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.PlaceholderWithDefault", odsAttrs.getContext());
  }

  PlaceholderWithDefaultOpGenericAdaptorBase(PlaceholderWithDefaultOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class PlaceholderWithDefaultOpGenericAdaptor : public detail::PlaceholderWithDefaultOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PlaceholderWithDefaultOpGenericAdaptorBase;
public:
  PlaceholderWithDefaultOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PlaceholderWithDefaultOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PlaceholderWithDefaultOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PlaceholderWithDefaultOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PlaceholderWithDefaultOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PlaceholderWithDefaultOpGenericAdaptor(RangeT values, const PlaceholderWithDefaultOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PlaceholderWithDefaultOp, typename = std::enable_if_t<std::is_same_v<LateInst, PlaceholderWithDefaultOp>>>
  PlaceholderWithDefaultOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PlaceholderWithDefaultOpAdaptor : public PlaceholderWithDefaultOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PlaceholderWithDefaultOpGenericAdaptor::PlaceholderWithDefaultOpGenericAdaptor;
  PlaceholderWithDefaultOpAdaptor(PlaceholderWithDefaultOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PlaceholderWithDefaultOp : public ::mlir::Op<PlaceholderWithDefaultOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PlaceholderWithDefaultOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PlaceholderWithDefaultOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dtype"), ::llvm::StringRef("shape")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getShapeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getShapeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.PlaceholderWithDefault");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getDtype();
  ShapedType getShape();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PlaceholderWithDefaultOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PolygammaOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PolygammaOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PolygammaOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Polygamma", odsAttrs.getContext());
  }

  PolygammaOpGenericAdaptorBase(PolygammaOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class PolygammaOpGenericAdaptor : public detail::PolygammaOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PolygammaOpGenericAdaptorBase;
public:
  PolygammaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PolygammaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PolygammaOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PolygammaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PolygammaOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PolygammaOpGenericAdaptor(RangeT values, const PolygammaOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PolygammaOp, typename = std::enable_if_t<std::is_same_v<LateInst, PolygammaOp>>>
  PolygammaOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getX() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PolygammaOpAdaptor : public PolygammaOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PolygammaOpGenericAdaptor::PolygammaOpGenericAdaptor;
  PolygammaOpAdaptor(PolygammaOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PolygammaOp : public ::mlir::Op<PolygammaOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ResultsBroadcastableShape, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PolygammaOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PolygammaOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Polygamma");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value x, Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type z, ::mlir::Value a, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PolygammaOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PopulationCountOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PopulationCountOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PopulationCountOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.PopulationCount", odsAttrs.getContext());
  }

  PopulationCountOpGenericAdaptorBase(PopulationCountOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class PopulationCountOpGenericAdaptor : public detail::PopulationCountOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PopulationCountOpGenericAdaptorBase;
public:
  PopulationCountOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PopulationCountOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PopulationCountOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PopulationCountOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PopulationCountOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PopulationCountOpGenericAdaptor(RangeT values, const PopulationCountOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PopulationCountOp, typename = std::enable_if_t<std::is_same_v<LateInst, PopulationCountOp>>>
  PopulationCountOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PopulationCountOpAdaptor : public PopulationCountOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PopulationCountOpGenericAdaptor::PopulationCountOpGenericAdaptor;
  PopulationCountOpAdaptor(PopulationCountOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PopulationCountOp : public ::mlir::Op<PopulationCountOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PopulationCountOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PopulationCountOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.PopulationCount");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PopulationCountOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PowOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PowOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PowOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Pow", odsAttrs.getContext());
  }

  PowOpGenericAdaptorBase(PowOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class PowOpGenericAdaptor : public detail::PowOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PowOpGenericAdaptorBase;
public:
  PowOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PowOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PowOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PowOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PowOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PowOpGenericAdaptor(RangeT values, const PowOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PowOp, typename = std::enable_if_t<std::is_same_v<LateInst, PowOp>>>
  PowOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PowOpAdaptor : public PowOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PowOpGenericAdaptor::PowOpGenericAdaptor;
  PowOpAdaptor(PowOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PowOp : public ::mlir::Op<PowOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ResultsBroadcastableShape, ::mlir::OpTrait::TF::SameOperandsAndResultElementTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PowOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PowOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Pow");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value x, Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type z, ::mlir::Value x, ::mlir::Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PowOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PrefetchDatasetOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PrefetchDatasetOpGenericAdaptorBase {
public:
  struct Properties {
    using buffer_size_minTy = ::mlir::IntegerAttr;
    buffer_size_minTy buffer_size_min;

    auto getBufferSizeMin() const {
      auto &propStorage = this->buffer_size_min;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setBufferSizeMin(const ::mlir::IntegerAttr &propValue) {
      this->buffer_size_min = propValue;
    }
    using legacy_autotuneTy = ::mlir::BoolAttr;
    legacy_autotuneTy legacy_autotune;

    auto getLegacyAutotune() const {
      auto &propStorage = this->legacy_autotune;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setLegacyAutotune(const ::mlir::BoolAttr &propValue) {
      this->legacy_autotune = propValue;
    }
    using metadataTy = ::mlir::StringAttr;
    metadataTy metadata;

    auto getMetadata() const {
      auto &propStorage = this->metadata;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setMetadata(const ::mlir::StringAttr &propValue) {
      this->metadata = propValue;
    }
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    using slack_periodTy = ::mlir::IntegerAttr;
    slack_periodTy slack_period;

    auto getSlackPeriod() const {
      auto &propStorage = this->slack_period;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSlackPeriod(const ::mlir::IntegerAttr &propValue) {
      this->slack_period = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.buffer_size_min == this->buffer_size_min &&
        rhs.legacy_autotune == this->legacy_autotune &&
        rhs.metadata == this->metadata &&
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        rhs.slack_period == this->slack_period &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PrefetchDatasetOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.PrefetchDataset", odsAttrs.getContext());
  }

  PrefetchDatasetOpGenericAdaptorBase(PrefetchDatasetOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::IntegerAttr getSlackPeriodAttr();
  uint64_t getSlackPeriod();
  ::mlir::BoolAttr getLegacyAutotuneAttr();
  bool getLegacyAutotune();
  ::mlir::IntegerAttr getBufferSizeMinAttr();
  uint64_t getBufferSizeMin();
  ::mlir::StringAttr getMetadataAttr();
  ::llvm::StringRef getMetadata();
};
} // namespace detail
template <typename RangeT>
class PrefetchDatasetOpGenericAdaptor : public detail::PrefetchDatasetOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PrefetchDatasetOpGenericAdaptorBase;
public:
  PrefetchDatasetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PrefetchDatasetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PrefetchDatasetOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PrefetchDatasetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PrefetchDatasetOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PrefetchDatasetOpGenericAdaptor(RangeT values, const PrefetchDatasetOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PrefetchDatasetOp, typename = std::enable_if_t<std::is_same_v<LateInst, PrefetchDatasetOp>>>
  PrefetchDatasetOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInputDataset() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBufferSize() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PrefetchDatasetOpAdaptor : public PrefetchDatasetOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PrefetchDatasetOpGenericAdaptor::PrefetchDatasetOpGenericAdaptor;
  PrefetchDatasetOpAdaptor(PrefetchDatasetOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PrefetchDatasetOp : public ::mlir::Op<PrefetchDatasetOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PrefetchDatasetOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PrefetchDatasetOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("buffer_size_min"), ::llvm::StringRef("legacy_autotune"), ::llvm::StringRef("metadata"), ::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types"), ::llvm::StringRef("slack_period")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBufferSizeMinAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBufferSizeMinAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getLegacyAutotuneAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getLegacyAutotuneAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getMetadataAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getMetadataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getSlackPeriodAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getSlackPeriodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.PrefetchDataset");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputDataset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getBufferSize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputDatasetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBufferSizeMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::IntegerAttr getSlackPeriodAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().slack_period);
  }

  uint64_t getSlackPeriod();
  ::mlir::BoolAttr getLegacyAutotuneAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().legacy_autotune);
  }

  bool getLegacyAutotune();
  ::mlir::IntegerAttr getBufferSizeMinAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().buffer_size_min);
  }

  uint64_t getBufferSizeMin();
  ::mlir::StringAttr getMetadataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().metadata);
  }

  ::llvm::StringRef getMetadata();
  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  void setSlackPeriodAttr(::mlir::IntegerAttr attr) {
    getProperties().slack_period = attr;
  }

  void setSlackPeriod(::std::optional<uint64_t> attrValue);
  void setLegacyAutotuneAttr(::mlir::BoolAttr attr) {
    getProperties().legacy_autotune = attr;
  }

  void setLegacyAutotune(::std::optional<bool> attrValue);
  void setBufferSizeMinAttr(::mlir::IntegerAttr attr) {
    getProperties().buffer_size_min = attr;
  }

  void setBufferSizeMin(::std::optional<uint64_t> attrValue);
  void setMetadataAttr(::mlir::StringAttr attr) {
    getProperties().metadata = attr;
  }

  void setMetadata(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeSlackPeriodAttr() {
      auto attr = getProperties().slack_period;
      getProperties().slack_period = {};
      return attr;
  }

  ::mlir::Attribute removeLegacyAutotuneAttr() {
      auto attr = getProperties().legacy_autotune;
      getProperties().legacy_autotune = {};
      return attr;
  }

  ::mlir::Attribute removeBufferSizeMinAttr() {
      auto attr = getProperties().buffer_size_min;
      getProperties().buffer_size_min = {};
      return attr;
  }

  ::mlir::Attribute removeMetadataAttr() {
      auto attr = getProperties().metadata;
      getProperties().metadata = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value input_dataset, ::mlir::Value buffer_size, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::IntegerAttr slack_period, /*optional*/::mlir::BoolAttr legacy_autotune = nullptr, /*optional*/::mlir::IntegerAttr buffer_size_min = nullptr, /*optional*/::mlir::StringAttr metadata = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input_dataset, ::mlir::Value buffer_size, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::IntegerAttr slack_period, /*optional*/::mlir::BoolAttr legacy_autotune = nullptr, /*optional*/::mlir::IntegerAttr buffer_size_min = nullptr, /*optional*/::mlir::StringAttr metadata = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value input_dataset, ::mlir::Value buffer_size, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/uint64_t slack_period = 0, /*optional*/bool legacy_autotune = true, /*optional*/uint64_t buffer_size_min = 0, /*optional*/::llvm::StringRef metadata = "");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input_dataset, ::mlir::Value buffer_size, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/uint64_t slack_period = 0, /*optional*/bool legacy_autotune = true, /*optional*/uint64_t buffer_size_min = 0, /*optional*/::llvm::StringRef metadata = "");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PrefetchDatasetOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PreventGradientOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PreventGradientOpGenericAdaptorBase {
public:
  struct Properties {
    using messageTy = ::mlir::StringAttr;
    messageTy message;

    auto getMessage() const {
      auto &propStorage = this->message;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setMessage(const ::mlir::StringAttr &propValue) {
      this->message = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.message == this->message &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PreventGradientOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.PreventGradient", odsAttrs.getContext());
  }

  PreventGradientOpGenericAdaptorBase(PreventGradientOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getMessageAttr();
  ::llvm::StringRef getMessage();
};
} // namespace detail
template <typename RangeT>
class PreventGradientOpGenericAdaptor : public detail::PreventGradientOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PreventGradientOpGenericAdaptorBase;
public:
  PreventGradientOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PreventGradientOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PreventGradientOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PreventGradientOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PreventGradientOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PreventGradientOpGenericAdaptor(RangeT values, const PreventGradientOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PreventGradientOp, typename = std::enable_if_t<std::is_same_v<LateInst, PreventGradientOp>>>
  PreventGradientOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PreventGradientOpAdaptor : public PreventGradientOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PreventGradientOpGenericAdaptor::PreventGradientOpGenericAdaptor;
  PreventGradientOpAdaptor(PreventGradientOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PreventGradientOp : public ::mlir::Op<PreventGradientOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PreventGradientOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PreventGradientOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("message")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getMessageAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getMessageAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.PreventGradient");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getMessageAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().message);
  }

  ::llvm::StringRef getMessage();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setMessageAttr(::mlir::StringAttr attr) {
    getProperties().message = attr;
  }

  void setMessage(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeMessageAttr() {
      auto attr = getProperties().message;
      getProperties().message = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, /*optional*/::mlir::StringAttr message);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, /*optional*/::mlir::StringAttr message);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, /*optional*/::mlir::StringAttr message);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, /*optional*/::llvm::StringRef message = "");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, /*optional*/::llvm::StringRef message = "");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, /*optional*/::llvm::StringRef message = "");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PreventGradientOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PrintOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PrintOpGenericAdaptorBase {
public:
  struct Properties {
    using first_nTy = ::mlir::IntegerAttr;
    first_nTy first_n;

    auto getFirstN() const {
      auto &propStorage = this->first_n;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setFirstN(const ::mlir::IntegerAttr &propValue) {
      this->first_n = propValue;
    }
    using messageTy = ::mlir::StringAttr;
    messageTy message;

    auto getMessage() const {
      auto &propStorage = this->message;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setMessage(const ::mlir::StringAttr &propValue) {
      this->message = propValue;
    }
    using summarizeTy = ::mlir::IntegerAttr;
    summarizeTy summarize;

    auto getSummarize() const {
      auto &propStorage = this->summarize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSummarize(const ::mlir::IntegerAttr &propValue) {
      this->summarize = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.first_n == this->first_n &&
        rhs.message == this->message &&
        rhs.summarize == this->summarize &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PrintOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Print", odsAttrs.getContext());
  }

  PrintOpGenericAdaptorBase(PrintOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getMessageAttr();
  ::llvm::StringRef getMessage();
  ::mlir::IntegerAttr getFirstNAttr();
  uint64_t getFirstN();
  ::mlir::IntegerAttr getSummarizeAttr();
  uint64_t getSummarize();
};
} // namespace detail
template <typename RangeT>
class PrintOpGenericAdaptor : public detail::PrintOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PrintOpGenericAdaptorBase;
public:
  PrintOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PrintOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PrintOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PrintOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PrintOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PrintOpGenericAdaptor(RangeT values, const PrintOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PrintOp, typename = std::enable_if_t<std::is_same_v<LateInst, PrintOp>>>
  PrintOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getData() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PrintOpAdaptor : public PrintOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PrintOpGenericAdaptor::PrintOpGenericAdaptor;
  PrintOpAdaptor(PrintOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PrintOp : public ::mlir::Op<PrintOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PrintOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PrintOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("U"), ::llvm::StringRef("first_n"), ::llvm::StringRef("message"), ::llvm::StringRef("summarize")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getUAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getUAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFirstNAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFirstNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getMessageAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getMessageAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getSummarizeAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getSummarizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Print");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getData() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getDataMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getMessageAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().message);
  }

  ::llvm::StringRef getMessage();
  ::mlir::IntegerAttr getFirstNAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().first_n);
  }

  uint64_t getFirstN();
  ::mlir::IntegerAttr getSummarizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().summarize);
  }

  uint64_t getSummarize();
  ::mlir::Type getT();
  mlir::OperandElementTypeRange getU();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setMessageAttr(::mlir::StringAttr attr) {
    getProperties().message = attr;
  }

  void setMessage(::std::optional<::llvm::StringRef> attrValue);
  void setFirstNAttr(::mlir::IntegerAttr attr) {
    getProperties().first_n = attr;
  }

  void setFirstN(::std::optional<uint64_t> attrValue);
  void setSummarizeAttr(::mlir::IntegerAttr attr) {
    getProperties().summarize = attr;
  }

  void setSummarize(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeMessageAttr() {
      auto attr = getProperties().message;
      getProperties().message = {};
      return attr;
  }

  ::mlir::Attribute removeFirstNAttr() {
      auto attr = getProperties().first_n;
      getProperties().first_n = {};
      return attr;
  }

  ::mlir::Attribute removeSummarizeAttr() {
      auto attr = getProperties().summarize;
      getProperties().summarize = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::ValueRange data, /*optional*/::mlir::StringAttr message, /*optional*/::mlir::IntegerAttr first_n = nullptr, /*optional*/::mlir::IntegerAttr summarize = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::ValueRange data, /*optional*/::mlir::StringAttr message, /*optional*/::mlir::IntegerAttr first_n = nullptr, /*optional*/::mlir::IntegerAttr summarize = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::ValueRange data, /*optional*/::llvm::StringRef message = "", /*optional*/uint64_t first_n = -1, /*optional*/uint64_t summarize = 3);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::ValueRange data, /*optional*/::llvm::StringRef message = "", /*optional*/uint64_t first_n = -1, /*optional*/uint64_t summarize = 3);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PrintOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::PrintV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PrintV2OpGenericAdaptorBase {
public:
  struct Properties {
    using endTy = ::mlir::StringAttr;
    endTy end;

    auto getEnd() const {
      auto &propStorage = this->end;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setEnd(const ::mlir::StringAttr &propValue) {
      this->end = propValue;
    }
    using output_streamTy = ::mlir::StringAttr;
    output_streamTy output_stream;

    auto getOutputStream() const {
      auto &propStorage = this->output_stream;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setOutputStream(const ::mlir::StringAttr &propValue) {
      this->output_stream = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.end == this->end &&
        rhs.output_stream == this->output_stream &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PrintV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.PrintV2", odsAttrs.getContext());
  }

  PrintV2OpGenericAdaptorBase(PrintV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getOutputStreamAttr();
  ::llvm::StringRef getOutputStream();
  ::mlir::StringAttr getEndAttr();
  ::llvm::StringRef getEnd();
};
} // namespace detail
template <typename RangeT>
class PrintV2OpGenericAdaptor : public detail::PrintV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PrintV2OpGenericAdaptorBase;
public:
  PrintV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PrintV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PrintV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PrintV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PrintV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PrintV2OpGenericAdaptor(RangeT values, const PrintV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PrintV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, PrintV2Op>>>
  PrintV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PrintV2OpAdaptor : public PrintV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using PrintV2OpGenericAdaptor::PrintV2OpGenericAdaptor;
  PrintV2OpAdaptor(PrintV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PrintV2Op : public ::mlir::Op<PrintV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PrintV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PrintV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("end"), ::llvm::StringRef("output_stream")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getEndAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getEndAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutputStreamAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutputStreamAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.PrintV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getOutputStreamAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().output_stream);
  }

  ::llvm::StringRef getOutputStream();
  ::mlir::StringAttr getEndAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().end);
  }

  ::llvm::StringRef getEnd();
  void setOutputStreamAttr(::mlir::StringAttr attr) {
    getProperties().output_stream = attr;
  }

  void setOutputStream(::std::optional<::llvm::StringRef> attrValue);
  void setEndAttr(::mlir::StringAttr attr) {
    getProperties().end = attr;
  }

  void setEnd(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeOutputStreamAttr() {
      auto attr = getProperties().output_stream;
      getProperties().output_stream = {};
      return attr;
  }

  ::mlir::Attribute removeEndAttr() {
      auto attr = getProperties().end;
      getProperties().end = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, /*optional*/::mlir::StringAttr output_stream, /*optional*/::mlir::StringAttr end = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, /*optional*/::mlir::StringAttr output_stream, /*optional*/::mlir::StringAttr end = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, /*optional*/::llvm::StringRef output_stream = "stderr", /*optional*/::llvm::StringRef end = "\n");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, /*optional*/::llvm::StringRef output_stream = "stderr", /*optional*/::llvm::StringRef end = "\n");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::PrintV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ProdOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ProdOpGenericAdaptorBase {
public:
  struct Properties {
    using keep_dimsTy = ::mlir::BoolAttr;
    keep_dimsTy keep_dims;

    auto getKeepDims() const {
      auto &propStorage = this->keep_dims;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setKeepDims(const ::mlir::BoolAttr &propValue) {
      this->keep_dims = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.keep_dims == this->keep_dims &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ProdOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Prod", odsAttrs.getContext());
  }

  ProdOpGenericAdaptorBase(ProdOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getKeepDimsAttr();
  bool getKeepDims();
};
} // namespace detail
template <typename RangeT>
class ProdOpGenericAdaptor : public detail::ProdOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ProdOpGenericAdaptorBase;
public:
  ProdOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ProdOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ProdOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ProdOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ProdOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ProdOpGenericAdaptor(RangeT values, const ProdOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ProdOp, typename = std::enable_if_t<std::is_same_v<LateInst, ProdOp>>>
  ProdOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getReductionIndices() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ProdOpAdaptor : public ProdOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ProdOpGenericAdaptor::ProdOpGenericAdaptor;
  ProdOpAdaptor(ProdOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ProdOp : public ::mlir::Op<ProdOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ProdOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ProdOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tidx"), ::llvm::StringRef("keep_dims")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTidxAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTidxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getKeepDimsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getKeepDimsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Prod");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getReductionIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getReductionIndicesMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getKeepDimsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().keep_dims);
  }

  bool getKeepDims();
  ::mlir::Type getT();
  ::mlir::Type getTidx();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setKeepDimsAttr(::mlir::BoolAttr attr) {
    getProperties().keep_dims = attr;
  }

  void setKeepDims(::std::optional<bool> attrValue);
  ::mlir::Attribute removeKeepDimsAttr() {
      auto attr = getProperties().keep_dims;
      getProperties().keep_dims = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/::mlir::BoolAttr keep_dims);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/::mlir::BoolAttr keep_dims);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/bool keep_dims = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/bool keep_dims = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ProdOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::QrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class QrOpGenericAdaptorBase {
public:
  struct Properties {
    using full_matricesTy = ::mlir::BoolAttr;
    full_matricesTy full_matrices;

    auto getFullMatrices() const {
      auto &propStorage = this->full_matrices;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setFullMatrices(const ::mlir::BoolAttr &propValue) {
      this->full_matrices = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.full_matrices == this->full_matrices &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  QrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Qr", odsAttrs.getContext());
  }

  QrOpGenericAdaptorBase(QrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getFullMatricesAttr();
  bool getFullMatrices();
};
} // namespace detail
template <typename RangeT>
class QrOpGenericAdaptor : public detail::QrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::QrOpGenericAdaptorBase;
public:
  QrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  QrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : QrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  QrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : QrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  QrOpGenericAdaptor(RangeT values, const QrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = QrOp, typename = std::enable_if_t<std::is_same_v<LateInst, QrOp>>>
  QrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class QrOpAdaptor : public QrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using QrOpGenericAdaptor::QrOpGenericAdaptor;
  QrOpAdaptor(QrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class QrOp : public ::mlir::Op<QrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = QrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = QrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("full_matrices")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFullMatricesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFullMatricesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Qr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getQ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getR() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getFullMatricesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().full_matrices);
  }

  bool getFullMatrices();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setFullMatricesAttr(::mlir::BoolAttr attr) {
    getProperties().full_matrices = attr;
  }

  void setFullMatrices(::std::optional<bool> attrValue);
  ::mlir::Attribute removeFullMatricesAttr() {
      auto attr = getProperties().full_matrices;
      getProperties().full_matrices = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type q, ::mlir::Type r, ::mlir::Value input, /*optional*/::mlir::BoolAttr full_matrices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, /*optional*/::mlir::BoolAttr full_matrices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type q, ::mlir::Type r, ::mlir::Value input, /*optional*/bool full_matrices = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, /*optional*/bool full_matrices = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::QrOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::QuantizeAndDequantizeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class QuantizeAndDequantizeOpGenericAdaptorBase {
public:
  struct Properties {
    using input_maxTy = ::mlir::FloatAttr;
    input_maxTy input_max;

    auto getInputMax() const {
      auto &propStorage = this->input_max;
      return ::llvm::dyn_cast_or_null<::mlir::FloatAttr>(propStorage);
    }
    void setInputMax(const ::mlir::FloatAttr &propValue) {
      this->input_max = propValue;
    }
    using input_minTy = ::mlir::FloatAttr;
    input_minTy input_min;

    auto getInputMin() const {
      auto &propStorage = this->input_min;
      return ::llvm::dyn_cast_or_null<::mlir::FloatAttr>(propStorage);
    }
    void setInputMin(const ::mlir::FloatAttr &propValue) {
      this->input_min = propValue;
    }
    using num_bitsTy = ::mlir::IntegerAttr;
    num_bitsTy num_bits;

    auto getNumBits() const {
      auto &propStorage = this->num_bits;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setNumBits(const ::mlir::IntegerAttr &propValue) {
      this->num_bits = propValue;
    }
    using range_givenTy = ::mlir::BoolAttr;
    range_givenTy range_given;

    auto getRangeGiven() const {
      auto &propStorage = this->range_given;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRangeGiven(const ::mlir::BoolAttr &propValue) {
      this->range_given = propValue;
    }
    using signed_inputTy = ::mlir::BoolAttr;
    signed_inputTy signed_input;

    auto getSignedInput() const {
      auto &propStorage = this->signed_input;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setSignedInput(const ::mlir::BoolAttr &propValue) {
      this->signed_input = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.input_max == this->input_max &&
        rhs.input_min == this->input_min &&
        rhs.num_bits == this->num_bits &&
        rhs.range_given == this->range_given &&
        rhs.signed_input == this->signed_input &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  QuantizeAndDequantizeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.QuantizeAndDequantize", odsAttrs.getContext());
  }

  QuantizeAndDequantizeOpGenericAdaptorBase(QuantizeAndDequantizeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getSignedInputAttr();
  bool getSignedInput();
  ::mlir::IntegerAttr getNumBitsAttr();
  uint64_t getNumBits();
  ::mlir::BoolAttr getRangeGivenAttr();
  bool getRangeGiven();
  ::mlir::FloatAttr getInputMinAttr();
  ::llvm::APFloat getInputMin();
  ::mlir::FloatAttr getInputMaxAttr();
  ::llvm::APFloat getInputMax();
};
} // namespace detail
template <typename RangeT>
class QuantizeAndDequantizeOpGenericAdaptor : public detail::QuantizeAndDequantizeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::QuantizeAndDequantizeOpGenericAdaptorBase;
public:
  QuantizeAndDequantizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  QuantizeAndDequantizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : QuantizeAndDequantizeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  QuantizeAndDequantizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : QuantizeAndDequantizeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  QuantizeAndDequantizeOpGenericAdaptor(RangeT values, const QuantizeAndDequantizeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = QuantizeAndDequantizeOp, typename = std::enable_if_t<std::is_same_v<LateInst, QuantizeAndDequantizeOp>>>
  QuantizeAndDequantizeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class QuantizeAndDequantizeOpAdaptor : public QuantizeAndDequantizeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using QuantizeAndDequantizeOpGenericAdaptor::QuantizeAndDequantizeOpGenericAdaptor;
  QuantizeAndDequantizeOpAdaptor(QuantizeAndDequantizeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class QuantizeAndDequantizeOp : public ::mlir::Op<QuantizeAndDequantizeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = QuantizeAndDequantizeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = QuantizeAndDequantizeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("input_max"), ::llvm::StringRef("input_min"), ::llvm::StringRef("num_bits"), ::llvm::StringRef("range_given"), ::llvm::StringRef("signed_input")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getInputMaxAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getInputMaxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getInputMinAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getInputMinAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getNumBitsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getNumBitsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getRangeGivenAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getRangeGivenAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getSignedInputAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getSignedInputAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.QuantizeAndDequantize");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getSignedInputAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().signed_input);
  }

  bool getSignedInput();
  ::mlir::IntegerAttr getNumBitsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().num_bits);
  }

  uint64_t getNumBits();
  ::mlir::BoolAttr getRangeGivenAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().range_given);
  }

  bool getRangeGiven();
  ::mlir::FloatAttr getInputMinAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::FloatAttr>(getProperties().input_min);
  }

  ::llvm::APFloat getInputMin();
  ::mlir::FloatAttr getInputMaxAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::FloatAttr>(getProperties().input_max);
  }

  ::llvm::APFloat getInputMax();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSignedInputAttr(::mlir::BoolAttr attr) {
    getProperties().signed_input = attr;
  }

  void setSignedInput(::std::optional<bool> attrValue);
  void setNumBitsAttr(::mlir::IntegerAttr attr) {
    getProperties().num_bits = attr;
  }

  void setNumBits(::std::optional<uint64_t> attrValue);
  void setRangeGivenAttr(::mlir::BoolAttr attr) {
    getProperties().range_given = attr;
  }

  void setRangeGiven(::std::optional<bool> attrValue);
  void setInputMinAttr(::mlir::FloatAttr attr) {
    getProperties().input_min = attr;
  }

  void setInputMin(::std::optional<::llvm::APFloat> attrValue);
  void setInputMaxAttr(::mlir::FloatAttr attr) {
    getProperties().input_max = attr;
  }

  void setInputMax(::std::optional<::llvm::APFloat> attrValue);
  ::mlir::Attribute removeSignedInputAttr() {
      auto attr = getProperties().signed_input;
      getProperties().signed_input = {};
      return attr;
  }

  ::mlir::Attribute removeNumBitsAttr() {
      auto attr = getProperties().num_bits;
      getProperties().num_bits = {};
      return attr;
  }

  ::mlir::Attribute removeRangeGivenAttr() {
      auto attr = getProperties().range_given;
      getProperties().range_given = {};
      return attr;
  }

  ::mlir::Attribute removeInputMinAttr() {
      auto attr = getProperties().input_min;
      getProperties().input_min = {};
      return attr;
  }

  ::mlir::Attribute removeInputMaxAttr() {
      auto attr = getProperties().input_max;
      getProperties().input_max = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, /*optional*/::mlir::BoolAttr signed_input, /*optional*/::mlir::IntegerAttr num_bits, /*optional*/::mlir::BoolAttr range_given, /*optional*/::mlir::FloatAttr input_min, /*optional*/::mlir::FloatAttr input_max);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, /*optional*/::mlir::BoolAttr signed_input, /*optional*/::mlir::IntegerAttr num_bits, /*optional*/::mlir::BoolAttr range_given, /*optional*/::mlir::FloatAttr input_min, /*optional*/::mlir::FloatAttr input_max);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, /*optional*/::mlir::BoolAttr signed_input, /*optional*/::mlir::IntegerAttr num_bits, /*optional*/::mlir::BoolAttr range_given, /*optional*/::mlir::FloatAttr input_min, /*optional*/::mlir::FloatAttr input_max);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, /*optional*/bool signed_input, /*optional*/uint64_t num_bits, /*optional*/bool range_given, /*optional*/::llvm::APFloat input_min, /*optional*/::llvm::APFloat input_max);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, /*optional*/bool signed_input, /*optional*/uint64_t num_bits, /*optional*/bool range_given, /*optional*/::llvm::APFloat input_min, /*optional*/::llvm::APFloat input_max);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, /*optional*/bool signed_input, /*optional*/uint64_t num_bits, /*optional*/bool range_given, /*optional*/::llvm::APFloat input_min, /*optional*/::llvm::APFloat input_max);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::QuantizeAndDequantizeOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::QuantizeAndDequantizeV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class QuantizeAndDequantizeV2OpGenericAdaptorBase {
public:
  struct Properties {
    using axisTy = ::mlir::IntegerAttr;
    axisTy axis;

    auto getAxis() const {
      auto &propStorage = this->axis;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAxis(const ::mlir::IntegerAttr &propValue) {
      this->axis = propValue;
    }
    using narrow_rangeTy = ::mlir::BoolAttr;
    narrow_rangeTy narrow_range;

    auto getNarrowRange() const {
      auto &propStorage = this->narrow_range;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setNarrowRange(const ::mlir::BoolAttr &propValue) {
      this->narrow_range = propValue;
    }
    using num_bitsTy = ::mlir::IntegerAttr;
    num_bitsTy num_bits;

    auto getNumBits() const {
      auto &propStorage = this->num_bits;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setNumBits(const ::mlir::IntegerAttr &propValue) {
      this->num_bits = propValue;
    }
    using range_givenTy = ::mlir::BoolAttr;
    range_givenTy range_given;

    auto getRangeGiven() const {
      auto &propStorage = this->range_given;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRangeGiven(const ::mlir::BoolAttr &propValue) {
      this->range_given = propValue;
    }
    using round_modeTy = ::mlir::StringAttr;
    round_modeTy round_mode;

    auto getRoundMode() const {
      auto &propStorage = this->round_mode;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setRoundMode(const ::mlir::StringAttr &propValue) {
      this->round_mode = propValue;
    }
    using signed_inputTy = ::mlir::BoolAttr;
    signed_inputTy signed_input;

    auto getSignedInput() const {
      auto &propStorage = this->signed_input;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setSignedInput(const ::mlir::BoolAttr &propValue) {
      this->signed_input = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.axis == this->axis &&
        rhs.narrow_range == this->narrow_range &&
        rhs.num_bits == this->num_bits &&
        rhs.range_given == this->range_given &&
        rhs.round_mode == this->round_mode &&
        rhs.signed_input == this->signed_input &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  QuantizeAndDequantizeV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.QuantizeAndDequantizeV2", odsAttrs.getContext());
  }

  QuantizeAndDequantizeV2OpGenericAdaptorBase(QuantizeAndDequantizeV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getSignedInputAttr();
  bool getSignedInput();
  ::mlir::IntegerAttr getNumBitsAttr();
  uint64_t getNumBits();
  ::mlir::BoolAttr getRangeGivenAttr();
  bool getRangeGiven();
  ::mlir::StringAttr getRoundModeAttr();
  ::llvm::StringRef getRoundMode();
  ::mlir::BoolAttr getNarrowRangeAttr();
  bool getNarrowRange();
  ::mlir::IntegerAttr getAxisAttr();
  uint64_t getAxis();
};
} // namespace detail
template <typename RangeT>
class QuantizeAndDequantizeV2OpGenericAdaptor : public detail::QuantizeAndDequantizeV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::QuantizeAndDequantizeV2OpGenericAdaptorBase;
public:
  QuantizeAndDequantizeV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  QuantizeAndDequantizeV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : QuantizeAndDequantizeV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  QuantizeAndDequantizeV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : QuantizeAndDequantizeV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  QuantizeAndDequantizeV2OpGenericAdaptor(RangeT values, const QuantizeAndDequantizeV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = QuantizeAndDequantizeV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, QuantizeAndDequantizeV2Op>>>
  QuantizeAndDequantizeV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getInputMin() {
    return (*getODSOperands(1).begin());
  }

  ValueT getInputMax() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class QuantizeAndDequantizeV2OpAdaptor : public QuantizeAndDequantizeV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using QuantizeAndDequantizeV2OpGenericAdaptor::QuantizeAndDequantizeV2OpGenericAdaptor;
  QuantizeAndDequantizeV2OpAdaptor(QuantizeAndDequantizeV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class QuantizeAndDequantizeV2Op : public ::mlir::Op<QuantizeAndDequantizeV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = QuantizeAndDequantizeV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = QuantizeAndDequantizeV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("axis"), ::llvm::StringRef("narrow_range"), ::llvm::StringRef("num_bits"), ::llvm::StringRef("range_given"), ::llvm::StringRef("round_mode"), ::llvm::StringRef("signed_input")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAxisAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAxisAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getNarrowRangeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getNarrowRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getNumBitsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getNumBitsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getRangeGivenAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getRangeGivenAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getRoundModeAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getRoundModeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getSignedInputAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getSignedInputAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.QuantizeAndDequantizeV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputMin() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputMax() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInputMinMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInputMaxMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getSignedInputAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().signed_input);
  }

  bool getSignedInput();
  ::mlir::IntegerAttr getNumBitsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().num_bits);
  }

  uint64_t getNumBits();
  ::mlir::BoolAttr getRangeGivenAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().range_given);
  }

  bool getRangeGiven();
  ::mlir::StringAttr getRoundModeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().round_mode);
  }

  ::llvm::StringRef getRoundMode();
  ::mlir::BoolAttr getNarrowRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().narrow_range);
  }

  bool getNarrowRange();
  ::mlir::IntegerAttr getAxisAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().axis);
  }

  uint64_t getAxis();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSignedInputAttr(::mlir::BoolAttr attr) {
    getProperties().signed_input = attr;
  }

  void setSignedInput(::std::optional<bool> attrValue);
  void setNumBitsAttr(::mlir::IntegerAttr attr) {
    getProperties().num_bits = attr;
  }

  void setNumBits(::std::optional<uint64_t> attrValue);
  void setRangeGivenAttr(::mlir::BoolAttr attr) {
    getProperties().range_given = attr;
  }

  void setRangeGiven(::std::optional<bool> attrValue);
  void setRoundModeAttr(::mlir::StringAttr attr) {
    getProperties().round_mode = attr;
  }

  void setRoundMode(::std::optional<::llvm::StringRef> attrValue);
  void setNarrowRangeAttr(::mlir::BoolAttr attr) {
    getProperties().narrow_range = attr;
  }

  void setNarrowRange(::std::optional<bool> attrValue);
  void setAxisAttr(::mlir::IntegerAttr attr) {
    getProperties().axis = attr;
  }

  void setAxis(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSignedInputAttr() {
      auto attr = getProperties().signed_input;
      getProperties().signed_input = {};
      return attr;
  }

  ::mlir::Attribute removeNumBitsAttr() {
      auto attr = getProperties().num_bits;
      getProperties().num_bits = {};
      return attr;
  }

  ::mlir::Attribute removeRangeGivenAttr() {
      auto attr = getProperties().range_given;
      getProperties().range_given = {};
      return attr;
  }

  ::mlir::Attribute removeRoundModeAttr() {
      auto attr = getProperties().round_mode;
      getProperties().round_mode = {};
      return attr;
  }

  ::mlir::Attribute removeNarrowRangeAttr() {
      auto attr = getProperties().narrow_range;
      getProperties().narrow_range = {};
      return attr;
  }

  ::mlir::Attribute removeAxisAttr() {
      auto attr = getProperties().axis;
      getProperties().axis = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, /*optional*/::mlir::BoolAttr signed_input, /*optional*/::mlir::IntegerAttr num_bits = nullptr, /*optional*/::mlir::BoolAttr range_given = nullptr, /*optional*/::mlir::StringAttr round_mode = nullptr, /*optional*/::mlir::BoolAttr narrow_range = nullptr, /*optional*/::mlir::IntegerAttr axis = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, /*optional*/::mlir::BoolAttr signed_input, /*optional*/::mlir::IntegerAttr num_bits = nullptr, /*optional*/::mlir::BoolAttr range_given = nullptr, /*optional*/::mlir::StringAttr round_mode = nullptr, /*optional*/::mlir::BoolAttr narrow_range = nullptr, /*optional*/::mlir::IntegerAttr axis = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, /*optional*/bool signed_input = true, /*optional*/uint64_t num_bits = 8, /*optional*/bool range_given = false, /*optional*/::llvm::StringRef round_mode = "HALF_TO_EVEN", /*optional*/bool narrow_range = false, /*optional*/uint64_t axis = -1);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, /*optional*/bool signed_input = true, /*optional*/uint64_t num_bits = 8, /*optional*/bool range_given = false, /*optional*/::llvm::StringRef round_mode = "HALF_TO_EVEN", /*optional*/bool narrow_range = false, /*optional*/uint64_t axis = -1);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::QuantizeAndDequantizeV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::QuantizeAndDequantizeV3Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class QuantizeAndDequantizeV3OpGenericAdaptorBase {
public:
  struct Properties {
    using axisTy = ::mlir::IntegerAttr;
    axisTy axis;

    auto getAxis() const {
      auto &propStorage = this->axis;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAxis(const ::mlir::IntegerAttr &propValue) {
      this->axis = propValue;
    }
    using narrow_rangeTy = ::mlir::BoolAttr;
    narrow_rangeTy narrow_range;

    auto getNarrowRange() const {
      auto &propStorage = this->narrow_range;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setNarrowRange(const ::mlir::BoolAttr &propValue) {
      this->narrow_range = propValue;
    }
    using range_givenTy = ::mlir::BoolAttr;
    range_givenTy range_given;

    auto getRangeGiven() const {
      auto &propStorage = this->range_given;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRangeGiven(const ::mlir::BoolAttr &propValue) {
      this->range_given = propValue;
    }
    using signed_inputTy = ::mlir::BoolAttr;
    signed_inputTy signed_input;

    auto getSignedInput() const {
      auto &propStorage = this->signed_input;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setSignedInput(const ::mlir::BoolAttr &propValue) {
      this->signed_input = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.axis == this->axis &&
        rhs.narrow_range == this->narrow_range &&
        rhs.range_given == this->range_given &&
        rhs.signed_input == this->signed_input &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  QuantizeAndDequantizeV3OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.QuantizeAndDequantizeV3", odsAttrs.getContext());
  }

  QuantizeAndDequantizeV3OpGenericAdaptorBase(QuantizeAndDequantizeV3Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getSignedInputAttr();
  bool getSignedInput();
  ::mlir::BoolAttr getRangeGivenAttr();
  bool getRangeGiven();
  ::mlir::BoolAttr getNarrowRangeAttr();
  bool getNarrowRange();
  ::mlir::IntegerAttr getAxisAttr();
  uint64_t getAxis();
};
} // namespace detail
template <typename RangeT>
class QuantizeAndDequantizeV3OpGenericAdaptor : public detail::QuantizeAndDequantizeV3OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::QuantizeAndDequantizeV3OpGenericAdaptorBase;
public:
  QuantizeAndDequantizeV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  QuantizeAndDequantizeV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : QuantizeAndDequantizeV3OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  QuantizeAndDequantizeV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : QuantizeAndDequantizeV3OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  QuantizeAndDequantizeV3OpGenericAdaptor(RangeT values, const QuantizeAndDequantizeV3OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = QuantizeAndDequantizeV3Op, typename = std::enable_if_t<std::is_same_v<LateInst, QuantizeAndDequantizeV3Op>>>
  QuantizeAndDequantizeV3OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getInputMin() {
    return (*getODSOperands(1).begin());
  }

  ValueT getInputMax() {
    return (*getODSOperands(2).begin());
  }

  ValueT getNumBits() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class QuantizeAndDequantizeV3OpAdaptor : public QuantizeAndDequantizeV3OpGenericAdaptor<::mlir::ValueRange> {
public:
  using QuantizeAndDequantizeV3OpGenericAdaptor::QuantizeAndDequantizeV3OpGenericAdaptor;
  QuantizeAndDequantizeV3OpAdaptor(QuantizeAndDequantizeV3Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class QuantizeAndDequantizeV3Op : public ::mlir::Op<QuantizeAndDequantizeV3Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = QuantizeAndDequantizeV3OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = QuantizeAndDequantizeV3OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("axis"), ::llvm::StringRef("narrow_range"), ::llvm::StringRef("range_given"), ::llvm::StringRef("signed_input")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAxisAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAxisAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getNarrowRangeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getNarrowRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getRangeGivenAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getRangeGivenAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getSignedInputAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getSignedInputAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.QuantizeAndDequantizeV3");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputMin() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputMax() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getNumBits() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInputMinMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInputMaxMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getNumBitsMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getSignedInputAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().signed_input);
  }

  bool getSignedInput();
  ::mlir::BoolAttr getRangeGivenAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().range_given);
  }

  bool getRangeGiven();
  ::mlir::BoolAttr getNarrowRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().narrow_range);
  }

  bool getNarrowRange();
  ::mlir::IntegerAttr getAxisAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().axis);
  }

  uint64_t getAxis();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSignedInputAttr(::mlir::BoolAttr attr) {
    getProperties().signed_input = attr;
  }

  void setSignedInput(::std::optional<bool> attrValue);
  void setRangeGivenAttr(::mlir::BoolAttr attr) {
    getProperties().range_given = attr;
  }

  void setRangeGiven(::std::optional<bool> attrValue);
  void setNarrowRangeAttr(::mlir::BoolAttr attr) {
    getProperties().narrow_range = attr;
  }

  void setNarrowRange(::std::optional<bool> attrValue);
  void setAxisAttr(::mlir::IntegerAttr attr) {
    getProperties().axis = attr;
  }

  void setAxis(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSignedInputAttr() {
      auto attr = getProperties().signed_input;
      getProperties().signed_input = {};
      return attr;
  }

  ::mlir::Attribute removeRangeGivenAttr() {
      auto attr = getProperties().range_given;
      getProperties().range_given = {};
      return attr;
  }

  ::mlir::Attribute removeNarrowRangeAttr() {
      auto attr = getProperties().narrow_range;
      getProperties().narrow_range = {};
      return attr;
  }

  ::mlir::Attribute removeAxisAttr() {
      auto attr = getProperties().axis;
      getProperties().axis = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, ::mlir::Value num_bits, /*optional*/::mlir::BoolAttr signed_input, /*optional*/::mlir::BoolAttr range_given = nullptr, /*optional*/::mlir::BoolAttr narrow_range = nullptr, /*optional*/::mlir::IntegerAttr axis = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, ::mlir::Value num_bits, /*optional*/::mlir::BoolAttr signed_input, /*optional*/::mlir::BoolAttr range_given = nullptr, /*optional*/::mlir::BoolAttr narrow_range = nullptr, /*optional*/::mlir::IntegerAttr axis = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, ::mlir::Value num_bits, /*optional*/bool signed_input = true, /*optional*/bool range_given = true, /*optional*/bool narrow_range = false, /*optional*/uint64_t axis = -1);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, ::mlir::Value num_bits, /*optional*/bool signed_input = true, /*optional*/bool range_given = true, /*optional*/bool narrow_range = false, /*optional*/uint64_t axis = -1);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::QuantizeAndDequantizeV3Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::QuantizeAndDequantizeV4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class QuantizeAndDequantizeV4OpGenericAdaptorBase {
public:
  struct Properties {
    using axisTy = ::mlir::IntegerAttr;
    axisTy axis;

    auto getAxis() const {
      auto &propStorage = this->axis;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAxis(const ::mlir::IntegerAttr &propValue) {
      this->axis = propValue;
    }
    using narrow_rangeTy = ::mlir::BoolAttr;
    narrow_rangeTy narrow_range;

    auto getNarrowRange() const {
      auto &propStorage = this->narrow_range;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setNarrowRange(const ::mlir::BoolAttr &propValue) {
      this->narrow_range = propValue;
    }
    using num_bitsTy = ::mlir::IntegerAttr;
    num_bitsTy num_bits;

    auto getNumBits() const {
      auto &propStorage = this->num_bits;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setNumBits(const ::mlir::IntegerAttr &propValue) {
      this->num_bits = propValue;
    }
    using range_givenTy = ::mlir::BoolAttr;
    range_givenTy range_given;

    auto getRangeGiven() const {
      auto &propStorage = this->range_given;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setRangeGiven(const ::mlir::BoolAttr &propValue) {
      this->range_given = propValue;
    }
    using round_modeTy = ::mlir::StringAttr;
    round_modeTy round_mode;

    auto getRoundMode() const {
      auto &propStorage = this->round_mode;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setRoundMode(const ::mlir::StringAttr &propValue) {
      this->round_mode = propValue;
    }
    using signed_inputTy = ::mlir::BoolAttr;
    signed_inputTy signed_input;

    auto getSignedInput() const {
      auto &propStorage = this->signed_input;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setSignedInput(const ::mlir::BoolAttr &propValue) {
      this->signed_input = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.axis == this->axis &&
        rhs.narrow_range == this->narrow_range &&
        rhs.num_bits == this->num_bits &&
        rhs.range_given == this->range_given &&
        rhs.round_mode == this->round_mode &&
        rhs.signed_input == this->signed_input &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  QuantizeAndDequantizeV4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.QuantizeAndDequantizeV4", odsAttrs.getContext());
  }

  QuantizeAndDequantizeV4OpGenericAdaptorBase(QuantizeAndDequantizeV4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getSignedInputAttr();
  bool getSignedInput();
  ::mlir::IntegerAttr getNumBitsAttr();
  uint64_t getNumBits();
  ::mlir::BoolAttr getRangeGivenAttr();
  bool getRangeGiven();
  ::mlir::StringAttr getRoundModeAttr();
  ::llvm::StringRef getRoundMode();
  ::mlir::BoolAttr getNarrowRangeAttr();
  bool getNarrowRange();
  ::mlir::IntegerAttr getAxisAttr();
  uint64_t getAxis();
};
} // namespace detail
template <typename RangeT>
class QuantizeAndDequantizeV4OpGenericAdaptor : public detail::QuantizeAndDequantizeV4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::QuantizeAndDequantizeV4OpGenericAdaptorBase;
public:
  QuantizeAndDequantizeV4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  QuantizeAndDequantizeV4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : QuantizeAndDequantizeV4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  QuantizeAndDequantizeV4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : QuantizeAndDequantizeV4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  QuantizeAndDequantizeV4OpGenericAdaptor(RangeT values, const QuantizeAndDequantizeV4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = QuantizeAndDequantizeV4Op, typename = std::enable_if_t<std::is_same_v<LateInst, QuantizeAndDequantizeV4Op>>>
  QuantizeAndDequantizeV4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getInputMin() {
    return (*getODSOperands(1).begin());
  }

  ValueT getInputMax() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class QuantizeAndDequantizeV4OpAdaptor : public QuantizeAndDequantizeV4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using QuantizeAndDequantizeV4OpGenericAdaptor::QuantizeAndDequantizeV4OpGenericAdaptor;
  QuantizeAndDequantizeV4OpAdaptor(QuantizeAndDequantizeV4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class QuantizeAndDequantizeV4Op : public ::mlir::Op<QuantizeAndDequantizeV4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = QuantizeAndDequantizeV4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = QuantizeAndDequantizeV4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("axis"), ::llvm::StringRef("narrow_range"), ::llvm::StringRef("num_bits"), ::llvm::StringRef("range_given"), ::llvm::StringRef("round_mode"), ::llvm::StringRef("signed_input")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAxisAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAxisAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getNarrowRangeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getNarrowRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getNumBitsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getNumBitsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getRangeGivenAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getRangeGivenAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getRoundModeAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getRoundModeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getSignedInputAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getSignedInputAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.QuantizeAndDequantizeV4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputMin() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputMax() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInputMinMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInputMaxMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getSignedInputAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().signed_input);
  }

  bool getSignedInput();
  ::mlir::IntegerAttr getNumBitsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().num_bits);
  }

  uint64_t getNumBits();
  ::mlir::BoolAttr getRangeGivenAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().range_given);
  }

  bool getRangeGiven();
  ::mlir::StringAttr getRoundModeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().round_mode);
  }

  ::llvm::StringRef getRoundMode();
  ::mlir::BoolAttr getNarrowRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().narrow_range);
  }

  bool getNarrowRange();
  ::mlir::IntegerAttr getAxisAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().axis);
  }

  uint64_t getAxis();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSignedInputAttr(::mlir::BoolAttr attr) {
    getProperties().signed_input = attr;
  }

  void setSignedInput(::std::optional<bool> attrValue);
  void setNumBitsAttr(::mlir::IntegerAttr attr) {
    getProperties().num_bits = attr;
  }

  void setNumBits(::std::optional<uint64_t> attrValue);
  void setRangeGivenAttr(::mlir::BoolAttr attr) {
    getProperties().range_given = attr;
  }

  void setRangeGiven(::std::optional<bool> attrValue);
  void setRoundModeAttr(::mlir::StringAttr attr) {
    getProperties().round_mode = attr;
  }

  void setRoundMode(::std::optional<::llvm::StringRef> attrValue);
  void setNarrowRangeAttr(::mlir::BoolAttr attr) {
    getProperties().narrow_range = attr;
  }

  void setNarrowRange(::std::optional<bool> attrValue);
  void setAxisAttr(::mlir::IntegerAttr attr) {
    getProperties().axis = attr;
  }

  void setAxis(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSignedInputAttr() {
      auto attr = getProperties().signed_input;
      getProperties().signed_input = {};
      return attr;
  }

  ::mlir::Attribute removeNumBitsAttr() {
      auto attr = getProperties().num_bits;
      getProperties().num_bits = {};
      return attr;
  }

  ::mlir::Attribute removeRangeGivenAttr() {
      auto attr = getProperties().range_given;
      getProperties().range_given = {};
      return attr;
  }

  ::mlir::Attribute removeRoundModeAttr() {
      auto attr = getProperties().round_mode;
      getProperties().round_mode = {};
      return attr;
  }

  ::mlir::Attribute removeNarrowRangeAttr() {
      auto attr = getProperties().narrow_range;
      getProperties().narrow_range = {};
      return attr;
  }

  ::mlir::Attribute removeAxisAttr() {
      auto attr = getProperties().axis;
      getProperties().axis = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, /*optional*/::mlir::BoolAttr signed_input, /*optional*/::mlir::IntegerAttr num_bits = nullptr, /*optional*/::mlir::BoolAttr range_given = nullptr, /*optional*/::mlir::StringAttr round_mode = nullptr, /*optional*/::mlir::BoolAttr narrow_range = nullptr, /*optional*/::mlir::IntegerAttr axis = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, /*optional*/::mlir::BoolAttr signed_input, /*optional*/::mlir::IntegerAttr num_bits = nullptr, /*optional*/::mlir::BoolAttr range_given = nullptr, /*optional*/::mlir::StringAttr round_mode = nullptr, /*optional*/::mlir::BoolAttr narrow_range = nullptr, /*optional*/::mlir::IntegerAttr axis = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, /*optional*/bool signed_input = true, /*optional*/uint64_t num_bits = 8, /*optional*/bool range_given = false, /*optional*/::llvm::StringRef round_mode = "HALF_TO_EVEN", /*optional*/bool narrow_range = false, /*optional*/uint64_t axis = -1);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value input_min, ::mlir::Value input_max, /*optional*/bool signed_input = true, /*optional*/uint64_t num_bits = 8, /*optional*/bool range_given = false, /*optional*/::llvm::StringRef round_mode = "HALF_TO_EVEN", /*optional*/bool narrow_range = false, /*optional*/uint64_t axis = -1);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::QuantizeAndDequantizeV4Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::QuantizeV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class QuantizeV2OpGenericAdaptorBase {
public:
  struct Properties {
    using axisTy = ::mlir::IntegerAttr;
    axisTy axis;

    auto getAxis() const {
      auto &propStorage = this->axis;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAxis(const ::mlir::IntegerAttr &propValue) {
      this->axis = propValue;
    }
    using ensure_minimum_rangeTy = ::mlir::FloatAttr;
    ensure_minimum_rangeTy ensure_minimum_range;

    auto getEnsureMinimumRange() const {
      auto &propStorage = this->ensure_minimum_range;
      return ::llvm::dyn_cast_or_null<::mlir::FloatAttr>(propStorage);
    }
    void setEnsureMinimumRange(const ::mlir::FloatAttr &propValue) {
      this->ensure_minimum_range = propValue;
    }
    using modeTy = ::mlir::StringAttr;
    modeTy mode;

    auto getMode() const {
      auto &propStorage = this->mode;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setMode(const ::mlir::StringAttr &propValue) {
      this->mode = propValue;
    }
    using narrow_rangeTy = ::mlir::BoolAttr;
    narrow_rangeTy narrow_range;

    auto getNarrowRange() const {
      auto &propStorage = this->narrow_range;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setNarrowRange(const ::mlir::BoolAttr &propValue) {
      this->narrow_range = propValue;
    }
    using round_modeTy = ::mlir::StringAttr;
    round_modeTy round_mode;

    auto getRoundMode() const {
      auto &propStorage = this->round_mode;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setRoundMode(const ::mlir::StringAttr &propValue) {
      this->round_mode = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.axis == this->axis &&
        rhs.ensure_minimum_range == this->ensure_minimum_range &&
        rhs.mode == this->mode &&
        rhs.narrow_range == this->narrow_range &&
        rhs.round_mode == this->round_mode &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  QuantizeV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.QuantizeV2", odsAttrs.getContext());
  }

  QuantizeV2OpGenericAdaptorBase(QuantizeV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getModeAttr();
  ::llvm::StringRef getMode();
  ::mlir::StringAttr getRoundModeAttr();
  ::llvm::StringRef getRoundMode();
  ::mlir::BoolAttr getNarrowRangeAttr();
  bool getNarrowRange();
  ::mlir::IntegerAttr getAxisAttr();
  uint64_t getAxis();
  ::mlir::FloatAttr getEnsureMinimumRangeAttr();
  ::llvm::APFloat getEnsureMinimumRange();
};
} // namespace detail
template <typename RangeT>
class QuantizeV2OpGenericAdaptor : public detail::QuantizeV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::QuantizeV2OpGenericAdaptorBase;
public:
  QuantizeV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  QuantizeV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : QuantizeV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  QuantizeV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : QuantizeV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  QuantizeV2OpGenericAdaptor(RangeT values, const QuantizeV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = QuantizeV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, QuantizeV2Op>>>
  QuantizeV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMinRange() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMaxRange() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class QuantizeV2OpAdaptor : public QuantizeV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using QuantizeV2OpGenericAdaptor::QuantizeV2OpGenericAdaptor;
  QuantizeV2OpAdaptor(QuantizeV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class QuantizeV2Op : public ::mlir::Op<QuantizeV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<3>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = QuantizeV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = QuantizeV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("axis"), ::llvm::StringRef("ensure_minimum_range"), ::llvm::StringRef("mode"), ::llvm::StringRef("narrow_range"), ::llvm::StringRef("round_mode")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAxisAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAxisAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getEnsureMinimumRangeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getEnsureMinimumRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getModeAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getModeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getNarrowRangeAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getNarrowRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getRoundModeAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getRoundModeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.QuantizeV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getMinRange() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getMaxRange() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMinRangeMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMaxRangeMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutputMin() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutputMax() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(2).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getModeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().mode);
  }

  ::llvm::StringRef getMode();
  ::mlir::StringAttr getRoundModeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().round_mode);
  }

  ::llvm::StringRef getRoundMode();
  ::mlir::BoolAttr getNarrowRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().narrow_range);
  }

  bool getNarrowRange();
  ::mlir::IntegerAttr getAxisAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().axis);
  }

  uint64_t getAxis();
  ::mlir::FloatAttr getEnsureMinimumRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::FloatAttr>(getProperties().ensure_minimum_range);
  }

  ::llvm::APFloat getEnsureMinimumRange();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setModeAttr(::mlir::StringAttr attr) {
    getProperties().mode = attr;
  }

  void setMode(::std::optional<::llvm::StringRef> attrValue);
  void setRoundModeAttr(::mlir::StringAttr attr) {
    getProperties().round_mode = attr;
  }

  void setRoundMode(::std::optional<::llvm::StringRef> attrValue);
  void setNarrowRangeAttr(::mlir::BoolAttr attr) {
    getProperties().narrow_range = attr;
  }

  void setNarrowRange(::std::optional<bool> attrValue);
  void setAxisAttr(::mlir::IntegerAttr attr) {
    getProperties().axis = attr;
  }

  void setAxis(::std::optional<uint64_t> attrValue);
  void setEnsureMinimumRangeAttr(::mlir::FloatAttr attr) {
    getProperties().ensure_minimum_range = attr;
  }

  void setEnsureMinimumRange(::std::optional<::llvm::APFloat> attrValue);
  ::mlir::Attribute removeModeAttr() {
      auto attr = getProperties().mode;
      getProperties().mode = {};
      return attr;
  }

  ::mlir::Attribute removeRoundModeAttr() {
      auto attr = getProperties().round_mode;
      getProperties().round_mode = {};
      return attr;
  }

  ::mlir::Attribute removeNarrowRangeAttr() {
      auto attr = getProperties().narrow_range;
      getProperties().narrow_range = {};
      return attr;
  }

  ::mlir::Attribute removeAxisAttr() {
      auto attr = getProperties().axis;
      getProperties().axis = {};
      return attr;
  }

  ::mlir::Attribute removeEnsureMinimumRangeAttr() {
      auto attr = getProperties().ensure_minimum_range;
      getProperties().ensure_minimum_range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Type output_min, ::mlir::Type output_max, ::mlir::Value input, ::mlir::Value min_range, ::mlir::Value max_range, /*optional*/::mlir::StringAttr mode, /*optional*/::mlir::StringAttr round_mode, /*optional*/::mlir::BoolAttr narrow_range, /*optional*/::mlir::IntegerAttr axis, /*optional*/::mlir::FloatAttr ensure_minimum_range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value min_range, ::mlir::Value max_range, /*optional*/::mlir::StringAttr mode, /*optional*/::mlir::StringAttr round_mode, /*optional*/::mlir::BoolAttr narrow_range, /*optional*/::mlir::IntegerAttr axis, /*optional*/::mlir::FloatAttr ensure_minimum_range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Type output_min, ::mlir::Type output_max, ::mlir::Value input, ::mlir::Value min_range, ::mlir::Value max_range, /*optional*/::llvm::StringRef mode, /*optional*/::llvm::StringRef round_mode, /*optional*/bool narrow_range, /*optional*/uint64_t axis, /*optional*/::llvm::APFloat ensure_minimum_range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value min_range, ::mlir::Value max_range, /*optional*/::llvm::StringRef mode, /*optional*/::llvm::StringRef round_mode, /*optional*/bool narrow_range, /*optional*/uint64_t axis, /*optional*/::llvm::APFloat ensure_minimum_range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::QuantizeV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::QueueDequeueV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class QueueDequeueV2OpGenericAdaptorBase {
public:
  struct Properties {
    using timeout_msTy = ::mlir::IntegerAttr;
    timeout_msTy timeout_ms;

    auto getTimeoutMs() const {
      auto &propStorage = this->timeout_ms;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setTimeoutMs(const ::mlir::IntegerAttr &propValue) {
      this->timeout_ms = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.timeout_ms == this->timeout_ms &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  QueueDequeueV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.QueueDequeueV2", odsAttrs.getContext());
  }

  QueueDequeueV2OpGenericAdaptorBase(QueueDequeueV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getTimeoutMsAttr();
  uint64_t getTimeoutMs();
};
} // namespace detail
template <typename RangeT>
class QueueDequeueV2OpGenericAdaptor : public detail::QueueDequeueV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::QueueDequeueV2OpGenericAdaptorBase;
public:
  QueueDequeueV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  QueueDequeueV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : QueueDequeueV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  QueueDequeueV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : QueueDequeueV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  QueueDequeueV2OpGenericAdaptor(RangeT values, const QueueDequeueV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = QueueDequeueV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, QueueDequeueV2Op>>>
  QueueDequeueV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getHandle() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class QueueDequeueV2OpAdaptor : public QueueDequeueV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using QueueDequeueV2OpGenericAdaptor::QueueDequeueV2OpGenericAdaptor;
  QueueDequeueV2OpAdaptor(QueueDequeueV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class QueueDequeueV2Op : public ::mlir::Op<QueueDequeueV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = QueueDequeueV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = QueueDequeueV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("component_types"), ::llvm::StringRef("timeout_ms")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getComponentTypesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getComponentTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTimeoutMsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTimeoutMsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.QueueDequeueV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getHandleMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getComponents() {
    return getODSResults(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getTimeoutMsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().timeout_ms);
  }

  uint64_t getTimeoutMs();
  mlir::ResultElementTypeRange getComponentTypes();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setTimeoutMsAttr(::mlir::IntegerAttr attr) {
    getProperties().timeout_ms = attr;
  }

  void setTimeoutMs(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeTimeoutMsAttr() {
      auto attr = getProperties().timeout_ms;
      getProperties().timeout_ms = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange components, ::mlir::Value handle, /*optional*/::mlir::IntegerAttr timeout_ms);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange components, ::mlir::Value handle, /*optional*/uint64_t timeout_ms = -1);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::QueueDequeueV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RFFT2DOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RFFT2DOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RFFT2DOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RFFT2D", odsAttrs.getContext());
  }

  RFFT2DOpGenericAdaptorBase(RFFT2DOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RFFT2DOpGenericAdaptor : public detail::RFFT2DOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RFFT2DOpGenericAdaptorBase;
public:
  RFFT2DOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RFFT2DOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RFFT2DOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RFFT2DOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RFFT2DOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RFFT2DOpGenericAdaptor(RangeT values, const RFFT2DOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RFFT2DOp, typename = std::enable_if_t<std::is_same_v<LateInst, RFFT2DOp>>>
  RFFT2DOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getFftLength() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RFFT2DOpAdaptor : public RFFT2DOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RFFT2DOpGenericAdaptor::RFFT2DOpGenericAdaptor;
  RFFT2DOpAdaptor(RFFT2DOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RFFT2DOp : public ::mlir::Op<RFFT2DOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RFFT2DOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RFFT2DOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Tcomplex"), ::llvm::StringRef("Treal")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTcomplexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTcomplexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTrealAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTrealAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RFFT2D");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getFftLength() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getFftLengthMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getTreal();
  ::mlir::Type getTcomplex();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value fft_length);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value fft_length);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RFFT2DOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RFFT3DOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RFFT3DOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RFFT3DOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RFFT3D", odsAttrs.getContext());
  }

  RFFT3DOpGenericAdaptorBase(RFFT3DOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RFFT3DOpGenericAdaptor : public detail::RFFT3DOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RFFT3DOpGenericAdaptorBase;
public:
  RFFT3DOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RFFT3DOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RFFT3DOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RFFT3DOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RFFT3DOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RFFT3DOpGenericAdaptor(RangeT values, const RFFT3DOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RFFT3DOp, typename = std::enable_if_t<std::is_same_v<LateInst, RFFT3DOp>>>
  RFFT3DOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getFftLength() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RFFT3DOpAdaptor : public RFFT3DOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RFFT3DOpGenericAdaptor::RFFT3DOpGenericAdaptor;
  RFFT3DOpAdaptor(RFFT3DOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RFFT3DOp : public ::mlir::Op<RFFT3DOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RFFT3DOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RFFT3DOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Tcomplex"), ::llvm::StringRef("Treal")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTcomplexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTcomplexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTrealAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTrealAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RFFT3D");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getFftLength() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getFftLengthMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getTreal();
  ::mlir::Type getTcomplex();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value fft_length);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value fft_length);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RFFT3DOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RFFTOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RFFTOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RFFTOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RFFT", odsAttrs.getContext());
  }

  RFFTOpGenericAdaptorBase(RFFTOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RFFTOpGenericAdaptor : public detail::RFFTOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RFFTOpGenericAdaptorBase;
public:
  RFFTOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RFFTOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RFFTOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RFFTOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RFFTOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RFFTOpGenericAdaptor(RangeT values, const RFFTOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RFFTOp, typename = std::enable_if_t<std::is_same_v<LateInst, RFFTOp>>>
  RFFTOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getFftLength() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RFFTOpAdaptor : public RFFTOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RFFTOpGenericAdaptor::RFFTOpGenericAdaptor;
  RFFTOpAdaptor(RFFTOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RFFTOp : public ::mlir::Op<RFFTOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RFFTOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RFFTOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Tcomplex"), ::llvm::StringRef("Treal")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTcomplexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTcomplexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTrealAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTrealAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RFFT");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getFftLength() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getFftLengthMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getTreal();
  ::mlir::Type getTcomplex();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value fft_length);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value fft_length);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RFFTOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RGBToHSVOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RGBToHSVOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RGBToHSVOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RGBToHSV", odsAttrs.getContext());
  }

  RGBToHSVOpGenericAdaptorBase(RGBToHSVOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RGBToHSVOpGenericAdaptor : public detail::RGBToHSVOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RGBToHSVOpGenericAdaptorBase;
public:
  RGBToHSVOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RGBToHSVOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RGBToHSVOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RGBToHSVOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RGBToHSVOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RGBToHSVOpGenericAdaptor(RangeT values, const RGBToHSVOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RGBToHSVOp, typename = std::enable_if_t<std::is_same_v<LateInst, RGBToHSVOp>>>
  RGBToHSVOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getImages() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RGBToHSVOpAdaptor : public RGBToHSVOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RGBToHSVOpGenericAdaptor::RGBToHSVOpGenericAdaptor;
  RGBToHSVOpAdaptor(RGBToHSVOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RGBToHSVOp : public ::mlir::Op<RGBToHSVOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RGBToHSVOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RGBToHSVOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RGBToHSV");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getImages() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getImagesMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value images);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value images);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RGBToHSVOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RaggedGatherOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RaggedGatherOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RaggedGatherOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RaggedGather", odsAttrs.getContext());
  }

  RaggedGatherOpGenericAdaptorBase(RaggedGatherOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RaggedGatherOpGenericAdaptor : public detail::RaggedGatherOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RaggedGatherOpGenericAdaptorBase;
public:
  RaggedGatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RaggedGatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RaggedGatherOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RaggedGatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RaggedGatherOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RaggedGatherOpGenericAdaptor(RangeT values, const RaggedGatherOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RaggedGatherOp, typename = std::enable_if_t<std::is_same_v<LateInst, RaggedGatherOp>>>
  RaggedGatherOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getParamsNestedSplits() {
    return getODSOperands(0);
  }

  ValueT getParamsDenseValues() {
    return (*getODSOperands(1).begin());
  }

  ValueT getIndices() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RaggedGatherOpAdaptor : public RaggedGatherOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RaggedGatherOpGenericAdaptor::RaggedGatherOpGenericAdaptor;
  RaggedGatherOpAdaptor(RaggedGatherOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RaggedGatherOp : public ::mlir::Op<RaggedGatherOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::AtLeastNResults<1>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RaggedGatherOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RaggedGatherOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("OUTPUT_RAGGED_RANK"), ::llvm::StringRef("PARAMS_RAGGED_RANK"), ::llvm::StringRef("Tindices"), ::llvm::StringRef("Tsplits"), ::llvm::StringRef("Tvalues")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOUTPUT_RAGGED_RANKAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOUTPUT_RAGGED_RANKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getPARAMS_RAGGED_RANKAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getPARAMS_RAGGED_RANKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getTindicesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getTindicesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getTsplitsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getTsplitsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getTvaluesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getTvaluesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RaggedGather");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getParamsNestedSplits() {
    return getODSOperands(0);
  }

  ::mlir::TypedValue<::mlir::TensorType> getParamsDenseValues() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::MutableOperandRange getParamsNestedSplitsMutable();
  ::mlir::OpOperand &getParamsDenseValuesMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getIndicesMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getOutputNestedSplits() {
    return getODSResults(0);
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutputDenseValues() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  size_t getPARAMS_RAGGED_RANK();
  ::mlir::Type getTindices();
  ::mlir::Type getTsplits();
  ::mlir::Type getTvalues();
  size_t getOUTPUT_RAGGED_RANK();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange output_nested_splits, ::mlir::Type output_dense_values, ::mlir::ValueRange params_nested_splits, ::mlir::Value params_dense_values, ::mlir::Value indices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange params_nested_splits, ::mlir::Value params_dense_values, ::mlir::Value indices);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RaggedGatherOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RaggedRangeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RaggedRangeOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RaggedRangeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RaggedRange", odsAttrs.getContext());
  }

  RaggedRangeOpGenericAdaptorBase(RaggedRangeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RaggedRangeOpGenericAdaptor : public detail::RaggedRangeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RaggedRangeOpGenericAdaptorBase;
public:
  RaggedRangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RaggedRangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RaggedRangeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RaggedRangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RaggedRangeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RaggedRangeOpGenericAdaptor(RangeT values, const RaggedRangeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RaggedRangeOp, typename = std::enable_if_t<std::is_same_v<LateInst, RaggedRangeOp>>>
  RaggedRangeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getStarts() {
    return (*getODSOperands(0).begin());
  }

  ValueT getLimits() {
    return (*getODSOperands(1).begin());
  }

  ValueT getDeltas() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RaggedRangeOpAdaptor : public RaggedRangeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RaggedRangeOpGenericAdaptor::RaggedRangeOpGenericAdaptor;
  RaggedRangeOpAdaptor(RaggedRangeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RaggedRangeOp : public ::mlir::Op<RaggedRangeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RaggedRangeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RaggedRangeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tsplits")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTsplitsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTsplitsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RaggedRange");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getStarts() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getLimits() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDeltas() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getStartsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getLimitsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDeltasMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getRtNestedSplits() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getRtDenseValues() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  ::mlir::Type getTsplits();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type rt_nested_splits, ::mlir::Type rt_dense_values, ::mlir::Value starts, ::mlir::Value limits, ::mlir::Value deltas);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value starts, ::mlir::Value limits, ::mlir::Value deltas);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RaggedRangeOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RandomGammaGradOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RandomGammaGradOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RandomGammaGradOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RandomGammaGrad", odsAttrs.getContext());
  }

  RandomGammaGradOpGenericAdaptorBase(RandomGammaGradOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RandomGammaGradOpGenericAdaptor : public detail::RandomGammaGradOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RandomGammaGradOpGenericAdaptorBase;
public:
  RandomGammaGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RandomGammaGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RandomGammaGradOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RandomGammaGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RandomGammaGradOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RandomGammaGradOpGenericAdaptor(RangeT values, const RandomGammaGradOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RandomGammaGradOp, typename = std::enable_if_t<std::is_same_v<LateInst, RandomGammaGradOp>>>
  RandomGammaGradOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getAlpha() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSample() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RandomGammaGradOpAdaptor : public RandomGammaGradOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RandomGammaGradOpGenericAdaptor::RandomGammaGradOpGenericAdaptor;
  RandomGammaGradOpAdaptor(RandomGammaGradOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RandomGammaGradOp : public ::mlir::Op<RandomGammaGradOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ResultsBroadcastableShape, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RandomGammaGradOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RandomGammaGradOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RandomGammaGrad");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getAlpha() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getSample() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getAlphaMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSampleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value x, Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value alpha, ::mlir::Value sample);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value alpha, ::mlir::Value sample);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RandomGammaGradOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RandomGammaOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RandomGammaOpGenericAdaptorBase {
public:
  struct Properties {
    using seedTy = ::mlir::IntegerAttr;
    seedTy seed;

    auto getSeed() const {
      auto &propStorage = this->seed;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed(const ::mlir::IntegerAttr &propValue) {
      this->seed = propValue;
    }
    using seed2Ty = ::mlir::IntegerAttr;
    seed2Ty seed2;

    auto getSeed2() const {
      auto &propStorage = this->seed2;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed2(const ::mlir::IntegerAttr &propValue) {
      this->seed2 = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.seed == this->seed &&
        rhs.seed2 == this->seed2 &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RandomGammaOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RandomGamma", odsAttrs.getContext());
  }

  RandomGammaOpGenericAdaptorBase(RandomGammaOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSeedAttr();
  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr();
  uint64_t getSeed2();
};
} // namespace detail
template <typename RangeT>
class RandomGammaOpGenericAdaptor : public detail::RandomGammaOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RandomGammaOpGenericAdaptorBase;
public:
  RandomGammaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RandomGammaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RandomGammaOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RandomGammaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RandomGammaOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RandomGammaOpGenericAdaptor(RangeT values, const RandomGammaOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RandomGammaOp, typename = std::enable_if_t<std::is_same_v<LateInst, RandomGammaOp>>>
  RandomGammaOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getShape() {
    return (*getODSOperands(0).begin());
  }

  ValueT getAlpha() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RandomGammaOpAdaptor : public RandomGammaOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RandomGammaOpGenericAdaptor::RandomGammaOpGenericAdaptor;
  RandomGammaOpAdaptor(RandomGammaOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RandomGammaOp : public ::mlir::Op<RandomGammaOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::TF::CannotDuplicate, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RandomGammaOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RandomGammaOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("S"), ::llvm::StringRef("T"), ::llvm::StringRef("seed"), ::llvm::StringRef("seed2")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSeedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSeedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSeed2AttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSeed2AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RandomGamma");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getAlpha() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getShapeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getAlphaMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSeedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed);
  }

  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed2);
  }

  uint64_t getSeed2();
  ::mlir::Type getS();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSeedAttr(::mlir::IntegerAttr attr) {
    getProperties().seed = attr;
  }

  void setSeed(::std::optional<uint64_t> attrValue);
  void setSeed2Attr(::mlir::IntegerAttr attr) {
    getProperties().seed2 = attr;
  }

  void setSeed2(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSeedAttr() {
      auto attr = getProperties().seed;
      getProperties().seed = {};
      return attr;
  }

  ::mlir::Attribute removeSeed2Attr() {
      auto attr = getProperties().seed2;
      getProperties().seed2 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, ::mlir::Value alpha, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, ::mlir::Value alpha, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, ::mlir::Value alpha, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, ::mlir::Value alpha, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RandomGammaOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RandomPoissonOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RandomPoissonOpGenericAdaptorBase {
public:
  struct Properties {
    using seedTy = ::mlir::IntegerAttr;
    seedTy seed;

    auto getSeed() const {
      auto &propStorage = this->seed;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed(const ::mlir::IntegerAttr &propValue) {
      this->seed = propValue;
    }
    using seed2Ty = ::mlir::IntegerAttr;
    seed2Ty seed2;

    auto getSeed2() const {
      auto &propStorage = this->seed2;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed2(const ::mlir::IntegerAttr &propValue) {
      this->seed2 = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.seed == this->seed &&
        rhs.seed2 == this->seed2 &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RandomPoissonOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RandomPoisson", odsAttrs.getContext());
  }

  RandomPoissonOpGenericAdaptorBase(RandomPoissonOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSeedAttr();
  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr();
  uint64_t getSeed2();
};
} // namespace detail
template <typename RangeT>
class RandomPoissonOpGenericAdaptor : public detail::RandomPoissonOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RandomPoissonOpGenericAdaptorBase;
public:
  RandomPoissonOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RandomPoissonOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RandomPoissonOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RandomPoissonOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RandomPoissonOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RandomPoissonOpGenericAdaptor(RangeT values, const RandomPoissonOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RandomPoissonOp, typename = std::enable_if_t<std::is_same_v<LateInst, RandomPoissonOp>>>
  RandomPoissonOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getShape() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRate() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RandomPoissonOpAdaptor : public RandomPoissonOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RandomPoissonOpGenericAdaptor::RandomPoissonOpGenericAdaptor;
  RandomPoissonOpAdaptor(RandomPoissonOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RandomPoissonOp : public ::mlir::Op<RandomPoissonOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::TF::CannotDuplicate, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RandomPoissonOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RandomPoissonOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("S"), ::llvm::StringRef("dtype"), ::llvm::StringRef("seed"), ::llvm::StringRef("seed2")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSeedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSeedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSeed2AttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSeed2AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RandomPoisson");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getRate() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getShapeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRateMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSeedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed);
  }

  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed2);
  }

  uint64_t getSeed2();
  ::mlir::Type getS();
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSeedAttr(::mlir::IntegerAttr attr) {
    getProperties().seed = attr;
  }

  void setSeed(::std::optional<uint64_t> attrValue);
  void setSeed2Attr(::mlir::IntegerAttr attr) {
    getProperties().seed2 = attr;
  }

  void setSeed2(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSeedAttr() {
      auto attr = getProperties().seed;
      getProperties().seed = {};
      return attr;
  }

  ::mlir::Attribute removeSeed2Attr() {
      auto attr = getProperties().seed2;
      getProperties().seed2 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, ::mlir::Value rate, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, ::mlir::Value rate, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, ::mlir::Value rate, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, ::mlir::Value rate, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RandomPoissonOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RandomPoissonV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RandomPoissonV2OpGenericAdaptorBase {
public:
  struct Properties {
    using seedTy = ::mlir::IntegerAttr;
    seedTy seed;

    auto getSeed() const {
      auto &propStorage = this->seed;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed(const ::mlir::IntegerAttr &propValue) {
      this->seed = propValue;
    }
    using seed2Ty = ::mlir::IntegerAttr;
    seed2Ty seed2;

    auto getSeed2() const {
      auto &propStorage = this->seed2;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed2(const ::mlir::IntegerAttr &propValue) {
      this->seed2 = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.seed == this->seed &&
        rhs.seed2 == this->seed2 &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RandomPoissonV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RandomPoissonV2", odsAttrs.getContext());
  }

  RandomPoissonV2OpGenericAdaptorBase(RandomPoissonV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSeedAttr();
  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr();
  uint64_t getSeed2();
};
} // namespace detail
template <typename RangeT>
class RandomPoissonV2OpGenericAdaptor : public detail::RandomPoissonV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RandomPoissonV2OpGenericAdaptorBase;
public:
  RandomPoissonV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RandomPoissonV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RandomPoissonV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RandomPoissonV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RandomPoissonV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RandomPoissonV2OpGenericAdaptor(RangeT values, const RandomPoissonV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RandomPoissonV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, RandomPoissonV2Op>>>
  RandomPoissonV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getShape() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRate() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RandomPoissonV2OpAdaptor : public RandomPoissonV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using RandomPoissonV2OpGenericAdaptor::RandomPoissonV2OpGenericAdaptor;
  RandomPoissonV2OpAdaptor(RandomPoissonV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RandomPoissonV2Op : public ::mlir::Op<RandomPoissonV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::TF::CannotDuplicate, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RandomPoissonV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RandomPoissonV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("R"), ::llvm::StringRef("S"), ::llvm::StringRef("dtype"), ::llvm::StringRef("seed"), ::llvm::StringRef("seed2")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSeedAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSeedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getSeed2AttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getSeed2AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RandomPoissonV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getRate() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getShapeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRateMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSeedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed);
  }

  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed2);
  }

  uint64_t getSeed2();
  ::mlir::Type getR();
  ::mlir::Type getS();
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSeedAttr(::mlir::IntegerAttr attr) {
    getProperties().seed = attr;
  }

  void setSeed(::std::optional<uint64_t> attrValue);
  void setSeed2Attr(::mlir::IntegerAttr attr) {
    getProperties().seed2 = attr;
  }

  void setSeed2(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSeedAttr() {
      auto attr = getProperties().seed;
      getProperties().seed = {};
      return attr;
  }

  ::mlir::Attribute removeSeed2Attr() {
      auto attr = getProperties().seed2;
      getProperties().seed2 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, ::mlir::Value rate, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, ::mlir::Value rate, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, ::mlir::Value rate, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, ::mlir::Value rate, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RandomPoissonV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RandomShuffleOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RandomShuffleOpGenericAdaptorBase {
public:
  struct Properties {
    using seedTy = ::mlir::IntegerAttr;
    seedTy seed;

    auto getSeed() const {
      auto &propStorage = this->seed;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed(const ::mlir::IntegerAttr &propValue) {
      this->seed = propValue;
    }
    using seed2Ty = ::mlir::IntegerAttr;
    seed2Ty seed2;

    auto getSeed2() const {
      auto &propStorage = this->seed2;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed2(const ::mlir::IntegerAttr &propValue) {
      this->seed2 = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.seed == this->seed &&
        rhs.seed2 == this->seed2 &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RandomShuffleOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RandomShuffle", odsAttrs.getContext());
  }

  RandomShuffleOpGenericAdaptorBase(RandomShuffleOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSeedAttr();
  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr();
  uint64_t getSeed2();
};
} // namespace detail
template <typename RangeT>
class RandomShuffleOpGenericAdaptor : public detail::RandomShuffleOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RandomShuffleOpGenericAdaptorBase;
public:
  RandomShuffleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RandomShuffleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RandomShuffleOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RandomShuffleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RandomShuffleOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RandomShuffleOpGenericAdaptor(RangeT values, const RandomShuffleOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RandomShuffleOp, typename = std::enable_if_t<std::is_same_v<LateInst, RandomShuffleOp>>>
  RandomShuffleOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getValue() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RandomShuffleOpAdaptor : public RandomShuffleOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RandomShuffleOpGenericAdaptor::RandomShuffleOpGenericAdaptor;
  RandomShuffleOpAdaptor(RandomShuffleOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RandomShuffleOp : public ::mlir::Op<RandomShuffleOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::TF::CannotDuplicate, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RandomShuffleOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RandomShuffleOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("seed"), ::llvm::StringRef("seed2")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSeedAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSeedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSeed2AttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSeed2AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RandomShuffle");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSeedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed);
  }

  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed2);
  }

  uint64_t getSeed2();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSeedAttr(::mlir::IntegerAttr attr) {
    getProperties().seed = attr;
  }

  void setSeed(::std::optional<uint64_t> attrValue);
  void setSeed2Attr(::mlir::IntegerAttr attr) {
    getProperties().seed2 = attr;
  }

  void setSeed2(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSeedAttr() {
      auto attr = getProperties().seed;
      getProperties().seed = {};
      return attr;
  }

  ::mlir::Attribute removeSeed2Attr() {
      auto attr = getProperties().seed2;
      getProperties().seed2 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value value, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value value, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RandomShuffleOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RandomStandardNormalOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RandomStandardNormalOpGenericAdaptorBase {
public:
  struct Properties {
    using seedTy = ::mlir::IntegerAttr;
    seedTy seed;

    auto getSeed() const {
      auto &propStorage = this->seed;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed(const ::mlir::IntegerAttr &propValue) {
      this->seed = propValue;
    }
    using seed2Ty = ::mlir::IntegerAttr;
    seed2Ty seed2;

    auto getSeed2() const {
      auto &propStorage = this->seed2;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed2(const ::mlir::IntegerAttr &propValue) {
      this->seed2 = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.seed == this->seed &&
        rhs.seed2 == this->seed2 &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RandomStandardNormalOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RandomStandardNormal", odsAttrs.getContext());
  }

  RandomStandardNormalOpGenericAdaptorBase(RandomStandardNormalOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSeedAttr();
  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr();
  uint64_t getSeed2();
};
} // namespace detail
template <typename RangeT>
class RandomStandardNormalOpGenericAdaptor : public detail::RandomStandardNormalOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RandomStandardNormalOpGenericAdaptorBase;
public:
  RandomStandardNormalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RandomStandardNormalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RandomStandardNormalOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RandomStandardNormalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RandomStandardNormalOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RandomStandardNormalOpGenericAdaptor(RangeT values, const RandomStandardNormalOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RandomStandardNormalOp, typename = std::enable_if_t<std::is_same_v<LateInst, RandomStandardNormalOp>>>
  RandomStandardNormalOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getShape() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RandomStandardNormalOpAdaptor : public RandomStandardNormalOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RandomStandardNormalOpGenericAdaptor::RandomStandardNormalOpGenericAdaptor;
  RandomStandardNormalOpAdaptor(RandomStandardNormalOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RandomStandardNormalOp : public ::mlir::Op<RandomStandardNormalOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::TF::CannotDuplicate, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RandomStandardNormalOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RandomStandardNormalOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("dtype"), ::llvm::StringRef("seed"), ::llvm::StringRef("seed2")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSeedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSeedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSeed2AttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSeed2AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RandomStandardNormal");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getShapeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSeedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed);
  }

  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed2);
  }

  uint64_t getSeed2();
  ::mlir::Type getT();
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSeedAttr(::mlir::IntegerAttr attr) {
    getProperties().seed = attr;
  }

  void setSeed(::std::optional<uint64_t> attrValue);
  void setSeed2Attr(::mlir::IntegerAttr attr) {
    getProperties().seed2 = attr;
  }

  void setSeed2(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSeedAttr() {
      auto attr = getProperties().seed;
      getProperties().seed = {};
      return attr;
  }

  ::mlir::Attribute removeSeed2Attr() {
      auto attr = getProperties().seed2;
      getProperties().seed2 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RandomStandardNormalOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RandomUniformIntOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RandomUniformIntOpGenericAdaptorBase {
public:
  struct Properties {
    using seedTy = ::mlir::IntegerAttr;
    seedTy seed;

    auto getSeed() const {
      auto &propStorage = this->seed;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed(const ::mlir::IntegerAttr &propValue) {
      this->seed = propValue;
    }
    using seed2Ty = ::mlir::IntegerAttr;
    seed2Ty seed2;

    auto getSeed2() const {
      auto &propStorage = this->seed2;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed2(const ::mlir::IntegerAttr &propValue) {
      this->seed2 = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.seed == this->seed &&
        rhs.seed2 == this->seed2 &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RandomUniformIntOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RandomUniformInt", odsAttrs.getContext());
  }

  RandomUniformIntOpGenericAdaptorBase(RandomUniformIntOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSeedAttr();
  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr();
  uint64_t getSeed2();
};
} // namespace detail
template <typename RangeT>
class RandomUniformIntOpGenericAdaptor : public detail::RandomUniformIntOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RandomUniformIntOpGenericAdaptorBase;
public:
  RandomUniformIntOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RandomUniformIntOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RandomUniformIntOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RandomUniformIntOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RandomUniformIntOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RandomUniformIntOpGenericAdaptor(RangeT values, const RandomUniformIntOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RandomUniformIntOp, typename = std::enable_if_t<std::is_same_v<LateInst, RandomUniformIntOp>>>
  RandomUniformIntOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getShape() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMinval() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMaxval() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RandomUniformIntOpAdaptor : public RandomUniformIntOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RandomUniformIntOpGenericAdaptor::RandomUniformIntOpGenericAdaptor;
  RandomUniformIntOpAdaptor(RandomUniformIntOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RandomUniformIntOp : public ::mlir::Op<RandomUniformIntOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::TF::CannotDuplicate, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RandomUniformIntOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RandomUniformIntOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tout"), ::llvm::StringRef("seed"), ::llvm::StringRef("seed2")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getToutAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getToutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSeedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSeedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSeed2AttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSeed2AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RandomUniformInt");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getMinval() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getMaxval() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getShapeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMinvalMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMaxvalMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSeedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed);
  }

  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed2);
  }

  uint64_t getSeed2();
  ::mlir::Type getT();
  ::mlir::Type getTout();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSeedAttr(::mlir::IntegerAttr attr) {
    getProperties().seed = attr;
  }

  void setSeed(::std::optional<uint64_t> attrValue);
  void setSeed2Attr(::mlir::IntegerAttr attr) {
    getProperties().seed2 = attr;
  }

  void setSeed2(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSeedAttr() {
      auto attr = getProperties().seed;
      getProperties().seed = {};
      return attr;
  }

  ::mlir::Attribute removeSeed2Attr() {
      auto attr = getProperties().seed2;
      getProperties().seed2 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, ::mlir::Value minval, ::mlir::Value maxval, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, ::mlir::Value minval, ::mlir::Value maxval, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, ::mlir::Value minval, ::mlir::Value maxval, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, ::mlir::Value minval, ::mlir::Value maxval, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RandomUniformIntOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RandomUniformOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RandomUniformOpGenericAdaptorBase {
public:
  struct Properties {
    using seedTy = ::mlir::IntegerAttr;
    seedTy seed;

    auto getSeed() const {
      auto &propStorage = this->seed;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed(const ::mlir::IntegerAttr &propValue) {
      this->seed = propValue;
    }
    using seed2Ty = ::mlir::IntegerAttr;
    seed2Ty seed2;

    auto getSeed2() const {
      auto &propStorage = this->seed2;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSeed2(const ::mlir::IntegerAttr &propValue) {
      this->seed2 = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.seed == this->seed &&
        rhs.seed2 == this->seed2 &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RandomUniformOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RandomUniform", odsAttrs.getContext());
  }

  RandomUniformOpGenericAdaptorBase(RandomUniformOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSeedAttr();
  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr();
  uint64_t getSeed2();
};
} // namespace detail
template <typename RangeT>
class RandomUniformOpGenericAdaptor : public detail::RandomUniformOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RandomUniformOpGenericAdaptorBase;
public:
  RandomUniformOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RandomUniformOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RandomUniformOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RandomUniformOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RandomUniformOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RandomUniformOpGenericAdaptor(RangeT values, const RandomUniformOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RandomUniformOp, typename = std::enable_if_t<std::is_same_v<LateInst, RandomUniformOp>>>
  RandomUniformOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getShape() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RandomUniformOpAdaptor : public RandomUniformOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RandomUniformOpGenericAdaptor::RandomUniformOpGenericAdaptor;
  RandomUniformOpAdaptor(RandomUniformOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RandomUniformOp : public ::mlir::Op<RandomUniformOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, GetResourceInstanceInterface::Trait, ::mlir::OpTrait::TF::CannotDuplicate, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RandomUniformOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RandomUniformOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("dtype"), ::llvm::StringRef("seed"), ::llvm::StringRef("seed2")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSeedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSeedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSeed2AttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSeed2AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RandomUniform");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getShapeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSeedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed);
  }

  uint64_t getSeed();
  ::mlir::IntegerAttr getSeed2Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().seed2);
  }

  uint64_t getSeed2();
  ::mlir::Type getT();
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSeedAttr(::mlir::IntegerAttr attr) {
    getProperties().seed = attr;
  }

  void setSeed(::std::optional<uint64_t> attrValue);
  void setSeed2Attr(::mlir::IntegerAttr attr) {
    getProperties().seed2 = attr;
  }

  void setSeed2(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSeedAttr() {
      auto attr = getProperties().seed;
      getProperties().seed = {};
      return attr;
  }

  ::mlir::Attribute removeSeed2Attr() {
      auto attr = getProperties().seed2;
      getProperties().seed2 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, /*optional*/::mlir::IntegerAttr seed, /*optional*/::mlir::IntegerAttr seed2 = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value shape, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value shape, /*optional*/uint64_t seed = 0, /*optional*/uint64_t seed2 = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  std::optional<std::string> GetResourceInstanceStr();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RandomUniformOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RangeDatasetOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RangeDatasetOpGenericAdaptorBase {
public:
  struct Properties {
    using metadataTy = ::mlir::StringAttr;
    metadataTy metadata;

    auto getMetadata() const {
      auto &propStorage = this->metadata;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setMetadata(const ::mlir::StringAttr &propValue) {
      this->metadata = propValue;
    }
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    using replicate_on_splitTy = ::mlir::BoolAttr;
    replicate_on_splitTy replicate_on_split;

    auto getReplicateOnSplit() const {
      auto &propStorage = this->replicate_on_split;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setReplicateOnSplit(const ::mlir::BoolAttr &propValue) {
      this->replicate_on_split = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.metadata == this->metadata &&
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        rhs.replicate_on_split == this->replicate_on_split &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RangeDatasetOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RangeDataset", odsAttrs.getContext());
  }

  RangeDatasetOpGenericAdaptorBase(RangeDatasetOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::StringAttr getMetadataAttr();
  ::llvm::StringRef getMetadata();
  ::mlir::BoolAttr getReplicateOnSplitAttr();
  bool getReplicateOnSplit();
};
} // namespace detail
template <typename RangeT>
class RangeDatasetOpGenericAdaptor : public detail::RangeDatasetOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RangeDatasetOpGenericAdaptorBase;
public:
  RangeDatasetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RangeDatasetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RangeDatasetOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RangeDatasetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RangeDatasetOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RangeDatasetOpGenericAdaptor(RangeT values, const RangeDatasetOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RangeDatasetOp, typename = std::enable_if_t<std::is_same_v<LateInst, RangeDatasetOp>>>
  RangeDatasetOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getStart() {
    return (*getODSOperands(0).begin());
  }

  ValueT getStop() {
    return (*getODSOperands(1).begin());
  }

  ValueT getStep() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RangeDatasetOpAdaptor : public RangeDatasetOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RangeDatasetOpGenericAdaptor::RangeDatasetOpGenericAdaptor;
  RangeDatasetOpAdaptor(RangeDatasetOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RangeDatasetOp : public ::mlir::Op<RangeDatasetOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::TF::NoConstantFold> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RangeDatasetOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RangeDatasetOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("metadata"), ::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types"), ::llvm::StringRef("replicate_on_split")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMetadataAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMetadataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getReplicateOnSplitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getReplicateOnSplitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RangeDataset");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getStart() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getStop() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getStep() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getStartMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getStopMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getStepMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::StringAttr getMetadataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().metadata);
  }

  ::llvm::StringRef getMetadata();
  ::mlir::BoolAttr getReplicateOnSplitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().replicate_on_split);
  }

  bool getReplicateOnSplit();
  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  void setMetadataAttr(::mlir::StringAttr attr) {
    getProperties().metadata = attr;
  }

  void setMetadata(::std::optional<::llvm::StringRef> attrValue);
  void setReplicateOnSplitAttr(::mlir::BoolAttr attr) {
    getProperties().replicate_on_split = attr;
  }

  void setReplicateOnSplit(::std::optional<bool> attrValue);
  ::mlir::Attribute removeMetadataAttr() {
      auto attr = getProperties().metadata;
      getProperties().metadata = {};
      return attr;
  }

  ::mlir::Attribute removeReplicateOnSplitAttr() {
      auto attr = getProperties().replicate_on_split;
      getProperties().replicate_on_split = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value start, ::mlir::Value stop, ::mlir::Value step, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::StringAttr metadata, /*optional*/::mlir::BoolAttr replicate_on_split = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value start, ::mlir::Value stop, ::mlir::Value step, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::StringAttr metadata, /*optional*/::mlir::BoolAttr replicate_on_split = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value start, ::mlir::Value stop, ::mlir::Value step, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::llvm::StringRef metadata = "", /*optional*/bool replicate_on_split = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value start, ::mlir::Value stop, ::mlir::Value step, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::llvm::StringRef metadata = "", /*optional*/bool replicate_on_split = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RangeDatasetOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RangeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RangeOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RangeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Range", odsAttrs.getContext());
  }

  RangeOpGenericAdaptorBase(RangeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RangeOpGenericAdaptor : public detail::RangeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RangeOpGenericAdaptorBase;
public:
  RangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RangeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RangeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RangeOpGenericAdaptor(RangeT values, const RangeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RangeOp, typename = std::enable_if_t<std::is_same_v<LateInst, RangeOp>>>
  RangeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getStart() {
    return (*getODSOperands(0).begin());
  }

  ValueT getLimit() {
    return (*getODSOperands(1).begin());
  }

  ValueT getDelta() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RangeOpAdaptor : public RangeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RangeOpGenericAdaptor::RangeOpGenericAdaptor;
  RangeOpAdaptor(RangeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RangeOp : public ::mlir::Op<RangeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::TF::SameOperandsAndResultElementTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RangeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RangeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Tidx")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTidxAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTidxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Range");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getStart() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getLimit() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDelta() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getStartMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getLimitMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDeltaMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getTidx();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value start, Value limit, Value delta);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value start, ::mlir::Value limit, ::mlir::Value delta);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value start, ::mlir::Value limit, ::mlir::Value delta);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RangeOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RankOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RankOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RankOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Rank", odsAttrs.getContext());
  }

  RankOpGenericAdaptorBase(RankOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RankOpGenericAdaptor : public detail::RankOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RankOpGenericAdaptorBase;
public:
  RankOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RankOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RankOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RankOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RankOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RankOpGenericAdaptor(RangeT values, const RankOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RankOp, typename = std::enable_if_t<std::is_same_v<LateInst, RankOp>>>
  RankOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RankOpAdaptor : public RankOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RankOpGenericAdaptor::RankOpGenericAdaptor;
  RankOpAdaptor(RankOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RankOp : public ::mlir::Op<RankOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RankOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RankOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Rank");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value input);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RankOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ReadFileOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ReadFileOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ReadFileOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ReadFile", odsAttrs.getContext());
  }

  ReadFileOpGenericAdaptorBase(ReadFileOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ReadFileOpGenericAdaptor : public detail::ReadFileOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ReadFileOpGenericAdaptorBase;
public:
  ReadFileOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ReadFileOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ReadFileOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ReadFileOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ReadFileOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ReadFileOpGenericAdaptor(RangeT values, const ReadFileOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ReadFileOp, typename = std::enable_if_t<std::is_same_v<LateInst, ReadFileOp>>>
  ReadFileOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getFilename() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ReadFileOpAdaptor : public ReadFileOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ReadFileOpGenericAdaptor::ReadFileOpGenericAdaptor;
  ReadFileOpAdaptor(ReadFileOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ReadFileOp : public ::mlir::Op<ReadFileOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::TF::NoConstantFold> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ReadFileOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ReadFileOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ReadFile");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getFilename() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getFilenameMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getContents() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type contents, ::mlir::Value filename);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value filename);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ReadFileOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ReadVariableOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ReadVariableOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ReadVariableOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ReadVariableOp", odsAttrs.getContext());
  }

  ReadVariableOpGenericAdaptorBase(ReadVariableOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ReadVariableOpGenericAdaptor : public detail::ReadVariableOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ReadVariableOpGenericAdaptorBase;
public:
  ReadVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ReadVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ReadVariableOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ReadVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ReadVariableOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ReadVariableOpGenericAdaptor(RangeT values, const ReadVariableOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ReadVariableOp, typename = std::enable_if_t<std::is_same_v<LateInst, ReadVariableOp>>>
  ReadVariableOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getResource() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ReadVariableOpAdaptor : public ReadVariableOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ReadVariableOpGenericAdaptor::ReadVariableOpGenericAdaptor;
  ReadVariableOpAdaptor(ReadVariableOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ReadVariableOp : public ::mlir::Op<ReadVariableOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::DerivedAttributeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ReadVariableOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ReadVariableOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dtype")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ReadVariableOp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getResource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getResourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type value, ::mlir::Value resource);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value resource);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ReadVariableOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RealDivOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RealDivOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RealDivOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.RealDiv", odsAttrs.getContext());
  }

  RealDivOpGenericAdaptorBase(RealDivOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RealDivOpGenericAdaptor : public detail::RealDivOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RealDivOpGenericAdaptorBase;
public:
  RealDivOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RealDivOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RealDivOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RealDivOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RealDivOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RealDivOpGenericAdaptor(RangeT values, const RealDivOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RealDivOp, typename = std::enable_if_t<std::is_same_v<LateInst, RealDivOp>>>
  RealDivOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RealDivOpAdaptor : public RealDivOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RealDivOpGenericAdaptor::RealDivOpGenericAdaptor;
  RealDivOpAdaptor(RealDivOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RealDivOp : public ::mlir::Op<RealDivOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ResultsBroadcastableShape, ::mlir::OpTrait::TF::CwiseBinary, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RealDivOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RealDivOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.RealDiv");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value x, Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type z, ::mlir::Value x, ::mlir::Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::RealDivOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::RealOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RealOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RealOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Real", odsAttrs.getContext());
  }

  RealOpGenericAdaptorBase(RealOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class RealOpGenericAdaptor : public detail::RealOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RealOpGenericAdaptorBase;
public:
  RealOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RealOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RealOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RealOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RealOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RealOpGenericAdaptor(RangeT values, const RealOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RealOp, typename = std::enable_if_t<std::is_same_v<LateInst, RealOp>>>
  RealOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RealOpAdaptor : public RealOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RealOpGenericAdaptor::RealOpGenericAdaptor;
  RealOpAdaptor(RealOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RealOp : public ::mlir::Op<RealOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RealOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RealOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tout")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getToutAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getToutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Real");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  ::mlir::Type getTout();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  stati