from .. import Provider as JobProvider


class Provider(JobProvider):
    """
    Implement job provider for ``bn_BD`` locale.
    """

    jobs = (
        "একাডেমিক গ্রন্থাগারিক",
        "আবাসন ব্যবস্থাপক",
        "অ্যাকাউন্টেন্ট, চার্টার্ড",
        "অ্যাকাউন্টেন্ট, চার্টার্ড সার্টিফাইড",
        "অ্যাকাউন্টেন্ট, চার্টার্ড ম্যানেজমেন্ট",
        "অ্যাকাউন্টেন্ট, চার্টার্ড পাবলিক ফাইন্যান্স",
        "অ্যাকাউন্টিং টেকনিশিয়ান",
        "অভিনেতা",
        "অ্যাকচুরি",
        "আকুপাংচারিস্ট",
        "প্রশাসক",
        "প্রশাসক, কলা",
        "প্রশাসক, দাতব্য/স্বেচ্ছাসেবী সংস্থা",
        "প্রশাসক, সিভিল সার্ভিস",
        "প্রশাসক, শিক্ষা",
        "প্রশাসক, স্থানীয় সরকার",
        "প্রশাসক, ক্রীড়া",
        "প্রাপ্তবয়স্ক নির্দেশিকা কর্মী",
        "প্রাপ্তবয়স্ক নার্স",
        "বিজ্ঞাপন অ্যাকাউন্ট এক্সিকিউটিভ",
        "বিজ্ঞাপন অ্যাকাউন্ট পরিকল্পনাকারী",
        "বিজ্ঞাপন শিল্প পরিচালক",
        "বিজ্ঞাপন কপিরাইটার",
        "পরামর্শ কর্মী",
        "বৈমানিক প্রকৌশলী",
        "কৃষি পরামর্শক",
        "কৃষি প্রকৌশলী",
        "সহায়তা কর্মী",
        "এয়ার ব্রোকার",
        "এয়ার কেবিন ক্রু",
        "এয়ার ট্রাফিক কন্ট্রোলার",
        "এয়ারলাইন পাইলট",
        "অ্যাম্বুলেন্স ব্যক্তি",
        "সুবিধা উদ্যানতত্ত্ববিদ",
        "বিশ্লেষনমূলক রসায়নবিদ",
        "পশু পুষ্টিবিদ",
        "প্রাণী প্রযুক্তিবিদ",
        "অ্যানিমেটর",
        "অ্যাপ্লিকেশন ডেভেলপার",
        "আর্বোরিকালচারিস্ট",
        "প্রত্নতত্ত্ববিদ",
        "স্থপতি",
        "স্থাপত্য প্রযুক্তিবিদ",
        "আর্কাইভিস্ট",
        "সশস্ত্র বাহিনী লজিস্টিক/সাপোর্ট/প্রশাসনিক কর্মকর্তা",
        "সশস্ত্র বাহিনীর অপারেশনাল অফিসার",
        "সশস্ত্র বাহিনীর প্রযুক্তিগত কর্মকর্তা",
        "সশস্ত্র বাহিনীর প্রশিক্ষণ ও শিক্ষা অফিসার",
        "আর্ট গ্যালারি ম্যানেজার",
        "শিল্প থেরাপিস্ট",
        "শিল্পী",
        "কলা প্রশাসক",
        "কলা উন্নয়ন কর্মকর্তা",
        "সহযোগী অধ্যাপক",
        "জ্যোতির্বিজ্ঞানী",
        "অডিওলজিক্যাল সায়েন্টিস্ট",
        "অটোমোটিভ ইঞ্জিনিয়ার",
        "ব্যাঙ্কার",
        "বরিস্তা",
        "ব্যারিস্টার",
        "ব্যারিস্টার কেরানি",
        "সেরা ছেলে",
        "বায়োকেমিস্ট, ক্লিনিকাল",
        "বায়োমেডিকেল প্রকৌশলী",
        "বায়োমেডিকাল বিজ্ঞানী",
        "বন্ড ব্যবসায়ী",
        "পুস্তক বিক্রেতা",
        "ব্রুইং টেকনোলজিস্ট",
        "সম্প্রচার প্রকৌশলী",
        "সম্প্রচার সাংবাদিক",
        "সম্প্রচার উপস্থাপক",
        "বিল্ডিং কন্ট্রোল সার্ভেয়ার",
        "বিল্ডিং সার্ভিস ইঞ্জিনিয়ার",
        "বিল্ডিং সার্ভেয়ার",
        "ক্রেতা, শিল্প",
        "ক্রেতা, খুচরা",
        "কেবিনের নাবিক",
        "কল সেন্টার ম্যানেজার",
        "কেমেরা চালাক",
        "ক্যারিয়ার উপদেষ্টা",
        "ক্যারিয়ার ইনফরমেশন অফিসার",
        "মানচিত্রকার",
        "পরিবেশন ব্যবস্থাপক",
        "সিরামিক ডিজাইনার",
        "দাতব্য তহবিল সংগ্রহকারী",
        "চ্যারিটি অফিসার",
        "চার্টার্ড হিসাবরক্ষক",
        "চার্টার্ড সার্টিফাইড অ্যাকাউন্ট্যান্ট",
        "চার্টার্ড লিগ্যাল এক্সিকিউটিভ (ইংল্যান্ড এবং ওয়েলস)",
        "চার্টার্ড ক্ষতি সমন্বয়কারী",
        "চার্টার্ড ম্যানেজমেন্ট অ্যাকাউন্ট্যান্ট",
        "চার্টার্ড পাবলিক ফাইন্যান্স অ্যাকাউন্ট্যান্ট",
        "রাসায়নিক প্রকৌশলী",
        "রসায়নবিদ, বিশ্লেষণাত্মক",
        "প্রধান নির্বাহী কর্মকর্তা",
        "প্রধান অর্থনৈতিক কর্মকর্তা",
        "প্রধান বিপণন কর্মকর্তা",
        "বাহিনী প্রধান",
        "প্রধান পরিচালন কর্মকর্তা",
        "প্রধান কৌশল কর্মকর্তা",
        "মুখ্য প্রযুক্তিবিদ্যা অফিসার",
        "শিশু সাইকোথেরাপিস্ট",
        "চিরোপডিস্ট",
        "রোগ চিকিৎসা বিশেষ",
        "সিভিল ইঞ্জিনিয়ার, পরামর্শ",
        "সিভিল ইঞ্জিনিয়ার, কন্ট্রাক্টিং",
        "সিভিল সার্ভিস প্রশাসক",
        "সিভিল সার্ভিস ফাস্ট স্ট্রিমার",
        "দাবি পরিদর্শক/মূল্যায়নকারী",
        "ক্লিনিক্যাল বায়োকেমিস্ট",
        "ক্লিনিকাল সাইটোজেনেটিস্ট",
        "ক্লিনিকাল ভ্রূণ বিশেষজ্ঞ",
        "ক্লিনিকাল আণবিক জেনেটিসিস্ট",
        "ক্লিনিকাল মনোবৈজ্ঞানিক",
        "ক্লিনিক্যাল রিসার্চ অ্যাসোসিয়েট",
        "ক্লিনিক্যাল সায়েন্টিস্ট, হিস্টোকম্প্যাটিবিলিটি এবং ইমিউনোজেনেটিক্স",
        "পোশাক/টেক্সটাইল প্রযুক্তিবিদ",
        "রঙ প্রযুক্তিবিদ",
        "বাণিজ্যিক আর্ট গ্যালারি ম্যানেজার",
        "বাণিজ্যিক উদ্যানতত্ত্ববিদ",
        "বাণিজ্যিক/আবাসিক সার্ভেয়ার",
        "কমিশনিং এডিটর",
        "যোগাযোগ প্রকৌশলী",
        "সম্প্রদায়িক শিল্প কর্মী",
        "সমাজ উন্নয়ন কর্মী",
        "সম্প্রদায় শিক্ষা অফিসার",
        "কমিউনিটি ফার্মাসিস্ট",
        "কোম্পানি সচিব",
        "নিয়ন্ত্রক",
        "কম্পিউটার গেম ডেভেলপার",
        "কনফারেন্স সেন্টার ম্যানেজার",
        "সংরক্ষণ কর্মকর্তা, ঐতিহাসিক ভবন",
        "সংরক্ষণ কর্মকর্তা, প্রকৃতি",
        "সংরক্ষক, আসবাবপত্র",
        "সংরক্ষক, জাদুঘর/গ্যালারি",
        "পরামর্শ সিভিল ইঞ্জিনিয়ার",
        "কন্ট্রাক্টিং সিভিল ইঞ্জিনিয়ার",
        "ঠিকাদার",
        "নিয়ন্ত্রণ এবং যন্ত্র প্রকৌশলী",
        "কপি",
        "কপিরাইটার, বিজ্ঞাপন",
        "কর্পোরেট ইনভেস্টমেন্ট ব্যাংকার",
        "কর্পোরেট কোষাধ্যক্ষ",
        "কাউন্সেলিং সাইকোলজিস্ট",
        "কাউন্সেলর",
        "কিউরেটর",
        "গ্রাহক পরিষেবা ব্যবস্থাপক",
        "সাইটোজেনেটিসিস্ট",
        "নৃত্য আন্দোলনের সাইকোথেরাপিস্ট",
        "নর্তকী",
        "ডেটা প্রসেসিং ম্যানেজার",
        "তথ্য বিজ্ঞানী",
        "ডাটাবেস প্রশাসক",
        "বিক্রেতা",
        "দন্ত চিকিৎসক",
        "ডিজাইনার, প্রস্ফুটিত কাচ/দাগযুক্ত কাচ",
        "ডিজাইনার, সিরামিক/মৃৎপাত্র",
        "ডিজাইনার, প্রদর্শনী/ডিসপ্লে",
        "ডিজাইনার, ফ্যাশন/পোশাক",
        "ডিজাইনার, আসবাবপত্র",
        "ডিজাইনার, গ্রাফিক",
        "ডিজাইনার, শিল্প/পণ্য",
        "ডিজাইনার, অভ্যন্তরীণ/স্থানিক",
        "ডিজাইনার, গহনা",
        "ডিজাইনার, মাল্টিমিডিয়া",
        "ডিজাইনার, টেলিভিশন/ফিল্ম সেট",
        "ডিজাইনার, টেক্সটাইল",
        "উন্নয়নকর্মী, সম্প্রদায়",
        "উন্নয়ন কর্মী, আন্তর্জাতিক সাহায্য",
        "ডায়াগনস্টিক রেডিওগ্রাফার",
        "আহার বিশেষজ্ঞ",
        "কূটনৈতিক সার্ভিস অপারেশনাল অফিসার",
        "ডিসপেন্সিং অপটিশিয়ান",
        "ডাক্তার, সাধারণ অনুশীলন",
        "ডাক্তার, হাসপাতাল",
        "নাট্য থেরাপিস্ট",
        "তুরপুন প্রকৌশলী",
        "প্রাথমিক বছরের শিক্ষক",
        "বাস্তু বিশেষজ্ঞ",
        "অর্থনীতিবিদ",
        "সম্পাদক, কমিশনিং",
        "সম্পাদক, ফিল্ম/ভিডিও",
        "সম্পাদক, পত্রিকার বৈশিষ্ট্য",
        "সম্পাদকীয় সহকারী",
        "শিক্ষা প্রশাসক",
        "শিক্ষা কর্মকর্তা, সম্প্রদায়",
        "শিক্ষা কর্মকর্তা, পরিবেশ",
        "শিক্ষা কর্মকর্তা, জাদুঘর",
        "শিক্ষামূলক মনোবিজ্ঞানী",
        "তড়িৎ প্রকৌশলী",
        "ইলেকট্রনিক্স প্রকৌশলী",
        "ভ্রুণ বিশেষজ্ঞ, ক্লিনিকাল",
        "জরুরি পরিকল্পনা/ব্যবস্থাপনা কর্মকর্তা",
        "শক্তি প্রকৌশলী",
        "শক্তি ব্যবস্থাপক",
        "ইঞ্জিনিয়ার, অ্যারোনটিক্যাল",
        "প্রকৌশলী, কৃষি",
        "ইঞ্জিনিয়ার, স্বয়ংচালিত",
        "প্রকৌশলী, বায়োমেডিকেল",
        "প্রকৌশলী, সম্প্রচার (অপারেশন)",
        "প্রকৌশলী, বিল্ডিং পরিষেবা",
        "প্রকৌশলী, রাসায়নিক",
        "প্রকৌশলী, সিভিল (পরামর্শ)",
        "প্রকৌশলী, সিভিল (চুক্তি)",
        "প্রকৌশলী, যোগাযোগ",
        "প্রকৌশলী, নিয়ন্ত্রণ এবং উপকরণ",
        "ইঞ্জিনিয়ার, ড্রিলিং",
        "প্রকৌশলী, বৈদ্যুতিক",
        "প্রকৌশলী, ইলেকট্রনিক্স",
        "প্রকৌশলী, শক্তি",
        "প্রকৌশলী, জমি",
        "প্রকৌশলী, রক্ষণাবেক্ষণ",
        "প্রকৌশলী, রক্ষণাবেক্ষণ (আইটি)",
        "ইঞ্জিনিয়ার, ম্যানুফ্যাকচারিং",
        "ইঞ্জিনিয়ার, ম্যানুফ্যাকচারিং সিস্টেম",
        "প্রকৌশলী, উপকরণ",
        "ইঞ্জিনিয়ার, মাইনিং",
        "প্রকৌশলী, পেট্রোলিয়াম",
        "প্রকৌশলী, উৎপাদন",
        "ইঞ্জিনিয়ার, সাইট",
        "প্রকৌশলী, কাঠামোগত",
        "প্রকৌশলী, প্রযুক্তিগত বিক্রয়",
        "প্রকৌশলী, জল",
        "প্রকৌশলী ভূতত্ত্ববিদ",
        "বিদেশী ভাষার শিক্ষক হিসাবে ইংরেজি",
        "দ্বিতীয় ভাষার শিক্ষক হিসাবে ইংরেজি",
        "পরিবেশ পরামর্শক",
        "পরিবেশ শিক্ষা কর্মকর্তা",
        "পরিবেশগত স্বাস্থ্য অনুশীলনকারী",
        "পরিবেশ ব্যবস্থাপক",
        "সমতা এবং বৈচিত্র্য কর্মকর্তা",
        "ইকুইটি ব্যবসায়ী",
        "এরগনোমিস্ট",
        "এস্টেট এজেন্ট",
        "এস্টেট ম্যানেজার/ল্যান্ড এজেন্ট",
        "ইভেন্ট সংগঠক",
        "ব্যায়াম ফিজিওলজিস্ট",
        "প্রদর্শনী ডিজাইনার",
        "প্রদর্শনী অফিসার, জাদুঘর/গ্যালারি",
        "সুবিধা ম্যানেজার",
        "খামার ব্যবস্থাপক",
        "ফ্যাশান ডিজাইনার",
        "ফাস্ট ফুড রেস্টুরেন্ট ম্যানেজার",
        "ক্ষেত্র সিসমোলজিস্ট",
        "ফিল্ড ট্রায়াল অফিসার",
        "চলচ্চিত্র/ভিডিও সম্পাদক",
        "একটি বন্ধু পূর্ণ নাম লিখুন",
        "আর্থিক নিয়ন্ত্রক",
        "অর্থনৈতিক ব্যবস্থাপক",
        "আর্থিক পরিকল্পক",
        "আর্থিক ঝুঁকি বিশ্লেষক",
        "আর্থিক ব্যবসায়ী",
        "ভালো শিল্পী",
        "অগ্নিনির্বাপক",
        "মাছ খামার ম্যানেজার",
        "মৎস্য কর্মকর্তা",
        "ফিটনেস সেন্টার ম্যানেজার",
        "খাদ্য প্রযুক্তিবিদ",
        "ফরেন্সিক সাইকোলজিস্ট",
        "ফরেনসিক বিজ্ঞানী",
        "বন/উডল্যান্ড ম্যানেজার",
        "মালবাহী ফরওয়ার্ডার",
        "আসবাব সংরক্ষণকারী/পুনরুদ্ধারকারী",
        "ফার্নিচার ডিজাইনার",
        "আরো শিক্ষার প্রভাষক",
        "ফিউচার ট্রেডার",
        "গফার",
        "গেমস ডেভেলপার",
        "গার্মেন্টস/টেক্সটাইল টেকনোলজিস্ট",
        "সাধারণ অনুশীলন ডাক্তার",
        "জেনেটিসিস্ট, আণবিক",
        "জিওকেমিস্ট",
        "ভৌগলিক তথ্য সিস্টেম অফিসার",
        "ভূতত্ত্ববিদ, প্রকৌশল",
        "ভূতত্ত্ববিদ, ওয়েলসাইট",
        "জিওফিজিক্যাল ডেটা প্রসেসর",
        "জিওফিজিসিস্ট/ফিল্ড সিসমোলজিস্ট",
        "ভূ-বিজ্ঞানী",
        "গ্লাস ব্লোয়ার/ডিজাইনার",
        "সরকারি সামাজিক গবেষণা কর্মকর্তা",
        "গ্রাফিক ডিজাইনার",
        "হেমাটোলজিস্ট",
        "স্বাস্থ্য ও নিরাপত্তা উপদেষ্টা",
        "স্বাস্থ্য ও নিরাপত্তা পরিদর্শক",
        "স্বাস্থ্য পদার্থবিদ",
        "স্বাস্থ্য প্রচার বিশেষজ্ঞ",
        "স্বাস্থ্য পরিষেবা ব্যবস্থাপক",
        "স্বাস্থ্য পরিদর্শক",
        "ভেষজবিদ",
        "হেরিটেজ ম্যানেজার",
        "হারপেটোলজিস্ট",
        "উচ্চ শিক্ষা ক্যারিয়ার উপদেষ্টা",
        "উচ্চ শিক্ষার প্রভাষক",
        "ঐতিহাসিক ভবন পরিদর্শক/সংরক্ষণ কর্মকর্তা",
        "ছুটির প্রতিনিধি",
        "হোমিওপ্যাথ",
        "হর্টিকালচারাল কনসালট্যান্ট",
        "হর্টিকালচারাল থেরাপিস্ট",
        "হর্টিকালচারিস্ট, সুবিধা",
        "হর্টিকালচারিস্ট, বাণিজ্যিক",
        "হাসপাতাল ডাক্তার",
        "হাসপাতাল ফার্মাসিস্ট",
        "হোটেল ব্যবস্থাপক",
        "হাউজিং ম্যানেজার/অফিসার",
        "মানব সম্পদ উন্নয়ন কর্মকর্তা",
        "হাইড্রোজোলজিস্ট",
        "হাইড্রোগ্রাফিক সার্ভেয়ার",
        "জলবিদ",
        "ইলাস্ট্রেটর",
        "অভিবাসন কর্মকর্তা",
        "ইমিউনোলজিস্ট",
        "শিল্প ক্রেতা",
        "শিল্প/পণ্য ডিজাইনার",
        "তথ্য কর্মকর্তা",
        "তথ্য সিস্টেম ম্যানেজার",
        "বীমা অ্যাকাউন্ট ম্যানেজার",
        "বীমা ব্রোকার",
        "বীমা দাবির হ্যান্ডলার",
        "বীমা ঝুঁকি সার্ভেয়ার",
        "বীমা আন্ডাররাইটার",
        "গোয়েন্দা বিশ্লেষক",
        "অভ্যন্তরীণ এবং স্থানিক ডিজাইনার",
        "আন্তর্জাতিক সাহায্য/উন্নয়ন কর্মী",
        "দোভাষী",
        "বিনিয়োগ বিশ্লেষক",
        "বিনিয়োগ ব্যাংকার, কর্পোরেট",
        "বিনিয়োগ ব্যাংকার, অপারেশনাল",
        "তথ্য ও প্রযুক্তি বিশেষজ্ঞ",
        "আইটি বিক্রয় পেশাদার",
        "আইটি প্রযুক্তিগত সহায়তা কর্মকর্তা",
        "আইটি প্রশিক্ষক",
        "গহনা ডিজাইনার",
        "সাংবাদিক, সম্প্রচার",
        "সাংবাদিক, পত্রিকা",
        "সাংবাদিক, সংবাদপত্র",
        "ভূমি",
        "ভূমি/ভৌমিক জরিপকারী",
        "আড়াআড়ি স্থপতি",
        "আইনজীবী",
        "লার্নিং অক্ষমতা নার্স",
        "শিক্ষার পরামর্শদাতা",
        "প্রভাষক, আরও শিক্ষা",
        "প্রভাষক, উচ্চ শিক্ষা",
        "আইনি নির্বাহী",
        "আইনি সচিব",
        "অবসর কেন্দ্রের ব্যবস্থাপক",
        "লেক্সিকোগ্রাফার",
        "গ্রন্থাগারিক, একাডেমিক",
        "লাইব্রেরিয়ান, পাবলিক",
        "লাইসেন্সপ্রাপ্ত পরিবাহক",
        "লাইটিং টেকনিশিয়ান, ব্রডকাস্টিং/ফিল্ম/ভিডিও",
        "লবিস্ট",
        "স্থানীয় সরকার কর্মকর্তা",
        "অবস্থান ম্যানেজার",
        "লজিস্টিক এবং ডিস্ট্রিবিউশন ম্যানেজার",
        "লস সমন্বয়কারী, চার্টার্ড",
        "পত্রিকা বৈশিষ্ট্য সম্পাদক",
        "ম্যাগাজিন সাংবাদিক",
        "রক্ষণাবেক্ষণ প্রকৌশলী",
        "বানান",
        "ব্যবস্থাপনা পরামর্শক",
        "ম্যানুফ্যাকচারিং ইঞ্জিনিয়ার",
        "উৎপাদন সিস্টেম ইঞ্জিনিয়ার",
        "সামুদ্রিক বিজ্ঞানী",
        "বাজার গবেষক",
        "বিপণন নির্বাহী",
        "পদার্থ প্রকৌশলী",
        "যন্ত্র কৌশলী",
        "মিডিয়া ক্রেতা",
        "মিডিয়া পরিকল্পনাকারী",
        "চিকিৎসা চিত্রকর",
        "চিকিৎসা পরীক্ষাগার বৈজ্ঞানিক কর্মকর্তা",
        "চিকিৎসা পদার্থবিদ",
        "চিকিৎসা বিক্রয় প্রতিনিধি",
        "চিকিৎসা সচিব",
        "মেডিকেল টেকনিক্যাল অফিসার",
        "মানসিক স্বাস্থ্য সেবিকা",
        "মার্চেন্ডাইজার, খুচরা",
        "মার্চেন্ট নেভি অফিসার",
        "ধাতুবিদ",
        "আবহাওয়াবিদ",
        "মাইক্রোবায়োলজিস্ট",
        "ধাত্রী",
        "খনিজ জরিপকারী",
        "খনি প্রকৌশলী",
        "মাডলগার",
        "মাল্টিমিডিয়া প্রোগ্রামার",
        "মাল্টিমিডিয়া বিশেষজ্ঞ",
        "জাদুঘর শিক্ষা অফিসার",
        "জাদুঘর/গ্যালারি সংরক্ষক",
        "জাদুঘর/গ্যালারি কিউরেটর",
        "জাদুঘর/গ্যালারি প্রদর্শনী কর্মকর্তা",
        "মিউজিক থেরাপিস্ট",
        "সঙ্গীত শিক্ষক",
        "সঙ্গীতশিল্পী",
        "প্রকৃতি সংরক্ষণ কর্মকর্তা",
        "নৌ - স্থপতি",
        "নেটওয়ার্ক ইঞ্জিনিয়ার",
        "নিউরোসার্জন",
        "সংবাদপত্রের সাংবাদিক",
        "নার্স, প্রাপ্তবয়স্ক",
        "নার্স, বাচ্চাদের",
        "নার্স, শেখার অক্ষমতা",
        "নার্স, মানসিক স্বাস্থ্য",
        "পুষ্টি থেরাপিস্ট",
        "পেশাগত স্বাস্থ্যবিদ",
        "পেশাগত মনোবিজ্ঞানী",
        "অকুপেশনাল থেরাপিস্ট",
        "সমুদ্রবিদ",
        "অফিস ব্যবস্থাপক",
        "অনকোলজিস্ট",
        "অপারেশনাল ইনভেস্টমেন্ট ব্যাংকার",
        "অপারেশনাল গবেষক",
        "অপারেশনস জিওলজিস্ট",
        "চক্ষু বিশেষজ্ঞ",
        "চক্ষু বিশেষজ্ঞ, বিতরণ",
        "চক্ষু বিশেষজ্ঞ",
        "অর্থোপটিস্ট",
        "অস্টিওপ্যাথ",
        "বাইরের কার্যক্রম/শিক্ষা ব্যবস্থাপক",
        "পেডিয়াট্রিক নার্স",
        "প্যারামেডিক",
        "যাত্রী পরিবহন ব্যবস্থাপক",
        "পেটেন্ট অ্যাটর্নি",
        "পেটেন্ট পরীক্ষক",
        "প্যাথলজিস্ট",
        "পেনশন স্কিম ম্যানেজার",
        "পেনশন পরামর্শক",
        "ব্যক্তিগত সহকারী",
        "নিজের অফিসার",
        "পেট্রোলিয়াম প্রকৌশলী",
        "ফার্মাসিস্ট, সম্প্রদায়",
        "ফার্মাসিস্ট, হাসপাতাল",
        "ফার্মাকোলজিস্ট",
        "ফটোগ্রাফার",
        "পদার্থবিদ, চিকিৎসা",
        "শারীরবৃত্তীয় বিজ্ঞানী",
        "ফিজিওথেরাপিস্ট",
        "ফাইটোথেরাপিস্ট",
        "পাইলট, এয়ারলাইন",
        "পরিকল্পনা ও উন্নয়ন সার্ভেয়ার",
        "উদ্ভিদ প্রজননকারী/জিনতত্ত্ববিদ",
        "পডিয়াট্রিস্ট",
        "পুলিশ অফিসার",
        "রাজনীতিবিদ সহকারী",
        "উপস্থাপক, সম্প্রচার",
        "ফটো সাংবাদিক",
        "প্রেস সাব",
        "প্রাথমিক স্কুল শিক্ষক",
        "প্রিন্ট প্রোডাকশন প্ল্যানার",
        "প্রিন্টমেকার",
        "কারাগার অফিসার",
        "বেসরকারী সঙ্গীত শিক্ষক",
        "পরিদর্শক",
        "প্রযোজক, রেডিও",
        "প্রযোজক, টেলিভিশন/ফিল্ম/ভিডিও",
        "পণ্য ডিজাইনার",
        "পণ্য ব্যবস্থাপক",
        "পণ্য/প্রক্রিয়া উন্নয়ন বিজ্ঞানী",
        "উৎপাদন সহকারী, রেডিও",
        "প্রযোজনা সহকারী, টেলিভিশন",
        "প্রযোজনা ডিজাইনার, থিয়েটার/টেলিভিশন/ফিল্ম",
        "উৎপাদন প্রকৌশলী",
        "উৎপাদন ব্যবস্থাপক",
        "অধ্যাপক এমেরিটাস",
        "প্রোগ্রাম গবেষক, সম্প্রচার/ফিল্ম/ভিডিও",
        "প্রোগ্রামার, অ্যাপ্লিকেশন",
        "প্রোগ্রামার, মাল্টিমিডিয়া",
        "প্রোগ্রামার, সিস্টেম",
        "প্রুফরিডার",
        "সাইকিয়াট্রিক নার্স",
        "সাইকিয়াট্রিস্ট",
        "মনোবিজ্ঞানী, ক্লিনিকাল",
        "মনোবিজ্ঞানী, কাউন্সেলিং",
        "মনোবিজ্ঞানী, শিক্ষামূলক",
        "মনোবিজ্ঞানী, ফরেনসিক",
        "মনোবিজ্ঞানী, পেশাগত",
        "মনোবিজ্ঞানী, কারাগার এবং প্রবেশন পরিষেবা",
        "মনোবিজ্ঞানী, খেলাধুলা এবং ব্যায়াম",
        "সাইকোথেরাপিস্ট",
        "সাইকোথেরাপিস্ট, শিশু",
        "সাইকোথেরাপিস্ট, নাচের আন্দোলন",
        "পাবলিক অ্যাফেয়ার্স কনসালটেন্ট",
        "পাবলিক হাউস ম্যানেজার",
        "পাবলিক লাইব্রেরিয়ান",
        "জনসংযোগ অ্যাকাউন্ট এক্সিকিউটিভ",
        "জনসংযোগ কর্মকর্তা",
        "প্রকাশিত অনুলিপি",
        "পাবলিশিং রাইট ম্যানেজার",
        "ক্রয় ব্যবস্থাপক",
        "গুনগতমান ব্যবস্থাপক",
        "পরিমাণ পরিমাপক",
        "কোয়ারি ম্যানেজার",
        "জাতি সম্পর্ক অফিসার",
        "বিকিরণ সুরক্ষা অনুশীলনকারী",
        "রেডিও সম্প্রচার সহকারী",
        "রেডিও প্রযোজক",
        "রেডিওগ্রাফার, ডায়াগনস্টিক",
        "রেডিওগ্রাফার, থেরাপিউটিক",
        "রেঞ্জার/ওয়ার্ডেন",
        "রেকর্ড ম্যানেজার",
        "নিয়োগ পরামর্শদাতা",
        "রিসাইক্লিং অফিসার",
        "নিয়ন্ত্রক বিষয়ক কর্মকর্তা",
        "গবেষণা কর্মকর্তা, সরকার",
        "গবেষণা কর্মকর্তা, রাজনৈতিক দল",
        "গবেষণা কর্মকর্তা, ট্রেড ইউনিয়ন",
        "গবেষণা বিজ্ঞানী (জীবন বিজ্ঞান)",
        "গবেষণা বিজ্ঞানী (গণিত)",
        "গবেষণা বিজ্ঞানী (চিকিৎসা)",
        "গবেষণা বিজ্ঞানী (শারীরিক বিজ্ঞান)",
        "রেস্টুরেন্ট ম্যানেজার",
        "রেস্তোরাঁর ম্যানেজার, ফাস্ট ফুড",
        "খুচরা ব্যাংকার",
        "খুচরা ক্রেতা",
        "খুচরা পরিচালক",
        "খুচরা মার্চেন্ডাইজার",
        "ঝুঁকি বিশ্লেষক",
        "ঝুকি ব্যাবস্থাপক",
        "রানার, সম্প্রচার/ফিল্ম/ভিডিও",
        "পল্লী অনুশীলন সার্ভেয়ার",
        "সেলস এক্সিকিউটিভ",
        "বিক্রয় পেশাদার, আইটি",
        "সেলস প্রমোশন অ্যাকাউন্ট এক্সিকিউটিভ",
        "বিজ্ঞান লেখক",
        "বৈজ্ঞানিক পরীক্ষাগার প্রযুক্তিবিদ",
        "বিজ্ঞানী, অডিওলজিক্যাল",
        "বিজ্ঞানী, বায়োমেডিকাল",
        "বিজ্ঞানী, ক্লিনিকাল (হিস্টোকম্প্যাটিবিলিটি এবং ইমিউনোজেনেটিক্স)",
        "বিজ্ঞানী, ফরেনসিক",
        "বিজ্ঞানী, সামুদ্রিক",
        "বিজ্ঞানী, শারীরবৃত্তীয়",
        "বিজ্ঞানী, পণ্য/প্রক্রিয়া উন্নয়ন",
        "বিজ্ঞানী, গবেষণা (জীবন বিজ্ঞান)",
        "বিজ্ঞানী, গবেষণা (গণিত)",
        "বিজ্ঞানী, গবেষণা (চিকিৎসা)",
        "বিজ্ঞানী, গবেষণা (ভৌত বিজ্ঞান)",
        "বিজ্ঞানী, জলের গুণমান",
        "মাধ্যমিক বিদ্যালয়ের শিক্ষক",
        "সচিব/প্রশাসক",
        "সচিব, কোম্পানি",
        "সিসমিক ইন্টারপ্রেটার",
        "সিনিয়র ট্যাক্স পেশাদার/কর পরিদর্শক",
        "সেট ডিজাইনার",
        "জাহাজ ব্রোকার",
        "প্রকল্প প্রকৌশলী",
        "সামাজিক গবেষণা কর্মকর্তা, সরকার",
        "সমাজ গবেষক",
        "সমাজ কর্মী",
        "সফটওয়্যার ইঞ্জিনিয়ার",
        "মৃত্তিকা বিজ্ঞানী",
        "উকিল",
        "সলিসিটর, স্কটল্যান্ড",
        "সাউন্ড টেকনিশিয়ান, ব্রডকাস্টিং/ফিল্ম/ভিডিও",
        "বিশেষ শিক্ষাগত প্রয়োজন শিক্ষক",
        "বিশেষ প্রভাব শিল্পী",
        "স্পিচ অ্যান্ড ল্যাঙ্গুয়েজ থেরাপিস্ট",
        "ক্রীড়া এবং ব্যায়াম মনোবিজ্ঞানী",
        "ক্রীড়া প্রশাসক",
        "ক্রীড়াশিক্ষক",
        "ক্রীড়া উন্নয়ন কর্মকর্তা",
        "ক্রীড়া থেরাপিস্ট",
        "পর্যায় ম্যানেজার",
        "পরিসংখ্যানবিদ",
        "স্ট্রাকচারাল ইঞ্জিনিয়ার",
        "সাব",
        "সার্জন",
        "জরিপকারী, বিল্ডিং",
        "সার্ভেয়ার, বিল্ডিং কন্ট্রোল",
        "সার্ভেয়ার, বাণিজ্যিক/আবাসিক",
        "জরিপকারী, হাইড্রোগ্রাফিক",
        "জরিপকারী, বীমা",
        "জরিপকারী, ভূমি/জিওম্যাটিক্স",
        "জরিপকারী, খনিজ",
        "জরিপকারী, খনির",
        "জরিপকারী, পরিকল্পনা ও উন্নয়ন",
        "জরিপকারী, পরিমাণ",
        "জরিপকারী, গ্রামীণ অনুশীলন",
        "সিস্টেম বিশ্লেষক",
        "সিস্টেম ডেভেলপার",
        "কর উপদেষ্টা",
        "কর পরিদর্শক",
        "শিক্ষক, বয়স্ক শিক্ষা",
        "শিক্ষক, প্রারম্ভিক বছর / প্রাক",
        "শিক্ষক, ইংরেজি একটি বিদেশী ভাষা হিসাবে",
        "শিক্ষক, সঙ্গীত",
        "শিক্ষক, প্রাথমিক বিদ্যালয়",
        "শিক্ষক, মাধ্যমিক বিদ্যালয়",
        "শিক্ষক, বিশেষ শিক্ষাগত প্রয়োজন",
        "পড়ানো ল্যাবরেটরি টেকনিশিয়ান",
        "প্রযুক্তিগত লেখক",
        "প্রযুক্তিগত ব্রুয়ার",
        "প্রযুক্তিগত বিক্রয় প্রকৌশলী",
        "টিইএফএল শিক্ষক",
        "টেলিযোগাযোগ গবেষক",
        "টেলিভিশন ক্যামেরা অপারেটর",
        "টেলিভিশন ফ্লোর ম্যানেজার",
        "টেলিভিশন প্রযোজনা সহকারী",
        "টেলিভিশন/ফিল্ম/ভিডিও প্রযোজক",
        "টেক্সটাইল ডিজাইনার",
        "থিয়েটার ডিরেক্টর",
        "থিয়েটার ম্যানেজার",
        "থিয়েটার স্টেজ ম্যানেজার",
        "থিম পার্ক ম্যানেজার",
        "থেরাপিউটিক রেডিওগ্রাফার",
        "থেরাপিস্ট, শিল্প",
        "থেরাপিস্ট, নাটক",
        "থেরাপিস্ট, উদ্যানবিদ্যা",
        "থেরাপিস্ট, সঙ্গীত",
        "থেরাপিস্ট, পুষ্টি",
        "থেরাপিস্ট, পেশাগত",
        "থেরাপিস্ট, বক্তৃতা এবং ভাষা",
        "থেরাপিস্ট, খেলাধুলা",
        "ট্যুর ব্যবস্থাপক",
        "পর্যটন কর্মকর্তা",
        "পর্যটন তথ্য কেন্দ্র ব্যবস্থাপক",
        "শহর পরিকল্পনাকারী",
        "বিষাক্ত বিশেষজ্ঞ",
        "ট্রেড মার্ক অ্যাটর্নি",
        "ট্রেড ইউনিয়ন গবেষণা কর্মকর্তা",
        "ট্রেডিং স্ট্যান্ডার্ড অফিসার",
        "প্রশিক্ষণ ও উন্নয়ন কর্মকর্তা",
        "অনুবাদক",
        "পরিবহন পরিকল্পনাকারী",
        "ট্রাভেল এজেন্সি ম্যানেজার",
        "বৃক্ষ সার্জন",
        "পশুচিকিৎসক",
        "ভিডিও এডিটর",
        "ভিজ্যুয়াল মার্চেন্ডাইজার",
        "স্বেচ্ছাসেবক সমন্বয়কারী",
        "ওয়ার্ডেন/রেঞ্জার",
        "গুদাম ম্যানেজার",
        "বর্জ্য ব্যবস্থাপনা কর্মকর্তা",
        "জল প্রকৌশলী",
        "পানির গুণমান বিজ্ঞানী",
        "ওয়েব ডিজাইনার",
        "ওয়েলসাইট ভূতত্ত্ববিদ",
        "লেখক",
        "যুবকর্মী",
    )
