/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.ide.navigationToolbar.rider.RiderMainToolbarStateListener;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetSettings;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.git.shared.GitDisplayName;
import com.intellij.vcs.git.shared.branch.GitInOutCountersInProject;
import com.intellij.vcs.git.shared.branch.GitInOutStateKt;
import git4idea.GitBranchesUsageCollector;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.BranchIconUtil;
import git4idea.ui.branch.popup.GitBranchesTreePopupOnBackend;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001e\u001f !B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\fH\u0014J\u0019\u0010\u001c\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0014\u00a8\u0006\""}, d2={"Lgit4idea/ui/branch/GitBranchWidget;", "Lcom/intellij/dvcs/ui/DvcsStatusWidget;", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "registerCustomListeners", "", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "ID", "", "copy", "Lcom/intellij/openapi/wm/StatusBarWidget;", "guessCurrentRepository", "selectedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getIcon", "Ljavax/swing/Icon;", "repository", "getFullBranchName", "isMultiRoot", "", "getWidgetPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "rememberRecentRoot", "path", "getToolTip", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "Listener", "SettingsListener", "Factory", "MyRiderMainToolbarStateListener", "intellij.vcs.git"})
public class GitBranchWidget
extends DvcsStatusWidget<GitRepository> {
    public GitBranchWidget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, GitDisplayName.NAME);
    }

    protected void registerCustomListeners(@NotNull MessageBusConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super.registerCustomListeners(connection);
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic, arg_0 -> GitBranchWidget.registerCustomListeners$lambda$0(this, arg_0));
        Topic<GitBranchIncomingOutgoingManager.GitIncomingOutgoingListener> topic2 = GitBranchIncomingOutgoingManager.GIT_INCOMING_OUTGOING_CHANGED;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"GIT_INCOMING_OUTGOING_CHANGED");
        connection.subscribe(topic2, () -> GitBranchWidget.registerCustomListeners$lambda$1(this));
    }

    @NotNull
    public String ID() {
        return "git";
    }

    @NotNull
    public StatusBarWidget copy() {
        return (StatusBarWidget)new GitBranchWidget(this.getProject());
    }

    @Nullable
    protected GitRepository guessCurrentRepository(@NotNull Project project, @Nullable VirtualFile selectedFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GitBranchUtil.guessWidgetRepository(project, selectedFile);
    }

    @NotNull
    protected Icon getIcon(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        return BranchIconUtil.Companion.getBranchIcon(repository2);
    }

    @NotNull
    protected String getFullBranchName(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        String string = GitBranchUtil.getDisplayableBranchText(repository2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayableBranchText(...)");
        return string;
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !GitUtil.justOneGitRepository(project);
    }

    @NotNull
    protected JBPopup getWidgetPopup(@NotNull Project project, @NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        GitBranchesUsageCollector.branchWidgetClicked();
        return GitBranchesTreePopupOnBackend.create(project, repository2);
    }

    protected void rememberRecentRoot(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GitVcsSettings.getInstance(this.getProject()).setRecentRoot(path);
    }

    @Nullable
    protected String getToolTip(@Nullable GitRepository repository2) {
        String string;
        if (repository2 != null && repository2.getState() == Repository.State.DETACHED) {
            string = GitBundle.message("git.status.bar.widget.tooltip.detached", new Object[0]);
        } else {
            if (repository2 == null) {
                return null;
            }
            String string2 = super.getToolTip((Repository)repository2);
            if (string2 == null) {
                return null;
            }
            String toolTip = string2;
            HtmlBuilder htmlBuilder = new HtmlBuilder().append(toolTip);
            GitLocalBranch gitLocalBranch = repository2.getCurrentBranch();
            if (gitLocalBranch == null) {
                return htmlBuilder.toString();
            }
            GitLocalBranch currentBranch = gitLocalBranch;
            GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)gitBranchIncomingOutgoingManager, (String)"getInstance(...)");
            GitBranchIncomingOutgoingManager incomingOutgoingManager = gitBranchIncomingOutgoingManager;
            GitInOutCountersInProject gitInOutCountersInProject = incomingOutgoingManager.getIncomingOutgoingState(repository2, currentBranch);
            Intrinsics.checkNotNullExpressionValue((Object)gitInOutCountersInProject, (String)"getIncomingOutgoingState(...)");
            GitInOutCountersInProject incomingOutgoingState = gitInOutCountersInProject;
            String incomingOutgoingTooltip = GitInOutStateKt.calcTooltip(incomingOutgoingState);
            if (incomingOutgoingTooltip != null) {
                htmlBuilder.br();
                htmlBuilder.appendRaw(incomingOutgoingTooltip);
            }
            string = htmlBuilder.toString();
        }
        return string;
    }

    private static final void registerCustomListeners$lambda$0(GitBranchWidget this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateLater();
    }

    private static final void registerCustomListeners$lambda$1(GitBranchWidget this$0) {
        this$0.updateLater();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/ui/branch/GitBranchWidget$Factory;", "Lcom/intellij/openapi/wm/StatusBarWidgetFactory;", "<init>", "()V", "getId", "", "getDisplayName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "createWidget", "Lcom/intellij/openapi/wm/StatusBarWidget;", "isEnabledByDefault", "intellij.vcs.git"})
    public static final class Factory
    implements StatusBarWidgetFactory {
        @NotNull
        public String getId() {
            return "git";
        }

        @NotNull
        public String getDisplayName() {
            String string = GitBundle.message("git.status.bar.widget.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean isAvailable(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (ExperimentalUI.Companion.isNewUI() || this.isEnabledByDefault()) && !GitRepositoryManager.getInstance(project).getRepositories().isEmpty();
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (StatusBarWidget)new GitBranchWidget(project);
        }

        public boolean isEnabledByDefault() {
            if (ExperimentalUI.Companion.isNewUI()) {
                return !UISettings.Companion.getInstance().getShowNewMainToolbar();
            }
            ToolbarSettings toolbarSettings = ToolbarSettings.Companion.getInstance();
            return !toolbarSettings.isVisible() || !toolbarSettings.isAvailable();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/GitBranchWidget$Listener;", "Lcom/intellij/dvcs/repo/VcsRepositoryMappingListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "mappingChanged", "", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitBranchWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchWidget.kt\ngit4idea/ui/branch/GitBranchWidget$Listener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,148:1\n30#2,2:149\n*S KotlinDebug\n*F\n+ 1 GitBranchWidget.kt\ngit4idea/ui/branch/GitBranchWidget$Listener\n*L\n101#1:149,2\n*E\n"})
    public static final class Listener
    implements VcsRepositoryMappingListener {
        @NotNull
        private final Project project;

        public Listener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void mappingChanged() {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<StatusBarWidgetsManager> serviceClass$iv = StatusBarWidgetsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((StatusBarWidgetsManager)object).updateWidget(Factory.class);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/GitBranchWidget$MyRiderMainToolbarStateListener;", "Lcom/intellij/ide/navigationToolbar/rider/RiderMainToolbarStateListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "refreshVisibility", "", "intellij.vcs.git"})
    public static final class MyRiderMainToolbarStateListener
    implements RiderMainToolbarStateListener {
        @NotNull
        private final Project project;

        public MyRiderMainToolbarStateListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void refreshVisibility() {
            ((StatusBarWidgetsManager)this.project.getService(StatusBarWidgetsManager.class)).updateWidget(Factory.class);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/GitBranchWidget$SettingsListener;", "Lcom/intellij/ide/ui/UISettingsListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "uiSettingsChanged", "", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitBranchWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchWidget.kt\ngit4idea/ui/branch/GitBranchWidget$SettingsListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,148:1\n30#2,2:149\n*S KotlinDebug\n*F\n+ 1 GitBranchWidget.kt\ngit4idea/ui/branch/GitBranchWidget$SettingsListener\n*L\n112#1:149,2\n*E\n"})
    public static final class SettingsListener
    implements UISettingsListener {
        @NotNull
        private final Project project;

        public SettingsListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
                StatusBarWidgetSettings statusBarSettings = StatusBarWidgetSettings.Companion.getInstance();
                if (!ExperimentalUI.Companion.isNewUI() || statusBarSettings.isExplicitlyDisabled("git")) {
                    return;
                }
                Factory factory = (Factory)StatusBarWidgetFactory.EP_NAME.findExtension(Factory.class);
                if (factory == null) break block3;
                Factory factory2 = factory;
                boolean bl = false;
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<StatusBarWidgetsManager> serviceClass$iv = StatusBarWidgetsManager.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                StatusBarWidgetsManager manager = (StatusBarWidgetsManager)object;
                if (manager.wasWidgetCreated("git") != factory2.isEnabledByDefault()) {
                    manager.updateWidget((StatusBarWidgetFactory)factory2);
                }
            }
        }
    }
}

