/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SmallMapSerializer;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.UrlDescriptor;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.FirstInBranch;

public class SvnBranchPointsCalculator {
    private static final Logger LOG = Logger.getInstance(SvnBranchPointsCalculator.class);
    @NotNull
    private final SmallMapSerializer<Url, TreeMap<String, BranchCopyData>> myPersistentMap;
    @NotNull
    private final Object myPersistenceLock;
    @NotNull
    private final SvnVcs myVcs;

    public SvnBranchPointsCalculator(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(0);
        }
        this.myPersistenceLock = new Object();
        this.myVcs = vcs;
        File directory = new File(new File(PathManager.getSystemPath(), "vcs"), "svn_copy_sources");
        directory.mkdirs();
        File file = new File(directory, this.myVcs.getProject().getLocationHash());
        this.myPersistentMap = new SmallMapSerializer<Url, TreeMap<String, BranchCopyData>>(file, UrlDescriptor.DECODED_URL_DESCRIPTOR, new BranchDataExternalizer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public WrapperInvertor getBestHit(@NotNull Url repoUrl, @NotNull Url sourceUrl, @NotNull Url targetUrl) {
        if (repoUrl == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(1);
        }
        if (sourceUrl == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(2);
        }
        if (targetUrl == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(3);
        }
        Object object = this.myPersistenceLock;
        synchronized (object) {
            WrapperInvertor result = null;
            TreeMap<String, BranchCopyData> map = this.myPersistentMap.get(repoUrl);
            if (map != null) {
                BranchCopyData sourceData = SvnBranchPointsCalculator.getBranchData(map, sourceUrl);
                BranchCopyData targetData = SvnBranchPointsCalculator.getBranchData(map, targetUrl);
                if (sourceData != null && targetData != null) {
                    boolean inverted = sourceData.getTargetRevision() > targetData.getTargetRevision();
                    result = new WrapperInvertor(inverted, inverted ? sourceData : targetData);
                } else if (sourceData != null) {
                    result = new WrapperInvertor(true, sourceData);
                } else if (targetData != null) {
                    result = new WrapperInvertor(false, targetData);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Object object = this.myPersistenceLock;
        synchronized (object) {
            this.myPersistentMap.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(@NotNull Url repoUrl, @NotNull BranchCopyData data) {
        if (repoUrl == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(4);
        }
        if (data == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(5);
        }
        Object object = this.myPersistenceLock;
        synchronized (object) {
            TreeMap<String, BranchCopyData> map = this.myPersistentMap.get(repoUrl);
            if (map == null) {
                map = new TreeMap();
            }
            map.put(data.getTarget().toString(), data);
            this.myPersistentMap.put(repoUrl, map);
            this.myPersistentMap.force();
        }
    }

    @Nullable
    private static BranchCopyData getBranchData(@NotNull NavigableMap<String, BranchCopyData> map, @NotNull Url url) {
        Map.Entry<String, BranchCopyData> branchData;
        if (map == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(6);
        }
        if (url == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(7);
        }
        return (branchData = map.floorEntry(url.toString())) != null && url.toString().startsWith(branchData.getKey()) ? branchData.getValue() : null;
    }

    @Nullable
    public WrapperInvertor calculateCopyPoint(@NotNull Url repoUrl, @NotNull Url sourceUrl, @NotNull Url targetUrl) throws VcsException {
        CopyData copyData;
        WrapperInvertor result;
        if (repoUrl == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(8);
        }
        if (sourceUrl == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(9);
        }
        if (targetUrl == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(10);
        }
        if ((result = this.getBestHit(repoUrl, sourceUrl, targetUrl)) == null && (copyData = new FirstInBranch(this.myVcs, repoUrl, targetUrl, sourceUrl).run()) != null) {
            BranchCopyData branchCopyData = copyData.isTrunkSupposedCorrect() ? new BranchCopyData(sourceUrl, copyData.getCopySourceRevision(), targetUrl, copyData.getCopyTargetRevision()) : new BranchCopyData(targetUrl, copyData.getCopySourceRevision(), sourceUrl, copyData.getCopyTargetRevision());
            this.persist(repoUrl, branchCopyData);
            result = new WrapperInvertor(!copyData.isTrunkSupposedCorrect(), branchCopyData);
        }
        SvnBranchPointsCalculator.logCopyData(repoUrl, sourceUrl, targetUrl, result);
        return result;
    }

    private static void logCopyData(@NotNull Url repoUrl, @NotNull Url sourceUrl, @NotNull Url targetUrl, @Nullable WrapperInvertor inverter) {
        if (repoUrl == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(11);
        }
        if (sourceUrl == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(12);
        }
        if (targetUrl == null) {
            SvnBranchPointsCalculator.$$$reportNull$$$0(13);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("repoURL: " + repoUrl.toDecodedString() + ", sourceUrl:" + sourceUrl.toDecodedString() + ", targetUrl: " + targetUrl.toDecodedString() + ", inverter: " + String.valueOf(inverter));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoUrl";
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceUrl";
                break;
            }
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBestHit";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "persist";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getBranchData";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateCopyPoint";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "logCopyData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class BranchDataExternalizer
    implements DataExternalizer<TreeMap<String, BranchCopyData>> {
        private BranchDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, @NotNull TreeMap<String, BranchCopyData> value) throws IOException {
            if (out == null) {
                BranchDataExternalizer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                BranchDataExternalizer.$$$reportNull$$$0(1);
            }
            out.writeInt(value.size());
            for (Map.Entry<String, BranchCopyData> entry : value.entrySet()) {
                out.writeUTF(entry.getKey());
                BranchDataExternalizer.save(out, entry.getValue());
            }
        }

        private static void save(@NotNull DataOutput out, @NotNull BranchCopyData value) throws IOException {
            if (out == null) {
                BranchDataExternalizer.$$$reportNull$$$0(2);
            }
            if (value == null) {
                BranchDataExternalizer.$$$reportNull$$$0(3);
            }
            UrlDescriptor.ENCODED_URL_DESCRIPTOR.save(out, value.getSource());
            UrlDescriptor.ENCODED_URL_DESCRIPTOR.save(out, value.getTarget());
            out.writeLong(value.getSourceRevision());
            out.writeLong(value.getTargetRevision());
        }

        @NotNull
        public TreeMap<String, BranchCopyData> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                BranchDataExternalizer.$$$reportNull$$$0(4);
            }
            TreeMap<String, BranchCopyData> result = new TreeMap<String, BranchCopyData>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                result.put(in.readUTF(), BranchDataExternalizer.readCopyPoint(in));
            }
            TreeMap<String, BranchCopyData> treeMap = result;
            if (treeMap == null) {
                BranchDataExternalizer.$$$reportNull$$$0(5);
            }
            return treeMap;
        }

        @NotNull
        private static BranchCopyData readCopyPoint(@NotNull DataInput in) throws IOException {
            if (in == null) {
                BranchDataExternalizer.$$$reportNull$$$0(6);
            }
            Url source = UrlDescriptor.ENCODED_URL_DESCRIPTOR.read(in);
            Url target = UrlDescriptor.ENCODED_URL_DESCRIPTOR.read(in);
            long sourceRevision = in.readLong();
            long targetRevision = in.readLong();
            return new BranchCopyData(source, sourceRevision, target, targetRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "readCopyPoint";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class BranchCopyData {
        @NotNull
        private final Url mySource;
        @NotNull
        private final Url myTarget;
        private final long mySourceRevision;
        private final long myTargetRevision;

        /*
         * WARNING - void declaration
         */
        public BranchCopyData(@NotNull Url source, long sourceRevision, @NotNull Url target, long l) {
            void targetRevision;
            if (source == null) {
                BranchCopyData.$$$reportNull$$$0(0);
            }
            if (target == null) {
                BranchCopyData.$$$reportNull$$$0(1);
            }
            this.mySource = source;
            this.mySourceRevision = sourceRevision;
            this.myTarget = target;
            this.myTargetRevision = targetRevision;
        }

        public String toString() {
            return "source: " + String.valueOf(this.mySource) + "@" + this.mySourceRevision + " target: " + String.valueOf(this.myTarget) + "@" + this.myTargetRevision;
        }

        @NotNull
        public Url getSource() {
            Url url = this.mySource;
            if (url == null) {
                BranchCopyData.$$$reportNull$$$0(2);
            }
            return url;
        }

        public long getSourceRevision() {
            return this.mySourceRevision;
        }

        @NotNull
        public Url getTarget() {
            Url url = this.myTarget;
            if (url == null) {
                BranchCopyData.$$$reportNull$$$0(3);
            }
            return url;
        }

        public long getTargetRevision() {
            return this.myTargetRevision;
        }

        public BranchCopyData invertSelf() {
            return new BranchCopyData(this.myTarget, this.myTargetRevision, this.mySource, this.mySourceRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchCopyData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchCopyData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class WrapperInvertor {
        private final BranchCopyData myWrapped;
        private final boolean myInvertedSense;

        public WrapperInvertor(boolean invertedSense, BranchCopyData wrapped) {
            this.myInvertedSense = invertedSense;
            this.myWrapped = wrapped;
        }

        public boolean isInvertedSense() {
            return this.myInvertedSense;
        }

        public BranchCopyData getWrapped() {
            return this.myWrapped;
        }

        public BranchCopyData getTrue() {
            return this.myInvertedSense ? this.myWrapped.invertSelf() : this.myWrapped;
        }

        public BranchCopyData inverted() {
            return this.myWrapped.invertSelf();
        }

        public String toString() {
            return "inverted: " + this.myInvertedSense + " wrapped: " + this.myWrapped.toString();
        }
    }
}

