/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.action.TerminalSessionContextMenuActionBase;
import org.jetbrains.plugins.terminal.vfs.TerminalEditorWidgetListener;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/action/MoveTerminalSessionToEditorAction;", "Lorg/jetbrains/plugins/terminal/action/TerminalSessionContextMenuActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "updateInTerminalToolWindow", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/ui/content/Content;", "terminalWidget", "Lcom/intellij/terminal/ui/TerminalWidget;", "actionPerformedInTerminalToolWindow", "intellij.terminal"})
final class MoveTerminalSessionToEditorAction
extends TerminalSessionContextMenuActionBase
implements DumbAware {
    @Override
    public void updateInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content, @NotNull TerminalWidget terminalWidget) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)terminalWidget, (String)"terminalWidget");
        e.getPresentation().setEnabledAndVisible(!TerminalToolWindowManager.getInstance(project).isSplitTerminal(terminalWidget) && !Registry.Companion.is("toolwindow.open.tab.in.editor"));
    }

    @Override
    public void actionPerformedInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content, @NotNull TerminalWidget terminalWidget) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)terminalWidget, (String)"terminalWidget");
        TerminalToolWindowManager terminalToolWindowManager = TerminalToolWindowManager.getInstance(project);
        TerminalSessionVirtualFileImpl file = new TerminalSessionVirtualFileImpl(terminalWidget.getTerminalTitle().buildTitle(), terminalWidget, (SettingsProvider)terminalToolWindowManager.getTerminalRunner().getSettingsProvider());
        file.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, true);
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, true);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
        ArraysKt.first((Object[])fileEditorArray);
        JBTerminalWidget jBTerminalWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)terminalWidget);
        if (jBTerminalWidget != null) {
            JBTerminalWidget it = jBTerminalWidget;
            boolean bl = false;
            it.setListener((JBTerminalWidgetListener)new TerminalEditorWidgetListener(project, file));
        }
        terminalToolWindowManager.detachWidgetAndRemoveContent(content);
        file.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
    }
}

