/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalColumnSpacing;
import org.jetbrains.plugins.terminal.TerminalFontSettingsServiceKt;
import org.jetbrains.plugins.terminal.TerminalFontSize;
import org.jetbrains.plugins.terminal.TerminalLineSpacing;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\nH\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontSettings;", "", "fontFamily", "", "fallbackFontFamily", "fontSize", "Lorg/jetbrains/plugins/terminal/TerminalFontSize;", "lineSpacing", "Lorg/jetbrains/plugins/terminal/TerminalLineSpacing;", "columnSpacing", "Lorg/jetbrains/plugins/terminal/TerminalColumnSpacing;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/terminal/TerminalFontSize;Lorg/jetbrains/plugins/terminal/TerminalLineSpacing;Lorg/jetbrains/plugins/terminal/TerminalColumnSpacing;)V", "preferences", "Lcom/intellij/openapi/editor/colors/FontPreferences;", "(Lcom/intellij/openapi/editor/colors/FontPreferences;Lorg/jetbrains/plugins/terminal/TerminalColumnSpacing;)V", "getFontFamily", "()Ljava/lang/String;", "getFallbackFontFamily", "getFontSize", "()Lorg/jetbrains/plugins/terminal/TerminalFontSize;", "getLineSpacing", "()Lorg/jetbrains/plugins/terminal/TerminalLineSpacing;", "getColumnSpacing", "()Lorg/jetbrains/plugins/terminal/TerminalColumnSpacing;", "copyTo", "", "Lcom/intellij/openapi/editor/colors/impl/FontPreferencesImpl;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
public final class TerminalFontSettings {
    @NotNull
    private final String fontFamily;
    @NotNull
    private final String fallbackFontFamily;
    @NotNull
    private final TerminalFontSize fontSize;
    @NotNull
    private final TerminalLineSpacing lineSpacing;
    @NotNull
    private final TerminalColumnSpacing columnSpacing;

    public TerminalFontSettings(@NotNull String fontFamily, @NotNull String fallbackFontFamily, @NotNull TerminalFontSize fontSize, @NotNull TerminalLineSpacing lineSpacing, @NotNull TerminalColumnSpacing columnSpacing) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        Intrinsics.checkNotNullParameter((Object)fallbackFontFamily, (String)"fallbackFontFamily");
        Intrinsics.checkNotNullParameter((Object)fontSize, (String)"fontSize");
        Intrinsics.checkNotNullParameter((Object)lineSpacing, (String)"lineSpacing");
        Intrinsics.checkNotNullParameter((Object)columnSpacing, (String)"columnSpacing");
        this.fontFamily = fontFamily;
        this.fallbackFontFamily = fallbackFontFamily;
        this.fontSize = fontSize;
        this.lineSpacing = lineSpacing;
        this.columnSpacing = columnSpacing;
    }

    @NotNull
    public final String getFontFamily() {
        return this.fontFamily;
    }

    @NotNull
    public final String getFallbackFontFamily() {
        return this.fallbackFontFamily;
    }

    @NotNull
    public final TerminalFontSize getFontSize() {
        return this.fontSize;
    }

    @NotNull
    public final TerminalLineSpacing getLineSpacing() {
        return this.lineSpacing;
    }

    @NotNull
    public final TerminalColumnSpacing getColumnSpacing() {
        return this.columnSpacing;
    }

    public TerminalFontSettings(@NotNull FontPreferences preferences, @NotNull TerminalColumnSpacing columnSpacing) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        Intrinsics.checkNotNullParameter((Object)columnSpacing, (String)"columnSpacing");
        String string = preferences.getFontFamily();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFontFamily(...)");
        List list = preferences.getEffectiveFontFamilies();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEffectiveFontFamilies(...)");
        String string2 = (String)CollectionsKt.getOrNull((List)list, (int)1);
        if (string2 == null) {
            String string3 = FontPreferences.DEFAULT_FONT_NAME;
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DEFAULT_FONT_NAME");
        }
        this(string, string2, TerminalFontSize.Companion.ofFloat(preferences.getSize2D(preferences.getFontFamily())), TerminalLineSpacing.Companion.ofFloat(preferences.getLineSpacing()), columnSpacing);
    }

    public final void copyTo(@NotNull FontPreferencesImpl preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        preferences.clearFonts();
        TerminalFontSettingsServiceKt.access$copyMainFont(this, preferences);
        TerminalFontSettingsServiceKt.access$copyFallbackFont(this, preferences);
        TerminalFontSettingsServiceKt.access$copyFontSize(this, preferences);
        TerminalFontSettingsServiceKt.access$copyLineSpacing(this, preferences);
    }

    @NotNull
    public final String component1() {
        return this.fontFamily;
    }

    @NotNull
    public final String component2() {
        return this.fallbackFontFamily;
    }

    @NotNull
    public final TerminalFontSize component3() {
        return this.fontSize;
    }

    @NotNull
    public final TerminalLineSpacing component4() {
        return this.lineSpacing;
    }

    @NotNull
    public final TerminalColumnSpacing component5() {
        return this.columnSpacing;
    }

    @NotNull
    public final TerminalFontSettings copy(@NotNull String fontFamily, @NotNull String fallbackFontFamily, @NotNull TerminalFontSize fontSize, @NotNull TerminalLineSpacing lineSpacing, @NotNull TerminalColumnSpacing columnSpacing) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        Intrinsics.checkNotNullParameter((Object)fallbackFontFamily, (String)"fallbackFontFamily");
        Intrinsics.checkNotNullParameter((Object)fontSize, (String)"fontSize");
        Intrinsics.checkNotNullParameter((Object)lineSpacing, (String)"lineSpacing");
        Intrinsics.checkNotNullParameter((Object)columnSpacing, (String)"columnSpacing");
        return new TerminalFontSettings(fontFamily, fallbackFontFamily, fontSize, lineSpacing, columnSpacing);
    }

    public static /* synthetic */ TerminalFontSettings copy$default(TerminalFontSettings terminalFontSettings, String string, String string2, TerminalFontSize terminalFontSize, TerminalLineSpacing terminalLineSpacing, TerminalColumnSpacing terminalColumnSpacing, int n, Object object) {
        if ((n & 1) != 0) {
            string = terminalFontSettings.fontFamily;
        }
        if ((n & 2) != 0) {
            string2 = terminalFontSettings.fallbackFontFamily;
        }
        if ((n & 4) != 0) {
            terminalFontSize = terminalFontSettings.fontSize;
        }
        if ((n & 8) != 0) {
            terminalLineSpacing = terminalFontSettings.lineSpacing;
        }
        if ((n & 0x10) != 0) {
            terminalColumnSpacing = terminalFontSettings.columnSpacing;
        }
        return terminalFontSettings.copy(string, string2, terminalFontSize, terminalLineSpacing, terminalColumnSpacing);
    }

    @NotNull
    public String toString() {
        return "TerminalFontSettings(fontFamily=" + this.fontFamily + ", fallbackFontFamily=" + this.fallbackFontFamily + ", fontSize=" + this.fontSize + ", lineSpacing=" + this.lineSpacing + ", columnSpacing=" + this.columnSpacing + ")";
    }

    public int hashCode() {
        int result2 = this.fontFamily.hashCode();
        result2 = result2 * 31 + this.fallbackFontFamily.hashCode();
        result2 = result2 * 31 + this.fontSize.hashCode();
        result2 = result2 * 31 + this.lineSpacing.hashCode();
        result2 = result2 * 31 + this.columnSpacing.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TerminalFontSettings)) {
            return false;
        }
        TerminalFontSettings terminalFontSettings = (TerminalFontSettings)other;
        if (!Intrinsics.areEqual((Object)this.fontFamily, (Object)terminalFontSettings.fontFamily)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fallbackFontFamily, (Object)terminalFontSettings.fallbackFontFamily)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontSize, (Object)terminalFontSettings.fontSize)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lineSpacing, (Object)terminalFontSettings.lineSpacing)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.columnSpacing, (Object)terminalFontSettings.columnSpacing);
    }
}

