/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.deciders;

import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.search.deciders.ConcurrentSearchRequestDecider;

@ExperimentalApi
public class ConcurrentSearchVisitor
implements QueryBuilderVisitor {
    private final Set<ConcurrentSearchRequestDecider> deciders;
    private final IndexSettings indexSettings;

    public ConcurrentSearchVisitor(Set<ConcurrentSearchRequestDecider> concurrentSearchVisitorDeciders, IndexSettings idxSettings) {
        Objects.requireNonNull(concurrentSearchVisitorDeciders, "Concurrent search deciders cannot be null");
        this.deciders = concurrentSearchVisitorDeciders;
        this.indexSettings = idxSettings;
    }

    @Override
    public void accept(QueryBuilder qb) {
        this.deciders.forEach(concurrentSearchDecider -> concurrentSearchDecider.evaluateForQuery(qb, this.indexSettings));
    }

    @Override
    public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
        return this;
    }
}

