/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import javax.swing.JToggleButton;

public class TristateButtonModel
extends JToggleButton.ToggleButtonModel {
    private static final long serialVersionUID = 9179129427948325126L;
    public static final int MIXED = 128;

    public void setState(int state) {
        switch (state) {
            case 0: {
                this.setSelected(false);
                break;
            }
            case 1: {
                this.setSelected(true);
                break;
            }
            case 2: {
                this.setMixed(true);
            }
        }
    }

    public int getState() {
        if (this.isMixed()) {
            return 2;
        }
        if (this.isSelected()) {
            return 1;
        }
        return 0;
    }

    protected int getNextState(int current) {
        if (current == 0) {
            return 1;
        }
        if (current == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public void setPressed(boolean b) {
        if (this.isPressed() == b || !this.isEnabled()) {
            return;
        }
        if (!b && this.isArmed()) {
            this.updateState();
        }
        this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        this.fireStateChanged();
        if (!this.isPressed() && this.isArmed()) {
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiers();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
        }
    }

    protected void updateState() {
        this.setState(this.getNextState(this.getState()));
    }

    @Override
    public void setSelected(boolean b) {
        boolean mixed = this.isMixed();
        if (mixed) {
            this.stateMask &= 0xFFFFFF7F;
            this.internalSetSelected(!this.isSelected());
        }
        super.setSelected(b);
    }

    void internalSetSelected(boolean b) {
        this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
    }

    public boolean isMixed() {
        return (this.stateMask & 0x80) != 0;
    }

    public void setMixed(boolean b) {
        if (this.isMixed() == b) {
            return;
        }
        if (b) {
            this.stateMask |= 0x80;
            this.stateMask |= 2;
        } else {
            this.stateMask &= 0xFFFFFF7F;
        }
        this.fireStateChanged();
    }
}

