/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import java.security.cert.X509Certificate;
import org.jboss.logging.Logger;
import org.keycloak.http.HttpRequest;
import org.keycloak.services.x509.X509ClientCertificateLookup;

public class DefaultClientCertificateLookup
implements X509ClientCertificateLookup {
    private static final Logger logger = Logger.getLogger(DefaultClientCertificateLookup.class);

    public void close() {
    }

    @Override
    public X509Certificate[] getCertificateChain(HttpRequest httpRequest) {
        X509Certificate[] certs = httpRequest.getClientCertificateChain();
        if (logger.isTraceEnabled() && certs != null) {
            for (X509Certificate cert : certs) {
                logger.tracef("Certificate's SubjectDN => \"%s\"", (Object)cert.getSubjectDN().getName());
            }
        }
        return certs;
    }
}

