/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.utility;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.AutoComplete;
import picocli.CommandLine;
import picocli.codegen.docgen.manpage.ManPageGenerator;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLineCommands;
import schemacrawler.tools.commandline.command.ConfigFileCommand;
import schemacrawler.tools.commandline.command.ConnectCommand;
import schemacrawler.tools.commandline.command.ExecuteCommand;
import schemacrawler.tools.commandline.command.FilterCommand;
import schemacrawler.tools.commandline.command.GrepCommand;
import schemacrawler.tools.commandline.command.LimitCommand;
import schemacrawler.tools.commandline.command.LoadCommand;
import schemacrawler.tools.commandline.command.LogCommand;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.state.StateFactory;
import schemacrawler.tools.commandline.utility.CommandLineUtility;

public final class GenerateCliSupport {
    private static final Logger LOGGER = Logger.getLogger(GenerateCliSupport.class.getName());

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new GenerateCliSupportCommand()).execute(args);
        if (exitCode != 0) {
            throw new RuntimeException("Could not generate CLI support files");
        }
    }

    @CommandLine.Command(name="generate-schemacrawler-cli-support", mixinStandardHelpOptions=true, description={"Generate SchemaCrawler CLI man pages and bash completion scripts"})
    private static final class GenerateCliSupportCommand
    implements Runnable {
        @CommandLine.Option(names={"-o", "--output-dir"}, description={"Output directory for generated files"}, required=true)
        private Path outputDir;
        @CommandLine.Option(names={"-s", "--completion-script"}, description={"File name for the generated bash completion script"}, required=true)
        private String completionScriptFilename;

        private GenerateCliSupportCommand() {
        }

        @Override
        public void run() {
            boolean isErrored = false;
            this.outputDir = this.createOutputDirectory();
            Path completionScript = this.outputDir.resolve(this.completionScriptFilename).toAbsolutePath();
            if (this.generateAsciiDoc()) {
                isErrored = true;
            }
            if (this.generateAutoComplete(completionScript)) {
                isErrored = true;
            }
            if (isErrored) {
                throw new RuntimeException("Could not generate CLI support files");
            }
        }

        protected Path createOutputDirectory() {
            try {
                Files.createDirectories(this.outputDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create output directory", e);
            }
            return this.outputDir.toAbsolutePath();
        }

        private CommandLine createCommandLine(Object commands) {
            ShellState state = new ShellState();
            StateFactory stateFactory = new StateFactory(state);
            return CommandLineUtility.newCommandLine(commands, stateFactory);
        }

        private boolean generateAsciiDoc() {
            boolean isErrored = false;
            boolean[] verbosity = new boolean[3];
            Arrays.fill(verbosity, true);
            try {
                @CommandLine.Command(name="schemacrawler", subcommands={ConfigFileCommand.class, ConnectCommand.class, FilterCommand.class, GrepCommand.class, LimitCommand.class, LoadCommand.class, ExecuteCommand.class, LogCommand.class})
                final class SchemaCrawlerCli {
                    SchemaCrawlerCli() {
                    }
                }
                ManPageGenerator.generateManPage((File)this.outputDir.toFile(), null, (boolean[])verbosity, (boolean)true, (CommandLine.Model.CommandSpec[])new CommandLine.Model.CommandSpec[]{this.createCommandLine(new SchemaCrawlerCli()).getCommandSpec()});
            }
            catch (IOException e) {
                isErrored = true;
                LOGGER.log(Level.SEVERE, "Could not generate man pages in AsciiDoc format", e);
            }
            return isErrored;
        }

        private boolean generateAutoComplete(Path completionScript) {
            boolean isErrored = false;
            try {
                CommandLine commandLine = this.createCommandLine(new SchemaCrawlerCommandLineCommands());
                AutoComplete.bash((String)"schemacrawler", (File)completionScript.toFile(), null, (CommandLine)commandLine);
            }
            catch (IOException e) {
                isErrored = true;
                LOGGER.log(Level.SEVERE, "Could not generate bash completion scripts", e);
            }
            return isErrored;
        }
    }
}

