# This file has been autogenerated by the pywayland scanner

# Copyright © 2023 Valve Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface
from .wp_fifo_v1 import WpFifoV1


class WpFifoManagerV1(Interface):
    """Protocol for fifo constraints

    When a Wayland compositor considers applying a content update, it must
    ensure all the update's readiness constraints (fences, etc) are met.

    This protocol provides a way to use the completion of a display refresh
    cycle as an additional readiness constraint.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "wp_fifo_manager_v1"
    version = 1

    class error(enum.IntEnum):
        already_exists = 0


class WpFifoManagerV1Proxy(Proxy[WpFifoManagerV1]):
    interface = WpFifoManagerV1

    @WpFifoManagerV1.request()
    def destroy(self) -> None:
        """Unbind from the manager interface

        Informs the server that the client will no longer be using this
        protocol object. Existing objects created by this object are not
        affected.
        """
        self._marshal(0)
        self._destroy()

    @WpFifoManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpFifoV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_fifo(self, surface: WlSurface) -> Proxy[WpFifoV1]:
        """Request fifo interface for surface

        Establish a fifo object for a surface that may be used to add display
        refresh constraints to content updates.

        Only one such object may exist for a surface and attempting to create
        more than one will result in an already_exists protocol error. If a
        surface is acted on by multiple software components, general best
        practice is that only the component performing
        :func:`WlSurface.attach()
        <pywayland.protocol.wayland.WlSurface.attach>` operations should use
        this protocol.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.fifo_v1.WpFifoV1`
        """
        id = self._marshal_constructor(1, WpFifoV1, surface)
        return id


class WpFifoManagerV1Resource(Resource):
    interface = WpFifoManagerV1


class WpFifoManagerV1Global(Global):
    interface = WpFifoManagerV1


WpFifoManagerV1._gen_c()
WpFifoManagerV1.proxy_class = WpFifoManagerV1Proxy
WpFifoManagerV1.resource_class = WpFifoManagerV1Resource
WpFifoManagerV1.global_class = WpFifoManagerV1Global
