/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4.http3;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.quic.QuicTokenHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SecureQuicTokenHandler
implements QuicTokenHandler {
    private static final int HMAC_KEY_LEN = 32;
    private static final int HMAC_TAG_LEN = 32;
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private static final String SERVER_NAME = "opensearch-netty";
    private static final byte[] SERVER_NAME_BYTES = "opensearch-netty".getBytes(CharsetUtil.US_ASCII);
    private static final ByteBuf SERVER_NAME_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])SERVER_NAME_BYTES)).asReadOnly();
    private static final int MAX_TOKEN_LEN = 52 + NetUtil.LOCALHOST6.getAddress().length + SERVER_NAME_BYTES.length;
    private final byte[] key = new byte[32];

    public SecureQuicTokenHandler(SecureRandom random) {
        random.nextBytes(this.key);
    }

    public boolean writeToken(ByteBuf out, ByteBuf dcid, InetSocketAddress address) {
        byte[] addr = address.getAddress().getAddress();
        byte[] buffer = new byte[32 + addr.length + dcid.readableBytes()];
        System.arraycopy(addr, 0, buffer, 32, addr.length);
        dcid.getBytes(dcid.readerIndex(), buffer, 32 + addr.length, dcid.readableBytes());
        try {
            Mac mac = Mac.getInstance(HMAC_SHA_256);
            mac.init(new SecretKeySpec(this.key, HMAC_SHA_256));
            mac.update(buffer, 32, addr.length + dcid.readableBytes());
            System.arraycopy(mac.doFinal(), 0, buffer, 0, 32);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            return false;
        }
        out.writeBytes(SERVER_NAME_BYTES).writeBytes(buffer);
        return true;
    }

    public int validateToken(ByteBuf token, InetSocketAddress address) {
        byte[] addr = address.getAddress().getAddress();
        int minLength = SERVER_NAME_BYTES.length + 32 + addr.length;
        if (token.readableBytes() <= minLength) {
            return -1;
        }
        if (!SERVER_NAME_BUFFER.equals((Object)token.slice(0, SERVER_NAME_BYTES.length))) {
            return -1;
        }
        ByteBuf tag = token.slice(SERVER_NAME_BYTES.length, 32);
        int length = token.readableBytes() - 32 - SERVER_NAME_BYTES.length;
        ByteBuf payload = token.slice(SERVER_NAME_BYTES.length + 32, length);
        try {
            Mac mac = Mac.getInstance(HMAC_SHA_256);
            mac.init(new SecretKeySpec(this.key, HMAC_SHA_256));
            for (int i = 0; i < payload.readableBytes(); ++i) {
                mac.update(payload.getByte(payload.readerIndex() + i));
            }
            byte[] actual = new byte[tag.readableBytes()];
            tag.getBytes(tag.readerIndex(), actual, 0, tag.readableBytes());
            byte[] expected = mac.doFinal();
            if (!MessageDigest.isEqual(actual, expected)) {
                return -1;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            return -1;
        }
        return minLength;
    }

    public int maxTokenLength() {
        return MAX_TOKEN_LEN;
    }
}

