/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KeywordMarkerTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, KeywordMarkerTokenFilter> {
    @Nullable
    private final Boolean ignoreCase;
    @Nonnull
    private final List<String> keywords;
    @Nullable
    private final String keywordsPath;
    @Nullable
    private final String keywordsPattern;
    public static final JsonpDeserializer<KeywordMarkerTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeywordMarkerTokenFilter::setupKeywordMarkerTokenFilterDeserializer);

    private KeywordMarkerTokenFilter(Builder builder) {
        super(builder);
        this.ignoreCase = builder.ignoreCase;
        this.keywords = ApiTypeHelper.unmodifiable(builder.keywords);
        this.keywordsPath = builder.keywordsPath;
        this.keywordsPattern = builder.keywordsPattern;
    }

    public static KeywordMarkerTokenFilter of(Function<Builder, ObjectBuilder<KeywordMarkerTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.KeywordMarker;
    }

    @Nullable
    public final Boolean ignoreCase() {
        return this.ignoreCase;
    }

    @Nonnull
    public final List<String> keywords() {
        return this.keywords;
    }

    @Nullable
    public final String keywordsPath() {
        return this.keywordsPath;
    }

    @Nullable
    public final String keywordsPattern() {
        return this.keywordsPattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keyword_marker");
        super.serializeInternal(generator, mapper);
        if (this.ignoreCase != null) {
            generator.writeKey("ignore_case");
            generator.write(this.ignoreCase.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.keywords)) {
            generator.writeKey("keywords");
            generator.writeStartArray();
            for (String item0 : this.keywords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.keywordsPath != null) {
            generator.writeKey("keywords_path");
            generator.write(this.keywordsPath);
        }
        if (this.keywordsPattern != null) {
            generator.writeKey("keywords_pattern");
            generator.write(this.keywordsPattern);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKeywordMarkerTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        KeywordMarkerTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::ignoreCase, JsonpDeserializer.booleanDeserializer(), "ignore_case");
        op.add(Builder::keywords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "keywords");
        op.add(Builder::keywordsPath, JsonpDeserializer.stringDeserializer(), "keywords_path");
        op.add(Builder::keywordsPattern, JsonpDeserializer.stringDeserializer(), "keywords_pattern");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreCase);
        result = 31 * result + Objects.hashCode(this.keywords);
        result = 31 * result + Objects.hashCode(this.keywordsPath);
        result = 31 * result + Objects.hashCode(this.keywordsPattern);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeywordMarkerTokenFilter other = (KeywordMarkerTokenFilter)o;
        return Objects.equals(this.ignoreCase, other.ignoreCase) && Objects.equals(this.keywords, other.keywords) && Objects.equals(this.keywordsPath, other.keywordsPath) && Objects.equals(this.keywordsPattern, other.keywordsPattern);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, KeywordMarkerTokenFilter> {
        @Nullable
        private Boolean ignoreCase;
        @Nullable
        private List<String> keywords;
        @Nullable
        private String keywordsPath;
        @Nullable
        private String keywordsPattern;

        public Builder() {
        }

        private Builder(KeywordMarkerTokenFilter o) {
            super(o);
            this.ignoreCase = o.ignoreCase;
            this.keywords = Builder._listCopy(o.keywords);
            this.keywordsPath = o.keywordsPath;
            this.keywordsPattern = o.keywordsPattern;
        }

        private Builder(Builder o) {
            super(o);
            this.ignoreCase = o.ignoreCase;
            this.keywords = Builder._listCopy(o.keywords);
            this.keywordsPath = o.keywordsPath;
            this.keywordsPattern = o.keywordsPattern;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder ignoreCase(@Nullable Boolean value) {
            this.ignoreCase = value;
            return this;
        }

        @Nonnull
        public final Builder keywords(List<String> list) {
            this.keywords = Builder._listAddAll(this.keywords, list);
            return this;
        }

        @Nonnull
        public final Builder keywords(String value, String ... values) {
            this.keywords = Builder._listAdd(this.keywords, value, values);
            return this;
        }

        @Nonnull
        public final Builder keywordsPath(@Nullable String value) {
            this.keywordsPath = value;
            return this;
        }

        @Nonnull
        public final Builder keywordsPattern(@Nullable String value) {
            this.keywordsPattern = value;
            return this;
        }

        @Override
        @Nonnull
        public KeywordMarkerTokenFilter build() {
            this._checkSingleUse();
            return new KeywordMarkerTokenFilter(this);
        }
    }
}

