/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.session;

import java.io.IOException;
import java.time.Instant;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MLMemorySession;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.session.MLCreateSessionInput;
import org.opensearch.ml.common.transport.session.MLCreateSessionRequest;
import org.opensearch.ml.common.transport.session.MLCreateSessionResponse;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportCreateSessionAction
extends HandledTransportAction<MLCreateSessionRequest, MLCreateSessionResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportCreateSessionAction.class);
    private final Client client;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    final MemoryContainerHelper memoryContainerHelper;

    @Inject
    public TransportCreateSessionAction(TransportService transportService, ActionFilters actionFilters, Client client, MLFeatureEnabledSetting mlFeatureEnabledSetting, MemoryContainerHelper memoryContainerHelper) {
        super("cluster:admin/opensearch/ml/memory_containers/sessions/create", transportService, actionFilters, MLCreateSessionRequest::new);
        this.client = client;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.memoryContainerHelper = memoryContainerHelper;
    }

    protected void doExecute(Task task, MLCreateSessionRequest request, ActionListener<MLCreateSessionResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLCreateSessionInput input = request.getMlCreateSessionInput();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, input.getTenantId(), actionListener)) {
            return;
        }
        User user = RestActionUtils.getUserContext(this.client);
        String ownerId = this.memoryContainerHelper.getOwnerId(user);
        input.setOwnerId(ownerId);
        String tenantId = input.getTenantId();
        String memoryContainerId = input.getMemoryContainerId();
        if (StringUtils.isBlank((CharSequence)memoryContainerId)) {
            actionListener.onFailure((Exception)new IllegalArgumentException("Memory container ID is required"));
            return;
        }
        this.memoryContainerHelper.getMemoryContainer(memoryContainerId, tenantId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            if (!this.memoryContainerHelper.checkMemoryContainerAccess(user, (MLMemoryContainer)container)) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to add memory to this container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            this.createNewSession(input, (MLMemoryContainer)container, user, tenantId, actionListener);
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }

    private void createNewSession(MLCreateSessionInput input, MLMemoryContainer container, User user, String tenantId, ActionListener<MLCreateSessionResponse> actionListener) {
        Instant now = Instant.now();
        MLMemorySession session = MLMemorySession.builder().ownerId(input.getOwnerId()).memoryContainerId(input.getMemoryContainerId()).summary(input.getSummary()).createdTime(now).lastUpdateTime(now).metadata(input.getMetadata()).agents(input.getAgents()).additionalInfo(input.getAdditionalInfo()).namespace(input.getNamespace()).tenantId(tenantId).build();
        IndexRequest indexRequest = new IndexRequest(container.getConfiguration().getSessionIndexName());
        String sessionId = input.getSessionId();
        if (sessionId != null && !sessionId.isBlank()) {
            indexRequest.id(sessionId);
        }
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            session.toXContent(builder, ToXContent.EMPTY_PARAMS);
            indexRequest.source(builder);
            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.memoryContainerHelper.indexData(container.getConfiguration(), indexRequest, (ActionListener<IndexResponse>)ActionListener.wrap(r -> {
                MLCreateSessionResponse response = MLCreateSessionResponse.builder().sessionId(r.getId()).status("created").build();
                actionListener.onResponse((Object)response);
            }, e -> {
                log.error("Failed to create session in container {}", (Object)input.getMemoryContainerId(), e);
                actionListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }));
        }
        catch (IOException e2) {
            log.error("Failed to build XContent for session in container {}", (Object)input.getMemoryContainerId(), (Object)e2);
            actionListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }
}

