/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.agent;

import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.contextmanagement.ContextManagementTemplateService;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.contextmanager.ContextManagementTemplate;
import org.opensearch.ml.common.contextmanager.ContextManagerConfig;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;

public class MLAgentRegistrationValidator {
    @Generated
    private static final Logger log = LogManager.getLogger(MLAgentRegistrationValidator.class);
    private final ContextManagementTemplateService contextManagementTemplateService;

    public MLAgentRegistrationValidator(ContextManagementTemplateService contextManagementTemplateService) {
        this.contextManagementTemplateService = contextManagementTemplateService;
    }

    public void validateAgentForRegistration(MLAgent agent, ActionListener<Boolean> listener) {
        try {
            log.debug("Starting agent registration validation for agent: {}", (Object)agent.getName());
            String configError = this.validateContextManagementConfiguration(agent);
            if (configError != null) {
                log.error("Agent registration validation failed - configuration error: {}", (Object)configError);
                listener.onFailure((Exception)new IllegalArgumentException(configError));
                return;
            }
            if (agent.getContextManagementName() != null) {
                this.validateContextManagementTemplateAccess(agent.getContextManagementName(), (ActionListener<Boolean>)ActionListener.wrap(templateAccessValid -> {
                    log.debug("Agent registration validation completed successfully for agent: {}", (Object)agent.getName());
                    listener.onResponse((Object)true);
                }, templateAccessError -> {
                    log.error("Agent registration validation failed - template access error: {}", (Object)templateAccessError.getMessage());
                    listener.onFailure(templateAccessError);
                }));
            } else {
                log.debug("Agent registration validation completed successfully for agent: {}", (Object)agent.getName());
                listener.onResponse((Object)true);
            }
        }
        catch (Exception e) {
            log.error("Unexpected error during agent registration validation", (Throwable)e);
            listener.onFailure((Exception)new IllegalArgumentException("Agent validation failed: " + e.getMessage()));
        }
    }

    public void validateContextManagementTemplateAccess(String templateName, ActionListener<Boolean> listener) {
        try {
            log.debug("Validating context management template access: {}", (Object)templateName);
            this.contextManagementTemplateService.getTemplate(templateName, (ActionListener<ContextManagementTemplate>)ActionListener.wrap(template -> {
                log.debug("Context management template access validation passed: {}", (Object)templateName);
                listener.onResponse((Object)true);
            }, exception -> {
                log.error("Context management template access validation failed: {}", (Object)templateName, exception);
                if (exception instanceof MLResourceNotFoundException) {
                    listener.onFailure((Exception)new IllegalArgumentException("Context management template not found: " + templateName));
                } else {
                    listener.onFailure((Exception)new IllegalArgumentException("Failed to validate context management template: " + exception.getMessage()));
                }
            }));
        }
        catch (Exception e) {
            log.error("Unexpected error during context management template access validation", (Throwable)e);
            listener.onFailure((Exception)new IllegalArgumentException("Context management template validation failed: " + e.getMessage()));
        }
    }

    public String validateContextManagementConfiguration(MLAgent agent) {
        String inlineConfigError;
        String templateNameError;
        if (agent.getContextManagementName() != null && agent.getContextManagement() != null) {
            return "Cannot specify both context_management_name and context_management";
        }
        if (agent.getContextManagementName() != null && (templateNameError = this.validateContextManagementTemplateName(agent.getContextManagementName())) != null) {
            return templateNameError;
        }
        if (agent.getContextManagement() != null && (inlineConfigError = this.validateInlineContextManagementConfiguration(agent.getContextManagement())) != null) {
            return inlineConfigError;
        }
        return null;
    }

    private String validateContextManagementTemplateName(String templateName) {
        if (templateName == null || templateName.trim().isEmpty()) {
            return "Context management template name cannot be null or empty";
        }
        if (templateName.length() > 256) {
            return "Context management template name cannot exceed 256 characters";
        }
        if (!templateName.matches("^[a-zA-Z0-9_\\-\\.]+$")) {
            return "Context management template name can only contain letters, numbers, underscores, hyphens, and dots";
        }
        return null;
    }

    private String validateInlineContextManagementConfiguration(ContextManagementTemplate contextManagement) {
        if (!contextManagement.isValid()) {
            return "Invalid context management configuration: configuration must have a name and at least one hook with valid context manager configurations";
        }
        if (contextManagement.getName() == null || contextManagement.getName().trim().isEmpty()) {
            return "Context management configuration name cannot be null or empty";
        }
        if (contextManagement.getHooks() == null || contextManagement.getHooks().isEmpty()) {
            return "Context management configuration must define at least one hook";
        }
        return this.validateContextManagementHooks(contextManagement.getHooks());
    }

    private String validateContextManagementHooks(Map<String, List<ContextManagerConfig>> hooks) {
        Set<String> validHookNames = Set.of("PRE_TOOL", "POST_TOOL", "PRE_LLM", "POST_LLM", "PRE_EXECUTION", "POST_EXECUTION");
        for (Map.Entry<String, List<ContextManagerConfig>> entry : hooks.entrySet()) {
            String hookName = entry.getKey();
            List<ContextManagerConfig> configs = entry.getValue();
            if (!validHookNames.contains(hookName)) {
                return "Invalid hook name: " + hookName + ". Valid hook names are: " + String.valueOf(validHookNames);
            }
            if (configs == null || configs.isEmpty()) {
                return "Hook " + hookName + " must have at least one context manager configuration";
            }
            for (int i = 0; i < configs.size(); ++i) {
                String typeError;
                ContextManagerConfig config = configs.get(i);
                if (!config.isValid()) {
                    return "Invalid context manager configuration at index " + i + " in hook " + hookName + ": type cannot be null or empty";
                }
                if (config.getType() == null || (typeError = this.validateContextManagerType(config.getType(), hookName, i)) == null) continue;
                return typeError;
            }
        }
        return null;
    }

    private String validateContextManagerType(String type, String hookName, int index) {
        Set<String> knownTypes = Set.of("ToolsOutputTruncateManager", "SummarizationManager", "MemoryManager", "ConversationManager");
        if (!knownTypes.contains(type)) {
            log.debug("Unknown context manager type '{}' in hook '{}' at index {}. This may be a custom or future type.", (Object)type, (Object)hookName, (Object)index);
        }
        return null;
    }
}

