/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.MLMemoryContainerDeleteRequest;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportDeleteMemoryContainerAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportDeleteMemoryContainerAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MemoryContainerHelper memoryContainerHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportDeleteMemoryContainerAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ConnectorAccessControlHelper connectorAccessControlHelper, MemoryContainerHelper memoryContainerHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/memory_containers/delete", transportService, actionFilters, MLMemoryContainerDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.memoryContainerHelper = memoryContainerHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLMemoryContainerDeleteRequest deleteRequest = MLMemoryContainerDeleteRequest.fromActionRequest((ActionRequest)request);
        String memoryContainerId = deleteRequest.getMemoryContainerId();
        String tenantId = deleteRequest.getTenantId();
        boolean deleteAllMemories = deleteRequest.isDeleteAllMemories();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        User user = RestActionUtils.getUserContext(this.client);
        this.memoryContainerHelper.getMemoryContainer(memoryContainerId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            boolean willDeleteIndices;
            String ownerId;
            String string = ownerId = container.getOwner() != null ? container.getOwner().getName() : null;
            if (!this.memoryContainerHelper.checkMemoryAccess(user, ownerId)) {
                log.error("User doesn't have permissions to delete the memory container: {}", (Object)memoryContainerId);
                actionListener.onFailure((Exception)new OpenSearchStatusException("Only container owner can delete container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            boolean bl = willDeleteIndices = deleteRequest.isDeleteAllMemories() || !CollectionUtils.isEmpty((Collection)deleteRequest.getDeleteMemories());
            if (willDeleteIndices) {
                MemoryConfiguration configuration = container.getConfiguration();
                String indexPrefix = configuration.getIndexPrefix();
                this.memoryContainerHelper.countContainersWithPrefix(indexPrefix, tenantId, (ActionListener<Long>)ActionListener.wrap(count -> {
                    if (count > 1L) {
                        String error = String.format("Cannot delete memory indices as multiple containers share the index prefix '%s'. Please delete the container without index deletion, or use delete_by_query API for data cleanup.", indexPrefix);
                        log.error("Prevented index deletion for shared prefix '{}': {} containers sharing", (Object)indexPrefix, count);
                        actionListener.onFailure((Exception)new OpenSearchStatusException(error, RestStatus.CONFLICT, new Object[0]));
                    } else {
                        this.deleteMemoryContainer(memoryContainerId, (MLMemoryContainer)container, tenantId, deleteRequest.isDeleteAllMemories(), deleteRequest.getDeleteMemories(), user, actionListener);
                    }
                }, e -> {
                    log.error("Failed to check for shared index prefix, aborting deletion for safety", (Throwable)e);
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }));
            } else {
                this.deleteMemoryContainer(memoryContainerId, (MLMemoryContainer)container, tenantId, deleteRequest.isDeleteAllMemories(), deleteRequest.getDeleteMemories(), user, actionListener);
            }
        }, error -> {
            log.error("Failed to retrieve memory container: {} for deletion", (Object)memoryContainerId, error);
            actionListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }));
    }

    private void deleteMemoryContainer(String memoryContainerId, MLMemoryContainer container, String tenantId, boolean deleteAllMemories, Set<MemoryType> deleteMemories, User user, ActionListener<DeleteResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            DeleteDataObjectRequest deleteRequest = ((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(".plugins-ml-am-memory-container")).id(memoryContainerId)).tenantId(tenantId)).build();
            this.sdkClient.deleteDataObjectAsync(deleteRequest).whenComplete((deleteResponse, throwable) -> this.handleDeleteResponse((DeleteDataObjectResponse)deleteResponse, (Throwable)throwable, deleteRequest.id(), deleteAllMemories, deleteMemories, container, user, listener));
        }
        catch (Exception e) {
            log.error("Failed to delete Memory Container: {}", (Object)memoryContainerId, (Object)e);
            listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private void handleDeleteResponse(DeleteDataObjectResponse response, Throwable throwable, String memoryContainerId, boolean deleteAllMemories, Set<MemoryType> deleteMemories, MLMemoryContainer container, User user, ActionListener<DeleteResponse> actionListener) {
        if (throwable != null) {
            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            log.error("Failed to delete ML Memory Container {}", (Object)memoryContainerId, (Object)cause);
            actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find memory container", RestStatus.NOT_FOUND, new Object[0]));
        } else {
            try {
                DeleteResponse deleteResponse = response.deleteResponse();
                log.info("Delete memory container - Event: CONTAINER_DELETED, Container ID: {}, User: {}, Timestamp: {}", (Object)memoryContainerId, (Object)(user != null ? user.getName() : "unknown"), (Object)Instant.now());
                if (deleteAllMemories || deleteMemories != null && !deleteMemories.isEmpty()) {
                    MemoryConfiguration configuration = container.getConfiguration();
                    if (deleteAllMemories) {
                        this.deleteAllMemoryIndices(memoryContainerId, configuration, user, deleteResponse, actionListener);
                    } else {
                        this.deleteSelectiveMemoryIndices(memoryContainerId, configuration, deleteMemories, user, deleteResponse, actionListener);
                    }
                } else {
                    actionListener.onResponse((Object)deleteResponse);
                }
            }
            catch (Exception e) {
                log.error("Failed to process container deletion", (Throwable)e);
                actionListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }
    }

    private void deleteAllMemoryIndices(String memoryContainerId, MemoryConfiguration configuration, User user, DeleteResponse deleteResponse, ActionListener<DeleteResponse> actionListener) {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(new String[]{configuration.getSessionIndexName(), configuration.getWorkingMemoryIndexName(), configuration.getLongMemoryIndexName(), configuration.getLongMemoryHistoryIndexName()});
        log.debug("Attempting to delete all memory indices for container {}: [{}, {}, {}, {}]", (Object)memoryContainerId, (Object)configuration.getSessionIndexName(), (Object)configuration.getWorkingMemoryIndexName(), (Object)configuration.getLongMemoryIndexName(), (Object)configuration.getLongMemoryHistoryIndexName());
        this.memoryContainerHelper.deleteIndex(configuration, deleteIndexRequest, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(r -> {
            log.info("Delete memory container - Event: ALL_INDICES_DELETED, Container ID: {}, Indices: [{}, {}, {}, {}], User: {}, Timestamp: {}", (Object)memoryContainerId, (Object)configuration.getSessionIndexName(), (Object)configuration.getWorkingMemoryIndexName(), (Object)configuration.getLongMemoryIndexName(), (Object)configuration.getLongMemoryHistoryIndexName(), (Object)(user != null ? user.getName() : "unknown"), (Object)Instant.now());
            actionListener.onResponse((Object)deleteResponse);
        }, e -> {
            log.error("Failed to delete memory indices for container: {}. Indices: [{}, {}, {}, {}]", (Object)memoryContainerId, (Object)configuration.getSessionIndexName(), (Object)configuration.getWorkingMemoryIndexName(), (Object)configuration.getLongMemoryIndexName(), (Object)configuration.getLongMemoryHistoryIndexName(), e);
            actionListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }));
    }

    private void deleteSelectiveMemoryIndices(String memoryContainerId, MemoryConfiguration configuration, Set<MemoryType> deleteMemories, User user, DeleteResponse deleteResponse, ActionListener<DeleteResponse> actionListener) {
        ArrayList<String> indicesToDelete = new ArrayList<String>();
        for (MemoryType memoryType : deleteMemories) {
            String indexName = null;
            switch (memoryType) {
                case SESSIONS: {
                    indexName = configuration.getSessionIndexName();
                    break;
                }
                case WORKING: {
                    indexName = configuration.getWorkingMemoryIndexName();
                    break;
                }
                case LONG_TERM: {
                    indexName = configuration.getLongMemoryIndexName();
                    break;
                }
                case HISTORY: {
                    indexName = configuration.getLongMemoryHistoryIndexName();
                }
            }
            if (indexName == null) continue;
            indicesToDelete.add(indexName);
        }
        if (!indicesToDelete.isEmpty()) {
            log.debug("Attempting selective deletion of memory indices for container {}: {}, requested types: {}", (Object)memoryContainerId, indicesToDelete, deleteMemories);
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indicesToDelete.toArray(new String[0]));
            this.memoryContainerHelper.deleteIndex(configuration, deleteIndexRequest, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(r -> {
                log.info("Delete memory container - Event: SELECTIVE_INDICES_DELETED, Container ID: {}, Indices: {}, Memory Types: {}, User: {}, Timestamp: {}", (Object)memoryContainerId, (Object)indicesToDelete, (Object)deleteMemories, (Object)(user != null ? user.getName() : "unknown"), (Object)Instant.now());
                actionListener.onResponse((Object)deleteResponse);
            }, e -> {
                log.error("Failed to delete selective memory indices [{}] for container: {}.", (Object)memoryContainerId, (Object)indicesToDelete, e);
                actionListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }));
        } else {
            log.info("No valid memory indices to delete for container: {}", (Object)memoryContainerId);
            actionListener.onResponse((Object)deleteResponse);
        }
    }
}

