"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspReportOnlyConfig = void 0;
var _config = require("./config");
var _CspReportOnlyConfig;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
const DEFAULT_CONFIG = Object.freeze(_config.config.schema.validate({}));

/**
 * CSP-Report-Only configuration for use in OpenSearch Dashboards.
 * @public
 */

/**
 * Allowed source configuration for CSP directives.
 * @internal
 */

/**
 * CSP-Report-Only configuration for use in OpenSearch Dashboards.
 * @public
 */
class CspReportOnlyConfig {
  /**
   * Returns the default CSP-Report-Only configuration when passed with no config
   * @internal
   */
  constructor(rawCspReportOnlyConfig = {}) {
    _defineProperty(this, "isEmitting", void 0);
    _defineProperty(this, "rules", void 0);
    _defineProperty(this, "nonceDirectives", void 0);
    _defineProperty(this, "cspReportOnlyHeader", void 0);
    _defineProperty(this, "reportingEndpointsHeader", void 0);
    _defineProperty(this, "endpoint", void 0);
    _defineProperty(this, "useDeprecatedReportUriOnly", void 0);
    _defineProperty(this, "endpointName", 'csp-endpoint');
    const source = {
      ...DEFAULT_CONFIG,
      ...rawCspReportOnlyConfig
    };
    this.isEmitting = source.isEmitting;
    this.useDeprecatedReportUriOnly = source.useDeprecatedReportUriOnly;
    this.nonceDirectives = source.nonceDirectives;
    this.endpoint = source.endpoint;

    // Store processed rules with allowed sources applied
    this.rules = this.applyAllowedSources(source.rules, source);

    // Set up reporting endpoint header if using modern reporting
    if (this.endpoint && !this.useDeprecatedReportUriOnly) {
      this.reportingEndpointsHeader = `${this.endpointName}="${this.endpoint}"`;
    }

    // Build the base header
    this.cspReportOnlyHeader = this.buildHeaderInternal();
  }

  /**
   * Builds the CSP-Report-Only header with nonce values inserted into configured directives.
   * @param nonce - The nonce value to insert (without 'nonce-' prefix)
   * @returns The complete CSP-Report-Only header string with nonces
   */
  buildHeaderWithNonce(nonce) {
    return this.buildHeaderInternal(nonce);
  }

  /**
   * Apply allowed sources to rules that support them.
   * @internal
   */
  applyAllowedSources(rules, sources) {
    return rules.map(rule => {
      if (sources.allowedFrameAncestorSources && rule.startsWith('frame-ancestors')) {
        return `${rule} ${sources.allowedFrameAncestorSources.join(' ')}`;
      }
      if (sources.allowedConnectSources && rule.startsWith('connect-src')) {
        return `${rule} ${sources.allowedConnectSources.join(' ')}`;
      }
      if (sources.allowedImgSources && rule.startsWith('img-src')) {
        return `${rule} ${sources.allowedImgSources.join(' ')}`;
      }
      return rule;
    });
  }

  /**
   * Apply nonces to rules that are in nonceDirectives.
   * @internal
   */
  applyNonces(rules, nonce) {
    return rules.map(rule => {
      const directive = rule.split(' ')[0];
      if (this.nonceDirectives.includes(directive)) {
        return `${rule} 'nonce-${nonce}'`;
      }
      return rule;
    });
  }

  /**
   * Append reporting directives to a header string.
   * @internal
   */
  appendReportingDirectives(header) {
    if (!this.endpoint) {
      return header;
    }
    if (this.useDeprecatedReportUriOnly) {
      return `${header}; report-uri ${this.endpoint};`;
    }
    return `${header}; report-uri ${this.endpoint}; report-to ${this.endpointName};`;
  }

  /**
   * Core header building logic, optionally with nonce.
   * @internal
   */
  buildHeaderInternal(nonce) {
    const rules = nonce ? this.applyNonces(this.rules, nonce) : this.rules;
    const header = rules.join('; ');
    return this.appendReportingDirectives(header);
  }
}
exports.CspReportOnlyConfig = CspReportOnlyConfig;
_CspReportOnlyConfig = CspReportOnlyConfig;
_defineProperty(CspReportOnlyConfig, "DEFAULT", new _CspReportOnlyConfig());