/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaFactory;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.jdbc.CalciteJdbc41Factory;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.tools.RelRunner;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.plan.Scannable;
import org.opensearch.sql.calcite.plan.rule.OpenSearchRules;
import org.opensearch.sql.calcite.plan.rule.PPLSimplifyDedupRule;
import org.opensearch.sql.calcite.profile.PlanProfileBuilder;
import org.opensearch.sql.calcite.utils.OpenSearchRelFieldTrimmer;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.monitor.profile.MetricName;
import org.opensearch.sql.monitor.profile.ProfileContext;
import org.opensearch.sql.monitor.profile.ProfileMetric;
import org.opensearch.sql.monitor.profile.QueryProfiling;

public class CalciteToolsHelper {
    private static final List<RelOptRule> hepRuleList = List.of(FilterMergeRule.Config.DEFAULT.toRule(), PPLSimplifyDedupRule.DEDUP_SIMPLIFY_RULE);
    private static final HepProgram HEP_PROGRAM = new HepProgramBuilder().addRuleCollection(hepRuleList).build();

    public static RelBuilder create(FrameworkConfig config) {
        return RelBuilder.create((FrameworkConfig)config);
    }

    public static OpenSearchRelBuilder create(FrameworkConfig config, JavaTypeFactory typeFactory, Connection connection) {
        return (OpenSearchRelBuilder)((Object)CalciteToolsHelper.withPrepare(config, typeFactory, connection, (cluster, relOptSchema, rootSchema, statement) -> new OpenSearchRelBuilder(config.getContext(), cluster, relOptSchema)));
    }

    public static Connection connect(FrameworkConfig config, JavaTypeFactory typeFactory) {
        Properties info = new Properties();
        if (config.getTypeSystem() != RelDataTypeSystem.DEFAULT) {
            info.setProperty(CalciteConnectionProperty.TYPE_SYSTEM.camelName(), config.getTypeSystem().getClass().getName());
        }
        try {
            return new OpenSearchDriver().connect("jdbc:calcite:", info, null, typeFactory);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static RelBuilderFactory proto(Context context) {
        return (cluster, schema) -> new OpenSearchRelBuilder(context, cluster, schema);
    }

    private static <R> R withPrepare(FrameworkConfig config, JavaTypeFactory typeFactory, Connection connection, Frameworks.BasePrepareAction<R> action) {
        try {
            Properties info = new Properties();
            if (config.getTypeSystem() != RelDataTypeSystem.DEFAULT) {
                info.setProperty(CalciteConnectionProperty.TYPE_SYSTEM.camelName(), config.getTypeSystem().getClass().getName());
            }
            CalciteServerStatement statement = connection.createStatement().unwrap(CalciteServerStatement.class);
            return new OpenSearchPrepareImpl().perform(statement, config, typeFactory, action);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static RelNode optimize(RelNode plan, CalcitePlanContext context) {
        Util.discard((Object)context);
        HepPlanner planner = new HepPlanner(HEP_PROGRAM);
        planner.setRoot(plan);
        return planner.findBestExp();
    }

    public static class OpenSearchRelBuilder
    extends RelBuilder {
        public OpenSearchRelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
            super(context, cluster, relOptSchema);
        }

        public RelBuilder.AggCall avg(boolean distinct, String alias, RexNode operand) {
            return this.aggregateCall(SqlParserPos.ZERO, PPLBuiltinOperators.AVG_NULLABLE, distinct, false, false, null, null, ImmutableList.of(), alias, ImmutableList.of(), ImmutableList.of((Object)operand));
        }
    }

    public static class OpenSearchDriver
    extends Driver {
        public Connection connect(String url, Properties info, CalciteSchema rootSchema, JavaTypeFactory typeFactory) throws SQLException {
            Instant now = Instant.now();
            long nanosSinceEpoch = now.getEpochSecond() * 1000000000L + (long)now.getNano();
            Hook.CURRENT_TIME.addThread(h -> h.set((Object)nanosSinceEpoch));
            CalciteJdbc41Factory factory = new CalciteJdbc41Factory();
            CalciteJdbc41Factory.CalciteJdbc41Connection connection = factory.newConnection((UnregisteredDriver)this, (AvaticaFactory)factory, url, info, rootSchema, typeFactory);
            this.handler.onConnectionInit((AvaticaConnection)connection);
            return connection;
        }

        public CalcitePrepare createPrepare() {
            if (this.prepareFactory != null) {
                return (CalcitePrepare)this.prepareFactory.get();
            }
            return new OpenSearchPrepareImpl();
        }
    }

    public static class OpenSearchPrepareImpl
    extends CalcitePrepareImpl {
        public <R> R perform(CalciteServerStatement statement, FrameworkConfig config, JavaTypeFactory typeFactory, Frameworks.BasePrepareAction<R> action) {
            CalcitePrepare.Context prepareContext = statement.createPrepareContext();
            SchemaPlus defaultSchema = config.getDefaultSchema();
            CalciteSchema schema = defaultSchema != null ? CalciteSchema.from((SchemaPlus)defaultSchema) : prepareContext.getRootSchema();
            CalciteCatalogReader catalogReader = new CalciteCatalogReader(schema.root(), schema.path(null), (RelDataTypeFactory)typeFactory, prepareContext.config());
            RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
            RelOptPlanner planner = this.createPlanner(prepareContext, Contexts.of((Object)prepareContext.config()), config.getCostFactory());
            this.registerCustomizedRules(planner);
            RelOptCluster cluster = this.createCluster(planner, rexBuilder);
            return (R)action.apply(cluster, (RelOptSchema)catalogReader, prepareContext.getRootSchema().plus(), statement);
        }

        private void registerCustomizedRules(RelOptPlanner planner) {
            OpenSearchRules.OPEN_SEARCH_OPT_RULES.forEach(arg_0 -> ((RelOptPlanner)planner).addRule(arg_0));
        }

        protected CalcitePrepareImpl.CalcitePreparingStmt getPreparingStmt(CalcitePrepare.Context context, Type elementType, CalciteCatalogReader catalogReader, RelOptPlanner planner) {
            JavaTypeFactory typeFactory = context.getTypeFactory();
            EnumerableRel.Prefer prefer = elementType == Object[].class ? EnumerableRel.Prefer.ARRAY : EnumerableRel.Prefer.CUSTOM;
            BindableConvention resultConvention = this.enableBindable ? BindableConvention.INSTANCE : EnumerableConvention.INSTANCE;
            return new OpenSearchCalcitePreparingStmt(this, context, (Prepare.CatalogReader)catalogReader, (RelDataTypeFactory)typeFactory, context.getRootSchema(), prefer, this.createCluster(planner, new RexBuilder((RelDataTypeFactory)typeFactory)), (Convention)resultConvention, this.createConvertletTable());
        }
    }

    public static class OpenSearchRelRunners {
        public static PreparedStatement run(CalcitePlanContext context, RelNode rel) {
            PreparedStatement preparedStatement;
            block9: {
                ProfileMetric optimizeTime = QueryProfiling.current().getOrCreateMetric(MetricName.OPTIMIZE);
                long startTime = System.nanoTime();
                rel = CalciteToolsHelper.optimize(rel, context);
                RelHomogeneousShuttle shuttle = new RelHomogeneousShuttle(){

                    public RelNode visit(TableScan scan) {
                        RelOptTable table = scan.getTable();
                        if (scan instanceof LogicalTableScan && Bindables.BindableTableScan.canHandle((RelOptTable)table)) {
                            return Bindables.BindableTableScan.create((RelOptCluster)scan.getCluster(), (RelOptTable)table);
                        }
                        return super.visit(scan);
                    }
                };
                rel = rel.accept((RelShuttle)shuttle);
                Connection connection = context.connection;
                try {
                    RelRunner runner = connection.unwrap(RelRunner.class);
                    PreparedStatement preparedStatement2 = runner.prepareStatement(rel);
                    optimizeTime.set(System.nanoTime() - startTime);
                    preparedStatement = preparedStatement2;
                    if (connection == null) break block9;
                }
                catch (Throwable runner) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable) {
                                runner.addSuppressed(throwable);
                            }
                        }
                        throw runner;
                    }
                    catch (SQLException e) {
                        String errorMsg = e.getMessage();
                        if (errorMsg != null && errorMsg.contains("Error while preparing plan") && errorMsg.contains("WIDTH_BUCKET")) {
                            throw new UnsupportedOperationException("The 'bins' parameter on timestamp fields requires: (1) pushdown to be enabled (controlled by plugins.calcite.pushdown.enabled, enabled by default), and (2) the timestamp field to be used as an aggregation bucket (e.g., 'stats count() by @timestamp').");
                        }
                        throw Util.throwAsRuntime((Throwable)e);
                    }
                }
                connection.close();
            }
            return preparedStatement;
        }
    }

    public static class OpenSearchSqlToRelConverter
    extends SqlToRelConverter {
        protected final RelBuilder relBuilder;

        public OpenSearchSqlToRelConverter(RelOptTable.ViewExpander viewExpander, @Nullable SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, SqlToRelConverter.Config config) {
            super(viewExpander, validator, catalogReader, cluster, convertletTable, config);
            this.relBuilder = config.getRelBuilderFactory().create(cluster, validator != null ? (RelOptSchema)validator.getCatalogReader().unwrap(RelOptSchema.class) : null).transform(config.getRelBuilderConfigTransform());
        }

        protected RelFieldTrimmer newFieldTrimmer() {
            return new OpenSearchRelFieldTrimmer(this.validator, this.relBuilder);
        }
    }

    public static class OpenSearchCalcitePreparingStmt
    extends CalcitePrepareImpl.CalcitePreparingStmt {
        protected final RelOptCluster cluster;

        public OpenSearchCalcitePreparingStmt(CalcitePrepareImpl prepare, CalcitePrepare.Context context, Prepare.CatalogReader catalogReader, RelDataTypeFactory typeFactory, CalciteSchema schema, EnumerableRel.Prefer prefer, RelOptCluster cluster, Convention resultConvention, SqlRexConvertletTable convertletTable) {
            super(prepare, context, catalogReader, typeFactory, schema, prefer, cluster, resultConvention, convertletTable);
            this.cluster = cluster;
        }

        protected Prepare.PreparedResult implement(RelRoot root) {
            RelNode relNode;
            ProfileContext profileContext = QueryProfiling.current();
            if (profileContext.isEnabled()) {
                PlanProfileBuilder.ProfilePlan plan = PlanProfileBuilder.profile(root.rel);
                profileContext.setPlanRoot(plan.planRoot());
                root = root.withRel(plan.rel());
            }
            if ((relNode = root.rel) instanceof Scannable) {
                Scannable scannable = (Scannable)relNode;
                Hook.PLAN_BEFORE_IMPLEMENTATION.run((Object)root);
                final RelDataType resultType = root.rel.getRowType();
                boolean isDml = root.kind.belongsTo((Collection)SqlKind.DML);
                final Bindable bindable = dataContext -> scannable.scan();
                return new Prepare.PreparedResultImpl(this, resultType, Objects.requireNonNull(this.parameterRowType, "parameterRowType"), Objects.requireNonNull(this.fieldOrigins, "fieldOrigins"), (List)(root.collation.getFieldCollations().isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)root.collation)), root.rel, this.mapTableModOp(isDml, root.kind), isDml){

                    public String getCode() {
                        throw new UnsupportedOperationException();
                    }

                    public Bindable getBindable(Meta.CursorFactory cursorFactory) {
                        return bindable;
                    }

                    public Type getElementType() {
                        return resultType.getFieldList().size() == 1 ? Object.class : Object[].class;
                    }
                };
            }
            return super.implement(root);
        }

        protected SqlToRelConverter getSqlToRelConverter(SqlValidator validator, Prepare.CatalogReader catalogReader, SqlToRelConverter.Config config) {
            return new OpenSearchSqlToRelConverter((RelOptTable.ViewExpander)this, validator, catalogReader, this.cluster, this.convertletTable, config);
        }
    }
}

