﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Contains information about the invitation to become a member
 * account.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Invitation">AWS
 * API Reference</a></p>
 */
class Invitation {
 public:
  AWS_GUARDDUTY_API Invitation() = default;
  AWS_GUARDDUTY_API Invitation(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Invitation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the account that the invitation was sent from.</p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  Invitation& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the invitation. This value is used to validate the inviter account
   * to the member account.</p>
   */
  inline const Aws::String& GetInvitationId() const { return m_invitationId; }
  inline bool InvitationIdHasBeenSet() const { return m_invitationIdHasBeenSet; }
  template <typename InvitationIdT = Aws::String>
  void SetInvitationId(InvitationIdT&& value) {
    m_invitationIdHasBeenSet = true;
    m_invitationId = std::forward<InvitationIdT>(value);
  }
  template <typename InvitationIdT = Aws::String>
  Invitation& WithInvitationId(InvitationIdT&& value) {
    SetInvitationId(std::forward<InvitationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the relationship between the inviter and invitee accounts.</p>
   */
  inline const Aws::String& GetRelationshipStatus() const { return m_relationshipStatus; }
  inline bool RelationshipStatusHasBeenSet() const { return m_relationshipStatusHasBeenSet; }
  template <typename RelationshipStatusT = Aws::String>
  void SetRelationshipStatus(RelationshipStatusT&& value) {
    m_relationshipStatusHasBeenSet = true;
    m_relationshipStatus = std::forward<RelationshipStatusT>(value);
  }
  template <typename RelationshipStatusT = Aws::String>
  Invitation& WithRelationshipStatus(RelationshipStatusT&& value) {
    SetRelationshipStatus(std::forward<RelationshipStatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when the invitation was sent.</p>
   */
  inline const Aws::String& GetInvitedAt() const { return m_invitedAt; }
  inline bool InvitedAtHasBeenSet() const { return m_invitedAtHasBeenSet; }
  template <typename InvitedAtT = Aws::String>
  void SetInvitedAt(InvitedAtT&& value) {
    m_invitedAtHasBeenSet = true;
    m_invitedAt = std::forward<InvitedAtT>(value);
  }
  template <typename InvitedAtT = Aws::String>
  Invitation& WithInvitedAt(InvitedAtT&& value) {
    SetInvitedAt(std::forward<InvitedAtT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_accountId;

  Aws::String m_invitationId;

  Aws::String m_relationshipStatus;

  Aws::String m_invitedAt;
  bool m_accountIdHasBeenSet = false;
  bool m_invitationIdHasBeenSet = false;
  bool m_relationshipStatusHasBeenSet = false;
  bool m_invitedAtHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
