/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Locale;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public class CheckBox
extends FormComponent<Boolean> {
    private static final long serialVersionUID = 1L;

    public CheckBox(String id) {
        this(id, (IModel<Boolean>)null);
    }

    public CheckBox(String id, IModel<Boolean> model) {
        super(id, model);
        this.setType(Boolean.class);
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "checkbox");
        String value = this.getValue();
        IConverter<Boolean> converter = this.getConverter(Boolean.class);
        Boolean checked = converter.convertToObject(value, this.getLocale());
        if (Boolean.TRUE.equals(checked)) {
            tag.put("checked", "checked");
        } else {
            tag.remove("checked");
        }
        tag.remove("value");
        super.onComponentTag(tag);
    }

    @Override
    protected IConverter<?> createConverter(Class<?> type) {
        if (Boolean.class.equals(type)) {
            return CheckBoxConverter.INSTANCE;
        }
        return null;
    }

    @Override
    public boolean checkRequired() {
        return true;
    }

    private static class CheckBoxConverter
    implements IConverter<Boolean> {
        private static final long serialVersionUID = 1L;
        private static final IConverter<Boolean> INSTANCE = new CheckBoxConverter();

        private CheckBoxConverter() {
        }

        @Override
        public Boolean convertToObject(String value, Locale locale) {
            if ("on".equals(value) || "true".equals(value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public String convertToString(Boolean value, Locale locale) {
            return value.toString();
        }
    }
}

