/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authorization.strategies;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.request.component.IRequestableComponent;

public class CompoundAuthorizationStrategy
implements IAuthorizationStrategy {
    private final List<IAuthorizationStrategy> strategies = new ArrayList<IAuthorizationStrategy>();

    public final void add(IAuthorizationStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("Strategy argument cannot be null");
        }
        this.strategies.add(strategy);
    }

    @Override
    public final <T extends IRequestableComponent> boolean isInstantiationAuthorized(Class<T> componentClass) {
        for (IAuthorizationStrategy strategy : this.strategies) {
            if (strategy.isInstantiationAuthorized(componentClass)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isActionAuthorized(Component component, Action action) {
        for (IAuthorizationStrategy strategy : this.strategies) {
            if (strategy.isActionAuthorized(component, action)) continue;
            return false;
        }
        return true;
    }
}

