/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldMemoryUsage
implements JsonpSerializable {
    @Nullable
    private final String memorySize;
    private final long memorySizeInBytes;
    public static final JsonpDeserializer<FieldMemoryUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldMemoryUsage::setupFieldMemoryUsageDeserializer);

    private FieldMemoryUsage(Builder builder) {
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = ApiTypeHelper.requireNonNull(builder.memorySizeInBytes, (Object)this, "memorySizeInBytes", 0L);
    }

    public static FieldMemoryUsage of(Function<Builder, ObjectBuilder<FieldMemoryUsage>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String memorySize() {
        return this.memorySize;
    }

    public final long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupFieldMemoryUsageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size");
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldMemoryUsage> {
        @Nullable
        private String memorySize;
        private Long memorySizeInBytes;

        public final Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        public final Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldMemoryUsage build() {
            this._checkSingleUse();
            return new FieldMemoryUsage(this);
        }
    }
}

