/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.LambdaHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.EmptyTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalProduct;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class SackValueStep<S, A, B>
extends AbstractStep<S, S>
implements TraversalParent,
ByModulating,
LambdaHolder {
    private Traversal.Admin<S, B> sackTraversal = null;
    private BiFunction<A, B, A> sackFunction;

    public SackValueStep(Traversal.Admin traversal, BiFunction<A, B, A> sackFunction) {
        super(traversal);
        this.sackFunction = sackFunction;
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> sackTraversal) {
        if (this.sackTraversal != null) {
            throw new IllegalStateException("Sack step can only have one by modulator");
        }
        this.sackTraversal = this.integrateChild(sackTraversal);
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        if (null != this.sackTraversal && this.sackTraversal.equals(oldTraversal)) {
            this.sackTraversal = this.integrateChild(newTraversal);
        }
    }

    public List<Traversal.Admin<S, B>> getLocalChildren() {
        return null == this.sackTraversal ? Collections.emptyList() : Collections.singletonList(this.sackTraversal);
    }

    @Override
    protected Traverser.Admin<S> processNextStart() {
        Object traverser = this.starts.next();
        if (null == this.sackTraversal) {
            traverser.sack(this.sackFunction.apply(traverser.sack(), traverser.get()));
            return traverser;
        }
        TraversalProduct product = TraversalUtil.produce(traverser, this.sackTraversal);
        if (!product.isProductive()) {
            return EmptyTraverser.instance();
        }
        traverser.sack(this.sackFunction.apply(traverser.sack(), product.get()));
        return traverser;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.sackFunction, this.sackTraversal);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.sackFunction.hashCode() ^ (null == this.sackTraversal ? "null".hashCode() : this.sackTraversal.hashCode());
    }

    public BiFunction<A, B, A> getSackFunction() {
        return this.sackFunction;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.SACK);
    }

    @Override
    public SackValueStep<S, A, B> clone() {
        SackValueStep clone = (SackValueStep)super.clone();
        if (null != this.sackTraversal) {
            clone.sackTraversal = this.sackTraversal.clone();
        }
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.sackTraversal);
    }
}

