/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.ser;

import io.netty.buffer.ByteBufAllocator;
import java.nio.ByteBuffer;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.AbstractGraphSONMessageSerializerV2;
import org.apache.tinkerpop.gremlin.util.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphSONMessageSerializerV3
extends AbstractGraphSONMessageSerializerV2
implements MessageTextSerializer<ObjectMapper> {
    private static final Logger logger = LoggerFactory.getLogger(GraphSONMessageSerializerV3.class);
    private static final String MIME_TYPE = "application/vnd.gremlin-v3.0+json";
    private static byte[] header;

    public GraphSONMessageSerializerV3() {
    }

    @Deprecated
    public GraphSONMessageSerializerV3(GraphSONMapper mapper) {
        super(mapper);
    }

    public GraphSONMessageSerializerV3(GraphSONMapper.Builder mapperBuilder) {
        super(mapperBuilder);
    }

    @Override
    public String[] mimeTypesSupported() {
        return new String[]{MIME_TYPE, "application/json"};
    }

    @Override
    GraphSONMapper.Builder configureBuilder(GraphSONMapper.Builder builder) {
        return builder.version(GraphSONVersion.V3_0).addCustomModule((SimpleModule)new AbstractGraphSONMessageSerializerV2.GremlinServerModule());
    }

    @Override
    byte[] obtainHeader() {
        return header;
    }

    @Override
    public ResponseMessage deserializeResponse(String msg) throws SerializationException {
        try {
            return (ResponseMessage)this.mapper.readValue(msg, ResponseMessage.class);
        }
        catch (Exception ex) {
            logger.warn(String.format("Response [%s] could not be deserialized by %s.", msg, GraphSONMessageSerializerV3.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public String serializeResponseAsString(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        try {
            return this.mapper.writeValueAsString((Object)responseMessage);
        }
        catch (Exception ex) {
            logger.warn(String.format("Response [%s] could not be serialized by %s.", responseMessage.toString(), GraphSONMessageSerializerV3.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public RequestMessage deserializeRequest(String msg) throws SerializationException {
        try {
            return (RequestMessage)this.mapper.readValue(msg, RequestMessage.class);
        }
        catch (Exception ex) {
            logger.warn(String.format("Request [%s] could not be deserialized by %s.", msg, GraphSONMessageSerializerV3.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public String serializeRequestAsString(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        try {
            return this.mapper.writeValueAsString((Object)requestMessage);
        }
        catch (Exception ex) {
            logger.warn(String.format("Request [%s] could not be serialized by %s.", requestMessage.toString(), GraphSONMessageSerializerV3.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    static {
        ByteBuffer buffer = ByteBuffer.allocate(MIME_TYPE.length() + 1);
        buffer.put((byte)MIME_TYPE.length());
        buffer.put(MIME_TYPE.getBytes());
        header = buffer.array();
    }
}

