/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class AnonymousTraversalSource<T extends TraversalSource> {
    private final Class<T> traversalSourceClass;

    private AnonymousTraversalSource(Class<T> traversalSourceClass) {
        this.traversalSourceClass = traversalSourceClass;
    }

    public static AnonymousTraversalSource<GraphTraversalSource> traversal() {
        return AnonymousTraversalSource.traversal(GraphTraversalSource.class);
    }

    public static <T extends TraversalSource> AnonymousTraversalSource<T> traversal(Class<T> traversalSourceClass) {
        return new AnonymousTraversalSource<T>(traversalSourceClass);
    }

    public T withRemote(String configFile) throws Exception {
        Configurations configs = new Configurations();
        return this.withRemote((Configuration)configs.properties(configFile));
    }

    public T withRemote(Configuration conf) {
        return this.withRemote(RemoteConnection.from(conf));
    }

    public T withRemote(RemoteConnection remoteConnection) {
        try {
            return (T)((TraversalSource)this.traversalSourceClass.getConstructor(RemoteConnection.class).newInstance(remoteConnection));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Deprecated
    public T withGraph(Graph graph) {
        return this.withEmbedded(graph);
    }

    public T withEmbedded(Graph graph) {
        try {
            return (T)((TraversalSource)this.traversalSourceClass.getConstructor(Graph.class).newInstance(graph));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

