/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.xmb;

import com.google.gxp.com.google.common.base.CharEscaper;
import com.google.gxp.com.google.common.base.Charsets;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.base.Util;
import com.google.gxp.compiler.codegen.BaseCodeGenerator;
import com.google.gxp.compiler.msgextract.MessageExtractedTree;
import com.google.gxp.compiler.xmb.XmlCharsetEscaper;
import com.google.transconsole.common.messages.MessageBundle;
import com.google.transconsole.common.xml.XmbBundleWriter;
import java.io.IOException;

public class XmbCodeGenerator
extends BaseCodeGenerator<MessageExtractedTree> {
    private static final CharEscaper XML_ASCII_ESCAPER = new XmlCharsetEscaper(Charsets.US_ASCII);

    public XmbCodeGenerator(MessageExtractedTree tree) {
        super(tree);
    }

    @Override
    public void generateCode(Appendable out, AlertSink alertSink) throws IOException {
        alertSink.addAll(((MessageExtractedTree)this.tree).getAlerts());
        MessageBundle messageBundle = Util.bundleMessages(alertSink, ((MessageExtractedTree)this.tree).getMessages());
        XmbBundleWriter bundleWriter = new XmbBundleWriter(messageBundle);
        bundleWriter.write(XML_ASCII_ESCAPER.escape(out));
    }
}

