/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.via;

import org.apache.sling.models.annotations.via.BeanProperty;
import org.apache.sling.models.impl.via.BeanPropertyViaProvider;
import org.apache.sling.models.spi.ViaProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class BeanPropertyViaProviderTest {
    private BeanPropertyViaProvider provider = new BeanPropertyViaProvider();

    BeanPropertyViaProviderTest() {
    }

    @Test
    void testGetType() {
        Assertions.assertEquals(BeanProperty.class, (Object)this.provider.getType());
    }

    @Test
    void testGetAdaptable() {
        Assertions.assertEquals((Object)ViaProvider.ORIGINAL, (Object)this.provider.getAdaptable(new Object(), ""));
        Assertions.assertNull((Object)this.provider.getAdaptable(null, "expectedException"));
        Assertions.assertNull((Object)this.provider.getAdaptable(new Object(), "notfound"));
        TestBean testBean = new TestBean("value1", null);
        Assertions.assertEquals((Object)"value1", (Object)this.provider.getAdaptable((Object)testBean, "field1"));
        testBean = new TestBean("value1", new TestNestedBean());
        Assertions.assertEquals((Object)"nestedValue1", (Object)this.provider.getAdaptable((Object)testBean, "nested1.nestedField1"));
    }

    private static class TestBean {
        private String field1;
        private TestNestedBean nested1;

        private TestBean(String field1, TestNestedBean nested1) {
            this.field1 = field1;
            this.nested1 = nested1;
        }

        public String getField1() {
            return this.field1;
        }

        public TestNestedBean getNested1() {
            return this.nested1;
        }
    }

    private static class TestNestedBean {
        private TestNestedBean() {
        }

        public String getNestedField1() {
            return "nestedValue1";
        }
    }
}

