/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.models.impl.injectors.SlingObjectInjector;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class SlingObjectInjectorResourceResolverTest {
    private final SlingObjectInjector injector = new SlingObjectInjector();
    @Mock
    private AnnotatedElement annotatedElement;
    @Mock
    private ResourceResolver resourceResolver;
    @Mock
    private DisposalCallbackRegistry registry;

    SlingObjectInjectorResourceResolverTest() {
    }

    @Test
    void testResourceResolver() {
        Object result = this.injector.getValue((Object)this.resourceResolver, null, ResourceResolver.class, this.annotatedElement, this.registry);
        Assert.assertSame((Object)this.resourceResolver, (Object)result);
    }

    @Test
    void testResource() {
        Object result = this.injector.getValue((Object)this.resourceResolver, null, Resource.class, this.annotatedElement, this.registry);
        Assert.assertNull((Object)result);
    }

    @Deprecated(since="2.0.0")
    @Test
    void testJavaxRequest() {
        Object result = this.injector.getValue((Object)this.resourceResolver, null, SlingHttpServletRequest.class, this.annotatedElement, this.registry);
        Assert.assertNull((Object)result);
    }

    @Deprecated(since="2.0.0")
    @Test
    void testJavaxResponse() {
        Object result = this.injector.getValue((Object)this.resourceResolver, null, SlingHttpServletResponse.class, this.annotatedElement, this.registry);
        Assert.assertNull((Object)result);
    }

    @Test
    void testJakartaRequest() {
        Object result = this.injector.getValue((Object)this.resourceResolver, null, SlingJakartaHttpServletRequest.class, this.annotatedElement, this.registry);
        Assert.assertNull((Object)result);
    }

    @Test
    void testJakartaResponse() {
        Object result = this.injector.getValue((Object)this.resourceResolver, null, SlingJakartaHttpServletResponse.class, this.annotatedElement, this.registry);
        Assert.assertNull((Object)result);
    }

    @Test
    void testScriptHelper() {
        Object result = this.injector.getValue((Object)this.resourceResolver, null, SlingScriptHelper.class, this.annotatedElement, this.registry);
        Assert.assertNull((Object)result);
    }

    @Test
    void testInvalid() {
        Object result = this.injector.getValue((Object)this, null, SlingScriptHelper.class, this.annotatedElement, this.registry);
        Assert.assertNull((Object)result);
    }
}

