/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.util.Collection;
import java.util.Locale;
import java.util.function.Predicate;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.internal.shared.CodeLists;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;

public final class VerticalDatumTypes
implements Predicate<CodeList<?>> {
    static final String ELLIPSOIDAL = "ELLIPSOIDAL";
    private static final String ORTHOMETRIC = "ORTHOMETRIC";
    static final String BAROMETRIC = "BAROMETRIC";
    static final String LOCAL = "LOCAL";
    private final StringBuilder datum;

    public static VerticalDatumType ellipsoidal() {
        return VerticalDatumType.valueOf((String)ELLIPSOIDAL);
    }

    public static boolean ellipsoidal(VerticalDatumType method) {
        return method != null && ELLIPSOIDAL.equalsIgnoreCase(method.name());
    }

    public static VerticalDatumType fromLegacyCode(int code) {
        switch (code) {
            case 2001: {
                return VerticalDatumType.valueOf((String)ORTHOMETRIC);
            }
            case 2002: {
                return VerticalDatumTypes.ellipsoidal();
            }
            case 2003: {
                return VerticalDatumType.BAROMETRIC;
            }
            case 2005: {
                return VerticalDatumType.GEOIDAL;
            }
            case 2006: {
                return VerticalDatumType.DEPTH;
            }
        }
        return null;
    }

    public static int toLegacyCode(VerticalDatumType method) {
        if (method != null) {
            switch (method.name().toUpperCase(Locale.US)) {
                case "ORTHOMETRIC": {
                    return 2001;
                }
                case "ELLIPSOIDAL": {
                    return 2002;
                }
                case "BAROMETRIC": {
                    return 2003;
                }
                case "GEOIDAL": 
                case "GEOID": {
                    return 2005;
                }
                case "LEVELLING": 
                case "TIDAL": 
                case "DEPTH": {
                    return 2006;
                }
            }
        }
        return 2000;
    }

    public static VerticalDatumType fromMethod(String name) {
        VerticalDatumType method = VerticalDatumTypes.fromDatum(name);
        if (method == null && name != null && !name.isBlank()) {
            int s = name.lastIndexOf(45);
            if (s >= 0 && name.substring(s + 1).strip().equalsIgnoreCase("based")) {
                method = VerticalDatumTypes.fromDatum(name.substring(0, s));
            }
            if (method == null) {
                method = VerticalDatumType.valueOf((String)name);
            }
        }
        return method;
    }

    public static VerticalDatumType fromDatum(String name, Collection<? extends GenericName> aliases, CoordinateSystemAxis axis) {
        VerticalDatumType method = VerticalDatumTypes.fromDatum(name);
        if (method != null) {
            return method;
        }
        if (aliases != null) {
            for (GenericName genericName : aliases) {
                method = VerticalDatumTypes.fromDatum(genericName.tip().toString());
                if (method == null) continue;
                return method;
            }
        }
        if (axis != null) {
            Unit unit = axis.getUnit();
            if (Units.isLinear((Unit)unit)) {
                String string = axis.getAbbreviation();
                if (string.length() == 1) {
                    AxisDirection dir = AxisDirection.UP;
                    switch (string.charAt(0)) {
                        case 'h': {
                            method = VerticalDatumTypes.ellipsoidal();
                            break;
                        }
                        case 'H': {
                            method = VerticalDatumType.GEOIDAL;
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            method = VerticalDatumType.DEPTH;
                            dir = AxisDirection.DOWN;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    if (dir.equals((Object)axis.getDirection())) {
                        return method;
                    }
                }
            } else if (Units.isPressure((Unit)unit)) {
                return VerticalDatumType.BAROMETRIC;
            }
        }
        return VerticalDatumType.OTHER_SURFACE;
    }

    private static VerticalDatumType fromDatum(String name) {
        if (name != null) {
            int c;
            if (CharSequences.equalsFiltered((CharSequence)"Mean Sea Level", (CharSequence)name, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true)) {
                return VerticalDatumType.GEOIDAL;
            }
            int i = 0;
            do {
                if (!name.regionMatches(true, i, "geoid", 0, 5)) continue;
                return VerticalDatumType.GEOIDAL;
            } while ((i = name.indexOf(32, i) + 1) > 0);
            if (name.equalsIgnoreCase("Tidal")) {
                return VerticalDatumType.DEPTH;
            }
            for (i = 0; i < name.length(); i += Character.charCount(c)) {
                c = name.codePointAt(i);
                if (!Character.isLetter(c)) continue;
                return (VerticalDatumType)CodeLists.find(VerticalDatumType.class, (Predicate)new VerticalDatumTypes(name));
            }
        }
        return null;
    }

    private VerticalDatumTypes(String name) {
        int c;
        int length = name.length();
        this.datum = new StringBuilder(length);
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = name.codePointAt(i);
            this.datum.appendCodePoint(Character.toUpperCase(c));
        }
        StringBuilders.toASCII((StringBuilder)this.datum);
    }

    @Override
    public boolean test(CodeList<?> code) {
        int i = this.datum.indexOf(code.name());
        return i == 0 || i >= 0 && Character.isWhitespace(this.datum.codePointBefore(i));
    }
}

