/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.time.temporal.Temporal;
import java.util.Date;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.temporal.TemporalDate;
import org.opengis.metadata.acquisition.RequestedDate;

@XmlType(name="MI_RequestedDate_Type", propOrder={"requestedDateOfCollection", "latestAcceptableDate"})
@XmlRootElement(name="MI_RequestedDate")
public class DefaultRequestedDate
extends ISOMetadata
implements RequestedDate {
    private static final long serialVersionUID = -8491304736666217656L;
    private Temporal requestedDateOfCollection;
    private Temporal latestAcceptableDate;

    public DefaultRequestedDate() {
    }

    public DefaultRequestedDate(RequestedDate object) {
        super(object);
        if (object != null) {
            this.requestedDateOfCollection = TemporalDate.toTemporal(object.getRequestedDateOfCollection());
            this.latestAcceptableDate = TemporalDate.toTemporal(object.getLatestAcceptableDate());
        }
    }

    public static DefaultRequestedDate castOrCopy(RequestedDate object) {
        if (object == null || object instanceof DefaultRequestedDate) {
            return (DefaultRequestedDate)object;
        }
        return new DefaultRequestedDate(object);
    }

    @XmlElement(name="requestedDateOfCollection", required=true)
    public Date getRequestedDateOfCollection() {
        return TemporalDate.toDate(this.requestedDateOfCollection);
    }

    public void setRequestedDateOfCollection(Temporal newValue) {
        this.checkWritePermission(this.requestedDateOfCollection);
        this.requestedDateOfCollection = newValue;
    }

    @Deprecated(since="1.5")
    public void setRequestedDateOfCollection(Date newValue) {
        this.setRequestedDateOfCollection(TemporalDate.toTemporal(newValue));
    }

    @XmlElement(name="latestAcceptableDate", required=true)
    public Date getLatestAcceptableDate() {
        return TemporalDate.toDate(this.latestAcceptableDate);
    }

    public void setLatestAcceptableDate(Temporal newValue) {
        this.checkWritePermission(this.latestAcceptableDate);
        this.latestAcceptableDate = newValue;
    }

    @Deprecated(since="1.5")
    public void setLatestAcceptableDate(Date newValue) {
        this.setLatestAcceptableDate(TemporalDate.toTemporal(newValue));
    }
}

