/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleAccumulation;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

@ThreadSafe
public final class DoubleLastValueAggregator
implements Aggregator<DoubleAccumulation, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleLastValueAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier) {
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<DoubleAccumulation, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public DoubleAccumulation merge(DoubleAccumulation previous, DoubleAccumulation current) {
        return current;
    }

    @Override
    public DoubleAccumulation diff(DoubleAccumulation previous, DoubleAccumulation current) {
        return current;
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Map<Attributes, DoubleAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpochNanos, long epochNanos) {
        return ImmutableMetricData.createDoubleGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(MetricDataUtils.toDoublePointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpochNanos, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<DoubleAccumulation, DoubleExemplarData> {
        @Nullable
        private static final Double DEFAULT_VALUE = null;
        private final AtomicReference<Double> current = new AtomicReference<Double>(DEFAULT_VALUE);

        private Handle(ExemplarReservoir<DoubleExemplarData> reservoir) {
            super(reservoir);
        }

        @Override
        protected DoubleAccumulation doAccumulateThenReset(List<DoubleExemplarData> exemplars) {
            return DoubleAccumulation.create(this.current.getAndSet(DEFAULT_VALUE), exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.set(value);
        }
    }
}

