/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.otlp;

import java.io.IOException;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.rocketmq.shaded.io.opentelemetry.proto.common.v1.internal.AnyValue;

public final class StringAnyValueMarshaler
extends MarshalerWithSize {
    private final byte[] valueUtf8;

    public StringAnyValueMarshaler(byte[] valueUtf8) {
        super(StringAnyValueMarshaler.calculateSize(valueUtf8));
        this.valueUtf8 = valueUtf8;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeString(AnyValue.STRING_VALUE, this.valueUtf8);
    }

    private static int calculateSize(byte[] valueUtf8) {
        return AnyValue.STRING_VALUE.getTagSize() + CodedOutputStream.computeByteArraySizeNoTag(valueUtf8);
    }
}

