/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.elect.impl;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.controller.BrokerLiveInfo;
import org.apache.rocketmq.controller.elect.ElectPolicy;

public class DefaultElectPolicy
implements ElectPolicy {
    private BiPredicate<String, String> validPredicate;
    private BiFunction<String, String, BrokerLiveInfo> additionalInfoGetter;
    private final Comparator<BrokerLiveInfo> comparator = (x, y) -> x.getEpoch() == y.getEpoch() ? (int)(y.getMaxOffset() - x.getMaxOffset()) : y.getEpoch() - x.getEpoch();

    public DefaultElectPolicy(BiPredicate<String, String> validPredicate, BiFunction<String, String, BrokerLiveInfo> additionalInfoGetter) {
        this.validPredicate = validPredicate;
        this.additionalInfoGetter = additionalInfoGetter;
    }

    public DefaultElectPolicy() {
    }

    @Override
    public String elect(String clusterName, Set<String> syncStateBrokers, Set<String> allReplicaBrokers, String oldMaster, String preferBrokerAddr) {
        String newMaster = null;
        if (syncStateBrokers != null) {
            newMaster = this.tryElect(clusterName, syncStateBrokers, oldMaster, preferBrokerAddr);
        }
        if (StringUtils.isNotEmpty(newMaster)) {
            return newMaster;
        }
        if (allReplicaBrokers != null) {
            newMaster = this.tryElect(clusterName, allReplicaBrokers, oldMaster, preferBrokerAddr);
        }
        return newMaster;
    }

    private String tryElect(String clusterName, Set<String> brokers, String oldMaster, String preferBrokerAddr) {
        if (this.validPredicate != null) {
            brokers = brokers.stream().filter(brokerAddr -> this.validPredicate.test(clusterName, (String)brokerAddr)).collect(Collectors.toSet());
        }
        if (brokers.size() >= 1) {
            if (brokers.contains(oldMaster) && (StringUtils.isBlank((CharSequence)preferBrokerAddr) || preferBrokerAddr.equals(oldMaster))) {
                return oldMaster;
            }
            if (StringUtils.isNotBlank((CharSequence)preferBrokerAddr)) {
                return brokers.contains(preferBrokerAddr) ? preferBrokerAddr : null;
            }
            if (this.additionalInfoGetter != null) {
                TreeSet<BrokerLiveInfo> brokerLiveInfos = new TreeSet<BrokerLiveInfo>(this.comparator);
                brokers.forEach(brokerAddr -> brokerLiveInfos.add(this.additionalInfoGetter.apply(clusterName, (String)brokerAddr)));
                if (brokerLiveInfos.size() >= 1) {
                    return brokerLiveInfos.first().getBrokerAddr();
                }
            }
            return brokers.iterator().next();
        }
        return null;
    }

    public BiFunction<String, String, BrokerLiveInfo> getAdditionalInfoGetter() {
        return this.additionalInfoGetter;
    }

    public void setAdditionalInfoGetter(BiFunction<String, String, BrokerLiveInfo> additionalInfoGetter) {
        this.additionalInfoGetter = additionalInfoGetter;
    }

    public BiPredicate<String, String> getValidPredicate() {
        return this.validPredicate;
    }

    public void setValidPredicate(BiPredicate<String, String> validPredicate) {
        this.validPredicate = validPredicate;
    }
}

