/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.common;

import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class RemotingHelper {
    public static final String ROCKETMQ_REMOTING = "RocketmqRemoting";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final AttributeKey<String> REMOTE_ADDR_KEY = AttributeKey.valueOf((String)"RemoteAddr");

    public static String exceptionSimpleDesc(Throwable e) {
        StringBuilder sb = new StringBuilder();
        if (e != null) {
            sb.append(e.toString());
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                StackTraceElement element = stackTrace[0];
                sb.append(", ");
                sb.append(element.toString());
            }
        }
        return sb.toString();
    }

    public static SocketAddress string2SocketAddress(String addr) {
        int split = addr.lastIndexOf(":");
        String host = addr.substring(0, split);
        String port = addr.substring(split + 1);
        InetSocketAddress isa = new InetSocketAddress(host, Integer.parseInt(port));
        return isa;
    }

    public static RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, RemotingCommandException {
        long beginTime = System.currentTimeMillis();
        SocketAddress socketAddress = RemotingUtil.string2SocketAddress(addr);
        SocketChannel socketChannel = RemotingUtil.connect(socketAddress);
        if (socketChannel != null) {
            boolean sendRequestOK = false;
            try {
                socketChannel.configureBlocking(true);
                socketChannel.socket().setSoTimeout((int)timeoutMillis);
                ByteBuffer byteBufferRequest = request.encode();
                while (byteBufferRequest.hasRemaining()) {
                    int length = socketChannel.write(byteBufferRequest);
                    if (length > 0) {
                        if (byteBufferRequest.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingSendRequestException(addr);
                        }
                    } else {
                        throw new RemotingSendRequestException(addr);
                    }
                    Thread.sleep(1L);
                }
                sendRequestOK = true;
                ByteBuffer byteBufferSize = ByteBuffer.allocate(4);
                while (byteBufferSize.hasRemaining()) {
                    int length = socketChannel.read(byteBufferSize);
                    if (length > 0) {
                        if (byteBufferSize.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingTimeoutException(addr, timeoutMillis);
                        }
                    } else {
                        throw new RemotingTimeoutException(addr, timeoutMillis);
                    }
                    Thread.sleep(1L);
                }
                int size = byteBufferSize.getInt(0);
                ByteBuffer byteBufferBody = ByteBuffer.allocate(size);
                while (byteBufferBody.hasRemaining()) {
                    int length = socketChannel.read(byteBufferBody);
                    if (length > 0) {
                        if (byteBufferBody.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingTimeoutException(addr, timeoutMillis);
                        }
                    } else {
                        throw new RemotingTimeoutException(addr, timeoutMillis);
                    }
                    Thread.sleep(1L);
                }
                byteBufferBody.flip();
                RemotingCommand remotingCommand = RemotingCommand.decode(byteBufferBody);
                return remotingCommand;
            }
            catch (IOException e) {
                log.error("invokeSync failure", (Throwable)e);
                if (sendRequestOK) {
                    throw new RemotingTimeoutException(addr, timeoutMillis);
                }
                throw new RemotingSendRequestException(addr);
            }
            finally {
                try {
                    socketChannel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        throw new RemotingConnectException(addr);
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        if (null == channel) {
            return "";
        }
        Attribute att = channel.attr(REMOTE_ADDR_KEY);
        if (att == null) {
            return RemotingHelper.parseChannelRemoteAddr0(channel);
        }
        String addr = (String)att.get();
        if (addr == null) {
            addr = RemotingHelper.parseChannelRemoteAddr0(channel);
            att.set((Object)addr);
        }
        return addr;
    }

    private static String parseChannelRemoteAddr0(Channel channel) {
        String addr;
        SocketAddress remote = channel.remoteAddress();
        String string = addr = remote != null ? remote.toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static String parseHostFromAddress(String address) {
        if (address == null) {
            return "";
        }
        String[] addressSplits = address.split(":");
        if (addressSplits.length < 1) {
            return "";
        }
        return addressSplits[0];
    }

    public static String parseSocketAddressAddr(SocketAddress socketAddress) {
        if (socketAddress != null) {
            String addr = socketAddress.toString();
            int index = addr.lastIndexOf("/");
            return index != -1 ? addr.substring(index + 1) : addr;
        }
        return "";
    }

    public static int parseSocketAddressPort(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)socketAddress).getPort();
        }
        return -1;
    }

    public static int ipToInt(String ip) {
        String[] ips = ip.split("\\.");
        return Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
    }

    public static boolean ipInCIDR(String ip, String cidr) {
        int cidrIpAddr;
        String[] cidrArr;
        int netId;
        int mask;
        int ipAddr = RemotingHelper.ipToInt(ip);
        return (ipAddr & (mask = -1 << 32 - (netId = Integer.parseInt((cidrArr = cidr.split("/"))[1])))) == ((cidrIpAddr = RemotingHelper.ipToInt(cidrArr[0])) & mask);
    }
}

