/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupEvent;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.broker.client.ConsumerManager;
import org.apache.rocketmq.broker.client.ProducerChangeListener;
import org.apache.rocketmq.broker.client.ProducerGroupEvent;
import org.apache.rocketmq.broker.client.ProducerManager;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.proxy.common.AbstractStartAndShutdown;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.service.ServiceManager;
import org.apache.rocketmq.proxy.service.message.ClusterMessageService;
import org.apache.rocketmq.proxy.service.message.MessageService;
import org.apache.rocketmq.proxy.service.metadata.ClusterMetadataService;
import org.apache.rocketmq.proxy.service.metadata.MetadataService;
import org.apache.rocketmq.proxy.service.mqclient.DoNothingClientRemotingProcessor;
import org.apache.rocketmq.proxy.service.mqclient.MQClientAPIFactory;
import org.apache.rocketmq.proxy.service.mqclient.ProxyClientRemotingProcessor;
import org.apache.rocketmq.proxy.service.relay.ClusterProxyRelayService;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayService;
import org.apache.rocketmq.proxy.service.route.ClusterTopicRouteService;
import org.apache.rocketmq.proxy.service.route.TopicRouteService;
import org.apache.rocketmq.proxy.service.transaction.ClusterTransactionService;
import org.apache.rocketmq.proxy.service.transaction.TransactionService;
import org.apache.rocketmq.remoting.RPCHook;

public class ClusterServiceManager
extends AbstractStartAndShutdown
implements ServiceManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqProxy");
    protected ClusterTransactionService clusterTransactionService;
    protected ProducerManager producerManager;
    protected ConsumerManager consumerManager;
    protected TopicRouteService topicRouteService;
    protected MessageService messageService;
    protected ProxyRelayService proxyRelayService;
    protected ClusterMetadataService metadataService;
    protected ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(3);
    protected MQClientAPIFactory messagingClientAPIFactory;
    protected MQClientAPIFactory operationClientAPIFactory;
    protected MQClientAPIFactory transactionClientAPIFactory;

    public ClusterServiceManager(RPCHook rpcHook) {
        this.producerManager = new ProducerManager();
        this.consumerManager = new ConsumerManager((ConsumerIdsChangeListener)new ConsumerIdsChangeListenerImpl());
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        this.messagingClientAPIFactory = new MQClientAPIFactory("ClusterMQClient_", proxyConfig.getRocketmqMQClientNum(), new DoNothingClientRemotingProcessor(null), rpcHook, this.scheduledExecutorService);
        this.operationClientAPIFactory = new MQClientAPIFactory("TopicRouteServiceClient_", 1, new DoNothingClientRemotingProcessor(null), rpcHook, this.scheduledExecutorService);
        this.transactionClientAPIFactory = new MQClientAPIFactory("ClusterTransaction_", 1, new ProxyClientRemotingProcessor(this.producerManager), rpcHook, this.scheduledExecutorService);
        this.topicRouteService = new ClusterTopicRouteService(this.operationClientAPIFactory);
        this.messageService = new ClusterMessageService(this.topicRouteService, this.messagingClientAPIFactory);
        this.clusterTransactionService = new ClusterTransactionService(this.topicRouteService, this.producerManager, rpcHook, this.transactionClientAPIFactory);
        this.proxyRelayService = new ClusterProxyRelayService(this.clusterTransactionService);
        this.metadataService = new ClusterMetadataService(this.topicRouteService, this.operationClientAPIFactory);
        this.init();
    }

    protected void init() {
        this.producerManager.appendProducerChangeListener((ProducerChangeListener)new ProducerChangeListenerImpl());
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.producerManager.scanNotActiveChannel();
                this.consumerManager.scanNotActiveChannel();
            }
            catch (Throwable e) {
                log.error("Error occurred when scan not active client channels.", e);
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
        this.appendShutdown(this.scheduledExecutorService::shutdown);
        this.appendStartAndShutdown(this.messagingClientAPIFactory);
        this.appendStartAndShutdown(this.operationClientAPIFactory);
        this.appendStartAndShutdown(this.transactionClientAPIFactory);
        this.appendStartAndShutdown(this.topicRouteService);
        this.appendStartAndShutdown(this.clusterTransactionService);
        this.appendStartAndShutdown(this.metadataService);
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    @Override
    public TopicRouteService getTopicRouteService() {
        return this.topicRouteService;
    }

    @Override
    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    @Override
    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    @Override
    public TransactionService getTransactionService() {
        return this.clusterTransactionService;
    }

    @Override
    public ProxyRelayService getProxyRelayService() {
        return this.proxyRelayService;
    }

    @Override
    public MetadataService getMetadataService() {
        return this.metadataService;
    }

    protected class ProducerChangeListenerImpl
    implements ProducerChangeListener {
        protected ProducerChangeListenerImpl() {
        }

        public void handle(ProducerGroupEvent event, String group, ClientChannelInfo clientChannelInfo) {
            if (event == ProducerGroupEvent.GROUP_UNREGISTER) {
                ClusterServiceManager.this.getTransactionService().unSubscribeAllTransactionTopic(group);
            }
        }
    }

    protected static class ConsumerIdsChangeListenerImpl
    implements ConsumerIdsChangeListener {
        protected ConsumerIdsChangeListenerImpl() {
        }

        public void handle(ConsumerGroupEvent event, String group, Object ... args) {
        }

        public void shutdown() {
        }
    }
}

