/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectAttributeOrStatistic;
import org.apache.qpid.server.model.ConfiguredObjectFinder;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredObjectStatistic;
import org.apache.qpid.server.model.ConfiguredSettableAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.OperationParameter;

public class ApiDocsServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;
    private static final Set<Character> VOWELS = new HashSet<Character>(Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u')));
    public static final Comparator<Class<? extends ConfiguredObject>> CLASS_COMPARATOR = Comparator.comparing(Class::getSimpleName);
    private final transient ConcurrentMap<Class<? extends ConfiguredObject>, List<Class<? extends ConfiguredObject>>> _typeSpecialisations = new ConcurrentHashMap<Class<? extends ConfiguredObject>, List<Class<? extends ConfiguredObject>>>();

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException {
        Class[] hierarchy;
        Class<? extends ConfiguredObject> configuredClass;
        ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(managedObject);
        String[] servletPathParts = request.getServletPath().split("/");
        Model model = managedObject.getModel();
        if (servletPathParts.length < 4) {
            configuredClass = null;
            hierarchy = null;
        } else {
            configuredClass = this.getConfiguredClass(request, managedObject);
            if (configuredClass == null) {
                this.sendError(response, 404);
                return;
            }
            hierarchy = finder.getHierarchy(configuredClass);
            if (hierarchy == null) {
                this.sendError(response, 404);
                return;
            }
            if (!this._typeSpecialisations.containsKey(configuredClass)) {
                ArrayList types = new ArrayList(model.getTypeRegistry().getTypeSpecialisations(configuredClass));
                this._typeSpecialisations.putIfAbsent(configuredClass, types);
            }
        }
        response.setContentType("text/html");
        response.setStatus(200);
        PrintWriter writer = response.getWriter();
        this.writePreamble(writer);
        this.writeHead(writer, hierarchy, configuredClass);
        if (hierarchy == null) {
            writer.println("<table class=\"api\">");
            writer.println("<thead>");
            writer.println("<tr>");
            writer.println("<th class=\"type\">Type</th>");
            writer.println("<th class=\"path\">Path</th>");
            writer.println("<th class=\"description\">Description</th>");
            writer.println("</tr>");
            writer.println("</thead>");
            writer.println("<tbody>");
            TreeSet<Class<? extends ConfiguredObject>> managedCategories = new TreeSet<Class<? extends ConfiguredObject>>(CLASS_COMPARATOR);
            managedCategories.addAll(finder.getManagedCategories());
            String pathStem = "/" + servletPathParts[1] + "/" + (servletPathParts.length == 2 ? "latest" : servletPathParts[2]) + "/";
            for (Class clazz : managedCategories) {
                String path = pathStem + clazz.getSimpleName().toLowerCase();
                writer.println("<tr>");
                writer.println("<td class=\"type\"><a href=" + path + ">" + clazz.getSimpleName() + "</a></td>");
                writer.println("<td class=\"path\">" + path + "</td>");
                writer.println("<td class=\"description\">" + clazz.getAnnotation(ManagedObject.class).description() + "</td>");
                writer.println("</tr>");
            }
            writer.println("</tbody>");
            writer.println("</table>");
        } else {
            List types = (List)this._typeSpecialisations.get(configuredClass);
            this.writeCategoryDescription(writer, configuredClass);
            this.writeUsage(writer, request, hierarchy, configuredClass);
            this.writeTypes(writer, model, types);
            this.writeAttributes(writer, configuredClass, model, types);
            this.writeStatistics(writer, configuredClass, model, types);
            this.writeOperations(writer, configuredClass, model, types);
            this.writeContext(writer, configuredClass, model, types);
        }
        this.writeFoot(writer);
    }

    private void writePreamble(PrintWriter writer) {
        writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        writer.println("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        writer.println("<html>");
    }

    private void writeHead(PrintWriter writer, Class<? extends ConfiguredObject>[] hierarchy, Class<? extends ConfiguredObject> configuredClass) {
        writer.println("<head>");
        writer.println("<link rel=\"icon\" type=\"image/png\" href=\"/images/qpid-favicon.png\">");
        writer.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/css/apidocs.css\">");
        this.writeTitle(writer, hierarchy, configuredClass);
        writer.println("</head>");
        writer.println("<body>");
    }

    private void writeTitle(PrintWriter writer, Class<? extends ConfiguredObject>[] hierarchy, Class<? extends ConfiguredObject> configuredClass) {
        writer.print("<title>");
        if (hierarchy == null) {
            writer.print("Qpid API");
        } else {
            writer.print("Qpid API: " + configuredClass.getSimpleName());
        }
        writer.println("</title>");
    }

    private void writeCategoryDescription(PrintWriter writer, Class<? extends ConfiguredObject> configuredClass) {
        writer.println("<h1>" + configuredClass.getSimpleName() + "</h1>");
        writer.println(configuredClass.getAnnotation(ManagedObject.class).description());
    }

    private void writeUsage(PrintWriter writer, HttpServletRequest request, Class<? extends ConfiguredObject>[] hierarchy, Class<? extends ConfiguredObject> configuredClass) {
        writer.println("<a name=\"usage\"><h2>Usage</h2></a>");
        writer.println("<table class=\"usage\">");
        writer.println("<tbody>");
        writer.print("<tr><th class=\"operation\">Read</th><td class=\"method\">GET</td><td class=\"path\">" + request.getServletPath().replace("apidocs", "api"));
        for (Class<? extends ConfiguredObject> category : hierarchy) {
            writer.print("[/&lt;" + category.getSimpleName().toLowerCase() + " name or id&gt;");
        }
        for (int i = 0; i < hierarchy.length; ++i) {
            writer.print("] ");
        }
        writer.println("</td></tr>");
        writer.print("<tr><th class=\"operation\">Update</th><td class=\"method\">PUT or POST</td><td class=\"path\">" + request.getServletPath().replace("apidocs", "api"));
        for (Class<? extends ConfiguredObject> category : hierarchy) {
            writer.print("/&lt;" + category.getSimpleName().toLowerCase() + " name or id&gt;");
        }
        writer.print("<tr><th class=\"operation\">Create</th><td class=\"method\">PUT or POST</td><td class=\"path\">" + request.getServletPath().replace("apidocs", "api"));
        for (int i = 0; i < hierarchy.length - 1; ++i) {
            writer.print("/&lt;" + hierarchy[i].getSimpleName().toLowerCase() + " name or id&gt;");
        }
        writer.print("<tr><th class=\"operation\">Delete</th><td class=\"method\">DELETE</td><td class=\"path\">" + request.getServletPath().replace("apidocs", "api"));
        for (Class<? extends ConfiguredObject> category : hierarchy) {
            writer.print("/&lt;" + category.getSimpleName().toLowerCase() + " name or id&gt;");
        }
        writer.println("</tbody>");
        writer.println("</table>");
    }

    private void writeTypes(PrintWriter writer, Model model, List<Class<? extends ConfiguredObject>> types) {
        if (!(types.isEmpty() || types.size() == 1 && this.getTypeName(types.iterator().next(), model).trim().equals(""))) {
            writer.println("<a name=\"types\"><h2>Types</h2></a>");
            writer.println("<table class=\"types\">");
            writer.println("<thead>");
            writer.println("<tr><th class=\"type\">Type</th><th class=\"description\">Description</th></tr>");
            writer.println("</thead>");
            writer.println("<tbody>");
            for (Class<? extends ConfiguredObject> type : types) {
                writer.print("<tr><td class=\"type\">");
                writer.print(this.getTypeName(type, model));
                writer.print("</td><td class=\"description\">");
                writer.print(type.getAnnotation(ManagedObject.class).description());
                writer.println("</td></tr>");
            }
            writer.println("</tbody>");
        }
        writer.println("</table>");
    }

    private String getTypeName(Class<? extends ConfiguredObject> type, Model model) {
        return type.getAnnotation(ManagedObject.class).type() == null ? model.getTypeRegistry().getTypeClass(type).getSimpleName() : type.getAnnotation(ManagedObject.class).type();
    }

    private void writeAttributes(PrintWriter writer, Class<? extends ConfiguredObject> configuredClass, Model model, List<Class<? extends ConfiguredObject>> types) {
        writer.println("<a name=\"types\"><h2>Attributes</h2></a>");
        writer.println("<h2>Common Attributes</h2>");
        this.writeAttributesTable(writer, model.getTypeRegistry().getAttributeTypes(configuredClass).values());
        for (Class<? extends ConfiguredObject> type : types) {
            String typeName = this.getTypeName(type, model);
            Collection typeSpecificAttributes = model.getTypeRegistry().getTypeSpecificAttributes(type);
            if (typeSpecificAttributes.isEmpty()) continue;
            writer.println("<h2><span class=\"type\">" + typeName + "</span> Specific Attributes</h2>");
            this.writeAttributesTable(writer, typeSpecificAttributes);
        }
    }

    private void writeAttributesTable(PrintWriter writer, Collection<ConfiguredObjectAttribute<?, ?>> attributeTypes) {
        writer.println("<table class=\"attributes\">");
        writer.println("<thead>");
        writer.println("<tr><th class=\"name\">Attribute Name</th><th class=\"type\">Type</th><th class=\"properties\">Properties</th><th class=\"description\">Description</th></tr>");
        writer.println("</thead>");
        writer.println("<tbody>");
        for (ConfiguredObjectAttribute<?, ?> attribute : attributeTypes) {
            ConfiguredSettableAttribute settableAttribute;
            String properties = attribute instanceof ConfiguredSettableAttribute ? ((settableAttribute = (ConfiguredSettableAttribute)attribute).isImmutable() ? "read/settable on create only" : "read/write") : "read only";
            writer.println("<tr><td class=\"name\">" + attribute.getName() + "</td><td class=\"type\">" + this.renderType((ConfiguredObjectAttributeOrStatistic)attribute) + "</td><td class=\"properties\">" + properties + "</td><td class=\"description\">" + attribute.getDescription() + "</td></tr>");
        }
        writer.println("</tbody>");
        writer.println("</table>");
    }

    private void writeStatistics(PrintWriter writer, Class<? extends ConfiguredObject> configuredClass, Model model, List<Class<? extends ConfiguredObject>> types) {
        writer.println("<a name=\"types\"><h2>Statistics</h2></a>");
        writer.println("<h2>Common Statistics</h2>");
        this.writeStatisticsTable(writer, model.getTypeRegistry().getStatistics(configuredClass));
        for (Class<? extends ConfiguredObject> type : types) {
            String typeName = this.getTypeName(type, model);
            Collection typeSpecificStatistics = model.getTypeRegistry().getTypeSpecificStatistics(type);
            if (typeSpecificStatistics.isEmpty()) continue;
            writer.println("<h2><span class=\"type\">" + typeName + "</span> Specific Statistics</h2>");
            this.writeStatisticsTable(writer, typeSpecificStatistics);
        }
    }

    private void writeStatisticsTable(PrintWriter writer, Collection<ConfiguredObjectStatistic<?, ?>> statisticTypes) {
        writer.println("<table class=\"statistics\">");
        writer.println("<thead>");
        writer.println("<tr><th class=\"name\">Statistic Name</th><th class=\"type\">Type</th><th class=\"units\">Units</th><th class=\"statisticType\">Stat Type</th><th class=\"statisticResettable\">Resettable</th><th class=\"description\">Description</th></tr>");
        writer.println("</thead>");
        writer.println("<tbody>");
        for (ConfiguredObjectStatistic<?, ?> statistic : statisticTypes) {
            writer.println("<tr><td class=\"name\">" + statistic.getName() + "</td><td class=\"type\">" + this.renderType((ConfiguredObjectAttributeOrStatistic)statistic) + "</td><td class=\"units\">" + String.valueOf(statistic.getUnits()) + "</td><td class=\"stattype\">" + String.valueOf(statistic.getStatisticType()) + "</td><td class=\"resettable\">" + statistic.isResettable() + "</td><td class=\"description\">" + statistic.getDescription() + "</td></tr>");
        }
        writer.println("</tbody>");
        writer.println("</table>");
    }

    private void writeOperations(PrintWriter writer, Class<? extends ConfiguredObject> configuredClass, Model model, List<Class<? extends ConfiguredObject>> types) {
        writer.println("<a name=\"types\"><h2>Operations</h2></a>");
        writer.println("<h2>Common Operations</h2>");
        Collection<ConfiguredObjectOperation<?>> categoryOperations = model.getTypeRegistry().getOperations(configuredClass).values();
        this.writeOperationsTables(writer, categoryOperations);
        for (Class<? extends ConfiguredObject> type : types) {
            String typeName = this.getTypeName(type, model);
            HashSet typeSpecificOperations = new HashSet(model.getTypeRegistry().getOperations(type).values());
            typeSpecificOperations.removeAll(categoryOperations);
            if (typeSpecificOperations.isEmpty() || type == configuredClass) continue;
            writer.println("<h2><span class=\"type\">" + typeName + "</span> Specific Operations</h2>");
            this.writeOperationsTables(writer, typeSpecificOperations);
        }
    }

    private void writeOperationsTables(PrintWriter writer, Collection<ConfiguredObjectOperation<?>> operations) {
        for (ConfiguredObjectOperation<?> operation : operations) {
            writer.println("<table class=\"operation\">");
            writer.println("<thead>");
            writer.println("<tr><th class=\"name\">Operation Name</th><th class=\"returnType\">Return Type</th><th class=\"description\">Description</th></tr>");
            writer.println("</thead>");
            writer.println("<tbody>");
            writer.println("<tr><td class=\"name\">" + operation.getName() + "</td><td class=\"type\">" + this.renderType(operation) + "</td><td class=\"description\">" + operation.getDescription() + "</td></tr>");
            if (!operation.getParameters().isEmpty()) {
                writer.println("<tr><td class=\"allparameters\" colspan=\"3\">" + this.renderParameters(operation.getParameters()) + "</td></tr>");
            }
            writer.println("</tbody>");
            writer.println("</table>");
        }
    }

    private String renderParameters(List<OperationParameter> parameters) {
        StringBuilder writer = new StringBuilder();
        writer.append("<table class=\"parameters\">");
        writer.append("<thead>");
        writer.append("<tr><th class=\"name\">Parameter Name</th><th>Type</th><th>Default</th><th>Mandatory?</th><th>Description</th></tr>");
        writer.append("</thead>");
        writer.append("<tbody>");
        for (OperationParameter param : parameters) {
            writer.append("<tr><td class=\"name\">" + param.getName() + "</td><td class=\"type\">" + this.renderType(param) + "</td><td class=\"default\">" + param.getDefaultValue() + "</td><td class=\"mandatory\">" + param.isMandatory() + "</td><td class=\"description\">" + param.getDescription() + "</td></tr>");
        }
        writer.append("</tbody>");
        writer.append("</table>");
        return writer.toString();
    }

    private String renderType(ConfiguredObjectAttributeOrStatistic attributeOrStatistic) {
        String validValuePattern;
        Collection validValues;
        Class type = attributeOrStatistic.getType();
        if (attributeOrStatistic instanceof ConfiguredSettableAttribute) {
            ConfiguredSettableAttribute settableAttribute = (ConfiguredSettableAttribute)attributeOrStatistic;
            validValues = settableAttribute.hasValidValues() ? settableAttribute.validValues() : null;
            validValuePattern = settableAttribute.validValuePattern();
        } else {
            validValues = null;
            validValuePattern = "";
        }
        return this.renderType(type, validValues, validValuePattern);
    }

    private String renderType(OperationParameter parameter) {
        Class type = parameter.getType();
        List validValues = parameter.getValidValues();
        return this.renderType(type, validValues, "");
    }

    private String renderType(Class type, Collection<String> validValues, String validValuePattern) {
        boolean hasValuesRestriction;
        if (Enum.class.isAssignableFrom(type)) {
            return "<div class=\"restriction\" title=\"enum: " + String.valueOf(EnumSet.allOf(type)) + "\">string</div>";
        }
        if (ConfiguredObject.class.isAssignableFrom(type)) {
            return "<div class=\"restriction\" title=\"name or id of a" + (VOWELS.contains(Character.valueOf(type.getSimpleName().toLowerCase().charAt(0))) ? "n " : " ") + type.getSimpleName() + "\">string</div>";
        }
        if (UUID.class == type) {
            return "<div class=\"restriction\" title=\"must be a UUID\">string</div>";
        }
        StringBuilder returnVal = new StringBuilder();
        boolean bl = hasValuesRestriction = validValues != null && !validValues.isEmpty();
        if (hasValuesRestriction) {
            returnVal.append("<div class=\"restricted\" title=\"Valid values: " + String.valueOf(validValues) + "\">");
        } else if (validValuePattern != null && !"".equals(validValuePattern)) {
            returnVal.append("<div class=\"restricted\" title=\"Valid value pattern: " + validValuePattern + "\">");
        }
        if (Number.class.isAssignableFrom(type)) {
            returnVal.append("number");
        } else if (Boolean.class == type) {
            returnVal.append("boolean");
        } else if (String.class == type) {
            returnVal.append("string");
        } else if (Collection.class.isAssignableFrom(type)) {
            returnVal.append("array");
        } else if (Map.class.isAssignableFrom(type)) {
            returnVal.append("object");
        } else {
            returnVal.append(type.getSimpleName());
        }
        if (hasValuesRestriction) {
            returnVal.append("</div>");
        }
        return returnVal.toString();
    }

    private String renderType(ConfiguredObjectOperation<?> operation) {
        return operation.getGenericReturnType() instanceof Class ? ((Class)operation.getGenericReturnType()).getName() : operation.getGenericReturnType().toString();
    }

    private void writeContext(PrintWriter writer, Class<? extends ConfiguredObject> configuredClass, Model model, List<Class<? extends ConfiguredObject>> types) {
        writer.println("<a name=\"types\"><h2>Context Variables</h2></a>");
        writer.println("<h2>Common Context Variables</h2>");
        Collection defaultContexts = model.getTypeRegistry().getContextDependencies(configuredClass);
        this.writeContextDefaults(writer, defaultContexts);
        for (Class<? extends ConfiguredObject> type : types) {
            String typeName = this.getTypeName(type, model);
            Collection typeSpecificDefaults = model.getTypeRegistry().getTypeSpecificContextDependencies(type);
            if (typeSpecificDefaults.isEmpty() || type == configuredClass) continue;
            writer.println("<h2><span class=\"type\">" + typeName + "</span> Specific Context Variables</h2>");
            this.writeContextDefaults(writer, typeSpecificDefaults);
        }
    }

    private void writeContextDefaults(PrintWriter writer, Collection<ManagedContextDefault> contextDefaults) {
        writer.println("<table class=\"contextDefault\">");
        writer.println("<thead>");
        writer.println("<tr><th class=\"name\">Name</th><th class=\"description\">Description</th></tr>");
        writer.println("</thead>");
        writer.println("<tbody>");
        for (ManagedContextDefault contextDefault : contextDefaults) {
            writer.println("<tr><td class=\"name\">" + contextDefault.name() + "</td><td class=\"description\">" + contextDefault.description() + "</td></tr>");
        }
        writer.println("</tbody>");
        writer.println("</table>");
    }

    private void writeFoot(PrintWriter writer) {
        writer.println("</body>");
        writer.println("</html>");
    }

    private Class<? extends ConfiguredObject> getConfiguredClass(HttpServletRequest request, ConfiguredObject<?> managedObject) {
        String[] servletPathElements = request.getServletPath().split("/");
        String categoryName = servletPathElements[servletPathElements.length - 1];
        Model model = managedObject.getModel();
        for (Class category : model.getSupportedCategories()) {
            if (!category.getSimpleName().toLowerCase().equals(categoryName)) continue;
            return category;
        }
        return null;
    }
}

