/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.everit.json.schema.event;

import com.hazelcast.shaded.org.everit.json.schema.Schema;
import com.hazelcast.shaded.org.json.JSONObject;
import java.util.Objects;

public abstract class ValidationEvent<S extends Schema> {
    protected final S schema;
    protected final Object instance;

    protected ValidationEvent(S schema, Object instance) {
        this.schema = schema;
        this.instance = instance;
    }

    public S getSchema() {
        return this.schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.canEqual(o)) {
            return false;
        }
        ValidationEvent that = (ValidationEvent)o;
        if (!that.canEqual(this)) {
            return false;
        }
        return ((Schema)this.schema).equals(that.schema) && this.instance.equals(that.instance);
    }

    boolean canEqual(Object o) {
        return o instanceof ValidationEvent;
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.instance);
    }

    public String toString() {
        return this.toJSON(false, false).toString();
    }

    public JSONObject toJSON(boolean includeSchema, boolean includeInstance) {
        JSONObject json = new JSONObject();
        if (includeSchema) {
            json.put("schema", new JSONObject(((Schema)this.schema).toString()));
        }
        if (includeInstance) {
            json.put("instance", this.instance);
        }
        this.describeTo(json);
        return json;
    }

    abstract void describeTo(JSONObject var1);
}

