/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.impl.connector.WriteJmsP;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.XAConnectionFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JmsSinkBuilder<T> {
    private final SupplierEx<ConnectionFactory> factorySupplier;
    private final boolean isTopic;
    private boolean exactlyOnce = true;
    private FunctionEx<ConnectionFactory, Connection> connectionFn;
    private BiFunctionEx<Session, T, Message> messageFn;
    private String username;
    private String password;
    private String destinationName;

    JmsSinkBuilder(@Nonnull SupplierEx<ConnectionFactory> factorySupplier, boolean isTopic) {
        Util.checkSerializable(factorySupplier, "factorySupplier");
        this.factorySupplier = factorySupplier;
        this.isTopic = isTopic;
    }

    @Nonnull
    public JmsSinkBuilder<T> connectionParams(@Nullable String username, @Nullable String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    @Nonnull
    public JmsSinkBuilder<T> connectionFn(@Nullable FunctionEx<ConnectionFactory, Connection> connectionFn) {
        Util.checkSerializable(connectionFn, "connectionFn");
        this.connectionFn = connectionFn;
        return this;
    }

    @Nonnull
    public JmsSinkBuilder<T> destinationName(@Nonnull String destinationName) {
        this.destinationName = destinationName;
        return this;
    }

    @Nonnull
    public JmsSinkBuilder<T> messageFn(@Nullable BiFunctionEx<Session, T, Message> messageFn) {
        Util.checkSerializable(messageFn, "messageFn");
        this.messageFn = messageFn;
        return this;
    }

    @Nonnull
    public JmsSinkBuilder<T> exactlyOnce(boolean enable) {
        this.exactlyOnce = enable;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        String usernameLocal = this.username;
        String passwordLocal = this.password;
        Preconditions.checkNotNull(this.destinationName);
        if (this.connectionFn == null) {
            this.connectionFn = factory -> {
                if (factory instanceof XAConnectionFactory) {
                    XAConnectionFactory xaFactory = (XAConnectionFactory)factory;
                    return usernameLocal != null || passwordLocal != null ? xaFactory.createXAConnection(usernameLocal, passwordLocal) : xaFactory.createXAConnection();
                }
                return usernameLocal != null || passwordLocal != null ? factory.createConnection(usernameLocal, passwordLocal) : factory.createConnection();
            };
        }
        if (this.messageFn == null) {
            this.messageFn = (session, item) -> {
                Message m;
                return item instanceof Message ? (m = (Message)item) : session.createTextMessage(item.toString());
            };
        }
        FunctionEx<ConnectionFactory, Connection> connectionFnLocal = this.connectionFn;
        SupplierEx<ConnectionFactory> factorySupplierLocal = this.factorySupplier;
        SupplierEx<Connection> newConnectionFn = () -> (Connection)connectionFnLocal.apply((ConnectionFactory)factorySupplierLocal.get());
        return Sinks.fromProcessor(this.sinkName(), WriteJmsP.supplier(this.destinationName, this.exactlyOnce, newConnectionFn, this.messageFn, this.isTopic));
    }

    private String sinkName() {
        return String.format("jms%sSink(%s)", this.isTopic ? "Topic" : "Queue", this.destinationName);
    }
}

