/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster;

import com.hazelcast.version.Version;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class Versions {
    public static final Version V4_0 = Version.of(4, 0);
    public static final Version V4_1 = Version.of(4, 1);
    public static final Version V4_2 = Version.of(4, 2);
    public static final Version V5_0 = Version.of(5, 0);
    public static final Version V5_1 = Version.of(5, 1);
    public static final Version V5_2 = Version.of(5, 2);
    public static final Version V5_3 = Version.of(5, 3);
    public static final Version V5_4 = Version.of(5, 4);
    public static final Version V5_5 = Version.of(5, 5);
    @Nonnull
    public static final Version PREVIOUS_CLUSTER_VERSION;
    @Nonnull
    public static final Version CURRENT_CLUSTER_VERSION;

    private Versions() {
    }

    static {
        Version buildPropertiesVersion = Version.of("5.5.0");
        Version currentClusterVersionConstant = null;
        Version previousHighest = null;
        for (Field field : Versions.class.getFields()) {
            if (!field.getType().equals(Version.class)) continue;
            try {
                Version version = (Version)field.get(null);
                if (version == null) continue;
                int versionCompareToBuildPropertiesVersion = version.compareTo(buildPropertiesVersion);
                if (versionCompareToBuildPropertiesVersion == 0) {
                    currentClusterVersionConstant = version;
                    continue;
                }
                if (versionCompareToBuildPropertiesVersion >= 0 || previousHighest != null && version.compareTo(previousHighest) <= 0) continue;
                previousHighest = version;
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
        CURRENT_CLUSTER_VERSION = Objects.requireNonNull(currentClusterVersionConstant, () -> MessageFormat.format("Failed to find matching constant for version {0}", buildPropertiesVersion));
        PREVIOUS_CLUSTER_VERSION = Objects.requireNonNull(previousHighest, () -> MessageFormat.format("Failed to find version preceding {0}", CURRENT_CLUSTER_VERSION));
    }
}

