/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.MailboxField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.AddressListFieldLenientImpl;
import org.apache.james.mime4j.field.ContentDescriptionFieldImpl;
import org.apache.james.mime4j.field.ContentDispositionFieldLenientImpl;
import org.apache.james.mime4j.field.ContentIdFieldImpl;
import org.apache.james.mime4j.field.ContentLanguageFieldLenientImpl;
import org.apache.james.mime4j.field.ContentLengthFieldImpl;
import org.apache.james.mime4j.field.ContentLocationFieldLenientImpl;
import org.apache.james.mime4j.field.ContentMD5FieldImpl;
import org.apache.james.mime4j.field.ContentTransferEncodingFieldImpl;
import org.apache.james.mime4j.field.ContentTypeFieldLenientImpl;
import org.apache.james.mime4j.field.DateTimeFieldLenientImpl;
import org.apache.james.mime4j.field.DelegatingFieldParser;
import org.apache.james.mime4j.field.MailboxFieldLenientImpl;
import org.apache.james.mime4j.field.MailboxListFieldLenientImpl;
import org.apache.james.mime4j.field.MimeVersionFieldImpl;
import org.apache.james.mime4j.field.UnstructuredFieldImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.stream.RawFieldParser;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;

public class LenientFieldParser
extends DelegatingFieldParser {
    private static final FieldParser<ParsedField> PARSER = new LenientFieldParser();

    public static FieldParser<ParsedField> getParser() {
        return PARSER;
    }

    public static ParsedField parse(ByteSequence raw, DecodeMonitor monitor) throws MimeException {
        RawField rawField = RawFieldParser.DEFAULT.parseField(raw);
        return PARSER.parse((Field)rawField, monitor);
    }

    public static ParsedField parse(String rawStr, DecodeMonitor monitor) throws MimeException {
        ByteSequence raw = ContentUtil.encode((CharSequence)rawStr);
        RawField rawField = RawFieldParser.DEFAULT.parseField(raw);
        return PARSER.parse((Field)rawField, monitor);
    }

    public static ParsedField parse(String rawStr) throws MimeException {
        return LenientFieldParser.parse(rawStr, DecodeMonitor.SILENT);
    }

    public LenientFieldParser() {
        super(UnstructuredFieldImpl.PARSER);
        this.setFieldParser("Content-Type", ContentTypeFieldLenientImpl.PARSER);
        this.setFieldParser("Content-Length", ContentLengthFieldImpl.PARSER);
        this.setFieldParser("Content-Transfer-Encoding", ContentTransferEncodingFieldImpl.PARSER);
        this.setFieldParser("Content-Disposition", ContentDispositionFieldLenientImpl.PARSER);
        this.setFieldParser("Content-ID", ContentIdFieldImpl.PARSER);
        this.setFieldParser("Content-MD5", ContentMD5FieldImpl.PARSER);
        this.setFieldParser("Content-Description", ContentDescriptionFieldImpl.PARSER);
        this.setFieldParser("Content-Language", ContentLanguageFieldLenientImpl.PARSER);
        this.setFieldParser("Content-Location", ContentLocationFieldLenientImpl.PARSER);
        this.setFieldParser("MIME-Version", MimeVersionFieldImpl.PARSER);
        FieldParser<DateTimeField> dateTimeParser = DateTimeFieldLenientImpl.PARSER;
        this.setFieldParser("Date", dateTimeParser);
        this.setFieldParser("Resent-Date", dateTimeParser);
        FieldParser<MailboxListField> mailboxListParser = MailboxListFieldLenientImpl.PARSER;
        this.setFieldParser("From", mailboxListParser);
        this.setFieldParser("Resent-From", mailboxListParser);
        FieldParser<MailboxField> mailboxParser = MailboxFieldLenientImpl.PARSER;
        this.setFieldParser("Sender", mailboxParser);
        this.setFieldParser("Resent-Sender", mailboxParser);
        FieldParser<AddressListField> addressListParser = AddressListFieldLenientImpl.PARSER;
        this.setFieldParser("To", addressListParser);
        this.setFieldParser("Resent-To", addressListParser);
        this.setFieldParser("Cc", addressListParser);
        this.setFieldParser("Resent-Cc", addressListParser);
        this.setFieldParser("Bcc", addressListParser);
        this.setFieldParser("Resent-Bcc", addressListParser);
        this.setFieldParser("Reply-To", addressListParser);
    }
}

