/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.asteriskjava.lock.LockableList;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ChannelHangupListener;
import org.asteriskjava.pbx.asterisk.wrap.events.ChannelState;
import org.asteriskjava.pbx.internal.core.CallEndedListener;
import org.asteriskjava.pbx.internal.core.ChannelProxy;
import org.asteriskjava.pbx.internal.core.Peer;
import org.asteriskjava.pbx.internal.core.PeerState;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class CallTracker
implements ChannelHangupListener {
    private static final Log logger = LogFactory.getLog(CallTracker.class);
    LockableList<Channel> _associatedChannels = new LockableList(new ArrayList());
    PeerState _state;
    private CallEndedListener listener;

    CallTracker(Peer peer, Channel initialChannel) {
        this._associatedChannels.add(initialChannel);
        initialChannel.addHangupListener(this);
        this.listener = peer;
    }

    void mergeCalls(CallTracker rhs) {
        try (Locker.LockCloser closer = this._associatedChannels.withLock();){
            this._associatedChannels.addAll((Collection<Channel>)rhs._associatedChannels);
            rhs._associatedChannels.clear();
        }
    }

    public PeerState getState() {
        return this._state;
    }

    public void setState(ChannelState channelState) {
        this._state = PeerState.valueByChannelState(channelState);
    }

    public int findChannel(Channel newChannel) {
        int index = -1;
        try (Locker.LockCloser closer = this._associatedChannels.withLock();){
            for (int i = 0; i < this._associatedChannels.size(); ++i) {
                Channel channel = this._associatedChannels.get(i);
                if (!channel.isSame(newChannel)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public void remove(Channel channel) {
        try (Locker.LockCloser closer = this._associatedChannels.withLock();){
            int index = this.findChannel(channel);
            if (index != -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("CallTracker removing channel: " + this.toString() + " " + channel.getExtendedChannelName());
                }
                this._associatedChannels.remove(index);
            }
        }
    }

    public void startSweep() {
        try (Locker.LockCloser closer = this._associatedChannels.withLock();){
            for (Channel channel : this._associatedChannels) {
                ((ChannelProxy)channel).getRealChannel().startSweep();
            }
        }
    }

    public void endSweep() {
        LinkedList<Channel> toremove = new LinkedList<Channel>();
        try (Locker.LockCloser closer = this._associatedChannels.withLock();){
            for (Channel channel : this._associatedChannels) {
                if (((ChannelProxy)channel).getRealChannel().wasMarkedDuringSweep()) continue;
                toremove.add(channel);
                logger.warn("removing channel " + this.hashCode() + " " + channel.getChannelName());
            }
            this._associatedChannels.removeAll(toremove);
        }
        for (Channel channel : toremove) {
            ((ChannelProxy)channel).getRealChannel().notifyHangupListeners(-1, "Lingering channel probably due to missed hangup event");
        }
    }

    void dumpChannelList() {
        if (logger.isDebugEnabled()) {
            logger.debug("CallTracker: dump channellist:" + this);
            try (Locker.LockCloser closer = this._associatedChannels.withLock();){
                for (Channel channel : this._associatedChannels) {
                    logger.debug("--> " + channel.toString());
                }
            }
        }
    }

    public boolean hasEnded() {
        try (Locker.LockCloser closer = this._associatedChannels.withLock();){
            boolean bl = this._associatedChannels.size() == 0;
            return bl;
        }
    }

    @Override
    public void channelHangup(Channel channel, Integer cause, String causeText) {
        this.remove(channel);
        try (Locker.LockCloser closer = this._associatedChannels.withLock();){
            if (this._associatedChannels.size() == 0) {
                this._state = PeerState.NOTSET;
                this.notifyCallEndedListener();
            }
        }
    }

    private void notifyCallEndedListener() {
        this.listener.callEnded(this);
    }

    public String toString() {
        return this.listener + " : " + (Object)((Object)this._state);
    }
}

