/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.core.uri.expression.Token;
import org.apache.olingo.odata2.core.uri.expression.TokenKind;

public class TokenizerExpectError
extends ODataMessageException {
    private static final long serialVersionUID = 1L;
    public static final int parseStringpoken = 1;
    public static final MessageReference NO_TOKEN_AVAILABLE = TokenizerExpectError.createMessageReference(TokenizerExpectError.class, (String)"NO_TOKEN_AVAILABLE");
    public static final MessageReference INVALID_TOKEN_AT = TokenizerExpectError.createMessageReference(TokenizerExpectError.class, (String)"INVALID_TOKEN_AT");
    public static final MessageReference INVALID_TOKENKIND_AT = TokenizerExpectError.createMessageReference(TokenizerExpectError.class, (String)"INVALID_TOKENKIND_AT");
    private String token;
    private Exception previous;
    private int position;

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Exception getPrevious() {
        return this.previous;
    }

    public void setPrevious(Exception previous) {
        this.previous = previous;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public TokenizerExpectError(MessageReference messageReference) {
        super(messageReference);
    }

    public static TokenizerExpectError createINVALID_TOKEN_AT(String expectedToken, Token actualToken) {
        MessageReference msgRef = INVALID_TOKEN_AT.create();
        msgRef.addContent(new Object[]{expectedToken});
        msgRef.addContent(new Object[]{actualToken.getUriLiteral()});
        msgRef.addContent(new Object[]{actualToken.getPosition()});
        return new TokenizerExpectError(msgRef);
    }

    public static TokenizerExpectError createINVALID_TOKENKIND_AT(TokenKind expectedTokenKind, Token actualToken) {
        MessageReference msgRef = INVALID_TOKEN_AT.create();
        msgRef.addContent(new Object[]{expectedTokenKind.toString()});
        msgRef.addContent(new Object[]{actualToken.getKind().toString()});
        msgRef.addContent(new Object[]{actualToken.getUriLiteral()});
        msgRef.addContent(new Object[]{actualToken.getPosition()});
        return new TokenizerExpectError(msgRef);
    }

    public static TokenizerExpectError createNO_TOKEN_AVAILABLE(String expectedToken) {
        MessageReference msgRef = INVALID_TOKEN_AT.create();
        msgRef.addContent(new Object[]{expectedToken});
        return new TokenizerExpectError(msgRef);
    }
}

