/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.search;

import java.nio.charset.Charset;
import java.util.Arrays;

public class SearchTerm<T> {
    private final byte[] bytes;
    private final int hashCode;
    private final T reference;

    public SearchTerm(byte[] bytes) {
        this(bytes, true, null);
    }

    public SearchTerm(byte[] bytes, boolean defensiveCopy, T reference) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException();
        }
        this.bytes = defensiveCopy ? Arrays.copyOf(bytes, bytes.length) : bytes;
        this.hashCode = Arrays.hashCode(this.bytes);
        this.reference = reference;
    }

    public int get(int index) {
        return this.bytes[index] & 0xFF;
    }

    public int size() {
        return this.bytes.length;
    }

    public T getReference() {
        return this.reference;
    }

    public boolean startsWith(byte[] window, int windowLength) {
        if (windowLength > window.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.bytes.length < windowLength) {
            return false;
        }
        for (int i = 0; i < this.bytes.length && i < windowLength; ++i) {
            if (this.bytes[i] == window[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchTerm other = (SearchTerm)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        return Arrays.equals(this.bytes, other.bytes);
    }

    public String toString() {
        return new String(this.bytes);
    }

    public String toString(Charset charset) {
        return new String(this.bytes, charset);
    }
}

