/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service.extension.docs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.extension.manifest.AllowableValue;
import org.apache.nifi.extension.manifest.ControllerServiceDefinition;
import org.apache.nifi.extension.manifest.DeprecationNotice;
import org.apache.nifi.extension.manifest.DynamicProperty;
import org.apache.nifi.extension.manifest.ExpressionLanguageScope;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.extension.manifest.ExtensionType;
import org.apache.nifi.extension.manifest.InputRequirement;
import org.apache.nifi.extension.manifest.Property;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.extension.manifest.Restricted;
import org.apache.nifi.extension.manifest.Restriction;
import org.apache.nifi.extension.manifest.Stateful;
import org.apache.nifi.extension.manifest.SystemResourceConsideration;
import org.apache.nifi.registry.extension.bundle.BundleInfo;
import org.apache.nifi.registry.extension.component.ExtensionMetadata;
import org.apache.nifi.registry.service.extension.docs.ExtensionDocWriter;
import org.springframework.stereotype.Service;

@Service
public class HtmlExtensionDocWriter
implements ExtensionDocWriter {
    @Override
    public void write(ExtensionMetadata extensionMetadata, Extension extension, OutputStream outputStream) throws IOException {
        try {
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            xmlStreamWriter.writeDTD("<!DOCTYPE html>");
            xmlStreamWriter.writeStartElement("html");
            xmlStreamWriter.writeAttribute("lang", "en");
            this.writeHead(extensionMetadata, xmlStreamWriter);
            this.writeBody(extensionMetadata, extension, xmlStreamWriter);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.close();
            outputStream.flush();
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IOException("Unable to create XMLOutputStream", e);
        }
    }

    private void writeHead(ExtensionMetadata extensionMetadata, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("head");
        xmlStreamWriter.writeStartElement("meta");
        xmlStreamWriter.writeAttribute("charset", "utf-8");
        xmlStreamWriter.writeEndElement();
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "title", extensionMetadata.getDisplayName());
        String componentUsageCss = "/nifi-registry-docs/css/component-usage.css";
        xmlStreamWriter.writeStartElement("link");
        xmlStreamWriter.writeAttribute("rel", "stylesheet");
        xmlStreamWriter.writeAttribute("href", "/nifi-registry-docs/css/component-usage.css");
        xmlStreamWriter.writeAttribute("type", "text/css");
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("script");
        xmlStreamWriter.writeAttribute("type", "text/javascript");
        xmlStreamWriter.writeCharacters("window.onload = function(){if(self==top) { document.getElementById('nameHeader').style.display = \"inherit\"; } }");
        xmlStreamWriter.writeEndElement();
    }

    private void writeBody(ExtensionMetadata extensionMetadata, Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("body");
        this.writeHeader(extensionMetadata, extension, xmlStreamWriter);
        this.writeBundleInfo(extensionMetadata, xmlStreamWriter);
        this.writeDeprecationWarning(extension, xmlStreamWriter);
        this.writeDescription(extensionMetadata, extension, xmlStreamWriter);
        this.writeTags(extension, xmlStreamWriter);
        this.writeProperties(extension, xmlStreamWriter);
        this.writeDynamicProperties(extension, xmlStreamWriter);
        this.writeAdditionalBodyInfo(extension, xmlStreamWriter);
        this.writeStatefulInfo(extension, xmlStreamWriter);
        this.writeRestrictedInfo(extension, xmlStreamWriter);
        this.writeInputRequirementInfo(extension, xmlStreamWriter);
        this.writeSystemResourceConsiderationInfo(extension, xmlStreamWriter);
        this.writeProvidedServiceApis(extension, xmlStreamWriter);
        this.writeSeeAlso(extension, xmlStreamWriter);
        xmlStreamWriter.writeEndElement();
    }

    protected void writeAdditionalBodyInfo(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
    }

    private void writeHeader(ExtensionMetadata extensionMetadata, Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("h1");
        xmlStreamWriter.writeAttribute("id", "nameHeader");
        xmlStreamWriter.writeAttribute("style", "display: none;");
        xmlStreamWriter.writeCharacters(extensionMetadata.getDisplayName());
        xmlStreamWriter.writeEndElement();
    }

    private void writeBundleInfoString(ExtensionMetadata extensionMetadata, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        BundleInfo bundleInfo = extensionMetadata.getBundleInfo();
        String bundleInfoText = bundleInfo.getGroupId() + "-" + bundleInfo.getArtifactId() + "-" + bundleInfo.getVersion();
        xmlStreamWriter.writeStartElement("p");
        xmlStreamWriter.writeStartElement("i");
        xmlStreamWriter.writeCharacters(bundleInfoText);
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeEndElement();
    }

    private void writeBundleInfo(ExtensionMetadata extensionMetadata, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        BundleInfo bundleInfo = extensionMetadata.getBundleInfo();
        String extenstionType = switch (extensionMetadata.getType()) {
            case ExtensionType.PROCESSOR -> "Processor";
            case ExtensionType.CONTROLLER_SERVICE -> "Controller Service";
            case ExtensionType.REPORTING_TASK -> "Reporting Task";
            default -> throw new IllegalArgumentException("Unknown extension type: " + String.valueOf(extensionMetadata.getType()));
        };
        xmlStreamWriter.writeStartElement("table");
        xmlStreamWriter.writeStartElement("tr");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Extension Info");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Value");
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("tr");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", "Full Name", true, "bundle-info");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", extensionMetadata.getName());
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("tr");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", "Type", true, "bundle-info");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", extenstionType);
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("tr");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", "Bundle Group", true, "bundle-info");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", bundleInfo.getGroupId());
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("tr");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", "Bundle Artifact", true, "bundle-info");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", bundleInfo.getArtifactId());
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("tr");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", "Bundle Version", true, "bundle-info");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", bundleInfo.getVersion());
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("tr");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", "Bundle Type", true, "bundle-info");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", bundleInfo.getBundleType().toString());
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("tr");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", "System API Version", true, "bundle-info");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", bundleInfo.getSystemApiVersion());
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeEndElement();
    }

    private void writeDeprecationWarning(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        DeprecationNotice deprecationNotice = extension.getDeprecationNotice();
        if (deprecationNotice != null) {
            xmlStreamWriter.writeStartElement("h2");
            xmlStreamWriter.writeCharacters("Deprecation notice: ");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("");
            if (!StringUtils.isEmpty((CharSequence)deprecationNotice.getReason())) {
                xmlStreamWriter.writeCharacters(deprecationNotice.getReason());
            } else {
                xmlStreamWriter.writeCharacters("Please be aware this processor is deprecated and may be removed in the near future.");
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("Please consider using one of the following alternatives: ");
            List alternatives = deprecationNotice.getAlternatives();
            if (alternatives != null && !alternatives.isEmpty()) {
                xmlStreamWriter.writeStartElement("ul");
                for (String alternative : alternatives) {
                    xmlStreamWriter.writeStartElement("li");
                    xmlStreamWriter.writeCharacters(alternative);
                    xmlStreamWriter.writeEndElement();
                }
                xmlStreamWriter.writeEndElement();
            } else {
                xmlStreamWriter.writeCharacters("No alternative components suggested.");
            }
            xmlStreamWriter.writeEndElement();
        }
    }

    private void writeDescription(ExtensionMetadata extensionMetadata, Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        String description = StringUtils.isBlank((CharSequence)extension.getDescription()) ? "No description provided." : extension.getDescription();
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "h2", "Description: ");
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "p", description);
        if (extensionMetadata.getHasAdditionalDetails()) {
            xmlStreamWriter.writeStartElement("p");
            BundleInfo bundleInfo = extensionMetadata.getBundleInfo();
            String bucketName = bundleInfo.getBucketName();
            String groupId = bundleInfo.getGroupId();
            String artifactId = bundleInfo.getArtifactId();
            String version = bundleInfo.getVersion();
            String extensionName = extensionMetadata.getName();
            String additionalDetailsPath = "/nifi-registry-api/extension-repository/" + bucketName + "/" + groupId + "/" + artifactId + "/" + version + "/extensions/" + extensionName + "/docs/additional-details";
            this.writeLink(xmlStreamWriter, "Additional Details...", additionalDetailsPath);
            xmlStreamWriter.writeEndElement();
        }
    }

    private void writeTags(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List tags = extension.getTags();
        xmlStreamWriter.writeStartElement("h3");
        xmlStreamWriter.writeCharacters("Tags: ");
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("p");
        if (tags != null) {
            String tagString = StringUtils.join((Iterable)tags, (String)", ");
            xmlStreamWriter.writeCharacters(tagString);
        } else {
            xmlStreamWriter.writeCharacters("No tags provided.");
        }
        xmlStreamWriter.writeEndElement();
    }

    protected void writeProperties(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List properties = extension.getProperties();
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "h3", "Properties: ");
        if (properties != null && !properties.isEmpty()) {
            boolean containsExpressionLanguage = this.containsExpressionLanguage(extension);
            boolean containsSensitiveProperties = this.containsSensitiveProperties(extension);
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("In the list below, the names of required properties appear in ");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "strong", "bold");
            xmlStreamWriter.writeCharacters(". Any other properties (not in bold) are considered optional. The table also indicates any default values");
            if (containsExpressionLanguage) {
                if (!containsSensitiveProperties) {
                    xmlStreamWriter.writeCharacters(", and ");
                } else {
                    xmlStreamWriter.writeCharacters(", ");
                }
                xmlStreamWriter.writeCharacters("whether a property supports the NiFi Expression Language");
            }
            if (containsSensitiveProperties) {
                xmlStreamWriter.writeCharacters(", and whether a property is considered \"sensitive\", meaning that its value will be encrypted");
            }
            xmlStreamWriter.writeCharacters(".");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "properties");
            xmlStreamWriter.writeStartElement("tr");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Name");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Default Value");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Allowable Values");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (Property property : properties) {
                xmlStreamWriter.writeStartElement("tr");
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeAttribute("id", "name");
                if (property.isRequired()) {
                    HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "strong", property.getDisplayName());
                } else {
                    xmlStreamWriter.writeCharacters(property.getDisplayName());
                }
                xmlStreamWriter.writeEndElement();
                HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", property.getDefaultValue(), false, "default-value");
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeAttribute("id", "allowable-values");
                this.writeValidValues(xmlStreamWriter, property);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeAttribute("id", "description");
                if (property.getDescription() != null && !property.getDescription().isBlank()) {
                    xmlStreamWriter.writeCharacters(property.getDescription());
                } else {
                    xmlStreamWriter.writeCharacters("No Description Provided.");
                }
                if (property.isSensitive()) {
                    xmlStreamWriter.writeEmptyElement("br");
                    HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "strong", "Sensitive Property: true");
                }
                if (property.isExpressionLanguageSupported()) {
                    xmlStreamWriter.writeEmptyElement("br");
                    StringBuilder text = new StringBuilder("Supports Expression Language: true");
                    String perFF = " (will be evaluated using flow file attributes and Environment variables)";
                    String registry = " (will be evaluated using Environment variables only)";
                    InputRequirement inputRequirement = extension.getInputRequirement();
                    switch (property.getExpressionLanguageScope()) {
                        case FLOWFILE_ATTRIBUTES: {
                            if (inputRequirement != null && inputRequirement.equals((Object)InputRequirement.INPUT_FORBIDDEN)) {
                                text.append(" (will be evaluated using Environment variables only)");
                                break;
                            }
                            text.append(" (will be evaluated using flow file attributes and Environment variables)");
                            break;
                        }
                        case ENVIRONMENT: {
                            text.append(" (will be evaluated using Environment variables only)");
                            break;
                        }
                        case NONE: {
                            text.append(" (undefined scope)");
                        }
                    }
                    HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "strong", text.toString());
                }
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else {
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "p", "This component has no required or optional properties.");
        }
    }

    private boolean containsExpressionLanguage(Extension extension) {
        for (Property property : extension.getProperties()) {
            if (!property.isExpressionLanguageSupported()) continue;
            return true;
        }
        return false;
    }

    private boolean containsSensitiveProperties(Extension extension) {
        for (Property property : extension.getProperties()) {
            if (!property.isSensitive()) continue;
            return true;
        }
        return false;
    }

    protected void writeValidValues(XMLStreamWriter xmlStreamWriter, Property property) throws XMLStreamException {
        if (property.getAllowableValues() != null && !property.getAllowableValues().isEmpty()) {
            xmlStreamWriter.writeStartElement("ul");
            for (AllowableValue value : property.getAllowableValues()) {
                xmlStreamWriter.writeStartElement("li");
                xmlStreamWriter.writeCharacters(value.getDisplayName());
                if (!StringUtils.isBlank((CharSequence)value.getDescription())) {
                    this.writeValidValueDescription(xmlStreamWriter, value.getDescription());
                }
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else if (property.getControllerServiceDefinition() != null) {
            ControllerServiceDefinition serviceDefinition = property.getControllerServiceDefinition();
            String controllerServiceClass = this.getSimpleName(serviceDefinition.getClassName());
            String group = serviceDefinition.getGroupId() == null ? "unknown" : serviceDefinition.getGroupId();
            String artifact = serviceDefinition.getArtifactId() == null ? "unknown" : serviceDefinition.getArtifactId();
            String version = serviceDefinition.getVersion() == null ? "unknown" : serviceDefinition.getVersion();
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "strong", "Controller Service API: ");
            xmlStreamWriter.writeEmptyElement("br");
            xmlStreamWriter.writeCharacters(controllerServiceClass);
            this.writeValidValueDescription(xmlStreamWriter, group + "-" + artifact + "-" + version);
        }
    }

    private String getSimpleName(String extensionName) {
        int index = extensionName.lastIndexOf(46);
        if (index > 0 && index < extensionName.length() - 1) {
            return extensionName.substring(index + 1);
        }
        return extensionName;
    }

    private void writeValidValueDescription(XMLStreamWriter xmlStreamWriter, String description) throws XMLStreamException {
        xmlStreamWriter.writeCharacters(" ");
        xmlStreamWriter.writeStartElement("img");
        xmlStreamWriter.writeAttribute("src", "/nifi-registry-docs/images/iconInfo.png");
        xmlStreamWriter.writeAttribute("alt", description);
        xmlStreamWriter.writeAttribute("title", description);
        xmlStreamWriter.writeEndElement();
    }

    private void writeDynamicProperties(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List dynamicProperties = extension.getDynamicProperties();
        if (dynamicProperties != null && !dynamicProperties.isEmpty()) {
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "h3", "Dynamic Properties: ");
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("Dynamic Properties allow the user to specify both the name and value of a property.");
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "dynamic-properties");
            xmlStreamWriter.writeStartElement("tr");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Name");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Value");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (DynamicProperty dynamicProperty : dynamicProperties) {
                String text;
                ExpressionLanguageScope elScope;
                String name = StringUtils.isBlank((CharSequence)dynamicProperty.getName()) ? "Not Specified" : dynamicProperty.getName();
                String value = StringUtils.isBlank((CharSequence)dynamicProperty.getValue()) ? "Not Specified" : dynamicProperty.getValue();
                String description = StringUtils.isBlank((CharSequence)dynamicProperty.getDescription()) ? "Not Specified" : dynamicProperty.getDescription();
                xmlStreamWriter.writeStartElement("tr");
                HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", name, false, "name");
                HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", value, false, "value");
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeCharacters(description);
                xmlStreamWriter.writeEmptyElement("br");
                ExpressionLanguageScope expressionLanguageScope = elScope = dynamicProperty.getExpressionLanguageScope() == null ? ExpressionLanguageScope.NONE : dynamicProperty.getExpressionLanguageScope();
                if (elScope.equals((Object)ExpressionLanguageScope.NONE)) {
                    text = dynamicProperty.isExpressionLanguageSupported() ? "Supports Expression Language: true (undefined scope)" : "Supports Expression Language: false";
                } else {
                    text = switch (elScope) {
                        case ExpressionLanguageScope.FLOWFILE_ATTRIBUTES -> "Supports Expression Language: true (will be evaluated using flow file attributes and env/syst variables registry)";
                        case ExpressionLanguageScope.ENVIRONMENT -> "Supports Expression Language: true (will be evaluated using env/syst variables registry only)";
                        default -> "Supports Expression Language: false";
                    };
                }
                HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "strong", text);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
        }
    }

    private void writeStatefulInfo(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        Stateful stateful = extension.getStateful();
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "h3", "State management: ");
        if (stateful != null) {
            List scopes = Optional.ofNullable(stateful.getScopes()).map(Collection::stream).orElseGet(Stream::empty).map(s -> s.toString()).collect(Collectors.toList());
            String description = StringUtils.isBlank((CharSequence)stateful.getDescription()) ? "Not Specified" : stateful.getDescription();
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "stateful");
            xmlStreamWriter.writeStartElement("tr");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Scope");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("tr");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", StringUtils.join(scopes, (String)", "));
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", description);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
        } else {
            xmlStreamWriter.writeCharacters("This component does not store state.");
        }
    }

    private void writeRestrictedInfo(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        Restricted restricted = extension.getRestricted();
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "h3", "Restricted: ");
        if (restricted != null) {
            List restrictions;
            String generalRestrictionExplanation = restricted.getGeneralRestrictionExplanation();
            if (!StringUtils.isBlank((CharSequence)generalRestrictionExplanation)) {
                xmlStreamWriter.writeCharacters(generalRestrictionExplanation);
            }
            if ((restrictions = restricted.getRestrictions()) != null && !restrictions.isEmpty()) {
                xmlStreamWriter.writeStartElement("table");
                xmlStreamWriter.writeAttribute("id", "restrictions");
                xmlStreamWriter.writeStartElement("tr");
                HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Required Permission");
                HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Explanation");
                xmlStreamWriter.writeEndElement();
                for (Restriction restriction : restrictions) {
                    String permission = StringUtils.isBlank((CharSequence)restriction.getRequiredPermission()) ? "Not Specified" : restriction.getRequiredPermission();
                    String explanation = StringUtils.isBlank((CharSequence)restriction.getExplanation()) ? "Not Specified" : restriction.getExplanation();
                    xmlStreamWriter.writeStartElement("tr");
                    HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", permission);
                    HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", explanation);
                    xmlStreamWriter.writeEndElement();
                }
                xmlStreamWriter.writeEndElement();
            } else {
                xmlStreamWriter.writeCharacters("This component requires access to restricted components regardless of restriction.");
            }
        } else {
            xmlStreamWriter.writeCharacters("This component is not restricted.");
        }
    }

    private void writeInputRequirementInfo(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        InputRequirement inputRequirement = extension.getInputRequirement();
        if (inputRequirement != null) {
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "h3", "Input requirement: ");
            switch (inputRequirement) {
                case INPUT_FORBIDDEN: {
                    xmlStreamWriter.writeCharacters("This component does not allow an incoming relationship.");
                    break;
                }
                case INPUT_ALLOWED: {
                    xmlStreamWriter.writeCharacters("This component allows an incoming relationship.");
                    break;
                }
                case INPUT_REQUIRED: {
                    xmlStreamWriter.writeCharacters("This component requires an incoming relationship.");
                }
            }
        }
    }

    private void writeSystemResourceConsiderationInfo(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List systemResourceConsiderations = extension.getSystemResourceConsiderations();
        HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "h3", "System Resource Considerations:");
        if (systemResourceConsiderations != null && !systemResourceConsiderations.isEmpty()) {
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "system-resource-considerations");
            xmlStreamWriter.writeStartElement("tr");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Resource");
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (SystemResourceConsideration systemResourceConsideration : systemResourceConsiderations) {
                String resource = StringUtils.isBlank((CharSequence)systemResourceConsideration.getResource()) ? "Not Specified" : systemResourceConsideration.getResource();
                String description = StringUtils.isBlank((CharSequence)systemResourceConsideration.getDescription()) ? "Not Specified" : systemResourceConsideration.getDescription();
                xmlStreamWriter.writeStartElement("tr");
                HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", resource);
                HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "td", description);
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else {
            xmlStreamWriter.writeCharacters("None specified.");
        }
    }

    private void writeProvidedServiceApis(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List serviceAPIS = extension.getProvidedServiceAPIs();
        if (serviceAPIS != null && !serviceAPIS.isEmpty()) {
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "h3", "Provided Service APIs:");
            xmlStreamWriter.writeStartElement("ul");
            for (ProvidedServiceAPI serviceAPI : serviceAPIS) {
                String name = this.getSimpleName(serviceAPI.getClassName());
                String bundleInfo = " (" + serviceAPI.getGroupId() + "-" + serviceAPI.getArtifactId() + "-" + serviceAPI.getVersion() + ")";
                xmlStreamWriter.writeStartElement("li");
                xmlStreamWriter.writeCharacters(name);
                xmlStreamWriter.writeStartElement("i");
                xmlStreamWriter.writeCharacters(bundleInfo);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        }
    }

    private void writeSeeAlso(Extension extension, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List seeAlsos = extension.getSeeAlso();
        if (seeAlsos != null && !seeAlsos.isEmpty()) {
            HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "h3", "See Also:");
            xmlStreamWriter.writeStartElement("ul");
            for (String seeAlso : seeAlsos) {
                HtmlExtensionDocWriter.writeSimpleElement(xmlStreamWriter, "li", seeAlso);
            }
            xmlStreamWriter.writeEndElement();
        }
    }

    protected static final void writeSimpleElement(XMLStreamWriter writer, String elementName, String characters) throws XMLStreamException {
        HtmlExtensionDocWriter.writeSimpleElement(writer, elementName, characters, false);
    }

    protected static final void writeSimpleElement(XMLStreamWriter writer, String elementName, String characters, boolean strong) throws XMLStreamException {
        HtmlExtensionDocWriter.writeSimpleElement(writer, elementName, characters, strong, null);
    }

    protected static final void writeSimpleElement(XMLStreamWriter writer, String elementName, String characters, boolean strong, String id) throws XMLStreamException {
        writer.writeStartElement(elementName);
        if (id != null) {
            writer.writeAttribute("id", id);
        }
        if (strong) {
            writer.writeStartElement("strong");
        }
        writer.writeCharacters(characters);
        if (strong) {
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void writeLink(XMLStreamWriter xmlStreamWriter, String text, String location) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("a");
        xmlStreamWriter.writeAttribute("href", location);
        xmlStreamWriter.writeCharacters(text);
        xmlStreamWriter.writeEndElement();
    }
}

