/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.nifi.bundle.BundleCoordinate;

public class ExtensionMapping {
    private final Map<String, Set<BundleCoordinate>> processorNames = new HashMap<String, Set<BundleCoordinate>>();
    private final Map<String, Set<BundleCoordinate>> controllerServiceNames = new HashMap<String, Set<BundleCoordinate>>();
    private final Map<String, Set<BundleCoordinate>> reportingTaskNames = new HashMap<String, Set<BundleCoordinate>>();
    private final Map<String, Set<BundleCoordinate>> flowAnalysisRuleNames = new HashMap<String, Set<BundleCoordinate>>();
    private final Map<String, Set<BundleCoordinate>> parameterProviderNames = new HashMap<String, Set<BundleCoordinate>>();
    private final Map<String, Set<BundleCoordinate>> flowRegistryClientNames = new HashMap<String, Set<BundleCoordinate>>();
    private final BiFunction<Set<BundleCoordinate>, Set<BundleCoordinate>, Set<BundleCoordinate>> merger = (oldValue, newValue) -> {
        HashSet merged = new HashSet();
        merged.addAll(oldValue);
        merged.addAll(newValue);
        return merged;
    };

    void addProcessor(BundleCoordinate coordinate, String processorName) {
        this.processorNames.computeIfAbsent(processorName, name -> new HashSet()).add(coordinate);
    }

    void addAllProcessors(BundleCoordinate coordinate, Collection<String> processorNames) {
        processorNames.forEach(name -> this.addProcessor(coordinate, (String)name));
    }

    void addControllerService(BundleCoordinate coordinate, String controllerServiceName) {
        this.controllerServiceNames.computeIfAbsent(controllerServiceName, name -> new HashSet()).add(coordinate);
    }

    void addAllControllerServices(BundleCoordinate coordinate, Collection<String> controllerServiceNames) {
        controllerServiceNames.forEach(name -> this.addControllerService(coordinate, (String)name));
    }

    void addReportingTask(BundleCoordinate coordinate, String reportingTaskName) {
        this.reportingTaskNames.computeIfAbsent(reportingTaskName, name -> new HashSet()).add(coordinate);
    }

    void addAllReportingTasks(BundleCoordinate coordinate, Collection<String> reportingTaskNames) {
        reportingTaskNames.forEach(name -> this.addReportingTask(coordinate, (String)name));
    }

    void addFlowAnalysisRule(BundleCoordinate coordinate, String flowAnalysisRuleName) {
        this.flowAnalysisRuleNames.computeIfAbsent(flowAnalysisRuleName, name -> new HashSet()).add(coordinate);
    }

    void addAllFlowAnalysisRules(BundleCoordinate coordinate, Collection<String> flowAnalysisRuleNames) {
        flowAnalysisRuleNames.forEach(name -> this.addFlowAnalysisRule(coordinate, (String)name));
    }

    void addParameterProvider(BundleCoordinate coordinate, String parameterProviderName) {
        this.parameterProviderNames.computeIfAbsent(parameterProviderName, name -> new HashSet()).add(coordinate);
    }

    void addAllParameterProviders(BundleCoordinate coordinate, Collection<String> parameterProviderNames) {
        parameterProviderNames.forEach(name -> this.addParameterProvider(coordinate, (String)name));
    }

    void addFlowRegistryClient(BundleCoordinate coordinate, String flowRegistryClientName) {
        this.flowRegistryClientNames.computeIfAbsent(flowRegistryClientName, name -> new HashSet()).add(coordinate);
    }

    void addAllFlowRegistryClients(BundleCoordinate coordinate, Collection<String> flowRegistryClientNames) {
        flowRegistryClientNames.forEach(name -> this.addFlowRegistryClient(coordinate, (String)name));
    }

    void merge(ExtensionMapping other) {
        other.getProcessorNames().forEach((name, otherCoordinates) -> this.processorNames.merge((String)name, (Set<BundleCoordinate>)otherCoordinates, this.merger));
        other.getControllerServiceNames().forEach((name, otherCoordinates) -> this.controllerServiceNames.merge((String)name, (Set<BundleCoordinate>)otherCoordinates, this.merger));
        other.getReportingTaskNames().forEach((name, otherCoordinates) -> this.reportingTaskNames.merge((String)name, (Set<BundleCoordinate>)otherCoordinates, this.merger));
        other.getFlowAnalysisRuleNames().forEach((name, otherCoordinates) -> this.flowAnalysisRuleNames.merge((String)name, (Set<BundleCoordinate>)otherCoordinates, this.merger));
        other.getParameterProviderNames().forEach((name, otherCoordinates) -> this.parameterProviderNames.merge((String)name, (Set<BundleCoordinate>)otherCoordinates, this.merger));
        other.getFlowRegistryClientNames().forEach((name, otherCoordinates) -> this.flowRegistryClientNames.merge((String)name, (Set<BundleCoordinate>)otherCoordinates, this.merger));
    }

    public Map<String, Set<BundleCoordinate>> getProcessorNames() {
        return Collections.unmodifiableMap(this.processorNames);
    }

    public Map<String, Set<BundleCoordinate>> getControllerServiceNames() {
        return Collections.unmodifiableMap(this.controllerServiceNames);
    }

    public Map<String, Set<BundleCoordinate>> getReportingTaskNames() {
        return Collections.unmodifiableMap(this.reportingTaskNames);
    }

    public Map<String, Set<BundleCoordinate>> getFlowAnalysisRuleNames() {
        return Collections.unmodifiableMap(this.flowAnalysisRuleNames);
    }

    public Map<String, Set<BundleCoordinate>> getParameterProviderNames() {
        return Collections.unmodifiableMap(this.parameterProviderNames);
    }

    public Map<String, Set<BundleCoordinate>> getFlowRegistryClientNames() {
        return Collections.unmodifiableMap(this.flowRegistryClientNames);
    }

    public Map<String, Set<BundleCoordinate>> getAllExtensionNames() {
        HashMap<String, Set<BundleCoordinate>> extensionNames = new HashMap<String, Set<BundleCoordinate>>();
        extensionNames.putAll(this.processorNames);
        extensionNames.putAll(this.controllerServiceNames);
        extensionNames.putAll(this.reportingTaskNames);
        extensionNames.putAll(this.flowAnalysisRuleNames);
        extensionNames.putAll(this.parameterProviderNames);
        extensionNames.putAll(this.flowRegistryClientNames);
        return extensionNames;
    }

    public int size() {
        int size = 0;
        for (Set<BundleCoordinate> coordinates : this.processorNames.values()) {
            size += coordinates.size();
        }
        for (Set<BundleCoordinate> coordinates : this.controllerServiceNames.values()) {
            size += coordinates.size();
        }
        for (Set<BundleCoordinate> coordinates : this.reportingTaskNames.values()) {
            size += coordinates.size();
        }
        for (Set<BundleCoordinate> coordinates : this.flowAnalysisRuleNames.values()) {
            size += coordinates.size();
        }
        for (Set<BundleCoordinate> coordinates : this.parameterProviderNames.values()) {
            size += coordinates.size();
        }
        for (Set<BundleCoordinate> coordinates : this.flowRegistryClientNames.values()) {
            size += coordinates.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.processorNames.isEmpty() && this.controllerServiceNames.isEmpty() && this.reportingTaskNames.isEmpty() && this.flowAnalysisRuleNames.isEmpty() && this.parameterProviderNames.isEmpty() && this.flowRegistryClientNames.isEmpty();
    }
}

