/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.validator;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.LengthValidator;
import jakarta.faces.validator.ValidatorException;
import java.util.Objects;
import org.apache.myfaces.tobago.util.MessageUtils;

public class SubmittedValueLengthValidator
extends LengthValidator {
    public static final String VALIDATOR_ID = "org.apache.myfaces.tobago.SubmittedValueLength";
    private Integer minimum;
    private Integer maximum;

    public SubmittedValueLengthValidator() {
    }

    public SubmittedValueLengthValidator(int maximum) {
        this.setMaximum(maximum);
    }

    public SubmittedValueLengthValidator(int maximum, int minimum) {
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public int getMinimum() {
        return this.minimum != null ? this.minimum : 0;
    }

    public void setMinimum(int minimum) {
        if (minimum > 0) {
            this.minimum = minimum;
        }
    }

    public int getMaximum() {
        return this.maximum != null ? this.maximum : 0;
    }

    public void setMaximum(int maximum) {
        if (maximum > 0) {
            this.maximum = maximum;
        }
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (value != null && uiComponent instanceof EditableValueHolder) {
            String submittedValue = ((EditableValueHolder)uiComponent).getSubmittedValue().toString();
            if (this.maximum != null && submittedValue.length() > this.maximum) {
                throw new ValidatorException(MessageUtils.getMessage(facesContext, FacesMessage.SEVERITY_ERROR, "jakarta.faces.validator.LengthValidator.MAXIMUM", this.maximum, uiComponent.getId()));
            }
            if (this.minimum != null && submittedValue.length() < this.minimum) {
                throw new ValidatorException(MessageUtils.getMessage(facesContext, FacesMessage.SEVERITY_ERROR, "jakarta.faces.validator.LengthValidator.MINIMUM", this.minimum, uiComponent.getId()));
            }
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maximum, this.minimum};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Integer)values[0];
        this.minimum = (Integer)values[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubmittedValueLengthValidator validator = (SubmittedValueLengthValidator)((Object)o);
        if (!Objects.equals(this.maximum, validator.maximum)) {
            return false;
        }
        return Objects.equals(this.minimum, validator.minimum);
    }

    public int hashCode() {
        int result = this.minimum != null ? this.minimum.hashCode() : 0;
        result = 31 * result + (this.maximum != null ? this.maximum.hashCode() : 0);
        return result;
    }
}

