/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.ReturnNode;
import org.apache.myfaces.flow.Freezable;

public class ReturnNodeImpl
extends ReturnNode
implements Freezable {
    private String fromOutcome;
    private ValueExpression fromOutcomeEL;
    private String id;
    private boolean initialized;

    public ReturnNodeImpl(String returnNodeId) {
        this.id = returnNodeId;
    }

    public String getFromOutcome(FacesContext context) {
        if (this.fromOutcomeEL != null) {
            return (String)this.fromOutcomeEL.getValue(context.getELContext());
        }
        return this.fromOutcome;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void freeze() {
        this.initialized = true;
    }

    private void checkInitialized() throws IllegalStateException {
        if (this.initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }

    public void setFromOutcome(String fromOutcome) {
        this.checkInitialized();
        this.fromOutcome = fromOutcome;
        this.fromOutcomeEL = null;
    }

    public void setFromOutcome(ValueExpression fromOutcome) {
        this.checkInitialized();
        this.fromOutcomeEL = fromOutcome;
        this.fromOutcome = null;
    }

    public void setId(String id) {
        this.checkInitialized();
        this.id = id;
    }
}

