/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import jakarta.faces.webapp.FacesServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.FacesInitializerFactory;

public class MyFacesServlet
implements Servlet {
    private static final Logger log = Logger.getLogger(MyFacesServlet.class.getName());
    private final FacesServlet delegate = new FacesServlet();
    private FacesInitializer facesInitializer;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        if (this.facesInitializer == null) {
            this.facesInitializer = FacesInitializerFactory.getFacesInitializer(servletConfig.getServletContext());
        }
        this.facesInitializer.initFaces(servletConfig.getServletContext());
        this.delegate.init(servletConfig);
    }

    @Override
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("MyFacesServlet service start");
        }
        this.delegate.service(request, response);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("MyFacesServlet service finished");
        }
    }

    @Override
    public void destroy() {
        if (this.facesInitializer == null) {
            this.facesInitializer = FacesInitializerFactory.getFacesInitializer(this.getServletConfig().getServletContext());
        }
        this.facesInitializer.destroyFaces(this.getServletConfig().getServletContext());
        this.delegate.destroy();
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.delegate.getServletConfig();
    }

    @Override
    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }
}

