/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.ValueExpression;
import jakarta.faces.component.StateHelper;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.TransientStateHelper;
import jakarta.faces.component.TransientStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

class _DeltaStateHelper
implements StateHelper,
TransientStateHelper,
TransientStateHolder {
    private UIComponent _component;
    private Map<Serializable, Object> _fullState;
    private Map<Serializable, Object> _deltas;
    private Map<Object, Object> _transientState;
    private Object[] _initialState;
    private boolean _transient = false;
    private Map<Serializable, Object> _initialFullState;
    private boolean _copyFullInitialState;

    public _DeltaStateHelper(UIComponent component) {
        this._component = component;
        this._fullState = new HashMap<Serializable, Object>();
        this._deltas = null;
        this._transientState = null;
        this._initialFullState = null;
        this._copyFullInitialState = false;
    }

    private boolean _createDeltas(Serializable key) {
        if (this.isInitialStateMarked()) {
            if (this._copyFullInitialState && this._initialFullState == null) {
                if (this._initialState == null) {
                    this._initialFullState = new HashMap<Serializable, Object>();
                    _DeltaStateHelper.copyMap(this._component.getFacesContext(), this._fullState, this._initialFullState);
                } else {
                    boolean keyInInitialState = false;
                    for (int i = 0; i < this._initialState.length; i += 2) {
                        Serializable key2 = (Serializable)this._initialState[i];
                        if (!key.equals(key2)) continue;
                        keyInInitialState = true;
                        break;
                    }
                    if (!keyInInitialState) {
                        this._initialFullState = new HashMap<Serializable, Object>();
                        _DeltaStateHelper.copyMap(this._component.getFacesContext(), this._fullState, this._initialFullState);
                    }
                }
            }
            if (this._deltas == null) {
                this._deltas = new HashMap<Serializable, Object>(2);
            }
            return true;
        }
        return false;
    }

    void setCopyFullInitialState(boolean value) {
        this._copyFullInitialState = value;
    }

    private static void copyMap(FacesContext context, Map<Serializable, Object> sourceMap, Map<Serializable, Object> targetMap) {
        Map<Serializable, Object> serializableMap = sourceMap;
        for (Map.Entry<Serializable, Object> entry : serializableMap.entrySet()) {
            Serializable key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof StateHolder || value instanceof List || !(value instanceof Serializable)) {
                Object savedValue = UIComponentBase.saveAttachedState(context, value);
                targetMap.put(key, UIComponentBase.restoreAttachedState(context, savedValue));
                continue;
            }
            if (!(value instanceof Serializable)) {
                Object newInstance;
                try {
                    newInstance = entry.getValue().getClass().newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Could not restore StateHolder of type " + entry.getValue().getClass().getName() + " (missing no-args constructor?)", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                targetMap.put(key, newInstance);
                continue;
            }
            targetMap.put(key, value);
        }
    }

    protected boolean isInitialStateMarked() {
        return this._component.initialStateMarked();
    }

    @Override
    public void add(Serializable key, Object value) {
        InternalList fullListValues;
        if (this._createDeltas(key)) {
            InternalDeltaListMap<Object, Boolean> deltaListMapValues = (InternalDeltaListMap<Object, Boolean>)this._deltas.get(key);
            if (deltaListMapValues == null) {
                deltaListMapValues = new InternalDeltaListMap<Object, Boolean>(3);
                this._deltas.put(key, deltaListMapValues);
            }
            deltaListMapValues.put(value, Boolean.TRUE);
        }
        if ((fullListValues = (InternalList)this._fullState.get(key)) == null) {
            fullListValues = new InternalList(3);
            this._fullState.put(key, fullListValues);
        }
        fullListValues.add(value);
    }

    @Override
    public Object eval(Serializable key) {
        Object returnValue = this._fullState.get(key);
        if (returnValue != null) {
            return returnValue;
        }
        ValueExpression expression = this._component.getValueExpression(key.toString());
        if (expression != null) {
            return expression.getValue(this._component.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public Object eval(Serializable key, Object defaultValue) {
        ValueExpression expression;
        Object returnValue = this._fullState.get(key);
        if (returnValue == null && (expression = this._component.getValueExpression(key.toString())) != null) {
            returnValue = expression.getValue(this._component.getFacesContext().getELContext());
        }
        if (returnValue == null) {
            returnValue = defaultValue;
        }
        return returnValue;
    }

    @Override
    public Object eval(Serializable key, Supplier<Object> defaultValueSupplier) {
        ValueExpression expression;
        Object returnValue = this._fullState.get(key);
        if (returnValue == null && (expression = this._component.getValueExpression(key.toString())) != null) {
            returnValue = expression.getValue(this._component.getFacesContext().getELContext());
        }
        if (returnValue == null && defaultValueSupplier != null) {
            returnValue = defaultValueSupplier.get();
        }
        return returnValue;
    }

    @Override
    public Object get(Serializable key) {
        return this._fullState.get(key);
    }

    @Override
    public Object put(Serializable key, Object value) {
        Object returnValue = null;
        if (this._createDeltas(key)) {
            if (this._deltas.containsKey(key)) {
                returnValue = this._deltas.put(key, value);
                this._fullState.put(key, value);
            } else if (value == null && !this._fullState.containsKey(key)) {
                returnValue = null;
            } else {
                this._deltas.put(key, value);
                returnValue = this._fullState.put(key, value);
            }
        } else {
            returnValue = this._fullState.put(key, value);
        }
        return returnValue;
    }

    @Override
    public Object put(Serializable key, String mapKey, Object value) {
        InternalMap<String, Object> mapValues;
        boolean returnSet = false;
        Object returnValue = null;
        if (this._createDeltas(key)) {
            mapValues = (InternalMap<String, Object>)this._deltas.get(key);
            if (mapValues == null) {
                mapValues = new InternalMap<String, Object>();
                this._deltas.put(key, mapValues);
            }
            if (mapValues.containsKey(mapKey)) {
                returnValue = mapValues.put(mapKey, value);
                returnSet = true;
            } else {
                mapValues.put(mapKey, value);
            }
        }
        if ((mapValues = (Map)this._fullState.get(key)) == null) {
            mapValues = new InternalMap();
            this._fullState.put(key, mapValues);
        }
        if (returnSet) {
            mapValues.put(mapKey, value);
        } else {
            returnValue = mapValues.put(mapKey, value);
        }
        return returnValue;
    }

    @Override
    public Object remove(Serializable key) {
        Object returnValue = null;
        if (this._createDeltas(key)) {
            if (this._deltas.containsKey(key)) {
                returnValue = this._deltas.put(key, null);
                this._fullState.remove(key);
            } else {
                this._deltas.put(key, null);
                returnValue = this._fullState.remove(key);
            }
        } else {
            returnValue = this._fullState.remove(key);
        }
        return returnValue;
    }

    @Override
    public Object remove(Serializable key, Object valueOrKey) {
        Object collectionOrMap = this._fullState.get(key);
        Object returnValue = null;
        if (collectionOrMap instanceof InternalMap) {
            if (this._createDeltas(key)) {
                returnValue = _DeltaStateHelper._removeValueOrKeyFromMap(this._deltas, key, valueOrKey, true);
                _DeltaStateHelper._removeValueOrKeyFromMap(this._fullState, key, valueOrKey, false);
            } else {
                returnValue = _DeltaStateHelper._removeValueOrKeyFromMap(this._fullState, key, valueOrKey, false);
            }
        } else if (collectionOrMap instanceof InternalList) {
            if (this._createDeltas(key)) {
                returnValue = _DeltaStateHelper._removeValueOrKeyFromCollectionDelta(this._deltas, key, valueOrKey);
                _DeltaStateHelper._removeValueOrKeyFromCollection(this._fullState, key, valueOrKey);
            } else {
                returnValue = _DeltaStateHelper._removeValueOrKeyFromCollection(this._fullState, key, valueOrKey);
            }
        }
        return returnValue;
    }

    private static Object _removeValueOrKeyFromCollectionDelta(Map<Serializable, Object> stateMap, Serializable key, Object valueOrKey) {
        Object returnValue = null;
        Map c = (Map)stateMap.get(key);
        if (c != null) {
            if (c.containsKey(valueOrKey)) {
                returnValue = valueOrKey;
            }
            c.put(valueOrKey, Boolean.FALSE);
        }
        return returnValue;
    }

    private static Object _removeValueOrKeyFromCollection(Map<Serializable, Object> stateMap, Serializable key, Object valueOrKey) {
        Object returnValue = null;
        Collection c = (Collection)stateMap.get(key);
        if (c != null) {
            if (c.remove(valueOrKey)) {
                returnValue = valueOrKey;
            }
            if (c.isEmpty()) {
                stateMap.remove(key);
            }
        }
        return returnValue;
    }

    private static Object _removeValueOrKeyFromMap(Map<Serializable, Object> stateMap, Serializable key, Object valueOrKey, boolean delta) {
        if (valueOrKey == null) {
            return null;
        }
        Object returnValue = null;
        Map map = (Map)stateMap.get(key);
        if (map != null) {
            returnValue = delta ? map.put((String)valueOrKey, null) : map.remove(valueOrKey);
            if (map.isEmpty()) {
                stateMap.put(key, null);
            }
        }
        return returnValue;
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public Object saveState(FacesContext context) {
        Map<Serializable, Object> serializableMap;
        Map<Serializable, Object> map = serializableMap = this.isInitialStateMarked() ? this._deltas : this._fullState;
        if (this._initialState != null && this._deltas != null && !this._deltas.isEmpty() && this.isInitialStateMarked()) {
            for (int i = 0; i < this._initialState.length; i += 2) {
                Serializable key = (Serializable)this._initialState[i];
                Object defaultValue = this._initialState[i + 1];
                if (!this._deltas.containsKey(key)) continue;
                Object deltaValue = this._deltas.get(key);
                if (deltaValue == null && defaultValue == null) {
                    this._deltas.remove(key);
                    if (this._deltas.isEmpty()) break;
                }
                if (deltaValue == null || !deltaValue.equals(defaultValue)) continue;
                this._deltas.remove(key);
                if (this._deltas.isEmpty()) break;
            }
        }
        if (serializableMap == null || serializableMap.isEmpty()) {
            return null;
        }
        Object[] retArr = new Object[serializableMap.entrySet().size() * 2];
        Iterator<Map.Entry<Serializable, Object>> it = serializableMap.entrySet().iterator();
        int cnt = 0;
        while (it.hasNext()) {
            Object savedValue;
            Map.Entry<Serializable, Object> entry = it.next();
            retArr[cnt] = entry.getKey();
            Object value = entry.getValue();
            retArr[cnt + 1] = value instanceof StateHolder || value instanceof List || !(value instanceof Serializable) ? (savedValue = UIComponentBase.saveAttachedState(context, value)) : value;
            cnt += 2;
        }
        return retArr;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] serializedState = (Object[])state;
        if (!this.isInitialStateMarked() && !this._fullState.isEmpty()) {
            this._fullState.clear();
            if (this._deltas != null) {
                this._deltas.clear();
            }
        }
        for (int cnt = 0; cnt < serializedState.length; cnt += 2) {
            Serializable key = (Serializable)serializedState[cnt];
            Object savedValue = UIComponentBase.restoreAttachedState(context, serializedState[cnt + 1]);
            if (this.isInitialStateMarked()) {
                if (savedValue instanceof InternalDeltaListMap) {
                    for (Map.Entry mapEntry : ((Map)savedValue).entrySet()) {
                        boolean addOrRemove = (Boolean)mapEntry.getValue();
                        if (addOrRemove) {
                            this.add(key, mapEntry.getKey());
                            continue;
                        }
                        this.remove(key, mapEntry.getKey());
                    }
                    continue;
                }
                if (savedValue instanceof InternalMap) {
                    for (Map.Entry mapEntry : ((Map)savedValue).entrySet()) {
                        this.put(key, (String)mapEntry.getKey(), mapEntry.getValue());
                    }
                    continue;
                }
                this.put(key, savedValue);
                continue;
            }
            this.put(key, savedValue);
        }
    }

    public Object resetHardState(FacesContext context) {
        if (this._transientState != null) {
            this._transientState.clear();
        }
        if (this._deltas != null && !this._deltas.isEmpty() && this.isInitialStateMarked()) {
            this.clearFullStateMap(context);
        }
        return this.saveState(context);
    }

    public Object resetSoftState(FacesContext context) {
        if (this._transientState != null) {
            this._transientState.clear();
        }
        return null;
    }

    protected void clearFullStateMap(FacesContext context) {
        if (this._deltas != null) {
            this._deltas.clear();
        }
        if (this._initialFullState != null) {
            this._fullState.clear();
            _DeltaStateHelper.copyMap(context, this._initialFullState, this._fullState);
        }
        if (this._initialState != null) {
            for (int i = 0; i < this._initialState.length; i += 2) {
                Serializable key2 = (Serializable)this._initialState[i];
                Object defaultValue = this._initialState[i + 1];
                if (!this._fullState.containsKey(key2)) continue;
                this._fullState.put(key2, defaultValue);
            }
        }
    }

    @Override
    public void setTransient(boolean transientValue) {
        this._transient = transientValue;
    }

    @Override
    public Object getTransient(Object key) {
        return this._transientState == null ? null : this._transientState.get(key);
    }

    @Override
    public Object getTransient(Object key, Object defaultValue) {
        Object returnValue;
        Object object = returnValue = this._transientState == null ? null : this._transientState.get(key);
        if (returnValue != null) {
            return returnValue;
        }
        return defaultValue;
    }

    @Override
    public Object putTransient(Object key, Object value) {
        if (this._transientState == null) {
            this._transientState = new HashMap<Object, Object>();
        }
        return this._transientState.put(key, value);
    }

    @Override
    public void restoreTransientState(FacesContext context, Object state) {
        this._transientState = (Map)state;
    }

    @Override
    public Object saveTransientState(FacesContext context) {
        return this._transientState;
    }

    public void markPropertyInInitialState(Object[] defaultInitialState) {
        boolean canApplyDefaultInitialState = true;
        for (int i = 0; i < defaultInitialState.length; i += 2) {
            Serializable key = (Serializable)defaultInitialState[i];
            if (!this._fullState.containsKey(key)) continue;
            canApplyDefaultInitialState = false;
            break;
        }
        if (canApplyDefaultInitialState) {
            this._initialState = defaultInitialState;
        } else {
            Object[] initialState = new Object[defaultInitialState.length];
            for (int i = 0; i < defaultInitialState.length; i += 2) {
                Serializable key = (Serializable)defaultInitialState[i];
                initialState[i] = key;
                initialState[i + 1] = this._fullState.containsKey(key) ? this._fullState.get(key) : defaultInitialState[i + 1];
            }
            this._initialState = initialState;
        }
    }

    static class InternalDeltaListMap<K, V>
    extends InternalMap<K, V> {
        public InternalDeltaListMap() {
        }

        public InternalDeltaListMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public InternalDeltaListMap(int initialSize) {
            super(initialSize);
        }

        public InternalDeltaListMap(Map<? extends K, ? extends V> m) {
            super(m);
        }
    }

    static class InternalList<T>
    extends ArrayList<T>
    implements StateHolder {
        public InternalList() {
        }

        public InternalList(Collection<? extends T> c) {
            super(c);
        }

        public InternalList(int initialSize) {
            super(initialSize);
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public void setTransient(boolean newTransientValue) {
        }

        @Override
        public void restoreState(FacesContext context, Object state) {
            Object[] listAsArr;
            for (Object elem : listAsArr = (Object[])state) {
                this.add(UIComponentBase.restoreAttachedState(context, elem));
            }
        }

        @Override
        public Object saveState(FacesContext context) {
            Object[] values = new Object[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                Object value = this.get(i);
                values[i] = value instanceof StateHolder || value instanceof List || !(value instanceof Serializable) ? UIComponentBase.saveAttachedState(context, value) : value;
            }
            return values;
        }
    }

    static class InternalMap<K, V>
    extends HashMap<K, V>
    implements StateHolder {
        public InternalMap() {
        }

        public InternalMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public InternalMap(Map<? extends K, ? extends V> m) {
            super(m);
        }

        public InternalMap(int initialSize) {
            super(initialSize);
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public void setTransient(boolean newTransientValue) {
        }

        @Override
        public void restoreState(FacesContext context, Object state) {
            Object[] listAsMap = (Object[])state;
            for (int cnt = 0; cnt < listAsMap.length; cnt += 2) {
                this.put(listAsMap[cnt], UIComponentBase.restoreAttachedState(context, listAsMap[cnt + 1]));
            }
        }

        @Override
        public Object saveState(FacesContext context) {
            int cnt = 0;
            Object[] mapArr = new Object[this.size() * 2];
            for (Map.Entry entry : this.entrySet()) {
                mapArr[cnt] = entry.getKey();
                Object value = entry.getValue();
                mapArr[cnt + 1] = value instanceof StateHolder || value instanceof List || !(value instanceof Serializable) ? UIComponentBase.saveAttachedState(context, value) : value;
                cnt += 2;
            }
            return mapArr;
        }
    }
}

