/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.api.ExtensibleEnum;
import org.apache.maven.api.Language;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.ProjectScope;

abstract class ExtensibleEnums {
    ExtensibleEnums() {
    }

    static Language language(String id) {
        return new DefaultLanguage(id);
    }

    static PathScope pathScope(String id, ProjectScope projectScope, DependencyScope ... dependencyScopes) {
        return new DefaultPathScope(id, projectScope, dependencyScopes);
    }

    static ProjectScope projectScope(String id) {
        return new DefaultProjectScope(id);
    }

    private static class DefaultLanguage
    extends DefaultExtensibleEnum
    implements Language {
        DefaultLanguage(String id) {
            super(id);
        }
    }

    private static class DefaultPathScope
    extends DefaultExtensibleEnum
    implements PathScope {
        private final ProjectScope projectScope;
        private final Set<DependencyScope> dependencyScopes;

        DefaultPathScope(String id, ProjectScope projectScope, DependencyScope ... dependencyScopes) {
            super(id);
            this.projectScope = Objects.requireNonNull(projectScope);
            this.dependencyScopes = Collections.unmodifiableSet(new HashSet<DependencyScope>(Arrays.asList(Objects.requireNonNull(dependencyScopes))));
        }

        @Override
        public ProjectScope projectScope() {
            return this.projectScope;
        }

        @Override
        public Set<DependencyScope> dependencyScopes() {
            return this.dependencyScopes;
        }
    }

    private static class DefaultProjectScope
    extends DefaultExtensibleEnum
    implements ProjectScope {
        DefaultProjectScope(String id) {
            super(id);
        }
    }

    private static class DefaultExtensibleEnum
    implements ExtensibleEnum {
        private final String id;

        DefaultExtensibleEnum(String id) {
            this.id = Objects.requireNonNull(id);
        }

        @Override
        public String id() {
            return this.id;
        }

        public int hashCode() {
            return this.id().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass() && this.id().equals(((DefaultExtensibleEnum)obj).id());
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.id() + "]";
        }
    }
}

